//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMWARP_H
#define PMWARP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmobject.h"

/**
 * Class for Repeat Warps
 */ 

class PMWarp : public PMObject
{
   typedef PMObject Base;
public:
   enum PMWarpType { Repeat, BlackHole, Turbulence };

   /** Creates a PMWarp */
   PMWarp( );
   /** deletes the PMWarp */
   virtual ~PMWarp( );

   /** */
   virtual PMObject* newObject( ) const { return new PMWarp( ); }
   /** */
   virtual QString className( ) const { return QString( "warp" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTWarp; }
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   
   /** Returns a new @ref PMWarpEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;
   /** Returns the name of the pixmap that is displayed in the tree view
    * and dialog view */
   virtual QString pixmap( ) const { return QString( "pmwarp" ); }

   PMWarpType warpType( ) const { return m_warpType; }
   void setWarpType( PMWarpType c );

   PMVector direction( ) const { return m_direction; }
   void setDirection( const PMVector& c );
   PMVector offset( ) const { return m_offset; }
   void setOffset( const PMVector& c );
   PMVector flip( ) const { return m_flip; }
   void setFlip( const PMVector& c );
   
   PMVector location( ) const { return m_location; }
   void setLocation( const PMVector& v );
   double radius( ) const { return m_radius; }
   void setRadius( double c );
   double strength( ) { return m_strength; }
   void setStrength( double c );
   double falloff( ) { return m_falloff; }
   void setFalloff( double c );
   bool inverse( ) { return m_inverse; }
   void setInverse( bool c );
   PMVector repeat( ) const { return m_repeat; }
   void setRepeat( const PMVector& v );
   PMVector turbulence( ) const { return m_turbulence; }
   void setTurbulence( const PMVector& v );

   PMVector valueVector( ) const { return m_valueVector; }
   void setValueVector( const PMVector& v );
   int octaves( ) const { return m_octaves; }
   void setOctaves( int c );
   double omega( ) const { return m_omega; }
   void setOmega( double c );
   double lambda( ) const { return m_lambda; }
   void setLambda( double c );

   /** */
   virtual void restoreMemento( PMMemento* s );
private:
   /** IDs for @ref PMMementoData */
   enum PMWarpMementoID { PMWarpTypeID, PMDirectionID, PMOffsetID, PMFlipID,
                          PMLocationID, PMRadiusID, PMStrengthID, PMFalloffID,
                          PMInverseID, PMRepeatID, PMTurbulenceID,
                          PMValueVectorID, PMOctavesID, PMOmegaID, PMLambdaID };

   PMWarpType m_warpType;

   /* Repeat variables */
   PMVector m_direction;
   PMVector m_offset;
   PMVector m_flip;

   /* Black Hole variables */
   PMVector m_location;
   double m_radius;
   double m_strength;
   double m_falloff;
   bool m_inverse;
   PMVector m_repeat;
   PMVector m_turbulence;

   /* Turbulence variables */
   PMVector m_valueVector;
   int m_octaves;
   double m_omega;
   double m_lambda;
};

#endif
