/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __TASK__H__
#define __TASK__H__

#include <glib.h>

#include <pan/base/message-identifier.h>
#include <pan/base/pan-callback.h>
#include <pan/base/server.h>
#include <pan/base/status-item.h>
#include <pan/base/article.h>

#include <pan/task-state.h>

/**
***  TASK CLASS DEFINITION
**/

enum
{
	TASK_TYPE_OTHER,
	TASK_TYPE_BODY,
	TASK_TYPE_BODIES,
	TASK_TYPE_HEADERS,
	TASK_TYPE_SAVE,
	TASK_TYPE_POST
};

#define TASK(a) ((Task*)a)
typedef struct _Task Task;
typedef int (*TaskRunFunc)(Task*);
struct _Task
{
	/* Parent Class */
	StatusItem parent;

	/* Public Fields */
	PanCallback * task_ran_callback;

	/* Accessed by Queue */
	int thread_qty;
	GSList * sockets;
	gboolean hint_abort;

	/* Private Fields */  
	guint gets_bodies        : 1;
	guint high_priority      : 1;
	gint8 type;
	Server * server;
	GPtrArray * identifiers;
	TaskState state;
};

/**
***  PROTECTED
**/

void task_destructor      (PanObject                 * object);

void task_constructor     (Task                      * task,
                           PanObjectDestructor         dtor,
                           StatusItemDescribeFunc      describe,
                           Server                    * server,
                           gboolean                    high_priority);

/**
***  PUBLIC
**/

void         task_add_identifiers     (Task                 * task,
                                       MessageIdentifier   ** identifiers,
                                       int                    identifier_qty);

GPtrArray*   task_get_identifiers      (Task                * task);


#endif
