/*  This file is part of the KDE project
    Copyright (C) 2008 Matthias Kretz <kretz@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) version 3, or any
    later version accepted by the membership of KDE e.V. (or its
    successor approved by the membership of KDE e.V.), Trolltech ASA 
    (or its successors, if any) and the KDE Free Qt Foundation, which shall
    act as a proxy defined in Section 6 of version 3 of the license.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public 
    License along with this library.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "mediasource.h"
#include "mediasource_p.h"

#define S_D(Class) Class##Private *d = reinterpret_cast<Class##Private *>(Phonon::MediaSource::d.data())

namespace Phonon
{
namespace Experimental
{

MediaSource::MediaSource(const MediaSource &rhs)
    : Phonon::MediaSource(rhs)
{
}

MediaSource &MediaSource::operator=(const MediaSource &rhs)
{
    d = rhs.d;
    return *this;
}

bool MediaSource::operator==(const MediaSource &rhs) const
{
    return d == rhs.d;
}

VideoCaptureDevice MediaSource::videoCaptureDevice() const
{
    S_D(const MediaSource);
    return d->videoCaptureDevice;
}

MediaSource::MediaSource(const VideoCaptureDevice &videoDevice)
    : Phonon::MediaSource(*new MediaSourcePrivate(VideoCaptureDeviceSource))
{
    S_D(MediaSource);
    d->videoCaptureDevice = videoDevice;
}

MediaSource::MediaSource(const QList<Phonon::MediaSource> &mediaList)
    : Phonon::MediaSource(*new MediaSourcePrivate(Link))
{
    S_D(MediaSource);
    d->linkedSources = mediaList;
    foreach (const Phonon::MediaSource &ms, mediaList) {
        Q_ASSERT(static_cast<MediaSource::Type>(ms.type()) != Link);
    }
}

QList<Phonon::MediaSource> MediaSource::substreams() const
{
    S_D(MediaSource);
    return d->linkedSources;
}

} // namespace Experimental
} // namespace Phonon
