/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.text;

import info.aduna.text.StringUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class StringSearch {
    public static int find(String text, String searchString, boolean caseSensitive) {
        if (!caseSensitive) {
            searchString = searchString.toLowerCase();
            text = text.toLowerCase();
        }
        text = StringUtil.gsub("\n", " ", text);
        text = StringUtil.gsub("\t", " ", text);
        text = StringUtil.gsub("\r", " ", text);
        text = StringUtil.gsub("\f", " ", text);
        HashSet<String> includeTokens = new HashSet<String>();
        HashSet<String> excludeTokens = new HashSet<String>();
        HashSet<String> neutralTokens = new HashSet<String>();
        String quotedToken = null;
        int openQuoteIndex = searchString.indexOf("\"");
        while (openQuoteIndex >= 0 && searchString.length() > 1) {
            StringBuilder tmpBuf = new StringBuilder(searchString);
            int closeQuoteIndex = searchString.indexOf("\"", openQuoteIndex + 1);
            if (closeQuoteIndex < 0 && (closeQuoteIndex = searchString.indexOf(" ", openQuoteIndex + 1)) < 0) {
                closeQuoteIndex = searchString.length();
            }
            quotedToken = searchString.substring(openQuoteIndex + 1, closeQuoteIndex);
            tmpBuf.delete(openQuoteIndex, closeQuoteIndex + 1);
            if (openQuoteIndex > 0) {
                if (searchString.charAt(openQuoteIndex - 1) == '+') {
                    includeTokens.add(quotedToken);
                    tmpBuf.deleteCharAt(openQuoteIndex - 1);
                } else if (searchString.charAt(openQuoteIndex - 1) == '-') {
                    excludeTokens.add(quotedToken);
                    tmpBuf.deleteCharAt(openQuoteIndex - 1);
                } else {
                    neutralTokens.add(quotedToken);
                }
            } else {
                neutralTokens.add(quotedToken);
            }
            searchString = tmpBuf.toString();
            openQuoteIndex = searchString.indexOf("\"", closeQuoteIndex + 1);
        }
        StringTokenizer strtok = new StringTokenizer(searchString);
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            if (token.startsWith("+")) {
                includeTokens.add(token.substring(1));
                continue;
            }
            if (token.startsWith("-")) {
                excludeTokens.add(token.substring(1));
                continue;
            }
            neutralTokens.add(token);
        }
        int result = 0;
        Iterator it = includeTokens.iterator();
        while (it.hasNext() && result >= 0) {
            String includeToken = (String)it.next();
            if (!StringSearch.contains(text, includeToken)) {
                result = -1;
                continue;
            }
            ++result;
        }
        if (result >= 0) {
            it = excludeTokens.iterator();
            while (it.hasNext() && result >= 0) {
                String excludeToken = (String)it.next();
                if (!StringSearch.contains(text, excludeToken)) continue;
                result = -1;
            }
        }
        if (result >= 0) {
            for (String neutralToken : neutralTokens) {
                if (!StringSearch.contains(text, neutralToken)) continue;
                ++result;
            }
        }
        return result;
    }

    public static int find(String text, String searchString, boolean caseSensitive, boolean relevance) {
        if (relevance) {
            return StringSearch.find(text, searchString, caseSensitive);
        }
        if (!caseSensitive) {
            searchString = searchString.toLowerCase();
            text = text.toLowerCase();
        }
        text = StringUtil.gsub("\n", " ", text);
        text = StringUtil.gsub("\t", " ", text);
        text = StringUtil.gsub("\r", " ", text);
        text = StringUtil.gsub("\f", " ", text);
        HashSet<String> includeTokens = new HashSet<String>();
        HashSet<String> excludeTokens = new HashSet<String>();
        HashSet<String> neutralTokens = new HashSet<String>();
        String quotedToken = null;
        int openQuoteIndex = searchString.indexOf("\"");
        while (openQuoteIndex >= 0 && searchString.length() > 1) {
            StringBuilder tmpBuf = new StringBuilder(searchString);
            int closeQuoteIndex = searchString.indexOf("\"", openQuoteIndex + 1);
            if (closeQuoteIndex < 0 && (closeQuoteIndex = searchString.indexOf(" ", openQuoteIndex + 1)) < 0) {
                closeQuoteIndex = searchString.length();
            }
            quotedToken = searchString.substring(openQuoteIndex + 1, closeQuoteIndex);
            tmpBuf.delete(openQuoteIndex, closeQuoteIndex + 1);
            if (openQuoteIndex > 0) {
                if (searchString.charAt(openQuoteIndex - 1) == '+') {
                    includeTokens.add(quotedToken);
                    tmpBuf.deleteCharAt(openQuoteIndex - 1);
                } else if (searchString.charAt(openQuoteIndex - 1) == '-') {
                    excludeTokens.add(quotedToken);
                    tmpBuf.deleteCharAt(openQuoteIndex - 1);
                } else {
                    neutralTokens.add(quotedToken);
                }
            } else {
                neutralTokens.add(quotedToken);
            }
            searchString = tmpBuf.toString();
            openQuoteIndex = searchString.indexOf("\"", closeQuoteIndex + 1);
        }
        StringTokenizer strtok = new StringTokenizer(searchString);
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            if (token.startsWith("+")) {
                includeTokens.add(token.substring(1));
                continue;
            }
            if (token.startsWith("-")) {
                excludeTokens.add(token.substring(1));
                continue;
            }
            neutralTokens.add(token);
        }
        for (String includeToken : includeTokens) {
            if (StringSearch.contains(text, includeToken)) continue;
            return -1;
        }
        for (String excludeToken : excludeTokens) {
            if (!StringSearch.contains(text, excludeToken)) continue;
            return -1;
        }
        for (String neutralToken : neutralTokens) {
            if (!StringSearch.contains(text, neutralToken)) continue;
            return 1;
        }
        if (!includeTokens.isEmpty() || !excludeTokens.isEmpty()) {
            return 1;
        }
        return -1;
    }

    public static boolean contains(String text, String token) {
        String DELIMITERS = " .,/\\?!`'~#$%^&*()-_=+|[]{}";
        boolean result = false;
        int tokenLength = token.length();
        int textLength = text.length();
        if (token.startsWith("*") && token.endsWith("*") && tokenLength > 2) {
            result = text.indexOf(token.substring(1, tokenLength - 1)) >= 0;
        } else if (token.startsWith("*") && tokenLength > 1) {
            String stoken = token.substring(1, tokenLength);
            int stokenLength = stoken.length();
            int position = text.indexOf(stoken, 0);
            while (!result && position >= 0) {
                result = position + stokenLength >= textLength || DELIMITERS.indexOf(text.charAt(position + stokenLength)) >= 0;
                position = text.indexOf(stoken, position + 1);
            }
        } else if (token.endsWith("*") && tokenLength > 1) {
            String stoken = token.substring(0, tokenLength - 1);
            int position = text.indexOf(stoken, 0);
            while (!result && position >= 0) {
                result = position == 0 || DELIMITERS.indexOf(text.charAt(position - 1)) >= 0;
                position = text.indexOf(stoken, position + 1);
            }
        } else {
            result = StringSearch.containsDelimiter(token, DELIMITERS) ? text.indexOf(token) >= 0 : StringSearch.containsWord(token, text, DELIMITERS);
        }
        return result;
    }

    private static boolean containsWord(String word, String text, String delimiters) {
        boolean result = false;
        StringTokenizer strtok = new StringTokenizer(text, delimiters);
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            if (!token.equals(word)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean containsDelimiter(String text, String delimiters) {
        StringTokenizer strtok = new StringTokenizer(text, delimiters);
        return strtok.countTokens() > 1;
    }
}

