/*
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// client.h -- primary header for client

//define	PARANOID			// speed sapping error checking

#include "ref.h"
#include "vid.h"
#include "screen.h"
#include "sound.h"
#include "input.h"
#include "keys.h"
#ifdef CD_AUDIO
#include "cdaudio.h"
#endif

#ifdef USE_CURL
#define CURL_STATICLIB
#include <curl/curl.h>
#endif

//=============================================================================

typedef struct
{
	qboolean		valid;			// cleared if delta parsing was invalid
	int				serverframe;
	int				servertime;		// server time the message is valid for (in msec)
	int				deltaframe;
	byte			areabits[MAX_MAP_AREAS/8];		// portalarea visibility bits
	player_state_t	playerstate;
	int				num_entities;
	int				parse_entities;	// non-masked index into cl_parse_entities array
} frame_t;

typedef struct
{
	entity_state_t	baseline;		// delta from this if not from a previous frame
	entity_state_t	current;
	entity_state_t	prev;			// will always be valid, but might just be a copy of current

	int			serverframe;		// if not current, this ent isn't in the frame

	int			trailcount;			// for diminishing grenade trails
	vec3_t		lerp_origin;		// for trails (variable hz)

	int			fly_stoptime;
} centity_t;

#define MAX_CLIENTWEAPONMODELS		20		// PGM -- upped from 16 to fit the chainfist vwep

typedef struct
{
	char	name[MAX_QPATH];
	char	cinfo[MAX_QPATH];
	struct image_s	*skin;
	struct image_s	*icon;
	char	iconname[MAX_QPATH];
	struct model_s	*model;
	struct model_s	*weaponmodel[MAX_CLIENTWEAPONMODELS];
} clientinfo_t;

extern char cl_weaponmodels[MAX_CLIENTWEAPONMODELS][MAX_QPATH];
extern int num_cl_weaponmodels;

#define	CMD_BACKUP		64	// allow a lot of command backups for very fast systems
#define CMD_MASK		(CMD_BACKUP-1)

#ifdef USE_CURL
void CL_CancelHTTPDownloads (qboolean permKill);
void CL_InitHTTPDownloads (void);
qboolean CL_QueueHTTPDownload (const char *quakePath);
void CL_RunHTTPDownloads (void);
qboolean CL_PendingHTTPDownloads (void);
void CL_SetHTTPServer (const char *URL);
void CL_HTTP_Cleanup (qboolean fullShutdown);

typedef enum
{
	DLQ_STATE_NOT_STARTED,
	DLQ_STATE_RUNNING,
	DLQ_STATE_DONE
} dlq_state;

typedef struct dlqueue_s
{
	struct dlqueue_s	*next;
	char				quakePath[MAX_QPATH];
	dlq_state			state;
} dlqueue_t;

typedef struct dlhandle_s
{
	CURL		*curl;
	char		filePath[MAX_OSPATH];
	FILE		*file;
	dlqueue_t	*queueEntry;
	size_t		fileSize;
	size_t		position;
	double		speed;
	char		URL[576];
	char		*tempBuffer;
} dlhandle_t;
#endif

typedef struct {
	int		realtime;	// time sent, for calculating pings
	int		cmdNumber;	// current cmdNumber for this frame
} client_history_t;

//
// the client_state_t structure is wiped completely at every
// server map change
//
typedef struct
{
	unsigned int timeoutcount;

	unsigned int timedemo_frames;
	unsigned int timedemo_start;

	qboolean	refresh_prepped;	// false if on new level or new ref dll
	qboolean	sound_prepped;		// ambient sounds can start
	qboolean	force_refdef;		// vid has changed, so we can't use a paused refdef

	int			parse_entities;		// index (not anded off) into cl_parse_entities[]

	qboolean	sendPacketNow;
	usercmd_t	cmd;
	usercmd_t	cmds[CMD_BACKUP];	// each mesage will send several old cmds
	int			cmdNumber;
	int16		predicted_origins[CMD_BACKUP][3];	// for debug comparing against server
	client_history_t	history[CMD_BACKUP];

	float		predicted_step;				// for stair up smoothing
	unsigned int predicted_step_time;
	int			predicted_step_frame;
	vec3_t		move;

	vec3_t		predicted_origin;	// generated by CL_PredictMovement
	vec3_t		predicted_angles;
	vec3_t		predicted_velocity;
	vec3_t		prediction_error;

	frame_t		frame;				// received from server
	int			surpressCount;		// number of messages rate supressed
	frame_t		frames[UPDATE_BACKUP];

	int			serverTime;

	// the client maintains its own idea of view angles, which are
	// sent to the server each frame.  It is cleared to 0 upon entering each level.
	// the server sends a delta each frame which is added to the locally
	// tracked view angles to account for standing on rotating objects,
	// and teleport direction changes
	vec3_t		viewangles;

	int			time;			// this is the time value that the client
								// is rendering at.  always <= cls.realtime
	//int			initial_server_frame;
	float		lerpfrac;		// between oldframe and frame

	refdef_t	refdef;

	vec3_t		v_forward, v_right, v_up;	// set when refdef.angles is set

	//
	// transient data from server
	//
	char		layout[1024];		// general 2D overlay
	int			inventory[MAX_ITEMS];

	//
	// non-gameserver infornamtion
	// FIXME: move this cinematic stuff into the cin_t structure
	fileHandle_t cinematic_file;
	int			cinematictime;		// cls.realtime for first cinematic frame
	int			cinematicframe;
	unsigned char		cinematicpalette[768];
	qboolean	cinematicpalette_active;

	//
	// server state information
	//
	qboolean	attractloop;		// running the attract loop, any key will menu
	int			servercount;	// server identification for prespawns
	char		gamedir[MAX_QPATH];
	int			playernum;
	int			maxclients;
	pmoveParams_t pmp;

	char		configstrings[MAX_CONFIGSTRINGS][MAX_QPATH];

	//
	// locally derived information from server state
	//
	struct model_s	*model_draw[MAX_MODELS];
	struct cmodel_s	*model_clip[MAX_MODELS];

	struct sfx_s	*sound_precache[MAX_SOUNDS];
	struct image_s	*image_precache[MAX_IMAGES];

	clientinfo_t	clientinfo[MAX_CLIENTS];
	clientinfo_t	baseclientinfo;

	byte			demoFrame[1400];
	sizebuf_t		demoBuff;

	unsigned		settings[SVSET_MAX];

} client_state_t;

extern	client_state_t	cl;

/*
==================================================================

the client_static_t structure is persistant through an arbitrary number
of server connections

==================================================================
*/
typedef struct playerStatus_s {
	char name[16];
	int ping;
	int score;
} playerStatus_t;

#define MAX_PLAYERSTATUS	32

typedef struct serverStatus_s {
	char	address[MAX_QPATH];
	char	infostring[MAX_INFO_STRING];
	playerStatus_t	players[MAX_PLAYERSTATUS];
	int	numPlayers;
} serverStatus_t;

typedef enum {
	ca_uninitialized,
	ca_disconnected, 	// not talking to a server
	ca_connecting,		// sending request packets to the server
	ca_connected,		// netchan_t established, waiting for svc_serverdata
	ca_active			// game views should be displayed
} connstate_t;

/*typedef enum {
	dl_none,
	dl_model,
	dl_sound,
	dl_skin,
	dl_single
} dltype_t;		// download type
*/
typedef enum {key_game, key_console, key_message, key_menu} keydest_t;

typedef struct
{
	connstate_t	state;
	keydest_t	key_dest;

	//int			framecount;
	unsigned int realtime;			// always increasing, no clamping, etc
	float		 frametime;			// seconds since last frame

// screen rendering information
	unsigned int disable_screen;		// showing loading plaque between levels
									// or changing rendering dlls
									// if time gets > 30 seconds ahead, break it
	int			disable_servercount;	// when we receive a frame and cl.servercount
									// > cls.disable_servercount, clear disable_screen

// connection information
	char		servername[MAX_OSPATH];	// name of server from original connect
	char		lastservername[MAX_OSPATH];	// name of server from original connect
	int			connect_time;		// for connection retransmits

	int			quakePort;			// a 16 bit value that allows quake servers
									// to work around address translating routers
	netchan_t	netchan;
	int			serverProtocol;		// in case we are doing some kind of version hack

	int			challenge;			// from the server to use for connecting

	FILE		*download;			// file transfer from server
	char		downloadtempname[MAX_OSPATH];
	char		downloadname[MAX_OSPATH];
	//int		downloadnumber;
	//dltype_t	downloadtype;
	int			downloadpercent;

	qboolean	failed_download;
	size_t		downloadposition;

// demo recording info must be here, so it isn't cleared on level change
	qboolean	demorecording;
	qboolean	demowaiting;	// don't record until a non-delta message is received
	fileHandle_t demofile;

	qboolean		demoplaying;
	unsigned int	timeDemoFrames;		// counter of rendered frames
	unsigned int	timeDemoStart;		// cls.realtime before first frame
	unsigned int	timeDemoBaseTime;	// each frame will be at this time + frameNum * 50

	int doscreenshot;

	char mapname[MAX_QPATH];

	unsigned int lastSpamTime; //last client reply time
	unsigned int spamTime;
	unsigned int roundtime; //Hack to show roundtime in aq2 mod

	int			protocolVersion;	// R1Q2 protocol minor version

#ifdef USE_CURL
	dlqueue_t		downloadQueue;			//queue of paths we need
	
	dlhandle_t		HTTPHandles[4];			//actual download handles
	//don't raise this!
	//i use a hardcoded maximum of 4 simultaneous connections to avoid
	//overloading the server. i'm all too familiar with assholes who set
	//their IE or Firefox max connections to 16 and rape my Apache processes
	//every time they load a page... i'd rather not have my q2 client also
	//have the ability to do so - especially since we're possibly downloading
	//large files.

	char			downloadServer[512];	//base url prefix to download from
	char			downloadReferer[32];	//libcurl requires a static string :(
#endif
} client_static_t;

extern client_static_t	cls;

//=============================================================================

//
// cvars
//
extern	cvar_t	*cl_stereo_separation;
extern	cvar_t	*cl_stereo;

extern	cvar_t	*cl_gun;
extern	cvar_t	*cl_add_blend;
extern	cvar_t	*cl_add_lights;
extern	cvar_t	*cl_add_particles;
extern	cvar_t	*cl_add_entities;
extern	cvar_t	*cl_predict;
extern	cvar_t	*cl_footsteps;
extern	cvar_t	*cl_noskins;
//extern	cvar_t	*cl_autoskins;

extern	cvar_t	*cl_upspeed;
extern	cvar_t	*cl_forwardspeed;
extern	cvar_t	*cl_sidespeed;

extern	cvar_t	*cl_yawspeed;
extern	cvar_t	*cl_pitchspeed;

extern	cvar_t	*cl_run;

extern	cvar_t	*cl_anglespeedkey;

extern	cvar_t	*cl_shownet;
extern	cvar_t	*cl_showmiss;
extern	cvar_t	*cl_showclamp;

extern	cvar_t	*lookspring;
extern	cvar_t	*lookstrafe;
extern	cvar_t	*sensitivity;

extern	cvar_t	*m_pitch;
extern	cvar_t	*m_yaw;
extern	cvar_t	*m_forward;
extern	cvar_t	*m_side;

extern	cvar_t	*freelook;

extern	cvar_t	*cl_lightlevel;	// FIXME HACK

extern	cvar_t	*cl_paused;
extern	cvar_t	*cl_timedemo;

extern	cvar_t	*cl_vwep;

extern	cvar_t	*ch_alpha;
extern	cvar_t	*ch_pulse;
extern	cvar_t	*ch_scale;
extern	cvar_t	*ch_red;
extern	cvar_t	*ch_green;
extern	cvar_t	*ch_blue;
extern	cvar_t	*con_notifylines;
extern	cvar_t	*con_notifyfade;
extern	cvar_t	*con_alpha;
extern	cvar_t	*con_scrlines;
extern	cvar_t	*cl_clock;
extern	cvar_t	*cl_fps;
extern	cvar_t	*cl_chathud;
extern	cvar_t	*cl_chathudlines;
extern	cvar_t	*cl_maptime;
extern	cvar_t	*cl_timestamps;
extern	cvar_t	*cl_timestampsformat;
extern	cvar_t	*scr_conheight;
extern	cvar_t	*cl_hudalpha;
extern	cvar_t	*cl_textcolors;
extern	cvar_t	*cl_autorecord;

#ifdef USE_CURL
extern	cvar_t	*cl_http_downloads;
extern	cvar_t	*cl_http_filelists;
extern	cvar_t	*cl_http_proxy;
extern	cvar_t	*cl_http_max_connections;
#endif

typedef struct
{
	int		key;				// so entities can reuse same entry
	vec3_t	color;
	vec3_t	origin;
	float	radius;
	float	die;				// stop lighting after this time
	//float	decay;				// drop this each second
	//float	minlight;			// don't add when contributing less
} cdlight_t;

extern	centity_t	cl_entities[MAX_EDICTS];
//extern	cdlight_t	cl_dlights[MAX_DLIGHTS];

// the cl_parse_entities must be large enough to hold UPDATE_BACKUP frames of
// entities, so that when a delta compressed message arives from the server
// it can be un-deltad from the original 
#define	MAX_PARSE_ENTITIES		1024
#define PARSE_ENTITIES_MASK		( MAX_PARSE_ENTITIES - 1 )
extern	entity_state_t	cl_parse_entities[MAX_PARSE_ENTITIES];

//=============================================================================

extern	netadr_t	net_from;
extern	sizebuf_t	net_message;

#ifdef GL_QUAKE
void Draw_String (int x, int y, const char *s, int color, float alpha, qboolean alt);
void DrawCString (int x, int y, const short *s, float alpha, int enable);

#define DrawString(x, y, s)				Draw_String((x), (y), (s), 7, 1, false)
#define DrawAltString(x, y, s)			Draw_String((x), (y), (s), 7, 1, true)
#define DrawColorString(x, y, s, c, a)	Draw_String((x), (y), (s), (c), (a), false)
#define DrawString2(x, y, s, a)			DrawCString((x), (y), (s), (a), (cl_textcolors->integer))
#else
void DrawString (int x, int y, const char *s);
void DrawAltString (int x, int y, const char *s);	// toggle high bit
void DrawString2 (int x, int y, const short *s, float alpha);
#define Draw_String(x, y, s, c, a, alt) ((alt) ? DrawAltString((x), (y), (s)) : DrawString((x), (y), (s)))
#define DrawColorString(x, y, s, c, a)	(((c)&2) ? DrawAltString((x), (y), (s)) : DrawString((x), (y), (s)))
#endif

qboolean	CL_CheckOrDownloadFile (const char *filename);

void CL_AddNetgraph (void);

//ROGUE
typedef struct cl_sustain
{
	int			id;
	int			type;
	int			endtime;
	int			nextthink;
	int			thinkinterval;
	vec3_t		org;
	vec3_t		dir;
	int			color;
	int			count;
	int			magnitude;
	void		(*think)(struct cl_sustain *self);
} cl_sustain_t;

#define MAX_SUSTAINS		32
void CL_ParticleSteamEffect2(cl_sustain_t *self);

void CL_TeleporterParticles (const entity_state_t *ent);
void CL_ParticleEffect (const vec3_t org, const vec3_t dir, int color, int count);
void CL_ParticleEffect2 (const vec3_t org, const vec3_t dir, int color, int count);

// RAFAEL
void CL_ParticleEffect3 (const vec3_t org, const vec3_t dir, int color, int count);


//=================================================

// ========
// PGM
typedef struct particle_s
{
	struct particle_s	*next;

	float		time;

	vec3_t		org;
	vec3_t		vel;
	vec3_t		accel;
	int			color;
	//float		color;
	//float		colorvel;
	float		alpha;
	float		alphavel;
} cparticle_t;


#define	PARTICLE_GRAVITY	40
#define BLASTER_PARTICLE_COLOR		0xe0
// PMM
#define INSTANT_PARTICLE	-10000.0
// PGM
// ========

void CL_ClearEffects (void);
void CL_ClearTEnts (void);
void CL_BlasterTrail (const vec3_t start, const vec3_t end);
void CL_QuadTrail (const vec3_t start, const vec3_t end);
void CL_RailTrail (const vec3_t start, const vec3_t end);
void CL_BubbleTrail (const vec3_t start, const vec3_t end);
void CL_FlagTrail (const vec3_t start, const vec3_t end, float color);

// RAFAEL
void CL_IonripperTrail (const vec3_t start, const vec3_t end);

// ========
// PGM
void CL_BlasterParticles2 (const vec3_t org, const vec3_t dir, unsigned int color);
void CL_BlasterTrail2 (const vec3_t start, const vec3_t end);
void CL_DebugTrail (const vec3_t start, const vec3_t end);
void CL_SmokeTrail (const vec3_t start, const vec3_t end, int colorStart, int colorRun, int spacing);
void CL_Flashlight (int ent, const vec3_t pos);
void CL_ForceWall (const vec3_t start, const vec3_t end, int color);
//void CL_FlameEffects (centity_t *ent, vec3_t origin);
void CL_GenericParticleEffect (const vec3_t org, const vec3_t dir, int color, int count, int numcolors, int dirspread, float alphavel);
void CL_BubbleTrail2 (const vec3_t start, const vec3_t end, int dist);
void CL_Heatbeam (const vec3_t start, const vec3_t end);
void CL_ParticleSteamEffect (const vec3_t org, const vec3_t dir, int color, int count, int magnitude);
void CL_TrackerTrail (const vec3_t start, const vec3_t end, int particleColor);
void CL_Tracker_Explode(const vec3_t origin);
void CL_TagTrail (const vec3_t start, const vec3_t end, int color);
void CL_ColorFlash (const vec3_t pos, int ent, int intensity, float r, float g, float b);
void CL_Tracker_Shell(const vec3_t origin);
void CL_MonsterPlasma_Shell(const vec3_t origin);
void CL_ColorExplosionParticles (const vec3_t org, int color, int run);
void CL_ParticleSmokeEffect (const vec3_t org, const vec3_t dir, int color, int count, int magnitude);
void CL_Widowbeamout (cl_sustain_t *self);
void CL_Nukeblast (cl_sustain_t *self);
void CL_WidowSplash (const vec3_t org);
// PGM
// ========

int CL_ParseEntityBits (sizebuf_t *msg, unsigned int *bits);
void CL_ParseDelta (sizebuf_t *msg, const entity_state_t *from, entity_state_t *to, int number, int bits);
void CL_ParseFrame (sizebuf_t *msg, int extrabits);

void CL_ParseTEnt (sizebuf_t *msg);
void CL_ParseMuzzleFlash (sizebuf_t *msg);
void CL_ParseMuzzleFlash2 (sizebuf_t *msg);
void SmokeAndFlash(vec3_t origin);

void CL_SetLightstyle (int index);

void CL_RunParticles (void);
void CL_RunDLights (void);
void CL_RunLightStyles (void);

void CL_AddEntities (void);
void CL_AddDLights (void);
void CL_AddTEnts (void);
void CL_AddLightStyles (void);

//=================================================

void CL_PrepRefresh (void);
void CL_RegisterSounds (void);

void CL_Quit_f (void);

void IN_Accumulate (void);

//void CL_ParseLayout (void);


//
// cl_main
//

void CL_Init (void);

void CL_FixUpGender(void);
void CL_Disconnect (void);
void CL_Disconnect_f (void);
void CL_GetChallengePacket (void);
void CL_PingServers_f (void);
void CL_Snd_Restart_f (void);
void CL_RequestNextDownload (void);

void CL_FixCvarCheats (void);
void CL_RestartFilesystem (qboolean execAutoexec);

//
// cl_input
//
typedef struct
{
	int			down[2];		// key nums holding it down
	unsigned	downtime;		// msec timestamp
	unsigned	msec;			// msec down this frame
	int			state;
} kbutton_t;

extern 	kbutton_t 	in_strafe;
extern 	kbutton_t 	in_speed;

void CL_InitInput (void);
void CL_SendCmd (void);

void CL_ClearState (void);

void CL_ReadPackets (void);

void IN_CenterView (void);

const char *Key_KeynumToString (int keynum);

//
// cl_demo.c
//
void CL_WriteDemoMessageFull (sizebuf_t *msg);
void CL_WriteDemoMessage (byte *buff, int len, qboolean forceFlush);

void CL_Stop_f (void);
void CL_Record_f (void);
void CL_InitDemos(void);
void CL_StartAutoRecord(void);
void CL_StopAutoRecord (void);

//
// console.c
//
void Con_CheckResize (void);
void Con_Init (void);
void Con_DrawConsole (float frac, qboolean ingame);
void Con_Print (const char *txt);
void Con_CenteredPrint (const char *text);
void Con_Clear_f (void);
void Con_DrawNotify (void);
void Con_ClearNotify (void);
void Con_ToggleConsole_f (void);
void Con_SkipNotify ( qboolean skip );

//
// cl_parse.c
//
extern	const char *svc_strings[256];

void CL_ParseServerMessage (sizebuf_t *msg);
void CL_LoadClientinfo (clientinfo_t *ci, char *s);
void SHOWNET(sizebuf_t *msg, const char *s);
void CL_ParseClientinfo (int player);
void CL_Download_f (void);

//
// cl_view.c
//

void V_Init (void);
void V_RenderView( float stereo_separation );
void V_AddEntity (const entity_t *ent);
void V_AddParticle (const particle_t *p);
void V_AddLight (const vec3_t org, float intensity, float r, float g, float b);
void V_AddLightStyle (int style, const vec3_t value);

// cl_tent.c
void CL_RegisterTEntSounds (void);
void CL_RegisterTEntModels (void);
void CL_SmokeAndFlash(const vec3_t origin);


// cl_pred.c
void CL_InitPrediction (void);
void CL_PredictMove (void);
void CL_CheckPredictionError (void);

// cl_fx.c
cdlight_t *CL_AllocDlight (int key);
void CL_BigTeleportParticles (const vec3_t org);
void CL_RocketTrail (const vec3_t start, const vec3_t end, centity_t *old);
void CL_DiminishingTrail (const vec3_t start, const vec3_t end, centity_t *old, int flags);
void CL_FlyEffect (centity_t *ent, const vec3_t origin);
void CL_BfgParticles (const entity_t *ent);
void CL_AddParticles (void);
void CL_EntityEvent (const entity_state_t *ent);
// RAFAEL
void CL_TrapParticles (entity_t *ent);

#define MAX_LOCAL_SERVERS 9
// menus
void M_Init (void);
//void M_Keydown (int key);
void M_Keydown (int key, qboolean down);
void M_MouseMove( int mx, int my );
void M_Draw (void);
void M_Menu_Main_f (void);
void M_ForceMenuOff (void);
void M_AddToServerList (const serverStatus_t *status);

// cl_inv.c
void CL_ParseInventory (sizebuf_t *msg);
void CL_DrawInventory (void);

// cl_pred.c
void CL_PredictMovement (void);

#if id386
void x86_TimerStart( void );
void x86_TimerStop( void );
void x86_TimerInit( unsigned long smallest, unsigned longest );
unsigned long *x86_TimerGetHistogram( void );
#endif

// cl_locs.c
void CL_FreeLocs(void);
void CL_LoadLoc(void);
void CL_AddViewLocs(void);
void CL_InitLocs(void);

//AVI EXPORT
#ifdef AVI_EXPORT
#include "avi_export.h"
#endif

#include "mp3.h"

