/* Copyright (c) 2002,2007-2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

START_ENUMTYPE(SU_PERFCNT_SELECT)
    GENERATE_ENUM(PERF_PAPC_PASX_REQ, 0)
    GENERATE_ENUM(UNUSED1, 1)
    GENERATE_ENUM(PERF_PAPC_PASX_FIRST_VECTOR, 2)
    GENERATE_ENUM(PERF_PAPC_PASX_SECOND_VECTOR, 3)
    GENERATE_ENUM(PERF_PAPC_PASX_FIRST_DEAD, 4)
    GENERATE_ENUM(PERF_PAPC_PASX_SECOND_DEAD, 5)
    GENERATE_ENUM(PERF_PAPC_PASX_VTX_KILL_DISCARD, 6)
    GENERATE_ENUM(PERF_PAPC_PASX_VTX_NAN_DISCARD, 7)
    GENERATE_ENUM(PERF_PAPC_PA_INPUT_PRIM, 8)
    GENERATE_ENUM(PERF_PAPC_PA_INPUT_NULL_PRIM, 9)
    GENERATE_ENUM(PERF_PAPC_PA_INPUT_EVENT_FLAG, 10)
    GENERATE_ENUM(PERF_PAPC_PA_INPUT_FIRST_PRIM_SLOT, 11)
    GENERATE_ENUM(PERF_PAPC_PA_INPUT_END_OF_PACKET, 12)
    GENERATE_ENUM(PERF_PAPC_CLPR_CULL_PRIM, 13)
    GENERATE_ENUM(UNUSED2, 14)
    GENERATE_ENUM(PERF_PAPC_CLPR_VV_CULL_PRIM, 15)
    GENERATE_ENUM(UNUSED3, 16)
    GENERATE_ENUM(PERF_PAPC_CLPR_VTX_KILL_CULL_PRIM, 17)
    GENERATE_ENUM(PERF_PAPC_CLPR_VTX_NAN_CULL_PRIM, 18)
    GENERATE_ENUM(PERF_PAPC_CLPR_CULL_TO_NULL_PRIM, 19)
    GENERATE_ENUM(UNUSED4, 20)
    GENERATE_ENUM(PERF_PAPC_CLPR_VV_CLIP_PRIM, 21)
    GENERATE_ENUM(UNUSED5, 22)
    GENERATE_ENUM(PERF_PAPC_CLPR_POINT_CLIP_CANDIDATE, 23)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_CNT_1, 24)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_CNT_2, 25)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_CNT_3, 26)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_CNT_4, 27)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_CNT_5, 28)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_CNT_6, 29)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_NEAR, 30)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_FAR, 31)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_LEFT, 32)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_RIGHT, 33)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_TOP, 34)
    GENERATE_ENUM(PERF_PAPC_CLPR_CLIP_PLANE_BOTTOM, 35)
    GENERATE_ENUM(PERF_PAPC_CLSM_NULL_PRIM, 36)
    GENERATE_ENUM(PERF_PAPC_CLSM_TOTALLY_VISIBLE_PRIM, 37)
    GENERATE_ENUM(PERF_PAPC_CLSM_CLIP_PRIM, 38)
    GENERATE_ENUM(PERF_PAPC_CLSM_CULL_TO_NULL_PRIM, 39)
    GENERATE_ENUM(PERF_PAPC_CLSM_OUT_PRIM_CNT_1, 40)
    GENERATE_ENUM(PERF_PAPC_CLSM_OUT_PRIM_CNT_2, 41)
    GENERATE_ENUM(PERF_PAPC_CLSM_OUT_PRIM_CNT_3, 42)
    GENERATE_ENUM(PERF_PAPC_CLSM_OUT_PRIM_CNT_4, 43)
    GENERATE_ENUM(PERF_PAPC_CLSM_OUT_PRIM_CNT_5, 44)
    GENERATE_ENUM(PERF_PAPC_CLSM_OUT_PRIM_CNT_6_7, 45)
    GENERATE_ENUM(PERF_PAPC_CLSM_NON_TRIVIAL_CULL, 46)
    GENERATE_ENUM(PERF_PAPC_SU_INPUT_PRIM, 47)
    GENERATE_ENUM(PERF_PAPC_SU_INPUT_CLIP_PRIM, 48)
    GENERATE_ENUM(PERF_PAPC_SU_INPUT_NULL_PRIM, 49)
    GENERATE_ENUM(PERF_PAPC_SU_ZERO_AREA_CULL_PRIM, 50)
    GENERATE_ENUM(PERF_PAPC_SU_BACK_FACE_CULL_PRIM, 51)
    GENERATE_ENUM(PERF_PAPC_SU_FRONT_FACE_CULL_PRIM, 52)
    GENERATE_ENUM(PERF_PAPC_SU_POLYMODE_FACE_CULL, 53)
    GENERATE_ENUM(PERF_PAPC_SU_POLYMODE_BACK_CULL, 54)
    GENERATE_ENUM(PERF_PAPC_SU_POLYMODE_FRONT_CULL, 55)
    GENERATE_ENUM(PERF_PAPC_SU_POLYMODE_INVALID_FILL, 56)
    GENERATE_ENUM(PERF_PAPC_SU_OUTPUT_PRIM, 57)
    GENERATE_ENUM(PERF_PAPC_SU_OUTPUT_CLIP_PRIM, 58)
    GENERATE_ENUM(PERF_PAPC_SU_OUTPUT_NULL_PRIM, 59)
    GENERATE_ENUM(PERF_PAPC_SU_OUTPUT_EVENT_FLAG, 60)
    GENERATE_ENUM(PERF_PAPC_SU_OUTPUT_FIRST_PRIM_SLOT, 61)
    GENERATE_ENUM(PERF_PAPC_SU_OUTPUT_END_OF_PACKET, 62)
    GENERATE_ENUM(PERF_PAPC_SU_OUTPUT_POLYMODE_FACE, 63)
    GENERATE_ENUM(PERF_PAPC_SU_OUTPUT_POLYMODE_BACK, 64)
    GENERATE_ENUM(PERF_PAPC_SU_OUTPUT_POLYMODE_FRONT, 65)
    GENERATE_ENUM(PERF_PAPC_SU_OUT_CLIP_POLYMODE_FACE, 66)
    GENERATE_ENUM(PERF_PAPC_SU_OUT_CLIP_POLYMODE_BACK, 67)
    GENERATE_ENUM(PERF_PAPC_SU_OUT_CLIP_POLYMODE_FRONT, 68)
    GENERATE_ENUM(PERF_PAPC_PASX_REQ_IDLE, 69)
    GENERATE_ENUM(PERF_PAPC_PASX_REQ_BUSY, 70)
    GENERATE_ENUM(PERF_PAPC_PASX_REQ_STALLED, 71)
    GENERATE_ENUM(PERF_PAPC_PASX_REC_IDLE, 72)
    GENERATE_ENUM(PERF_PAPC_PASX_REC_BUSY, 73)
    GENERATE_ENUM(PERF_PAPC_PASX_REC_STARVED_SX, 74)
    GENERATE_ENUM(PERF_PAPC_PASX_REC_STALLED, 75)
    GENERATE_ENUM(PERF_PAPC_PASX_REC_STALLED_POS_MEM, 76)
    GENERATE_ENUM(PERF_PAPC_PASX_REC_STALLED_CCGSM_IN, 77)
    GENERATE_ENUM(PERF_PAPC_CCGSM_IDLE, 78)
    GENERATE_ENUM(PERF_PAPC_CCGSM_BUSY, 79)
    GENERATE_ENUM(PERF_PAPC_CCGSM_STALLED, 80)
    GENERATE_ENUM(PERF_PAPC_CLPRIM_IDLE, 81)
    GENERATE_ENUM(PERF_PAPC_CLPRIM_BUSY, 82)
    GENERATE_ENUM(PERF_PAPC_CLPRIM_STALLED, 83)
    GENERATE_ENUM(PERF_PAPC_CLPRIM_STARVED_CCGSM, 84)
    GENERATE_ENUM(PERF_PAPC_CLIPSM_IDLE, 85)
    GENERATE_ENUM(PERF_PAPC_CLIPSM_BUSY, 86)
    GENERATE_ENUM(PERF_PAPC_CLIPSM_WAIT_CLIP_VERT_ENGH, 87)
    GENERATE_ENUM(PERF_PAPC_CLIPSM_WAIT_HIGH_PRI_SEQ, 88)
    GENERATE_ENUM(PERF_PAPC_CLIPSM_WAIT_CLIPGA, 89)
    GENERATE_ENUM(PERF_PAPC_CLIPSM_WAIT_AVAIL_VTE_CLIP, 90)
    GENERATE_ENUM(PERF_PAPC_CLIPSM_WAIT_CLIP_OUTSM, 91)
    GENERATE_ENUM(PERF_PAPC_CLIPGA_IDLE, 92)
    GENERATE_ENUM(PERF_PAPC_CLIPGA_BUSY, 93)
    GENERATE_ENUM(PERF_PAPC_CLIPGA_STARVED_VTE_CLIP, 94)
    GENERATE_ENUM(PERF_PAPC_CLIPGA_STALLED, 95)
    GENERATE_ENUM(PERF_PAPC_CLIP_IDLE, 96)
    GENERATE_ENUM(PERF_PAPC_CLIP_BUSY, 97)
    GENERATE_ENUM(PERF_PAPC_SU_IDLE, 98)
    GENERATE_ENUM(PERF_PAPC_SU_BUSY, 99)
    GENERATE_ENUM(PERF_PAPC_SU_STARVED_CLIP, 100)
    GENERATE_ENUM(PERF_PAPC_SU_STALLED_SC, 101)
END_ENUMTYPE(SU_PERFCNT_SELECT)

START_ENUMTYPE(SC_PERFCNT_SELECT)
    GENERATE_ENUM(SC_SR_WINDOW_VALID, 0)
    GENERATE_ENUM(SC_CW_WINDOW_VALID, 1)
    GENERATE_ENUM(SC_QM_WINDOW_VALID, 2)
    GENERATE_ENUM(SC_FW_WINDOW_VALID, 3)
    GENERATE_ENUM(SC_EZ_WINDOW_VALID, 4)
    GENERATE_ENUM(SC_IT_WINDOW_VALID, 5)
    GENERATE_ENUM(SC_STARVED_BY_PA, 6)
    GENERATE_ENUM(SC_STALLED_BY_RB_TILE, 7)
    GENERATE_ENUM(SC_STALLED_BY_RB_SAMP, 8)
    GENERATE_ENUM(SC_STARVED_BY_RB_EZ, 9)
    GENERATE_ENUM(SC_STALLED_BY_SAMPLE_FF, 10)
    GENERATE_ENUM(SC_STALLED_BY_SQ, 11)
    GENERATE_ENUM(SC_STALLED_BY_SP, 12)
    GENERATE_ENUM(SC_TOTAL_NO_PRIMS, 13)
    GENERATE_ENUM(SC_NON_EMPTY_PRIMS, 14)
    GENERATE_ENUM(SC_NO_TILES_PASSING_QM, 15)
    GENERATE_ENUM(SC_NO_PIXELS_PRE_EZ, 16)
    GENERATE_ENUM(SC_NO_PIXELS_POST_EZ, 17)
END_ENUMTYPE(SC_PERFCNT_SELECT)

START_ENUMTYPE(VGT_DI_PRIM_TYPE)
    GENERATE_ENUM(DI_PT_NONE, 0)
    GENERATE_ENUM(DI_PT_POINTLIST, 1)
    GENERATE_ENUM(DI_PT_LINELIST, 2)
    GENERATE_ENUM(DI_PT_LINESTRIP, 3)
    GENERATE_ENUM(DI_PT_TRILIST, 4)
    GENERATE_ENUM(DI_PT_TRIFAN, 5)
    GENERATE_ENUM(DI_PT_TRISTRIP, 6)
    GENERATE_ENUM(DI_PT_UNUSED_1, 7)
    GENERATE_ENUM(DI_PT_RECTLIST, 8)
    GENERATE_ENUM(DI_PT_UNUSED_2, 9)
    GENERATE_ENUM(DI_PT_UNUSED_3, 10)
    GENERATE_ENUM(DI_PT_UNUSED_4, 11)
    GENERATE_ENUM(DI_PT_UNUSED_5, 12)
    GENERATE_ENUM(DI_PT_QUADLIST, 13)
    GENERATE_ENUM(DI_PT_QUADSTRIP, 14)
    GENERATE_ENUM(DI_PT_POLYGON, 15)
    GENERATE_ENUM(DI_PT_2D_COPY_RECT_LIST_V0, 16)
    GENERATE_ENUM(DI_PT_2D_COPY_RECT_LIST_V1, 17)
    GENERATE_ENUM(DI_PT_2D_COPY_RECT_LIST_V2, 18)
    GENERATE_ENUM(DI_PT_2D_COPY_RECT_LIST_V3, 19)
    GENERATE_ENUM(DI_PT_2D_FILL_RECT_LIST, 20)
    GENERATE_ENUM(DI_PT_2D_LINE_STRIP, 21)
    GENERATE_ENUM(DI_PT_2D_TRI_STRIP, 22)
END_ENUMTYPE(VGT_DI_PRIM_TYPE)

START_ENUMTYPE(VGT_DI_SOURCE_SELECT)
    GENERATE_ENUM(DI_SRC_SEL_DMA, 0)
    GENERATE_ENUM(DI_SRC_SEL_IMMEDIATE, 1)
    GENERATE_ENUM(DI_SRC_SEL_AUTO_INDEX, 2)
    GENERATE_ENUM(DI_SRC_SEL_RESERVED, 3)
END_ENUMTYPE(VGT_DI_SOURCE_SELECT)

START_ENUMTYPE(VGT_DI_INDEX_SIZE)
    GENERATE_ENUM(DI_INDEX_SIZE_16_BIT, 0)
    GENERATE_ENUM(DI_INDEX_SIZE_32_BIT, 1)
END_ENUMTYPE(VGT_DI_INDEX_SIZE)

START_ENUMTYPE(VGT_DI_SMALL_INDEX)
    GENERATE_ENUM(DI_USE_INDEX_SIZE, 0)
    GENERATE_ENUM(DI_INDEX_SIZE_8_BIT, 1)
END_ENUMTYPE(VGT_DI_SMALL_INDEX)

START_ENUMTYPE(VGT_DI_PRE_FETCH_CULL_ENABLE)
    GENERATE_ENUM(DISABLE_PRE_FETCH_CULL_ENABLE, 0)
    GENERATE_ENUM(PRE_FETCH_CULL_ENABLE, 1)
END_ENUMTYPE(VGT_DI_PRE_FETCH_CULL_ENABLE)

START_ENUMTYPE(VGT_DI_GRP_CULL_ENABLE)
    GENERATE_ENUM(DISABLE_GRP_CULL_ENABLE, 0)
    GENERATE_ENUM(GRP_CULL_ENABLE, 1)
END_ENUMTYPE(VGT_DI_GRP_CULL_ENABLE)

START_ENUMTYPE(VGT_EVENT_TYPE)
    GENERATE_ENUM(VS_DEALLOC, 0)
    GENERATE_ENUM(PS_DEALLOC, 1)
    GENERATE_ENUM(VS_DONE_TS, 2)
    GENERATE_ENUM(PS_DONE_TS, 3)
    GENERATE_ENUM(CACHE_FLUSH_TS, 4)
    GENERATE_ENUM(CONTEXT_DONE, 5)
    GENERATE_ENUM(CACHE_FLUSH, 6)
    GENERATE_ENUM(VIZQUERY_START, 7)
    GENERATE_ENUM(VIZQUERY_END, 8)
    GENERATE_ENUM(SC_WAIT_WC, 9)
    GENERATE_ENUM(RST_PIX_CNT, 13)
    GENERATE_ENUM(RST_VTX_CNT, 14)
    GENERATE_ENUM(TILE_FLUSH, 15)
    GENERATE_ENUM(CACHE_FLUSH_AND_INV_TS_EVENT, 20)
    GENERATE_ENUM(ZPASS_DONE, 21)
    GENERATE_ENUM(CACHE_FLUSH_AND_INV_EVENT, 22)
    GENERATE_ENUM(PERFCOUNTER_START, 23)
    GENERATE_ENUM(PERFCOUNTER_STOP, 24)
    GENERATE_ENUM(VS_FETCH_DONE, 27)
END_ENUMTYPE(VGT_EVENT_TYPE)

START_ENUMTYPE(VGT_DMA_SWAP_MODE)
    GENERATE_ENUM(VGT_DMA_SWAP_NONE, 0)
    GENERATE_ENUM(VGT_DMA_SWAP_16_BIT, 1)
    GENERATE_ENUM(VGT_DMA_SWAP_32_BIT, 2)
    GENERATE_ENUM(VGT_DMA_SWAP_WORD, 3)
END_ENUMTYPE(VGT_DMA_SWAP_MODE)

START_ENUMTYPE(VGT_PERFCOUNT_SELECT)
    GENERATE_ENUM(VGT_SQ_EVENT_WINDOW_ACTIVE, 0)
    GENERATE_ENUM(VGT_SQ_SEND, 1)
    GENERATE_ENUM(VGT_SQ_STALLED, 2)
    GENERATE_ENUM(VGT_SQ_STARVED_BUSY, 3)
    GENERATE_ENUM(VGT_SQ_STARVED_IDLE, 4)
    GENERATE_ENUM(VGT_SQ_STATIC, 5)
    GENERATE_ENUM(VGT_PA_EVENT_WINDOW_ACTIVE, 6)
    GENERATE_ENUM(VGT_PA_CLIP_V_SEND, 7)
    GENERATE_ENUM(VGT_PA_CLIP_V_STALLED, 8)
    GENERATE_ENUM(VGT_PA_CLIP_V_STARVED_BUSY, 9)
    GENERATE_ENUM(VGT_PA_CLIP_V_STARVED_IDLE, 10)
    GENERATE_ENUM(VGT_PA_CLIP_V_STATIC, 11)
    GENERATE_ENUM(VGT_PA_CLIP_P_SEND, 12)
    GENERATE_ENUM(VGT_PA_CLIP_P_STALLED, 13)
    GENERATE_ENUM(VGT_PA_CLIP_P_STARVED_BUSY, 14)
    GENERATE_ENUM(VGT_PA_CLIP_P_STARVED_IDLE, 15)
    GENERATE_ENUM(VGT_PA_CLIP_P_STATIC, 16)
    GENERATE_ENUM(VGT_PA_CLIP_S_SEND, 17)
    GENERATE_ENUM(VGT_PA_CLIP_S_STALLED, 18)
    GENERATE_ENUM(VGT_PA_CLIP_S_STARVED_BUSY, 19)
    GENERATE_ENUM(VGT_PA_CLIP_S_STARVED_IDLE, 20)
    GENERATE_ENUM(VGT_PA_CLIP_S_STATIC, 21)
    GENERATE_ENUM(RBIU_FIFOS_EVENT_WINDOW_ACTIVE, 22)
    GENERATE_ENUM(RBIU_IMMED_DATA_FIFO_STARVED, 23)
    GENERATE_ENUM(RBIU_IMMED_DATA_FIFO_STALLED, 24)
    GENERATE_ENUM(RBIU_DMA_REQUEST_FIFO_STARVED, 25)
    GENERATE_ENUM(RBIU_DMA_REQUEST_FIFO_STALLED, 26)
    GENERATE_ENUM(RBIU_DRAW_INITIATOR_FIFO_STARVED, 27)
    GENERATE_ENUM(RBIU_DRAW_INITIATOR_FIFO_STALLED, 28)
    GENERATE_ENUM(BIN_PRIM_NEAR_CULL, 29)
    GENERATE_ENUM(BIN_PRIM_ZERO_CULL, 30)
    GENERATE_ENUM(BIN_PRIM_FAR_CULL, 31)
    GENERATE_ENUM(BIN_PRIM_BIN_CULL, 32)
    GENERATE_ENUM(SPARE33, 33)
    GENERATE_ENUM(SPARE34, 34)
    GENERATE_ENUM(SPARE35, 35)
    GENERATE_ENUM(SPARE36, 36)
    GENERATE_ENUM(SPARE37, 37)
    GENERATE_ENUM(SPARE38, 38)
    GENERATE_ENUM(SPARE39, 39)
    GENERATE_ENUM(TE_SU_IN_VALID, 40)
    GENERATE_ENUM(TE_SU_IN_READ, 41)
    GENERATE_ENUM(TE_SU_IN_PRIM, 42)
    GENERATE_ENUM(TE_SU_IN_EOP, 43)
    GENERATE_ENUM(TE_SU_IN_NULL_PRIM, 44)
    GENERATE_ENUM(TE_WK_IN_VALID, 45)
    GENERATE_ENUM(TE_WK_IN_READ, 46)
    GENERATE_ENUM(TE_OUT_PRIM_VALID, 47)
    GENERATE_ENUM(TE_OUT_PRIM_READ, 48)
END_ENUMTYPE(VGT_PERFCOUNT_SELECT)

START_ENUMTYPE(TCR_PERFCOUNT_SELECT)
    GENERATE_ENUM(DGMMPD_IPMUX0_STALL, 0)
    GENERATE_ENUM(reserved_46, 1)
    GENERATE_ENUM(reserved_47, 2)
    GENERATE_ENUM(reserved_48, 3)
    GENERATE_ENUM(DGMMPD_IPMUX_ALL_STALL, 4)
    GENERATE_ENUM(OPMUX0_L2_WRITES, 5)
    GENERATE_ENUM(reserved_49, 6)
    GENERATE_ENUM(reserved_50, 7)
    GENERATE_ENUM(reserved_51, 8)
END_ENUMTYPE(TCR_PERFCOUNT_SELECT)

START_ENUMTYPE(TP_PERFCOUNT_SELECT)
    GENERATE_ENUM(POINT_QUADS, 0)
    GENERATE_ENUM(BILIN_QUADS, 1)
    GENERATE_ENUM(ANISO_QUADS, 2)
    GENERATE_ENUM(MIP_QUADS, 3)
    GENERATE_ENUM(VOL_QUADS, 4)
    GENERATE_ENUM(MIP_VOL_QUADS, 5)
    GENERATE_ENUM(MIP_ANISO_QUADS, 6)
    GENERATE_ENUM(VOL_ANISO_QUADS, 7)
    GENERATE_ENUM(ANISO_2_1_QUADS, 8)
    GENERATE_ENUM(ANISO_4_1_QUADS, 9)
    GENERATE_ENUM(ANISO_6_1_QUADS, 10)
    GENERATE_ENUM(ANISO_8_1_QUADS, 11)
    GENERATE_ENUM(ANISO_10_1_QUADS, 12)
    GENERATE_ENUM(ANISO_12_1_QUADS, 13)
    GENERATE_ENUM(ANISO_14_1_QUADS, 14)
    GENERATE_ENUM(ANISO_16_1_QUADS, 15)
    GENERATE_ENUM(MIP_VOL_ANISO_QUADS, 16)
    GENERATE_ENUM(ALIGN_2_QUADS, 17)
    GENERATE_ENUM(ALIGN_4_QUADS, 18)
    GENERATE_ENUM(PIX_0_QUAD, 19)
    GENERATE_ENUM(PIX_1_QUAD, 20)
    GENERATE_ENUM(PIX_2_QUAD, 21)
    GENERATE_ENUM(PIX_3_QUAD, 22)
    GENERATE_ENUM(PIX_4_QUAD, 23)
    GENERATE_ENUM(TP_MIPMAP_LOD0, 24)
    GENERATE_ENUM(TP_MIPMAP_LOD1, 25)
    GENERATE_ENUM(TP_MIPMAP_LOD2, 26)
    GENERATE_ENUM(TP_MIPMAP_LOD3, 27)
    GENERATE_ENUM(TP_MIPMAP_LOD4, 28)
    GENERATE_ENUM(TP_MIPMAP_LOD5, 29)
    GENERATE_ENUM(TP_MIPMAP_LOD6, 30)
    GENERATE_ENUM(TP_MIPMAP_LOD7, 31)
    GENERATE_ENUM(TP_MIPMAP_LOD8, 32)
    GENERATE_ENUM(TP_MIPMAP_LOD9, 33)
    GENERATE_ENUM(TP_MIPMAP_LOD10, 34)
    GENERATE_ENUM(TP_MIPMAP_LOD11, 35)
    GENERATE_ENUM(TP_MIPMAP_LOD12, 36)
    GENERATE_ENUM(TP_MIPMAP_LOD13, 37)
    GENERATE_ENUM(TP_MIPMAP_LOD14, 38)
END_ENUMTYPE(TP_PERFCOUNT_SELECT)

START_ENUMTYPE(TCM_PERFCOUNT_SELECT)
    GENERATE_ENUM(QUAD0_RD_LAT_FIFO_EMPTY, 0)
    GENERATE_ENUM(reserved_01, 1)
    GENERATE_ENUM(reserved_02, 2)
    GENERATE_ENUM(QUAD0_RD_LAT_FIFO_4TH_FULL, 3)
    GENERATE_ENUM(QUAD0_RD_LAT_FIFO_HALF_FULL, 4)
    GENERATE_ENUM(QUAD0_RD_LAT_FIFO_FULL, 5)
    GENERATE_ENUM(QUAD0_RD_LAT_FIFO_LT_4TH_FULL, 6)
    GENERATE_ENUM(reserved_07, 7)
    GENERATE_ENUM(reserved_08, 8)
    GENERATE_ENUM(reserved_09, 9)
    GENERATE_ENUM(reserved_10, 10)
    GENERATE_ENUM(reserved_11, 11)
    GENERATE_ENUM(reserved_12, 12)
    GENERATE_ENUM(reserved_13, 13)
    GENERATE_ENUM(reserved_14, 14)
    GENERATE_ENUM(reserved_15, 15)
    GENERATE_ENUM(reserved_16, 16)
    GENERATE_ENUM(reserved_17, 17)
    GENERATE_ENUM(reserved_18, 18)
    GENERATE_ENUM(reserved_19, 19)
    GENERATE_ENUM(reserved_20, 20)
    GENERATE_ENUM(reserved_21, 21)
    GENERATE_ENUM(reserved_22, 22)
    GENERATE_ENUM(reserved_23, 23)
    GENERATE_ENUM(reserved_24, 24)
    GENERATE_ENUM(reserved_25, 25)
    GENERATE_ENUM(reserved_26, 26)
    GENERATE_ENUM(reserved_27, 27)
    GENERATE_ENUM(READ_STARVED_QUAD0, 28)
    GENERATE_ENUM(reserved_29, 29)
    GENERATE_ENUM(reserved_30, 30)
    GENERATE_ENUM(reserved_31, 31)
    GENERATE_ENUM(READ_STARVED, 32)
    GENERATE_ENUM(READ_STALLED_QUAD0, 33)
    GENERATE_ENUM(reserved_34, 34)
    GENERATE_ENUM(reserved_35, 35)
    GENERATE_ENUM(reserved_36, 36)
    GENERATE_ENUM(READ_STALLED, 37)
    GENERATE_ENUM(VALID_READ_QUAD0, 38)
    GENERATE_ENUM(reserved_39, 39)
    GENERATE_ENUM(reserved_40, 40)
    GENERATE_ENUM(reserved_41, 41)
    GENERATE_ENUM(TC_TP_STARVED_QUAD0, 42)
    GENERATE_ENUM(reserved_43, 43)
    GENERATE_ENUM(reserved_44, 44)
    GENERATE_ENUM(reserved_45, 45)
    GENERATE_ENUM(TC_TP_STARVED, 46)
END_ENUMTYPE(TCM_PERFCOUNT_SELECT)

START_ENUMTYPE(TCF_PERFCOUNT_SELECT)
    GENERATE_ENUM(VALID_CYCLES, 0)
    GENERATE_ENUM(SINGLE_PHASES, 1)
    GENERATE_ENUM(ANISO_PHASES, 2)
    GENERATE_ENUM(MIP_PHASES, 3)
    GENERATE_ENUM(VOL_PHASES, 4)
    GENERATE_ENUM(MIP_VOL_PHASES, 5)
    GENERATE_ENUM(MIP_ANISO_PHASES, 6)
    GENERATE_ENUM(VOL_ANISO_PHASES, 7)
    GENERATE_ENUM(ANISO_2_1_PHASES, 8)
    GENERATE_ENUM(ANISO_4_1_PHASES, 9)
    GENERATE_ENUM(ANISO_6_1_PHASES, 10)
    GENERATE_ENUM(ANISO_8_1_PHASES, 11)
    GENERATE_ENUM(ANISO_10_1_PHASES, 12)
    GENERATE_ENUM(ANISO_12_1_PHASES, 13)
    GENERATE_ENUM(ANISO_14_1_PHASES, 14)
    GENERATE_ENUM(ANISO_16_1_PHASES, 15)
    GENERATE_ENUM(MIP_VOL_ANISO_PHASES, 16)
    GENERATE_ENUM(ALIGN_2_PHASES, 17)
    GENERATE_ENUM(ALIGN_4_PHASES, 18)
    GENERATE_ENUM(TPC_BUSY, 19)
    GENERATE_ENUM(TPC_STALLED, 20)
    GENERATE_ENUM(TPC_STARVED, 21)
    GENERATE_ENUM(TPC_WORKING, 22)
    GENERATE_ENUM(TPC_WALKER_BUSY, 23)
    GENERATE_ENUM(TPC_WALKER_STALLED, 24)
    GENERATE_ENUM(TPC_WALKER_WORKING, 25)
    GENERATE_ENUM(TPC_ALIGNER_BUSY, 26)
    GENERATE_ENUM(TPC_ALIGNER_STALLED, 27)
    GENERATE_ENUM(TPC_ALIGNER_STALLED_BY_BLEND, 28)
    GENERATE_ENUM(TPC_ALIGNER_STALLED_BY_CACHE, 29)
    GENERATE_ENUM(TPC_ALIGNER_WORKING, 30)
    GENERATE_ENUM(TPC_BLEND_BUSY, 31)
    GENERATE_ENUM(TPC_BLEND_SYNC, 32)
    GENERATE_ENUM(TPC_BLEND_STARVED, 33)
    GENERATE_ENUM(TPC_BLEND_WORKING, 34)
    GENERATE_ENUM(OPCODE_0x00, 35)
    GENERATE_ENUM(OPCODE_0x01, 36)
    GENERATE_ENUM(OPCODE_0x04, 37)
    GENERATE_ENUM(OPCODE_0x10, 38)
    GENERATE_ENUM(OPCODE_0x11, 39)
    GENERATE_ENUM(OPCODE_0x12, 40)
    GENERATE_ENUM(OPCODE_0x13, 41)
    GENERATE_ENUM(OPCODE_0x18, 42)
    GENERATE_ENUM(OPCODE_0x19, 43)
    GENERATE_ENUM(OPCODE_0x1A, 44)
    GENERATE_ENUM(OPCODE_OTHER, 45)
    GENERATE_ENUM(IN_FIFO_0_EMPTY, 56)
    GENERATE_ENUM(IN_FIFO_0_LT_HALF_FULL, 57)
    GENERATE_ENUM(IN_FIFO_0_HALF_FULL, 58)
    GENERATE_ENUM(IN_FIFO_0_FULL, 59)
    GENERATE_ENUM(IN_FIFO_TPC_EMPTY, 72)
    GENERATE_ENUM(IN_FIFO_TPC_LT_HALF_FULL, 73)
    GENERATE_ENUM(IN_FIFO_TPC_HALF_FULL, 74)
    GENERATE_ENUM(IN_FIFO_TPC_FULL, 75)
    GENERATE_ENUM(TPC_TC_XFC, 76)
    GENERATE_ENUM(TPC_TC_STATE, 77)
    GENERATE_ENUM(TC_STALL, 78)
    GENERATE_ENUM(QUAD0_TAPS, 79)
    GENERATE_ENUM(QUADS, 83)
    GENERATE_ENUM(TCA_SYNC_STALL, 84)
    GENERATE_ENUM(TAG_STALL, 85)
    GENERATE_ENUM(TCB_SYNC_STALL, 88)
    GENERATE_ENUM(TCA_VALID, 89)
    GENERATE_ENUM(PROBES_VALID, 90)
    GENERATE_ENUM(MISS_STALL, 91)
    GENERATE_ENUM(FETCH_FIFO_STALL, 92)
    GENERATE_ENUM(TCO_STALL, 93)
    GENERATE_ENUM(ANY_STALL, 94)
    GENERATE_ENUM(TAG_MISSES, 95)
    GENERATE_ENUM(TAG_HITS, 96)
    GENERATE_ENUM(SUB_TAG_MISSES, 97)
    GENERATE_ENUM(SET0_INVALIDATES, 98)
    GENERATE_ENUM(SET1_INVALIDATES, 99)
    GENERATE_ENUM(SET2_INVALIDATES, 100)
    GENERATE_ENUM(SET3_INVALIDATES, 101)
    GENERATE_ENUM(SET0_TAG_MISSES, 102)
    GENERATE_ENUM(SET1_TAG_MISSES, 103)
    GENERATE_ENUM(SET2_TAG_MISSES, 104)
    GENERATE_ENUM(SET3_TAG_MISSES, 105)
    GENERATE_ENUM(SET0_TAG_HITS, 106)
    GENERATE_ENUM(SET1_TAG_HITS, 107)
    GENERATE_ENUM(SET2_TAG_HITS, 108)
    GENERATE_ENUM(SET3_TAG_HITS, 109)
    GENERATE_ENUM(SET0_SUB_TAG_MISSES, 110)
    GENERATE_ENUM(SET1_SUB_TAG_MISSES, 111)
    GENERATE_ENUM(SET2_SUB_TAG_MISSES, 112)
    GENERATE_ENUM(SET3_SUB_TAG_MISSES, 113)
    GENERATE_ENUM(SET0_EVICT1, 114)
    GENERATE_ENUM(SET0_EVICT2, 115)
    GENERATE_ENUM(SET0_EVICT3, 116)
    GENERATE_ENUM(SET0_EVICT4, 117)
    GENERATE_ENUM(SET0_EVICT5, 118)
    GENERATE_ENUM(SET0_EVICT6, 119)
    GENERATE_ENUM(SET0_EVICT7, 120)
    GENERATE_ENUM(SET0_EVICT8, 121)
    GENERATE_ENUM(SET1_EVICT1, 130)
    GENERATE_ENUM(SET1_EVICT2, 131)
    GENERATE_ENUM(SET1_EVICT3, 132)
    GENERATE_ENUM(SET1_EVICT4, 133)
    GENERATE_ENUM(SET1_EVICT5, 134)
    GENERATE_ENUM(SET1_EVICT6, 135)
    GENERATE_ENUM(SET1_EVICT7, 136)
    GENERATE_ENUM(SET1_EVICT8, 137)
    GENERATE_ENUM(SET2_EVICT1, 146)
    GENERATE_ENUM(SET2_EVICT2, 147)
    GENERATE_ENUM(SET2_EVICT3, 148)
    GENERATE_ENUM(SET2_EVICT4, 149)
    GENERATE_ENUM(SET2_EVICT5, 150)
    GENERATE_ENUM(SET2_EVICT6, 151)
    GENERATE_ENUM(SET2_EVICT7, 152)
    GENERATE_ENUM(SET2_EVICT8, 153)
    GENERATE_ENUM(SET3_EVICT1, 162)
    GENERATE_ENUM(SET3_EVICT2, 163)
    GENERATE_ENUM(SET3_EVICT3, 164)
    GENERATE_ENUM(SET3_EVICT4, 165)
    GENERATE_ENUM(SET3_EVICT5, 166)
    GENERATE_ENUM(SET3_EVICT6, 167)
    GENERATE_ENUM(SET3_EVICT7, 168)
    GENERATE_ENUM(SET3_EVICT8, 169)
    GENERATE_ENUM(FF_EMPTY, 178)
    GENERATE_ENUM(FF_LT_HALF_FULL, 179)
    GENERATE_ENUM(FF_HALF_FULL, 180)
    GENERATE_ENUM(FF_FULL, 181)
    GENERATE_ENUM(FF_XFC, 182)
    GENERATE_ENUM(FF_STALLED, 183)
    GENERATE_ENUM(FG_MASKS, 184)
    GENERATE_ENUM(FG_LEFT_MASKS, 185)
    GENERATE_ENUM(FG_LEFT_MASK_STALLED, 186)
    GENERATE_ENUM(FG_LEFT_NOT_DONE_STALL, 187)
    GENERATE_ENUM(FG_LEFT_FG_STALL, 188)
    GENERATE_ENUM(FG_LEFT_SECTORS, 189)
    GENERATE_ENUM(FG0_REQUESTS, 195)
    GENERATE_ENUM(FG0_STALLED, 196)
    GENERATE_ENUM(MEM_REQ512, 199)
    GENERATE_ENUM(MEM_REQ_SENT, 200)
    GENERATE_ENUM(MEM_LOCAL_READ_REQ, 202)
    GENERATE_ENUM(TC0_MH_STALLED, 203)
END_ENUMTYPE(TCF_PERFCOUNT_SELECT)

START_ENUMTYPE(SQ_PERFCNT_SELECT)
    GENERATE_ENUM(SQ_PIXEL_VECTORS_SUB, 0)
    GENERATE_ENUM(SQ_VERTEX_VECTORS_SUB, 1)
    GENERATE_ENUM(SQ_ALU0_ACTIVE_VTX_SIMD0, 2)
    GENERATE_ENUM(SQ_ALU1_ACTIVE_VTX_SIMD0, 3)
    GENERATE_ENUM(SQ_ALU0_ACTIVE_PIX_SIMD0, 4)
    GENERATE_ENUM(SQ_ALU1_ACTIVE_PIX_SIMD0, 5)
    GENERATE_ENUM(SQ_ALU0_ACTIVE_VTX_SIMD1, 6)
    GENERATE_ENUM(SQ_ALU1_ACTIVE_VTX_SIMD1, 7)
    GENERATE_ENUM(SQ_ALU0_ACTIVE_PIX_SIMD1, 8)
    GENERATE_ENUM(SQ_ALU1_ACTIVE_PIX_SIMD1, 9)
    GENERATE_ENUM(SQ_EXPORT_CYCLES, 10)
    GENERATE_ENUM(SQ_ALU_CST_WRITTEN, 11)
    GENERATE_ENUM(SQ_TEX_CST_WRITTEN, 12)
    GENERATE_ENUM(SQ_ALU_CST_STALL, 13)
    GENERATE_ENUM(SQ_ALU_TEX_STALL, 14)
    GENERATE_ENUM(SQ_INST_WRITTEN, 15)
    GENERATE_ENUM(SQ_BOOLEAN_WRITTEN, 16)
    GENERATE_ENUM(SQ_LOOPS_WRITTEN, 17)
    GENERATE_ENUM(SQ_PIXEL_SWAP_IN, 18)
    GENERATE_ENUM(SQ_PIXEL_SWAP_OUT, 19)
    GENERATE_ENUM(SQ_VERTEX_SWAP_IN, 20)
    GENERATE_ENUM(SQ_VERTEX_SWAP_OUT, 21)
    GENERATE_ENUM(SQ_ALU_VTX_INST_ISSUED, 22)
    GENERATE_ENUM(SQ_TEX_VTX_INST_ISSUED, 23)
    GENERATE_ENUM(SQ_VC_VTX_INST_ISSUED, 24)
    GENERATE_ENUM(SQ_CF_VTX_INST_ISSUED, 25)
    GENERATE_ENUM(SQ_ALU_PIX_INST_ISSUED, 26)
    GENERATE_ENUM(SQ_TEX_PIX_INST_ISSUED, 27)
    GENERATE_ENUM(SQ_VC_PIX_INST_ISSUED, 28)
    GENERATE_ENUM(SQ_CF_PIX_INST_ISSUED, 29)
    GENERATE_ENUM(SQ_ALU0_FIFO_EMPTY_SIMD0, 30)
    GENERATE_ENUM(SQ_ALU1_FIFO_EMPTY_SIMD0, 31)
    GENERATE_ENUM(SQ_ALU0_FIFO_EMPTY_SIMD1, 32)
    GENERATE_ENUM(SQ_ALU1_FIFO_EMPTY_SIMD1, 33)
    GENERATE_ENUM(SQ_ALU_NOPS, 34)
    GENERATE_ENUM(SQ_PRED_SKIP, 35)
    GENERATE_ENUM(SQ_SYNC_ALU_STALL_SIMD0_VTX, 36)
    GENERATE_ENUM(SQ_SYNC_ALU_STALL_SIMD1_VTX, 37)
    GENERATE_ENUM(SQ_SYNC_TEX_STALL_VTX, 38)
    GENERATE_ENUM(SQ_SYNC_VC_STALL_VTX, 39)
    GENERATE_ENUM(SQ_CONSTANTS_USED_SIMD0, 40)
    GENERATE_ENUM(SQ_CONSTANTS_SENT_SP_SIMD0, 41)
    GENERATE_ENUM(SQ_GPR_STALL_VTX, 42)
    GENERATE_ENUM(SQ_GPR_STALL_PIX, 43)
    GENERATE_ENUM(SQ_VTX_RS_STALL, 44)
    GENERATE_ENUM(SQ_PIX_RS_STALL, 45)
    GENERATE_ENUM(SQ_SX_PC_FULL, 46)
    GENERATE_ENUM(SQ_SX_EXP_BUFF_FULL, 47)
    GENERATE_ENUM(SQ_SX_POS_BUFF_FULL, 48)
    GENERATE_ENUM(SQ_INTERP_QUADS, 49)
    GENERATE_ENUM(SQ_INTERP_ACTIVE, 50)
    GENERATE_ENUM(SQ_IN_PIXEL_STALL, 51)
    GENERATE_ENUM(SQ_IN_VTX_STALL, 52)
    GENERATE_ENUM(SQ_VTX_CNT, 53)
    GENERATE_ENUM(SQ_VTX_VECTOR2, 54)
    GENERATE_ENUM(SQ_VTX_VECTOR3, 55)
    GENERATE_ENUM(SQ_VTX_VECTOR4, 56)
    GENERATE_ENUM(SQ_PIXEL_VECTOR1, 57)
    GENERATE_ENUM(SQ_PIXEL_VECTOR23, 58)
    GENERATE_ENUM(SQ_PIXEL_VECTOR4, 59)
    GENERATE_ENUM(SQ_CONSTANTS_USED_SIMD1, 60)
    GENERATE_ENUM(SQ_CONSTANTS_SENT_SP_SIMD1, 61)
    GENERATE_ENUM(SQ_SX_MEM_EXP_FULL, 62)
    GENERATE_ENUM(SQ_ALU0_ACTIVE_VTX_SIMD2, 63)
    GENERATE_ENUM(SQ_ALU1_ACTIVE_VTX_SIMD2, 64)
    GENERATE_ENUM(SQ_ALU0_ACTIVE_PIX_SIMD2, 65)
    GENERATE_ENUM(SQ_ALU1_ACTIVE_PIX_SIMD2, 66)
    GENERATE_ENUM(SQ_ALU0_ACTIVE_VTX_SIMD3, 67)
    GENERATE_ENUM(SQ_ALU1_ACTIVE_VTX_SIMD3, 68)
    GENERATE_ENUM(SQ_ALU0_ACTIVE_PIX_SIMD3, 69)
    GENERATE_ENUM(SQ_ALU1_ACTIVE_PIX_SIMD3, 70)
    GENERATE_ENUM(SQ_ALU0_FIFO_EMPTY_SIMD2, 71)
    GENERATE_ENUM(SQ_ALU1_FIFO_EMPTY_SIMD2, 72)
    GENERATE_ENUM(SQ_ALU0_FIFO_EMPTY_SIMD3, 73)
    GENERATE_ENUM(SQ_ALU1_FIFO_EMPTY_SIMD3, 74)
    GENERATE_ENUM(SQ_SYNC_ALU_STALL_SIMD2_VTX, 75)
    GENERATE_ENUM(SQ_SYNC_ALU_STALL_SIMD3_VTX, 76)
    GENERATE_ENUM(SQ_SYNC_ALU_STALL_SIMD0_PIX, 77)
    GENERATE_ENUM(SQ_SYNC_ALU_STALL_SIMD1_PIX, 78)
    GENERATE_ENUM(SQ_SYNC_ALU_STALL_SIMD2_PIX, 79)
    GENERATE_ENUM(SQ_SYNC_ALU_STALL_SIMD3_PIX, 80)
    GENERATE_ENUM(SQ_SYNC_TEX_STALL_PIX, 81)
    GENERATE_ENUM(SQ_SYNC_VC_STALL_PIX, 82)
    GENERATE_ENUM(SQ_CONSTANTS_USED_SIMD2, 83)
    GENERATE_ENUM(SQ_CONSTANTS_SENT_SP_SIMD2, 84)
    GENERATE_ENUM(SQ_CONSTANTS_USED_SIMD3, 85)
    GENERATE_ENUM(SQ_CONSTANTS_SENT_SP_SIMD3, 86)
    GENERATE_ENUM(SQ_ALU0_FIFO_FULL_SIMD0, 87)
    GENERATE_ENUM(SQ_ALU1_FIFO_FULL_SIMD0, 88)
    GENERATE_ENUM(SQ_ALU0_FIFO_FULL_SIMD1, 89)
    GENERATE_ENUM(SQ_ALU1_FIFO_FULL_SIMD1, 90)
    GENERATE_ENUM(SQ_ALU0_FIFO_FULL_SIMD2, 91)
    GENERATE_ENUM(SQ_ALU1_FIFO_FULL_SIMD2, 92)
    GENERATE_ENUM(SQ_ALU0_FIFO_FULL_SIMD3, 93)
    GENERATE_ENUM(SQ_ALU1_FIFO_FULL_SIMD3, 94)
    GENERATE_ENUM(VC_PERF_STATIC, 95)
    GENERATE_ENUM(VC_PERF_STALLED, 96)
    GENERATE_ENUM(VC_PERF_STARVED, 97)
    GENERATE_ENUM(VC_PERF_SEND, 98)
    GENERATE_ENUM(VC_PERF_ACTUAL_STARVED, 99)
    GENERATE_ENUM(PIXEL_THREAD_0_ACTIVE, 100)
    GENERATE_ENUM(VERTEX_THREAD_0_ACTIVE, 101)
    GENERATE_ENUM(PIXEL_THREAD_0_NUMBER, 102)
    GENERATE_ENUM(VERTEX_THREAD_0_NUMBER, 103)
    GENERATE_ENUM(VERTEX_EVENT_NUMBER, 104)
    GENERATE_ENUM(PIXEL_EVENT_NUMBER, 105)
    GENERATE_ENUM(PTRBUFF_EF_PUSH, 106)
    GENERATE_ENUM(PTRBUFF_EF_POP_EVENT, 107)
    GENERATE_ENUM(PTRBUFF_EF_POP_NEW_VTX, 108)
    GENERATE_ENUM(PTRBUFF_EF_POP_DEALLOC, 109)
    GENERATE_ENUM(PTRBUFF_EF_POP_PVECTOR, 110)
    GENERATE_ENUM(PTRBUFF_EF_POP_PVECTOR_X, 111)
    GENERATE_ENUM(PTRBUFF_EF_POP_PVECTOR_VNZ, 112)
    GENERATE_ENUM(PTRBUFF_PB_DEALLOC, 113)
    GENERATE_ENUM(PTRBUFF_PI_STATE_PPB_POP, 114)
    GENERATE_ENUM(PTRBUFF_PI_RTR, 115)
    GENERATE_ENUM(PTRBUFF_PI_READ_EN, 116)
    GENERATE_ENUM(PTRBUFF_PI_BUFF_SWAP, 117)
    GENERATE_ENUM(PTRBUFF_SQ_FREE_BUFF, 118)
    GENERATE_ENUM(PTRBUFF_SQ_DEC, 119)
    GENERATE_ENUM(PTRBUFF_SC_VALID_CNTL_EVENT, 120)
    GENERATE_ENUM(PTRBUFF_SC_VALID_IJ_XFER, 121)
    GENERATE_ENUM(PTRBUFF_SC_NEW_VECTOR_1_Q, 122)
    GENERATE_ENUM(PTRBUFF_QUAL_NEW_VECTOR, 123)
    GENERATE_ENUM(PTRBUFF_QUAL_EVENT, 124)
    GENERATE_ENUM(PTRBUFF_END_BUFFER, 125)
    GENERATE_ENUM(PTRBUFF_FILL_QUAD, 126)
    GENERATE_ENUM(VERTS_WRITTEN_SPI, 127)
    GENERATE_ENUM(TP_FETCH_INSTR_EXEC, 128)
    GENERATE_ENUM(TP_FETCH_INSTR_REQ, 129)
    GENERATE_ENUM(TP_DATA_RETURN, 130)
    GENERATE_ENUM(SPI_WRITE_CYCLES_SP, 131)
    GENERATE_ENUM(SPI_WRITES_SP, 132)
    GENERATE_ENUM(SP_ALU_INSTR_EXEC, 133)
    GENERATE_ENUM(SP_CONST_ADDR_TO_SQ, 134)
    GENERATE_ENUM(SP_PRED_KILLS_TO_SQ, 135)
    GENERATE_ENUM(SP_EXPORT_CYCLES_TO_SX, 136)
    GENERATE_ENUM(SP_EXPORTS_TO_SX, 137)
    GENERATE_ENUM(SQ_CYCLES_ELAPSED, 138)
    GENERATE_ENUM(SQ_TCFS_OPT_ALLOC_EXEC, 139)
    GENERATE_ENUM(SQ_TCFS_NO_OPT_ALLOC, 140)
    GENERATE_ENUM(SQ_ALU0_NO_OPT_ALLOC, 141)
    GENERATE_ENUM(SQ_ALU1_NO_OPT_ALLOC, 142)
    GENERATE_ENUM(SQ_TCFS_ARB_XFC_CNT, 143)
    GENERATE_ENUM(SQ_ALU0_ARB_XFC_CNT, 144)
    GENERATE_ENUM(SQ_ALU1_ARB_XFC_CNT, 145)
    GENERATE_ENUM(SQ_TCFS_CFS_UPDATE_CNT, 146)
    GENERATE_ENUM(SQ_ALU0_CFS_UPDATE_CNT, 147)
    GENERATE_ENUM(SQ_ALU1_CFS_UPDATE_CNT, 148)
    GENERATE_ENUM(SQ_VTX_PUSH_THREAD_CNT, 149)
    GENERATE_ENUM(SQ_VTX_POP_THREAD_CNT, 150)
    GENERATE_ENUM(SQ_PIX_PUSH_THREAD_CNT, 151)
    GENERATE_ENUM(SQ_PIX_POP_THREAD_CNT, 152)
    GENERATE_ENUM(SQ_PIX_TOTAL, 153)
    GENERATE_ENUM(SQ_PIX_KILLED, 154)
END_ENUMTYPE(SQ_PERFCNT_SELECT)

START_ENUMTYPE(SX_PERFCNT_SELECT)
    GENERATE_ENUM(SX_EXPORT_VECTORS, 0)
    GENERATE_ENUM(SX_DUMMY_QUADS, 1)
    GENERATE_ENUM(SX_ALPHA_FAIL, 2)
    GENERATE_ENUM(SX_RB_QUAD_BUSY, 3)
    GENERATE_ENUM(SX_RB_COLOR_BUSY, 4)
    GENERATE_ENUM(SX_RB_QUAD_STALL, 5)
    GENERATE_ENUM(SX_RB_COLOR_STALL, 6)
END_ENUMTYPE(SX_PERFCNT_SELECT)

START_ENUMTYPE(Abs_modifier)
    GENERATE_ENUM(NO_ABS_MOD, 0)
    GENERATE_ENUM(ABS_MOD, 1)
END_ENUMTYPE(Abs_modifier)

START_ENUMTYPE(Exporting)
    GENERATE_ENUM(NOT_EXPORTING, 0)
    GENERATE_ENUM(EXPORTING, 1)
END_ENUMTYPE(Exporting)

START_ENUMTYPE(ScalarOpcode)
    GENERATE_ENUM(ADDs, 0)
    GENERATE_ENUM(ADD_PREVs, 1)
    GENERATE_ENUM(MULs, 2)
    GENERATE_ENUM(MUL_PREVs, 3)
    GENERATE_ENUM(MUL_PREV2s, 4)
    GENERATE_ENUM(MAXs, 5)
    GENERATE_ENUM(MINs, 6)
    GENERATE_ENUM(SETEs, 7)
    GENERATE_ENUM(SETGTs, 8)
    GENERATE_ENUM(SETGTEs, 9)
    GENERATE_ENUM(SETNEs, 10)
    GENERATE_ENUM(FRACs, 11)
    GENERATE_ENUM(TRUNCs, 12)
    GENERATE_ENUM(FLOORs, 13)
    GENERATE_ENUM(EXP_IEEE, 14)
    GENERATE_ENUM(LOG_CLAMP, 15)
    GENERATE_ENUM(LOG_IEEE, 16)
    GENERATE_ENUM(RECIP_CLAMP, 17)
    GENERATE_ENUM(RECIP_FF, 18)
    GENERATE_ENUM(RECIP_IEEE, 19)
    GENERATE_ENUM(RECIPSQ_CLAMP, 20)
    GENERATE_ENUM(RECIPSQ_FF, 21)
    GENERATE_ENUM(RECIPSQ_IEEE, 22)
    GENERATE_ENUM(MOVAs, 23)
    GENERATE_ENUM(MOVA_FLOORs, 24)
    GENERATE_ENUM(SUBs, 25)
    GENERATE_ENUM(SUB_PREVs, 26)
    GENERATE_ENUM(PRED_SETEs, 27)
    GENERATE_ENUM(PRED_SETNEs, 28)
    GENERATE_ENUM(PRED_SETGTs, 29)
    GENERATE_ENUM(PRED_SETGTEs, 30)
    GENERATE_ENUM(PRED_SET_INVs, 31)
    GENERATE_ENUM(PRED_SET_POPs, 32)
    GENERATE_ENUM(PRED_SET_CLRs, 33)
    GENERATE_ENUM(PRED_SET_RESTOREs, 34)
    GENERATE_ENUM(KILLEs, 35)
    GENERATE_ENUM(KILLGTs, 36)
    GENERATE_ENUM(KILLGTEs, 37)
    GENERATE_ENUM(KILLNEs, 38)
    GENERATE_ENUM(KILLONEs, 39)
    GENERATE_ENUM(SQRT_IEEE, 40)
    GENERATE_ENUM(MUL_CONST_0, 42)
    GENERATE_ENUM(MUL_CONST_1, 43)
    GENERATE_ENUM(ADD_CONST_0, 44)
    GENERATE_ENUM(ADD_CONST_1, 45)
    GENERATE_ENUM(SUB_CONST_0, 46)
    GENERATE_ENUM(SUB_CONST_1, 47)
    GENERATE_ENUM(SIN, 48)
    GENERATE_ENUM(COS, 49)
    GENERATE_ENUM(RETAIN_PREV, 50)
END_ENUMTYPE(ScalarOpcode)

START_ENUMTYPE(SwizzleType)
    GENERATE_ENUM(NO_SWIZZLE, 0)
    GENERATE_ENUM(SHIFT_RIGHT_1, 1)
    GENERATE_ENUM(SHIFT_RIGHT_2, 2)
    GENERATE_ENUM(SHIFT_RIGHT_3, 3)
END_ENUMTYPE(SwizzleType)

START_ENUMTYPE(InputModifier)
    GENERATE_ENUM(NIL, 0)
    GENERATE_ENUM(NEGATE, 1)
END_ENUMTYPE(InputModifier)

START_ENUMTYPE(PredicateSelect)
    GENERATE_ENUM(NO_PREDICATION, 0)
    GENERATE_ENUM(PREDICATE_QUAD, 1)
    GENERATE_ENUM(PREDICATED_2, 2)
    GENERATE_ENUM(PREDICATED_3, 3)
END_ENUMTYPE(PredicateSelect)

START_ENUMTYPE(OperandSelect1)
    GENERATE_ENUM(ABSOLUTE_REG, 0)
    GENERATE_ENUM(RELATIVE_REG, 1)
END_ENUMTYPE(OperandSelect1)

START_ENUMTYPE(VectorOpcode)
    GENERATE_ENUM(ADDv, 0)
    GENERATE_ENUM(MULv, 1)
    GENERATE_ENUM(MAXv, 2)
    GENERATE_ENUM(MINv, 3)
    GENERATE_ENUM(SETEv, 4)
    GENERATE_ENUM(SETGTv, 5)
    GENERATE_ENUM(SETGTEv, 6)
    GENERATE_ENUM(SETNEv, 7)
    GENERATE_ENUM(FRACv, 8)
    GENERATE_ENUM(TRUNCv, 9)
    GENERATE_ENUM(FLOORv, 10)
    GENERATE_ENUM(MULADDv, 11)
    GENERATE_ENUM(CNDEv, 12)
    GENERATE_ENUM(CNDGTEv, 13)
    GENERATE_ENUM(CNDGTv, 14)
    GENERATE_ENUM(DOT4v, 15)
    GENERATE_ENUM(DOT3v, 16)
    GENERATE_ENUM(DOT2ADDv, 17)
    GENERATE_ENUM(CUBEv, 18)
    GENERATE_ENUM(MAX4v, 19)
    GENERATE_ENUM(PRED_SETE_PUSHv, 20)
    GENERATE_ENUM(PRED_SETNE_PUSHv, 21)
    GENERATE_ENUM(PRED_SETGT_PUSHv, 22)
    GENERATE_ENUM(PRED_SETGTE_PUSHv, 23)
    GENERATE_ENUM(KILLEv, 24)
    GENERATE_ENUM(KILLGTv, 25)
    GENERATE_ENUM(KILLGTEv, 26)
    GENERATE_ENUM(KILLNEv, 27)
    GENERATE_ENUM(DSTv, 28)
    GENERATE_ENUM(MOVAv, 29)
END_ENUMTYPE(VectorOpcode)

START_ENUMTYPE(OperandSelect0)
    GENERATE_ENUM(CONSTANT, 0)
    GENERATE_ENUM(NON_CONSTANT, 1)
END_ENUMTYPE(OperandSelect0)

START_ENUMTYPE(Ressource_type)
    GENERATE_ENUM(ALU, 0)
    GENERATE_ENUM(TEXTURE, 1)
END_ENUMTYPE(Ressource_type)

START_ENUMTYPE(Instruction_serial)
    GENERATE_ENUM(NOT_SERIAL, 0)
    GENERATE_ENUM(SERIAL, 1)
END_ENUMTYPE(Instruction_serial)

START_ENUMTYPE(VC_type)
    GENERATE_ENUM(ALU_TP_REQUEST, 0)
    GENERATE_ENUM(VC_REQUEST, 1)
END_ENUMTYPE(VC_type)

START_ENUMTYPE(Addressing)
    GENERATE_ENUM(RELATIVE_ADDR, 0)
    GENERATE_ENUM(ABSOLUTE_ADDR, 1)
END_ENUMTYPE(Addressing)

START_ENUMTYPE(CFOpcode)
    GENERATE_ENUM(NOP, 0)
    GENERATE_ENUM(EXECUTE, 1)
    GENERATE_ENUM(EXECUTE_END, 2)
    GENERATE_ENUM(COND_EXECUTE, 3)
    GENERATE_ENUM(COND_EXECUTE_END, 4)
    GENERATE_ENUM(COND_PRED_EXECUTE, 5)
    GENERATE_ENUM(COND_PRED_EXECUTE_END, 6)
    GENERATE_ENUM(LOOP_START, 7)
    GENERATE_ENUM(LOOP_END, 8)
    GENERATE_ENUM(COND_CALL, 9)
    GENERATE_ENUM(RETURN, 10)
    GENERATE_ENUM(COND_JMP, 11)
    GENERATE_ENUM(ALLOCATE, 12)
    GENERATE_ENUM(COND_EXECUTE_PRED_CLEAN, 13)
    GENERATE_ENUM(COND_EXECUTE_PRED_CLEAN_END, 14)
    GENERATE_ENUM(MARK_VS_FETCH_DONE, 15)
END_ENUMTYPE(CFOpcode)

START_ENUMTYPE(Allocation_type)
    GENERATE_ENUM(SQ_NO_ALLOC, 0)
    GENERATE_ENUM(SQ_POSITION, 1)
    GENERATE_ENUM(SQ_PARAMETER_PIXEL, 2)
    GENERATE_ENUM(SQ_MEMORY, 3)
END_ENUMTYPE(Allocation_type)

START_ENUMTYPE(TexInstOpcode)
    GENERATE_ENUM(TEX_INST_FETCH, 1)
    GENERATE_ENUM(TEX_INST_RESERVED_1, 2)
    GENERATE_ENUM(TEX_INST_RESERVED_2, 3)
    GENERATE_ENUM(TEX_INST_RESERVED_3, 4)
    GENERATE_ENUM(TEX_INST_GET_BORDER_COLOR_FRAC, 16)
    GENERATE_ENUM(TEX_INST_GET_COMP_TEX_LOD, 17)
    GENERATE_ENUM(TEX_INST_GET_GRADIENTS, 18)
    GENERATE_ENUM(TEX_INST_GET_WEIGHTS, 19)
    GENERATE_ENUM(TEX_INST_SET_TEX_LOD, 24)
    GENERATE_ENUM(TEX_INST_SET_GRADIENTS_H, 25)
    GENERATE_ENUM(TEX_INST_SET_GRADIENTS_V, 26)
    GENERATE_ENUM(TEX_INST_RESERVED_4, 27)
END_ENUMTYPE(TexInstOpcode)

START_ENUMTYPE(Addressmode)
    GENERATE_ENUM(LOGICAL, 0)
    GENERATE_ENUM(LOOP_RELATIVE, 1)
END_ENUMTYPE(Addressmode)

START_ENUMTYPE(TexCoordDenorm)
    GENERATE_ENUM(TEX_COORD_NORMALIZED, 0)
    GENERATE_ENUM(TEX_COORD_UNNORMALIZED, 1)
END_ENUMTYPE(TexCoordDenorm)

START_ENUMTYPE(SrcSel)
    GENERATE_ENUM(SRC_SEL_X, 0)
    GENERATE_ENUM(SRC_SEL_Y, 1)
    GENERATE_ENUM(SRC_SEL_Z, 2)
    GENERATE_ENUM(SRC_SEL_W, 3)
END_ENUMTYPE(SrcSel)

START_ENUMTYPE(DstSel)
    GENERATE_ENUM(DST_SEL_X, 0)
    GENERATE_ENUM(DST_SEL_Y, 1)
    GENERATE_ENUM(DST_SEL_Z, 2)
    GENERATE_ENUM(DST_SEL_W, 3)
    GENERATE_ENUM(DST_SEL_0, 4)
    GENERATE_ENUM(DST_SEL_1, 5)
    GENERATE_ENUM(DST_SEL_RSVD, 6)
    GENERATE_ENUM(DST_SEL_MASK, 7)
END_ENUMTYPE(DstSel)

START_ENUMTYPE(MagFilter)
    GENERATE_ENUM(MAG_FILTER_POINT, 0)
    GENERATE_ENUM(MAG_FILTER_LINEAR, 1)
    GENERATE_ENUM(MAG_FILTER_RESERVED_0, 2)
    GENERATE_ENUM(MAG_FILTER_USE_FETCH_CONST, 3)
END_ENUMTYPE(MagFilter)

START_ENUMTYPE(MinFilter)
    GENERATE_ENUM(MIN_FILTER_POINT, 0)
    GENERATE_ENUM(MIN_FILTER_LINEAR, 1)
    GENERATE_ENUM(MIN_FILTER_RESERVED_0, 2)
    GENERATE_ENUM(MIN_FILTER_USE_FETCH_CONST, 3)
END_ENUMTYPE(MinFilter)

START_ENUMTYPE(MipFilter)
    GENERATE_ENUM(MIP_FILTER_POINT, 0)
    GENERATE_ENUM(MIP_FILTER_LINEAR, 1)
    GENERATE_ENUM(MIP_FILTER_BASEMAP, 2)
    GENERATE_ENUM(MIP_FILTER_USE_FETCH_CONST, 3)
END_ENUMTYPE(MipFilter)

START_ENUMTYPE(AnisoFilter)
    GENERATE_ENUM(ANISO_FILTER_DISABLED, 0)
    GENERATE_ENUM(ANISO_FILTER_MAX_1_1, 1)
    GENERATE_ENUM(ANISO_FILTER_MAX_2_1, 2)
    GENERATE_ENUM(ANISO_FILTER_MAX_4_1, 3)
    GENERATE_ENUM(ANISO_FILTER_MAX_8_1, 4)
    GENERATE_ENUM(ANISO_FILTER_MAX_16_1, 5)
    GENERATE_ENUM(ANISO_FILTER_USE_FETCH_CONST, 7)
END_ENUMTYPE(AnisoFilter)

START_ENUMTYPE(ArbitraryFilter)
    GENERATE_ENUM(ARBITRARY_FILTER_2X4_SYM, 0)
    GENERATE_ENUM(ARBITRARY_FILTER_2X4_ASYM, 1)
    GENERATE_ENUM(ARBITRARY_FILTER_4X2_SYM, 2)
    GENERATE_ENUM(ARBITRARY_FILTER_4X2_ASYM, 3)
    GENERATE_ENUM(ARBITRARY_FILTER_4X4_SYM, 4)
    GENERATE_ENUM(ARBITRARY_FILTER_4X4_ASYM, 5)
    GENERATE_ENUM(ARBITRARY_FILTER_USE_FETCH_CONST, 7)
END_ENUMTYPE(ArbitraryFilter)

START_ENUMTYPE(VolMagFilter)
    GENERATE_ENUM(VOL_MAG_FILTER_POINT, 0)
    GENERATE_ENUM(VOL_MAG_FILTER_LINEAR, 1)
    GENERATE_ENUM(VOL_MAG_FILTER_USE_FETCH_CONST, 3)
END_ENUMTYPE(VolMagFilter)

START_ENUMTYPE(VolMinFilter)
    GENERATE_ENUM(VOL_MIN_FILTER_POINT, 0)
    GENERATE_ENUM(VOL_MIN_FILTER_LINEAR, 1)
    GENERATE_ENUM(VOL_MIN_FILTER_USE_FETCH_CONST, 3)
END_ENUMTYPE(VolMinFilter)

START_ENUMTYPE(PredSelect)
    GENERATE_ENUM(NOT_PREDICATED, 0)
    GENERATE_ENUM(PREDICATED, 1)
END_ENUMTYPE(PredSelect)

START_ENUMTYPE(SampleLocation)
    GENERATE_ENUM(SAMPLE_CENTROID, 0)
    GENERATE_ENUM(SAMPLE_CENTER, 1)
END_ENUMTYPE(SampleLocation)

START_ENUMTYPE(VertexMode)
    GENERATE_ENUM(POSITION_1_VECTOR, 0)
    GENERATE_ENUM(POSITION_2_VECTORS_UNUSED, 1)
    GENERATE_ENUM(POSITION_2_VECTORS_SPRITE, 2)
    GENERATE_ENUM(POSITION_2_VECTORS_EDGE, 3)
    GENERATE_ENUM(POSITION_2_VECTORS_KILL, 4)
    GENERATE_ENUM(POSITION_2_VECTORS_SPRITE_KILL, 5)
    GENERATE_ENUM(POSITION_2_VECTORS_EDGE_KILL, 6)
    GENERATE_ENUM(MULTIPASS, 7)
END_ENUMTYPE(VertexMode)

START_ENUMTYPE(Sample_Cntl)
    GENERATE_ENUM(CENTROIDS_ONLY, 0)
    GENERATE_ENUM(CENTERS_ONLY, 1)
    GENERATE_ENUM(CENTROIDS_AND_CENTERS, 2)
    GENERATE_ENUM(UNDEF, 3)
END_ENUMTYPE(Sample_Cntl)

START_ENUMTYPE(MhPerfEncode)
    GENERATE_ENUM(CP_R0_REQUESTS, 0)
    GENERATE_ENUM(CP_R1_REQUESTS, 1)
    GENERATE_ENUM(CP_R2_REQUESTS, 2)
    GENERATE_ENUM(CP_R3_REQUESTS, 3)
    GENERATE_ENUM(CP_R4_REQUESTS, 4)
    GENERATE_ENUM(CP_TOTAL_READ_REQUESTS, 5)
    GENERATE_ENUM(CP_W_REQUESTS, 6)
    GENERATE_ENUM(CP_TOTAL_REQUESTS, 7)
    GENERATE_ENUM(CP_DATA_BYTES_WRITTEN, 8)
    GENERATE_ENUM(CP_WRITE_CLEAN_RESPONSES, 9)
    GENERATE_ENUM(CP_R0_READ_BURSTS_RECEIVED, 10)
    GENERATE_ENUM(CP_R1_READ_BURSTS_RECEIVED, 11)
    GENERATE_ENUM(CP_R2_READ_BURSTS_RECEIVED, 12)
    GENERATE_ENUM(CP_R3_READ_BURSTS_RECEIVED, 13)
    GENERATE_ENUM(CP_R4_READ_BURSTS_RECEIVED, 14)
    GENERATE_ENUM(CP_TOTAL_READ_BURSTS_RECEIVED, 15)
    GENERATE_ENUM(CP_R0_DATA_BEATS_READ, 16)
    GENERATE_ENUM(CP_R1_DATA_BEATS_READ, 17)
    GENERATE_ENUM(CP_R2_DATA_BEATS_READ, 18)
    GENERATE_ENUM(CP_R3_DATA_BEATS_READ, 19)
    GENERATE_ENUM(CP_R4_DATA_BEATS_READ, 20)
    GENERATE_ENUM(CP_TOTAL_DATA_BEATS_READ, 21)
    GENERATE_ENUM(VGT_R0_REQUESTS, 22)
    GENERATE_ENUM(VGT_R1_REQUESTS, 23)
    GENERATE_ENUM(VGT_TOTAL_REQUESTS, 24)
    GENERATE_ENUM(VGT_R0_READ_BURSTS_RECEIVED, 25)
    GENERATE_ENUM(VGT_R1_READ_BURSTS_RECEIVED, 26)
    GENERATE_ENUM(VGT_TOTAL_READ_BURSTS_RECEIVED, 27)
    GENERATE_ENUM(VGT_R0_DATA_BEATS_READ, 28)
    GENERATE_ENUM(VGT_R1_DATA_BEATS_READ, 29)
    GENERATE_ENUM(VGT_TOTAL_DATA_BEATS_READ, 30)
    GENERATE_ENUM(TC_REQUESTS, 31)
    GENERATE_ENUM(TC_ROQ_REQUESTS, 32)
    GENERATE_ENUM(TC_INFO_SENT, 33)
    GENERATE_ENUM(TC_READ_BURSTS_RECEIVED, 34)
    GENERATE_ENUM(TC_DATA_BEATS_READ, 35)
    GENERATE_ENUM(TCD_BURSTS_READ, 36)
    GENERATE_ENUM(RB_REQUESTS, 37)
    GENERATE_ENUM(RB_DATA_BYTES_WRITTEN, 38)
    GENERATE_ENUM(RB_WRITE_CLEAN_RESPONSES, 39)
    GENERATE_ENUM(AXI_READ_REQUESTS_ID_0, 40)
    GENERATE_ENUM(AXI_READ_REQUESTS_ID_1, 41)
    GENERATE_ENUM(AXI_READ_REQUESTS_ID_2, 42)
    GENERATE_ENUM(AXI_READ_REQUESTS_ID_3, 43)
    GENERATE_ENUM(AXI_READ_REQUESTS_ID_4, 44)
    GENERATE_ENUM(AXI_READ_REQUESTS_ID_5, 45)
    GENERATE_ENUM(AXI_READ_REQUESTS_ID_6, 46)
    GENERATE_ENUM(AXI_READ_REQUESTS_ID_7, 47)
    GENERATE_ENUM(AXI_TOTAL_READ_REQUESTS, 48)
    GENERATE_ENUM(AXI_WRITE_REQUESTS_ID_0, 49)
    GENERATE_ENUM(AXI_WRITE_REQUESTS_ID_1, 50)
    GENERATE_ENUM(AXI_WRITE_REQUESTS_ID_2, 51)
    GENERATE_ENUM(AXI_WRITE_REQUESTS_ID_3, 52)
    GENERATE_ENUM(AXI_WRITE_REQUESTS_ID_4, 53)
    GENERATE_ENUM(AXI_WRITE_REQUESTS_ID_5, 54)
    GENERATE_ENUM(AXI_WRITE_REQUESTS_ID_6, 55)
    GENERATE_ENUM(AXI_WRITE_REQUESTS_ID_7, 56)
    GENERATE_ENUM(AXI_TOTAL_WRITE_REQUESTS, 57)
    GENERATE_ENUM(AXI_TOTAL_REQUESTS_ID_0, 58)
    GENERATE_ENUM(AXI_TOTAL_REQUESTS_ID_1, 59)
    GENERATE_ENUM(AXI_TOTAL_REQUESTS_ID_2, 60)
    GENERATE_ENUM(AXI_TOTAL_REQUESTS_ID_3, 61)
    GENERATE_ENUM(AXI_TOTAL_REQUESTS_ID_4, 62)
    GENERATE_ENUM(AXI_TOTAL_REQUESTS_ID_5, 63)
    GENERATE_ENUM(AXI_TOTAL_REQUESTS_ID_6, 64)
    GENERATE_ENUM(AXI_TOTAL_REQUESTS_ID_7, 65)
    GENERATE_ENUM(AXI_TOTAL_REQUESTS, 66)
    GENERATE_ENUM(AXI_READ_CHANNEL_BURSTS_ID_0, 67)
    GENERATE_ENUM(AXI_READ_CHANNEL_BURSTS_ID_1, 68)
    GENERATE_ENUM(AXI_READ_CHANNEL_BURSTS_ID_2, 69)
    GENERATE_ENUM(AXI_READ_CHANNEL_BURSTS_ID_3, 70)
    GENERATE_ENUM(AXI_READ_CHANNEL_BURSTS_ID_4, 71)
    GENERATE_ENUM(AXI_READ_CHANNEL_BURSTS_ID_5, 72)
    GENERATE_ENUM(AXI_READ_CHANNEL_BURSTS_ID_6, 73)
    GENERATE_ENUM(AXI_READ_CHANNEL_BURSTS_ID_7, 74)
    GENERATE_ENUM(AXI_READ_CHANNEL_TOTAL_BURSTS, 75)
    GENERATE_ENUM(AXI_READ_CHANNEL_DATA_BEATS_READ_ID_0, 76)
    GENERATE_ENUM(AXI_READ_CHANNEL_DATA_BEATS_READ_ID_1, 77)
    GENERATE_ENUM(AXI_READ_CHANNEL_DATA_BEATS_READ_ID_2, 78)
    GENERATE_ENUM(AXI_READ_CHANNEL_DATA_BEATS_READ_ID_3, 79)
    GENERATE_ENUM(AXI_READ_CHANNEL_DATA_BEATS_READ_ID_4, 80)
    GENERATE_ENUM(AXI_READ_CHANNEL_DATA_BEATS_READ_ID_5, 81)
    GENERATE_ENUM(AXI_READ_CHANNEL_DATA_BEATS_READ_ID_6, 82)
    GENERATE_ENUM(AXI_READ_CHANNEL_DATA_BEATS_READ_ID_7, 83)
    GENERATE_ENUM(AXI_READ_CHANNEL_TOTAL_DATA_BEATS_READ, 84)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_BURSTS_ID_0, 85)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_BURSTS_ID_1, 86)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_BURSTS_ID_2, 87)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_BURSTS_ID_3, 88)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_BURSTS_ID_4, 89)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_BURSTS_ID_5, 90)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_BURSTS_ID_6, 91)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_BURSTS_ID_7, 92)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_TOTAL_BURSTS, 93)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_0, 94)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_1, 95)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_2, 96)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_3, 97)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_4, 98)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_5, 99)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_6, 100)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_DATA_BYTES_WRITTEN_ID_7, 101)
    GENERATE_ENUM(AXI_WRITE_CHANNEL_TOTAL_DATA_BYTES_WRITTEN, 102)
    GENERATE_ENUM(AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_0, 103)
    GENERATE_ENUM(AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_1, 104)
    GENERATE_ENUM(AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_2, 105)
    GENERATE_ENUM(AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_3, 106)
    GENERATE_ENUM(AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_4, 107)
    GENERATE_ENUM(AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_5, 108)
    GENERATE_ENUM(AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_6, 109)
    GENERATE_ENUM(AXI_WRITE_RESPONSE_CHANNEL_RESPONSES_ID_7, 110)
    GENERATE_ENUM(AXI_WRITE_RESPONSE_CHANNEL_TOTAL_RESPONSES, 111)
    GENERATE_ENUM(TOTAL_MMU_MISSES, 112)
    GENERATE_ENUM(MMU_READ_MISSES, 113)
    GENERATE_ENUM(MMU_WRITE_MISSES, 114)
    GENERATE_ENUM(TOTAL_MMU_HITS, 115)
    GENERATE_ENUM(MMU_READ_HITS, 116)
    GENERATE_ENUM(MMU_WRITE_HITS, 117)
    GENERATE_ENUM(SPLIT_MODE_TC_HITS, 118)
    GENERATE_ENUM(SPLIT_MODE_TC_MISSES, 119)
    GENERATE_ENUM(SPLIT_MODE_NON_TC_HITS, 120)
    GENERATE_ENUM(SPLIT_MODE_NON_TC_MISSES, 121)
    GENERATE_ENUM(STALL_AWAITING_TLB_MISS_FETCH, 122)
    GENERATE_ENUM(MMU_TLB_MISS_READ_BURSTS_RECEIVED, 123)
    GENERATE_ENUM(MMU_TLB_MISS_DATA_BEATS_READ, 124)
    GENERATE_ENUM(CP_CYCLES_HELD_OFF, 125)
    GENERATE_ENUM(VGT_CYCLES_HELD_OFF, 126)
    GENERATE_ENUM(TC_CYCLES_HELD_OFF, 127)
    GENERATE_ENUM(TC_ROQ_CYCLES_HELD_OFF, 128)
    GENERATE_ENUM(TC_CYCLES_HELD_OFF_TCD_FULL, 129)
    GENERATE_ENUM(RB_CYCLES_HELD_OFF, 130)
    GENERATE_ENUM(TOTAL_CYCLES_ANY_CLNT_HELD_OFF, 131)
    GENERATE_ENUM(TLB_MISS_CYCLES_HELD_OFF, 132)
    GENERATE_ENUM(AXI_READ_REQUEST_HELD_OFF, 133)
    GENERATE_ENUM(AXI_WRITE_REQUEST_HELD_OFF, 134)
    GENERATE_ENUM(AXI_REQUEST_HELD_OFF, 135)
    GENERATE_ENUM(AXI_REQUEST_HELD_OFF_INFLIGHT_LIMIT, 136)
    GENERATE_ENUM(AXI_WRITE_DATA_HELD_OFF, 137)
    GENERATE_ENUM(CP_SAME_PAGE_BANK_REQUESTS, 138)
    GENERATE_ENUM(VGT_SAME_PAGE_BANK_REQUESTS, 139)
    GENERATE_ENUM(TC_SAME_PAGE_BANK_REQUESTS, 140)
    GENERATE_ENUM(TC_ARB_HOLD_SAME_PAGE_BANK_REQUESTS, 141)
    GENERATE_ENUM(RB_SAME_PAGE_BANK_REQUESTS, 142)
    GENERATE_ENUM(TOTAL_SAME_PAGE_BANK_REQUESTS, 143)
    GENERATE_ENUM(CP_SAME_PAGE_BANK_REQUESTS_KILLED_FAIRNESS_LIMIT, 144)
    GENERATE_ENUM(VGT_SAME_PAGE_BANK_REQUESTS_KILLED_FAIRNESS_LIMIT, 145)
    GENERATE_ENUM(TC_SAME_PAGE_BANK_REQUESTS_KILLED_FAIRNESS_LIMIT, 146)
    GENERATE_ENUM(RB_SAME_PAGE_BANK_REQUESTS_KILLED_FAIRNESS_LIMIT, 147)
    GENERATE_ENUM(TOTAL_SAME_PAGE_BANK_KILLED_FAIRNESS_LIMIT, 148)
    GENERATE_ENUM(TOTAL_MH_READ_REQUESTS, 149)
    GENERATE_ENUM(TOTAL_MH_WRITE_REQUESTS, 150)
    GENERATE_ENUM(TOTAL_MH_REQUESTS, 151)
    GENERATE_ENUM(MH_BUSY, 152)
    GENERATE_ENUM(CP_NTH_ACCESS_SAME_PAGE_BANK_SEQUENCE, 153)
    GENERATE_ENUM(VGT_NTH_ACCESS_SAME_PAGE_BANK_SEQUENCE, 154)
    GENERATE_ENUM(TC_NTH_ACCESS_SAME_PAGE_BANK_SEQUENCE, 155)
    GENERATE_ENUM(RB_NTH_ACCESS_SAME_PAGE_BANK_SEQUENCE, 156)
    GENERATE_ENUM(TC_ROQ_N_VALID_ENTRIES, 157)
    GENERATE_ENUM(ARQ_N_ENTRIES, 158)
    GENERATE_ENUM(WDB_N_ENTRIES, 159)
    GENERATE_ENUM(MH_READ_LATENCY_OUTST_REQ_SUM, 160)
    GENERATE_ENUM(MC_READ_LATENCY_OUTST_REQ_SUM, 161)
    GENERATE_ENUM(MC_TOTAL_READ_REQUESTS, 162)
    GENERATE_ENUM(ELAPSED_CYCLES_MH_GATED_CLK, 163)
END_ENUMTYPE(MhPerfEncode)

START_ENUMTYPE(MmuClntBeh)
    GENERATE_ENUM(BEH_NEVR, 0)
    GENERATE_ENUM(BEH_TRAN_RNG, 1)
    GENERATE_ENUM(BEH_TRAN_FLT, 2)
END_ENUMTYPE(MmuClntBeh)

START_ENUMTYPE(RBBM_PERFCOUNT1_SEL)
    GENERATE_ENUM(RBBM1_COUNT, 0)
    GENERATE_ENUM(RBBM1_NRT_BUSY, 1)
    GENERATE_ENUM(RBBM1_RB_BUSY, 2)
    GENERATE_ENUM(RBBM1_SQ_CNTX0_BUSY, 3)
    GENERATE_ENUM(RBBM1_SQ_CNTX17_BUSY, 4)
    GENERATE_ENUM(RBBM1_VGT_BUSY, 5)
    GENERATE_ENUM(RBBM1_VGT_NODMA_BUSY, 6)
    GENERATE_ENUM(RBBM1_PA_BUSY, 7)
    GENERATE_ENUM(RBBM1_SC_CNTX_BUSY, 8)
    GENERATE_ENUM(RBBM1_TPC_BUSY, 9)
    GENERATE_ENUM(RBBM1_TC_BUSY, 10)
    GENERATE_ENUM(RBBM1_SX_BUSY, 11)
    GENERATE_ENUM(RBBM1_CP_COHER_BUSY, 12)
    GENERATE_ENUM(RBBM1_CP_NRT_BUSY, 13)
    GENERATE_ENUM(RBBM1_GFX_IDLE_STALL, 14)
    GENERATE_ENUM(RBBM1_INTERRUPT, 15)
END_ENUMTYPE(RBBM_PERFCOUNT1_SEL)

START_ENUMTYPE(CP_PERFCOUNT_SEL)
    GENERATE_ENUM(ALWAYS_COUNT, 0)
    GENERATE_ENUM(TRANS_FIFO_FULL, 1)
    GENERATE_ENUM(TRANS_FIFO_AF, 2)
    GENERATE_ENUM(RCIU_PFPTRANS_WAIT, 3)
    GENERATE_ENUM(Reserved_04, 4)
    GENERATE_ENUM(Reserved_05, 5)
    GENERATE_ENUM(RCIU_NRTTRANS_WAIT, 6)
    GENERATE_ENUM(Reserved_07, 7)
    GENERATE_ENUM(CSF_NRT_READ_WAIT, 8)
    GENERATE_ENUM(CSF_I1_FIFO_FULL, 9)
    GENERATE_ENUM(CSF_I2_FIFO_FULL, 10)
    GENERATE_ENUM(CSF_ST_FIFO_FULL, 11)
    GENERATE_ENUM(Reserved_12, 12)
    GENERATE_ENUM(CSF_RING_ROQ_FULL, 13)
    GENERATE_ENUM(CSF_I1_ROQ_FULL, 14)
    GENERATE_ENUM(CSF_I2_ROQ_FULL, 15)
    GENERATE_ENUM(CSF_ST_ROQ_FULL, 16)
    GENERATE_ENUM(Reserved_17, 17)
    GENERATE_ENUM(MIU_TAG_MEM_FULL, 18)
    GENERATE_ENUM(MIU_WRITECLEAN, 19)
    GENERATE_ENUM(Reserved_20, 20)
    GENERATE_ENUM(Reserved_21, 21)
    GENERATE_ENUM(MIU_NRT_WRITE_STALLED, 22)
    GENERATE_ENUM(MIU_NRT_READ_STALLED, 23)
    GENERATE_ENUM(ME_WRITE_CONFIRM_FIFO_FULL, 24)
    GENERATE_ENUM(ME_VS_DEALLOC_FIFO_FULL, 25)
    GENERATE_ENUM(ME_PS_DEALLOC_FIFO_FULL, 26)
    GENERATE_ENUM(ME_REGS_VS_EVENT_FIFO_FULL, 27)
    GENERATE_ENUM(ME_REGS_PS_EVENT_FIFO_FULL, 28)
    GENERATE_ENUM(ME_REGS_CF_EVENT_FIFO_FULL, 29)
    GENERATE_ENUM(ME_MICRO_RB_STARVED, 30)
    GENERATE_ENUM(ME_MICRO_I1_STARVED, 31)
    GENERATE_ENUM(ME_MICRO_I2_STARVED, 32)
    GENERATE_ENUM(ME_MICRO_ST_STARVED, 33)
    GENERATE_ENUM(Reserved_34, 34)
    GENERATE_ENUM(Reserved_35, 35)
    GENERATE_ENUM(Reserved_36, 36)
    GENERATE_ENUM(Reserved_37, 37)
    GENERATE_ENUM(Reserved_38, 38)
    GENERATE_ENUM(Reserved_39, 39)
    GENERATE_ENUM(RCIU_RBBM_DWORD_SENT, 40)
    GENERATE_ENUM(ME_BUSY_CLOCKS, 41)
    GENERATE_ENUM(ME_WAIT_CONTEXT_AVAIL, 42)
    GENERATE_ENUM(PFP_TYPE0_PACKET, 43)
    GENERATE_ENUM(PFP_TYPE3_PACKET, 44)
    GENERATE_ENUM(CSF_RB_WPTR_NEQ_RPTR, 45)
    GENERATE_ENUM(CSF_I1_SIZE_NEQ_ZERO, 46)
    GENERATE_ENUM(CSF_I2_SIZE_NEQ_ZERO, 47)
    GENERATE_ENUM(CSF_RBI1I2_FETCHING, 48)
    GENERATE_ENUM(Reserved_49, 49)
    GENERATE_ENUM(Reserved_50, 50)
    GENERATE_ENUM(Reserved_51, 51)
    GENERATE_ENUM(Reserved_52, 52)
    GENERATE_ENUM(Reserved_53, 53)
    GENERATE_ENUM(Reserved_54, 54)
    GENERATE_ENUM(Reserved_55, 55)
    GENERATE_ENUM(Reserved_56, 56)
    GENERATE_ENUM(Reserved_57, 57)
    GENERATE_ENUM(Reserved_58, 58)
    GENERATE_ENUM(Reserved_59, 59)
    GENERATE_ENUM(Reserved_60, 60)
    GENERATE_ENUM(Reserved_61, 61)
    GENERATE_ENUM(Reserved_62, 62)
    GENERATE_ENUM(Reserved_63, 63)
END_ENUMTYPE(CP_PERFCOUNT_SEL)

START_ENUMTYPE(ColorformatX)
    GENERATE_ENUM(COLORX_4_4_4_4, 0)
    GENERATE_ENUM(COLORX_1_5_5_5, 1)
    GENERATE_ENUM(COLORX_5_6_5, 2)
    GENERATE_ENUM(COLORX_8, 3)
    GENERATE_ENUM(COLORX_8_8, 4)
    GENERATE_ENUM(COLORX_8_8_8_8, 5)
    GENERATE_ENUM(COLORX_S8_8_8_8, 6)
    GENERATE_ENUM(COLORX_16_FLOAT, 7)
    GENERATE_ENUM(COLORX_16_16_FLOAT, 8)
    GENERATE_ENUM(COLORX_16_16_16_16_FLOAT, 9)
    GENERATE_ENUM(COLORX_32_FLOAT, 10)
    GENERATE_ENUM(COLORX_32_32_FLOAT, 11)
    GENERATE_ENUM(COLORX_32_32_32_32_FLOAT, 12)
    GENERATE_ENUM(COLORX_2_3_3, 13)
    GENERATE_ENUM(COLORX_8_8_8, 14)
END_ENUMTYPE(ColorformatX)

START_ENUMTYPE(DepthformatX)
    GENERATE_ENUM(DEPTHX_16, 0)
    GENERATE_ENUM(DEPTHX_24_8, 1)
END_ENUMTYPE(DepthformatX)

START_ENUMTYPE(CompareFrag)
    GENERATE_ENUM(FRAG_NEVER, 0)
    GENERATE_ENUM(FRAG_LESS, 1)
    GENERATE_ENUM(FRAG_EQUAL, 2)
    GENERATE_ENUM(FRAG_LEQUAL, 3)
    GENERATE_ENUM(FRAG_GREATER, 4)
    GENERATE_ENUM(FRAG_NOTEQUAL, 5)
    GENERATE_ENUM(FRAG_GEQUAL, 6)
    GENERATE_ENUM(FRAG_ALWAYS, 7)
END_ENUMTYPE(CompareFrag)

START_ENUMTYPE(CompareRef)
    GENERATE_ENUM(REF_NEVER, 0)
    GENERATE_ENUM(REF_LESS, 1)
    GENERATE_ENUM(REF_EQUAL, 2)
    GENERATE_ENUM(REF_LEQUAL, 3)
    GENERATE_ENUM(REF_GREATER, 4)
    GENERATE_ENUM(REF_NOTEQUAL, 5)
    GENERATE_ENUM(REF_GEQUAL, 6)
    GENERATE_ENUM(REF_ALWAYS, 7)
END_ENUMTYPE(CompareRef)

START_ENUMTYPE(StencilOp)
    GENERATE_ENUM(STENCIL_KEEP, 0)
    GENERATE_ENUM(STENCIL_ZERO, 1)
    GENERATE_ENUM(STENCIL_REPLACE, 2)
    GENERATE_ENUM(STENCIL_INCR_CLAMP, 3)
    GENERATE_ENUM(STENCIL_DECR_CLAMP, 4)
    GENERATE_ENUM(STENCIL_INVERT, 5)
    GENERATE_ENUM(STENCIL_INCR_WRAP, 6)
    GENERATE_ENUM(STENCIL_DECR_WRAP, 7)
END_ENUMTYPE(StencilOp)

START_ENUMTYPE(BlendOpX)
    GENERATE_ENUM(BLENDX_ZERO, 0)
    GENERATE_ENUM(BLENDX_ONE, 1)
    GENERATE_ENUM(BLENDX_SRC_COLOR, 4)
    GENERATE_ENUM(BLENDX_ONE_MINUS_SRC_COLOR, 5)
    GENERATE_ENUM(BLENDX_SRC_ALPHA, 6)
    GENERATE_ENUM(BLENDX_ONE_MINUS_SRC_ALPHA, 7)
    GENERATE_ENUM(BLENDX_DST_COLOR, 8)
    GENERATE_ENUM(BLENDX_ONE_MINUS_DST_COLOR, 9)
    GENERATE_ENUM(BLENDX_DST_ALPHA, 10)
    GENERATE_ENUM(BLENDX_ONE_MINUS_DST_ALPHA, 11)
    GENERATE_ENUM(BLENDX_CONSTANT_COLOR, 12)
    GENERATE_ENUM(BLENDX_ONE_MINUS_CONSTANT_COLOR, 13)
    GENERATE_ENUM(BLENDX_CONSTANT_ALPHA, 14)
    GENERATE_ENUM(BLENDX_ONE_MINUS_CONSTANT_ALPHA, 15)
    GENERATE_ENUM(BLENDX_SRC_ALPHA_SATURATE, 16)
END_ENUMTYPE(BlendOpX)

START_ENUMTYPE(CombFuncX)
    GENERATE_ENUM(COMB_DST_PLUS_SRC, 0)
    GENERATE_ENUM(COMB_SRC_MINUS_DST, 1)
    GENERATE_ENUM(COMB_MIN_DST_SRC, 2)
    GENERATE_ENUM(COMB_MAX_DST_SRC, 3)
    GENERATE_ENUM(COMB_DST_MINUS_SRC, 4)
    GENERATE_ENUM(COMB_DST_PLUS_SRC_BIAS, 5)
END_ENUMTYPE(CombFuncX)

START_ENUMTYPE(DitherModeX)
    GENERATE_ENUM(DITHER_DISABLE, 0)
    GENERATE_ENUM(DITHER_ALWAYS, 1)
    GENERATE_ENUM(DITHER_IF_ALPHA_OFF, 2)
END_ENUMTYPE(DitherModeX)

START_ENUMTYPE(DitherTypeX)
    GENERATE_ENUM(DITHER_PIXEL, 0)
    GENERATE_ENUM(DITHER_SUBPIXEL, 1)
END_ENUMTYPE(DitherTypeX)

START_ENUMTYPE(EdramMode)
    GENERATE_ENUM(EDRAM_NOP, 0)
    GENERATE_ENUM(COLOR_DEPTH, 4)
    GENERATE_ENUM(DEPTH_ONLY, 5)
    GENERATE_ENUM(EDRAM_COPY, 6)
END_ENUMTYPE(EdramMode)

START_ENUMTYPE(SurfaceEndian)
    GENERATE_ENUM(ENDIAN_NONE, 0)
    GENERATE_ENUM(ENDIAN_8IN16, 1)
    GENERATE_ENUM(ENDIAN_8IN32, 2)
    GENERATE_ENUM(ENDIAN_16IN32, 3)
    GENERATE_ENUM(ENDIAN_8IN64, 4)
    GENERATE_ENUM(ENDIAN_8IN128, 5)
END_ENUMTYPE(SurfaceEndian)

START_ENUMTYPE(EdramSizeX)
    GENERATE_ENUM(EDRAMSIZE_16KB, 0)
    GENERATE_ENUM(EDRAMSIZE_32KB, 1)
    GENERATE_ENUM(EDRAMSIZE_64KB, 2)
    GENERATE_ENUM(EDRAMSIZE_128KB, 3)
    GENERATE_ENUM(EDRAMSIZE_256KB, 4)
    GENERATE_ENUM(EDRAMSIZE_512KB, 5)
    GENERATE_ENUM(EDRAMSIZE_1MB, 6)
    GENERATE_ENUM(EDRAMSIZE_2MB, 7)
    GENERATE_ENUM(EDRAMSIZE_4MB, 8)
    GENERATE_ENUM(EDRAMSIZE_8MB, 9)
    GENERATE_ENUM(EDRAMSIZE_16MB, 10)
END_ENUMTYPE(EdramSizeX)

START_ENUMTYPE(RB_PERFCNT_SELECT)
    GENERATE_ENUM(RBPERF_CNTX_BUSY, 0)
    GENERATE_ENUM(RBPERF_CNTX_BUSY_MAX, 1)
    GENERATE_ENUM(RBPERF_SX_QUAD_STARVED, 2)
    GENERATE_ENUM(RBPERF_SX_QUAD_STARVED_MAX, 3)
    GENERATE_ENUM(RBPERF_GA_GC_CH0_SYS_REQ, 4)
    GENERATE_ENUM(RBPERF_GA_GC_CH0_SYS_REQ_MAX, 5)
    GENERATE_ENUM(RBPERF_GA_GC_CH1_SYS_REQ, 6)
    GENERATE_ENUM(RBPERF_GA_GC_CH1_SYS_REQ_MAX, 7)
    GENERATE_ENUM(RBPERF_MH_STARVED, 8)
    GENERATE_ENUM(RBPERF_MH_STARVED_MAX, 9)
    GENERATE_ENUM(RBPERF_AZ_BC_COLOR_BUSY, 10)
    GENERATE_ENUM(RBPERF_AZ_BC_COLOR_BUSY_MAX, 11)
    GENERATE_ENUM(RBPERF_AZ_BC_Z_BUSY, 12)
    GENERATE_ENUM(RBPERF_AZ_BC_Z_BUSY_MAX, 13)
    GENERATE_ENUM(RBPERF_RB_SC_TILE_RTR_N, 14)
    GENERATE_ENUM(RBPERF_RB_SC_TILE_RTR_N_MAX, 15)
    GENERATE_ENUM(RBPERF_RB_SC_SAMP_RTR_N, 16)
    GENERATE_ENUM(RBPERF_RB_SC_SAMP_RTR_N_MAX, 17)
    GENERATE_ENUM(RBPERF_RB_SX_QUAD_RTR_N, 18)
    GENERATE_ENUM(RBPERF_RB_SX_QUAD_RTR_N_MAX, 19)
    GENERATE_ENUM(RBPERF_RB_SX_COLOR_RTR_N, 20)
    GENERATE_ENUM(RBPERF_RB_SX_COLOR_RTR_N_MAX, 21)
    GENERATE_ENUM(RBPERF_RB_SC_SAMP_LZ_BUSY, 22)
    GENERATE_ENUM(RBPERF_RB_SC_SAMP_LZ_BUSY_MAX, 23)
    GENERATE_ENUM(RBPERF_ZXP_STALL, 24)
    GENERATE_ENUM(RBPERF_ZXP_STALL_MAX, 25)
    GENERATE_ENUM(RBPERF_EVENT_PENDING, 26)
    GENERATE_ENUM(RBPERF_EVENT_PENDING_MAX, 27)
    GENERATE_ENUM(RBPERF_RB_MH_VALID, 28)
    GENERATE_ENUM(RBPERF_RB_MH_VALID_MAX, 29)
    GENERATE_ENUM(RBPERF_SX_RB_QUAD_SEND, 30)
    GENERATE_ENUM(RBPERF_SX_RB_COLOR_SEND, 31)
    GENERATE_ENUM(RBPERF_SC_RB_TILE_SEND, 32)
    GENERATE_ENUM(RBPERF_SC_RB_SAMPLE_SEND, 33)
    GENERATE_ENUM(RBPERF_SX_RB_MEM_EXPORT, 34)
    GENERATE_ENUM(RBPERF_SX_RB_QUAD_EVENT, 35)
    GENERATE_ENUM(RBPERF_SC_RB_TILE_EVENT_FILTERED, 36)
    GENERATE_ENUM(RBPERF_SC_RB_TILE_EVENT_ALL, 37)
    GENERATE_ENUM(RBPERF_RB_SC_EZ_SEND, 38)
    GENERATE_ENUM(RBPERF_RB_SX_INDEX_SEND, 39)
    GENERATE_ENUM(RBPERF_GMEM_INTFO_RD, 40)
    GENERATE_ENUM(RBPERF_GMEM_INTF1_RD, 41)
    GENERATE_ENUM(RBPERF_GMEM_INTFO_WR, 42)
    GENERATE_ENUM(RBPERF_GMEM_INTF1_WR, 43)
    GENERATE_ENUM(RBPERF_RB_CP_CONTEXT_DONE, 44)
    GENERATE_ENUM(RBPERF_RB_CP_CACHE_FLUSH, 45)
    GENERATE_ENUM(RBPERF_ZPASS_DONE, 46)
    GENERATE_ENUM(RBPERF_ZCMD_VALID, 47)
    GENERATE_ENUM(RBPERF_CCMD_VALID, 48)
    GENERATE_ENUM(RBPERF_ACCUM_GRANT, 49)
    GENERATE_ENUM(RBPERF_ACCUM_C0_GRANT, 50)
    GENERATE_ENUM(RBPERF_ACCUM_C1_GRANT, 51)
    GENERATE_ENUM(RBPERF_ACCUM_FULL_BE_WR, 52)
    GENERATE_ENUM(RBPERF_ACCUM_REQUEST_NO_GRANT, 53)
    GENERATE_ENUM(RBPERF_ACCUM_TIMEOUT_PULSE, 54)
    GENERATE_ENUM(RBPERF_ACCUM_LIN_TIMEOUT_PULSE, 55)
    GENERATE_ENUM(RBPERF_ACCUM_CAM_HIT_FLUSHING, 56)
END_ENUMTYPE(RB_PERFCNT_SELECT)

START_ENUMTYPE(DepthFormat)
    GENERATE_ENUM(DEPTH_24_8, 22)
    GENERATE_ENUM(DEPTH_24_8_FLOAT, 23)
    GENERATE_ENUM(DEPTH_16, 24)
END_ENUMTYPE(DepthFormat)

START_ENUMTYPE(SurfaceSwap)
    GENERATE_ENUM(SWAP_LOWRED, 0)
    GENERATE_ENUM(SWAP_LOWBLUE, 1)
END_ENUMTYPE(SurfaceSwap)

START_ENUMTYPE(DepthArray)
    GENERATE_ENUM(ARRAY_2D_ALT_DEPTH, 0)
    GENERATE_ENUM(ARRAY_2D_DEPTH, 1)
END_ENUMTYPE(DepthArray)

START_ENUMTYPE(ColorArray)
    GENERATE_ENUM(ARRAY_2D_ALT_COLOR, 0)
    GENERATE_ENUM(ARRAY_2D_COLOR, 1)
    GENERATE_ENUM(ARRAY_3D_SLICE_COLOR, 3)
END_ENUMTYPE(ColorArray)

START_ENUMTYPE(ColorFormat)
    GENERATE_ENUM(COLOR_8, 2)
    GENERATE_ENUM(COLOR_1_5_5_5, 3)
    GENERATE_ENUM(COLOR_5_6_5, 4)
    GENERATE_ENUM(COLOR_6_5_5, 5)
    GENERATE_ENUM(COLOR_8_8_8_8, 6)
    GENERATE_ENUM(COLOR_2_10_10_10, 7)
    GENERATE_ENUM(COLOR_8_A, 8)
    GENERATE_ENUM(COLOR_8_B, 9)
    GENERATE_ENUM(COLOR_8_8, 10)
    GENERATE_ENUM(COLOR_8_8_8, 11)
    GENERATE_ENUM(COLOR_8_8_8_8_A, 14)
    GENERATE_ENUM(COLOR_4_4_4_4, 15)
    GENERATE_ENUM(COLOR_10_11_11, 16)
    GENERATE_ENUM(COLOR_11_11_10, 17)
    GENERATE_ENUM(COLOR_16, 24)
    GENERATE_ENUM(COLOR_16_16, 25)
    GENERATE_ENUM(COLOR_16_16_16_16, 26)
    GENERATE_ENUM(COLOR_16_FLOAT, 30)
    GENERATE_ENUM(COLOR_16_16_FLOAT, 31)
    GENERATE_ENUM(COLOR_16_16_16_16_FLOAT, 32)
    GENERATE_ENUM(COLOR_32_FLOAT, 36)
    GENERATE_ENUM(COLOR_32_32_FLOAT, 37)
    GENERATE_ENUM(COLOR_32_32_32_32_FLOAT, 38)
    GENERATE_ENUM(COLOR_2_3_3, 39)
END_ENUMTYPE(ColorFormat)

START_ENUMTYPE(SurfaceNumber)
    GENERATE_ENUM(NUMBER_UREPEAT, 0)
    GENERATE_ENUM(NUMBER_SREPEAT, 1)
    GENERATE_ENUM(NUMBER_UINTEGER, 2)
    GENERATE_ENUM(NUMBER_SINTEGER, 3)
    GENERATE_ENUM(NUMBER_GAMMA, 4)
    GENERATE_ENUM(NUMBER_FIXED, 5)
    GENERATE_ENUM(NUMBER_FLOAT, 7)
END_ENUMTYPE(SurfaceNumber)

START_ENUMTYPE(SurfaceFormat)
    GENERATE_ENUM(FMT_1_REVERSE, 0)
    GENERATE_ENUM(FMT_1, 1)
    GENERATE_ENUM(FMT_8, 2)
    GENERATE_ENUM(FMT_1_5_5_5, 3)
    GENERATE_ENUM(FMT_5_6_5, 4)
    GENERATE_ENUM(FMT_6_5_5, 5)
    GENERATE_ENUM(FMT_8_8_8_8, 6)
    GENERATE_ENUM(FMT_2_10_10_10, 7)
    GENERATE_ENUM(FMT_8_A, 8)
    GENERATE_ENUM(FMT_8_B, 9)
    GENERATE_ENUM(FMT_8_8, 10)
    GENERATE_ENUM(FMT_Cr_Y1_Cb_Y0, 11)
    GENERATE_ENUM(FMT_Y1_Cr_Y0_Cb, 12)
    GENERATE_ENUM(FMT_5_5_5_1, 13)
    GENERATE_ENUM(FMT_8_8_8_8_A, 14)
    GENERATE_ENUM(FMT_4_4_4_4, 15)
    GENERATE_ENUM(FMT_8_8_8, 16)
    GENERATE_ENUM(FMT_DXT1, 18)
    GENERATE_ENUM(FMT_DXT2_3, 19)
    GENERATE_ENUM(FMT_DXT4_5, 20)
    GENERATE_ENUM(FMT_10_10_10_2, 21)
    GENERATE_ENUM(FMT_24_8, 22)
    GENERATE_ENUM(FMT_16, 24)
    GENERATE_ENUM(FMT_16_16, 25)
    GENERATE_ENUM(FMT_16_16_16_16, 26)
    GENERATE_ENUM(FMT_16_EXPAND, 27)
    GENERATE_ENUM(FMT_16_16_EXPAND, 28)
    GENERATE_ENUM(FMT_16_16_16_16_EXPAND, 29)
    GENERATE_ENUM(FMT_16_FLOAT, 30)
    GENERATE_ENUM(FMT_16_16_FLOAT, 31)
    GENERATE_ENUM(FMT_16_16_16_16_FLOAT, 32)
    GENERATE_ENUM(FMT_32, 33)
    GENERATE_ENUM(FMT_32_32, 34)
    GENERATE_ENUM(FMT_32_32_32_32, 35)
    GENERATE_ENUM(FMT_32_FLOAT, 36)
    GENERATE_ENUM(FMT_32_32_FLOAT, 37)
    GENERATE_ENUM(FMT_32_32_32_32_FLOAT, 38)
    GENERATE_ENUM(FMT_ATI_TC_RGB, 39)
    GENERATE_ENUM(FMT_ATI_TC_RGBA, 40)
    GENERATE_ENUM(FMT_ATI_TC_555_565_RGB, 41)
    GENERATE_ENUM(FMT_ATI_TC_555_565_RGBA, 42)
    GENERATE_ENUM(FMT_ATI_TC_RGBA_INTERP, 43)
    GENERATE_ENUM(FMT_ATI_TC_555_565_RGBA_INTERP, 44)
    GENERATE_ENUM(FMT_ETC1_RGBA_INTERP, 46)
    GENERATE_ENUM(FMT_ETC1_RGB, 47)
    GENERATE_ENUM(FMT_ETC1_RGBA, 48)
    GENERATE_ENUM(FMT_DXN, 49)
    GENERATE_ENUM(FMT_2_3_3, 51)
    GENERATE_ENUM(FMT_2_10_10_10_AS_16_16_16_16, 54)
    GENERATE_ENUM(FMT_10_10_10_2_AS_16_16_16_16, 55)
    GENERATE_ENUM(FMT_32_32_32_FLOAT, 57)
    GENERATE_ENUM(FMT_DXT3A, 58)
    GENERATE_ENUM(FMT_DXT5A, 59)
    GENERATE_ENUM(FMT_CTX1, 60)
END_ENUMTYPE(SurfaceFormat)

START_ENUMTYPE(SurfaceTiling)
    GENERATE_ENUM(ARRAY_LINEAR, 0)
    GENERATE_ENUM(ARRAY_TILED, 1)
END_ENUMTYPE(SurfaceTiling)

START_ENUMTYPE(SurfaceArray)
    GENERATE_ENUM(ARRAY_1D, 0)
    GENERATE_ENUM(ARRAY_2D, 1)
    GENERATE_ENUM(ARRAY_3D, 2)
    GENERATE_ENUM(ARRAY_3D_SLICE, 3)
END_ENUMTYPE(SurfaceArray)

START_ENUMTYPE(SurfaceNumberX)
    GENERATE_ENUM(NUMBERX_UREPEAT, 0)
    GENERATE_ENUM(NUMBERX_SREPEAT, 1)
    GENERATE_ENUM(NUMBERX_UINTEGER, 2)
    GENERATE_ENUM(NUMBERX_SINTEGER, 3)
    GENERATE_ENUM(NUMBERX_FLOAT, 7)
END_ENUMTYPE(SurfaceNumberX)

START_ENUMTYPE(ColorArrayX)
    GENERATE_ENUM(ARRAYX_2D_COLOR, 0)
    GENERATE_ENUM(ARRAYX_3D_SLICE_COLOR, 1)
END_ENUMTYPE(ColorArrayX)




// **************************************************************************
// These are ones that had to be added in addition to what's generated
// by the autoreg (in CSIM)
// **************************************************************************
START_ENUMTYPE(DXClipSpaceDef)
    GENERATE_ENUM(DXCLIP_OPENGL, 0)
    GENERATE_ENUM(DXCLIP_DIRECTX, 1)
END_ENUMTYPE(DXClipSpaceDef)

START_ENUMTYPE(PixCenter)
    GENERATE_ENUM(PIXCENTER_D3D, 0)
    GENERATE_ENUM(PIXCENTER_OGL, 1)
END_ENUMTYPE(PixCenter)

START_ENUMTYPE(RoundMode)
    GENERATE_ENUM(TRUNCATE,   0)
    GENERATE_ENUM(ROUND,      1)
    GENERATE_ENUM(ROUNDTOEVEN,    2)
    GENERATE_ENUM(ROUNDTOODD,     3)
END_ENUMTYPE(RoundMode)

START_ENUMTYPE(QuantMode)
    GENERATE_ENUM(ONE_SIXTEENTH,   0)
    GENERATE_ENUM(ONE_EIGHTH,      1)
    GENERATE_ENUM(ONE_QUARTER,     2)
    GENERATE_ENUM(ONE_HALF,    3)
    GENERATE_ENUM(ONE,         4)
END_ENUMTYPE(QuantMode)

START_ENUMTYPE(FrontFace)
    GENERATE_ENUM(FRONT_CCW,        0)
    GENERATE_ENUM(FRONT_CW,     1)
END_ENUMTYPE(FrontFace)

START_ENUMTYPE(PolyMode)
    GENERATE_ENUM(DISABLED,    0)
    GENERATE_ENUM(DUALMODE,    1)
END_ENUMTYPE(PolyMode)

START_ENUMTYPE(PType)
    GENERATE_ENUM(DRAW_POINTS,      0)
    GENERATE_ENUM(DRAW_LINES,       1)
    GENERATE_ENUM(DRAW_TRIANGLES,   2)
END_ENUMTYPE(PType)

START_ENUMTYPE(MSAANumSamples)
    GENERATE_ENUM(ONE,      0)
    GENERATE_ENUM(TWO,      1)
    GENERATE_ENUM(FOUR,     3)
END_ENUMTYPE(MSAANumSamples)

START_ENUMTYPE(PatternBitOrder)
    GENERATE_ENUM(LITTLE,   0)
    GENERATE_ENUM(BIG,      1)
END_ENUMTYPE(PatternBitOrder)

START_ENUMTYPE(AutoResetCntl)
    GENERATE_ENUM(NEVER,        0)
    GENERATE_ENUM(EACHPRIMITIVE,    1)
    GENERATE_ENUM(EACHPACKET,       2)
END_ENUMTYPE(AutoResetCntl)

START_ENUMTYPE(ParamShade)
    GENERATE_ENUM(FLAT,     0)
    GENERATE_ENUM(GOURAUD,  1)
END_ENUMTYPE(ParamShade)

START_ENUMTYPE(SamplingPattern)
    GENERATE_ENUM(CENTROID, 0)
    GENERATE_ENUM(PIXCENTER, 1)
END_ENUMTYPE(SamplingPattern)

START_ENUMTYPE(MSAASamples)
    GENERATE_ENUM(ONE,      0)
    GENERATE_ENUM(TWO,      1)
    GENERATE_ENUM(FOUR,     2)
END_ENUMTYPE(MSAASamples)

START_ENUMTYPE(CopySampleSelect)
    GENERATE_ENUM(SAMPLE_0, 0)
    GENERATE_ENUM(SAMPLE_1, 1)
    GENERATE_ENUM(SAMPLE_2, 2)
    GENERATE_ENUM(SAMPLE_3, 3)
    GENERATE_ENUM(SAMPLE_01,    4)
    GENERATE_ENUM(SAMPLE_23,    5)
    GENERATE_ENUM(SAMPLE_0123,  6)
END_ENUMTYPE(CopySampleSelect)


#undef START_ENUMTYPE
#undef GENERATE_ENUM
#undef END_ENUMTYPE
