/*
**
** $Id: jpegxr_priv.c,v 1.0 2009-02-23 13:47:11 Radhika Exp $
**
**
*/

/*************************************************************************
*
* This software module was originally contributed by Microsoft
* Corporation in the course of development of the
* ITU-T T.832 | ISO/IEC 29199-2 ("JPEG XR") format standard for
* reference purposes and its performance may not have been optimized.
*
* This software module is an implementation of one or more
* tools as specified by the JPEG XR standard.
*
* ITU/ISO/IEC give You a royalty-free, worldwide, non-exclusive
* copyright license to copy, distribute, and make derivative works
* of this software module or modifications thereof for use in
* products claiming conformance to the JPEG XR standard as
* specified by ITU-T T.832 | ISO/IEC 29199-2.
*
* ITU/ISO/IEC give users the same free license to this software
* module or modifications thereof for research purposes and further
* ITU/ISO/IEC standardization.
*
* Those intending to use this software module in products are advised
* that its use may infringe existing patents. ITU/ISO/IEC have no
* liability for use of this software module or modifications thereof.
*
* Copyright is not released for products that do not conform to
* to the JPEG XR standard as specified by ITU-T T.832 |
* ISO/IEC 29199-2.
*
* Microsoft Corporation retains full right to modify and use the code
* for its own purpose, to assign or donate the code to a third party,
* and to inhibit third parties from using the code for products that
* do not conform to the JPEG XR standard as specified by ITU-T T.832 |
* ISO/IEC 29199-2.
*
* This copyright notice must be included in all copies or derivative
* works.
*
* Copyright (c) ITU-T/ISO/IEC 2008, 2009.
***********************************************************************/

#ifdef _MSC_VER
#pragma comment (user,"$Id: jpegxr_priv.c,v 1.0 2009-02-23 13:47:11 Radhika Exp $")
#else
#ident "$Id: jpegxr_priv.c,v 1.0 2009-02-23 13:47:11 Radhika Exp $"
#endif
#include "jxr_priv.h"
#include <string.h>
/*
* This file contains functions for pixel format parsing
*/
unsigned char jxr_guids[NUM_GUIDS][16]=
{    
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x0D},/* JXR_24bppRGB = 0, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x0C},/* JXR_24bppBGR, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x0E},/* JXR_32bppBGR, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x15},/* JXR_48bppRGB, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x12},/* JXR_48bppRGBFixedPoint, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x3B},/* JXR_48bppRGBHalf, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x18},/* JXR_96bppRGBFixedPoint, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x40},/* JXR_64bppRGBFixedPoint, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x42},/* JXR_64bppRGBHalf, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x41},/* JXR_128bppRGBFixedPoint, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x1B},/* JXR_128bppRGBFloat, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x0F},/* JXR_32bppBGRA, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x16},/* JXR_64bppRGBA, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x1D},/* JXR_64bppRGBAFixedPoint, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x3A},/* JXR_64bppRGBAHalf, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x1E},/* JXR_128bppRGBAFixedPoint, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x19},/* JXR_128bppRGBAFloat, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x10},/* JXR_32bppPBGRA, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x17},/* JXR_64bppPRGBA, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x1A},/* JXR_128bppPRGBAFloat, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x1C},/* JXR_32bppCMYK, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x2C},/* JXR_40bppCMYKAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x1F},/* JXR_64bppCMYK, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x2D},/* JXR_80bppCMYKAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x20},/* JXR_24bpp3Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x21},/* JXR_32bpp4Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x22},/* JXR_40bpp5Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x23},/* JXR_48bpp6Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x24},/* JXR_56bpp7Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x25},/* JXR_64bpp8Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x2E},/* JXR_32bpp3ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x2F},/* JXR_40bpp4ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x30},/* JXR_48bpp5ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x31},/* JXR_56bpp6ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x32},/* JXR_64bpp7ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x33},/* JXR_72bpp8ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x26},/* JXR_48bpp3Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x27},/* JXR_64bpp4Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x28},/* JXR_80bpp5Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x29},/* JXR_96bpp6Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x2A},/* JXR_112bpp7Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x2B},/* JXR_128bpp8Channels, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x34},/* JXR_64bpp3ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x35},/* JXR_80bpp4ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x36},/* JXR_96bpp5ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x37},/* JXR_112bpp6ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x38},/* JXR_128bpp7ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x39},/* JXR_144bpp8ChannelsAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x08},/* JXR_8bppGray, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x0B},/* JXR_16bppGray, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x13},/* JXR_16bppGrayFixedPoint, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x3E},/* JXR_16bppGrayHalf, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x3F},/* JXR_32bppGrayFixedPoint, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x11},/* JXR_32bppGrayFloat, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x05},/* JXR_BlackWhite, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x09},/* JXR_16bppBGR555, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x0A},/* JXR_16bppBGR565, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x14},/* JXR_32bppBGR101010, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x3D},/* JXR_32bppRGBE, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x54},/* JXR_32bppCMYKDIRECT, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x55},/* JXR_64bppCMYKDIRECT, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x56},/* JXR_40bppCMYKDIRECTAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x43},/* JXR_80bppCMYKDIRECTAlpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x44},/* JXR_12bppYCC420, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x45},/* JXR_16bppYCC422, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x46},/* JXR_20bppYCC422, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x47},/* JXR_32bppYCC422, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x48},/* JXR_24bppYCC444, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x49},/* JXR_30bppYCC444, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x4A},/* JXR_48bppYCC444, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x4B},/* JXR_48bppYCC444FixedPoint, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x4C},/* JXR_20bppYCC420Alpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x4D},/* JXR_24bppYCC422Alpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x4E},/* JXR_30bppYCC422Alpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x4F},/* JXR_48bppYCC422Alpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x50},/* JXR_32bppYCC444Alpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x51},/* JXR_40bppYCC444Alpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x52},/* JXR_64bppYCC444Alpha, */
    {0x24, 0xC3, 0xDD, 0x6F, 03, 0x4E, 0xFE, 0x4B, 0xB1, 0x85, 0x3D, 0x77, 0x76, 0x8D, 0xC9,  0x53} /* JXR_64bppYCC444AlphaFixedPoint, */
};

unsigned int isEqualGUID(unsigned char guid1[16], unsigned char guid2[16])
{
    return memcmp(guid1,guid2,16) == 0;
}


/*
* $Log: jpegxr_pixelformat.c,v $
* Revision 1.2 2009/05/29 12:00:00 microsoft
* Reference Software v1.6 updates.
*
* Revision 1.1 2009/04/13 12:00:00 microsoft
* Reference Software v1.5 updates.
*
*/

