/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/ProviderResultsDoc/CDefinitionObjectCollectionDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ProviderResultsXml/DefinitionObjectCollectionXml.h"

using namespace Caf;

void DefinitionObjectCollectionXml::add(
	const SmartPtrCDefinitionObjectCollectionDoc definitionObjectCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("DefinitionObjectCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(definitionObjectCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<std::string> valueVal =
			definitionObjectCollectionDoc->getValue();
		if (! valueVal.empty()) {
			for (TConstIterator<std::deque<std::string> > valueIter(valueVal);
				valueIter; valueIter++) {
				thisXml->appendValue(*valueIter);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCDefinitionObjectCollectionDoc DefinitionObjectCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("DefinitionObjectCollectionXml", "parse");

	SmartPtrCDefinitionObjectCollectionDoc definitionObjectCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection valueChildrenXml =
			thisXml->getAllChildren();

		std::deque<std::string> valueVal;
		if (! valueChildrenXml.IsNull() && ! valueChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> valueXmlIter(*valueChildrenXml);
				valueXmlIter; valueXmlIter++) {
				const SmartPtrCXmlElement valueXml = valueXmlIter->second;
				const std::string valueDoc = valueXml->saveToStringRaw();
				valueVal.push_back(valueDoc);
			}
		}

		definitionObjectCollectionDoc.CreateInstance();
		definitionObjectCollectionDoc->initialize(
			valueVal);
	}
	CAF_CM_EXIT;

	return definitionObjectCollectionDoc;
}

