/****************************************************************************
 *  (c) Copyright 2007 Wi-Fi Alliance.  All Rights Reserved
 *
 *
 *  LICENSE
 *
 *  License is granted only to Wi-Fi Alliance members and designated
 *  contractors ($B!H(BAuthorized Licensees$B!I(B)..AN  Authorized Licensees are granted
 *  the non-exclusive, worldwide, limited right to use, copy, import, export
 *  and distribute this software:
 *  (i) solely for noncommercial applications and solely for testing Wi-Fi
 *  equipment; and
 *  (ii) solely for the purpose of embedding the software into Authorized
 *  Licensee$B!G(Bs proprietary equipment and software products for distribution to
 *  its customers under a license with at least the same restrictions as
 *  contained in this License, including, without limitation, the disclaimer of
 *  warranty and limitation of liability, below..AN  The distribution rights
 *  granted in clause
 *  (ii), above, include distribution to third party companies who will
 *  redistribute the Authorized Licensee$B!G(Bs product to their customers with or
 *  without such third party$B!G(Bs private label. Other than expressly granted
 *  herein, this License is not transferable or sublicensable, and it does not
 *  extend to and may not be used with non-Wi-Fi applications..AN  Wi-Fi Alliance
 *  reserves all rights not expressly granted herein..AN 
 *.AN 
 *  Except as specifically set forth above, commercial derivative works of
 *  this software or applications that use the Wi-Fi scripts generated by this
 *  software are NOT AUTHORIZED without specific prior written permission from
 *  Wi-Fi Alliance.
 *.AN 
 *  Non-Commercial derivative works of this software for internal use are
 *  authorized and are limited by the same restrictions; provided, however,
 *  that the Authorized Licensee shall provide Wi-Fi Alliance with a copy of
 *  such derivative works under a perpetual, payment-free license to use,
 *  modify, and distribute such derivative works for purposes of testing Wi-Fi
 *  equipment.
 *.AN 
 *  Neither the name of the author nor "Wi-Fi Alliance" may be used to endorse
 *  or promote products that are derived from or that use this software without
 *  specific prior written permission from Wi-Fi Alliance.
 *
 *  THIS SOFTWARE IS PROVIDED BY WI-FI ALLIANCE "AS IS" AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A.AN PARTICULAR PURPOSE,
 *  ARE DISCLAIMED. IN NO EVENT SHALL WI-FI ALLIANCE BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, THE COST OF PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE) ARISING IN ANY WAY OUT OF
 *  THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. ******************************************************************************
 */
 

/*
 * File: wfa_tlv.h
 *  definitions for each of command types. 
 *  format:
 *  ---------------------------------------------------
 *  |  tag   | length |   value   
 *  --------------------------------------------------- 
 *   2 bytes   2bytes    defined by length 
 */
#ifndef _WFA_TLV_H
#define _WFA_TLV_H

#include "wfa_types.h"

#define INTEGER_1 0x0001            /* byte */
#define INTEGER_2 0x0002            /* word */
#define OCTET_STRING 0x0003         /* string */

typedef struct _wfatlvHdr 
{
    WORD tag;   /* tag/type */
    WORD len;   /* value length */
} wfaTLV;

#define WFA_TLV_HDR_LEN sizeof(wfaTLV)

/* Commands */
#define WFA_GET_VERSION_TLV                                         0x01

/* Generic TRAFFIC GENERATOR Commands */
#define WFA_TRAFFIC_SEND_PING_TLV        (WFA_GET_VERSION_TLV + 0x01)                  /* 2 */
#define WFA_TRAFFIC_STOP_PING_TLV        (WFA_TRAFFIC_SEND_PING_TLV + 0x01)            /* 3 */
#define WFA_TRAFFIC_AGENT_CONFIG_TLV     (WFA_TRAFFIC_STOP_PING_TLV + 0x01)            /* 4 */
#define WFA_TRAFFIC_AGENT_SEND_TLV       (WFA_TRAFFIC_AGENT_CONFIG_TLV + 0x01)         /* 5 */
#define WFA_TRAFFIC_AGENT_RECV_START_TLV (WFA_TRAFFIC_AGENT_SEND_TLV + 0x01)           /* 6 */
#define WFA_TRAFFIC_AGENT_RECV_STOP_TLV  (WFA_TRAFFIC_AGENT_RECV_START_TLV + 0x01)     /* 7 */
#define WFA_TRAFFIC_AGENT_RESET_TLV      (WFA_TRAFFIC_AGENT_RECV_STOP_TLV + 0x01)      /* 8 */
#define WFA_TRAFFIC_AGENT_STATUS_TLV     (WFA_TRAFFIC_AGENT_RESET_TLV + 0x01)          /* 9 */

/* STATION/DUT Commands */
#define WFA_STA_GET_IP_CONFIG_TLV        (WFA_TRAFFIC_AGENT_STATUS_TLV + 0x01)         /* 10 */
#define WFA_STA_SET_IP_CONFIG_TLV        (WFA_STA_GET_IP_CONFIG_TLV + 0x01)            /* 11 */
#define WFA_STA_GET_MAC_ADDRESS_TLV      (WFA_STA_SET_IP_CONFIG_TLV + 0x01)            /* 12 */
#define WFA_STA_SET_MAC_ADDRESS_TLV      (WFA_STA_GET_MAC_ADDRESS_TLV + 0x01)          /* 13 */ 
#define WFA_STA_IS_CONNECTED_TLV         (WFA_STA_SET_MAC_ADDRESS_TLV + 0x01)          /* 14 */
#define WFA_STA_VERIFY_IP_CONNECTION_TLV (WFA_STA_IS_CONNECTED_TLV + 0x01)             /* 15 */
#define WFA_STA_GET_BSSID_TLV            (WFA_STA_VERIFY_IP_CONNECTION_TLV + 0x01)     /* 16 */
#define WFA_STA_GET_STATS_TLV            (WFA_STA_GET_BSSID_TLV + 0x01)                /* 17 */ 
#define WFA_STA_SET_ENCRYPTION_TLV       (WFA_STA_GET_STATS_TLV + 0x01)                /* 18 */
#define WFA_STA_SET_PSK_TLV              (WFA_STA_SET_ENCRYPTION_TLV + 0x01)           /* 19 */
#define WFA_STA_SET_EAPTLS_TLV           (WFA_STA_SET_PSK_TLV + 0x01)                  /* 20 */
#define WFA_STA_SET_UAPSD_TLV            (WFA_STA_SET_EAPTLS_TLV + 0x01)               /* 21 */
#define WFA_STA_ASSOCIATE_TLV            (WFA_STA_SET_UAPSD_TLV + 0x01)                /* 22 */
#define WFA_STA_SET_EAPTTLS_TLV          (WFA_STA_ASSOCIATE_TLV + 0x01)                /* 23 */
#define WFA_STA_SET_EAPSIM_TLV           (WFA_STA_SET_EAPTTLS_TLV + 0x01)              /* 24 */
#define WFA_STA_SET_PEAP_TLV             (WFA_STA_SET_EAPSIM_TLV + 0x01)               /* 25 */
#define WFA_STA_SET_IBSS_TLV             (WFA_STA_SET_PEAP_TLV + 0x01)                 /* 26 */
#define WFA_STA_GET_INFO_TLV             (WFA_STA_SET_IBSS_TLV + 0x01)                 /* 27 */
#define WFA_DEVICE_GET_INFO_TLV          (WFA_STA_GET_INFO_TLV + 0x01)                 /* 28 */
#define WFA_DEVICE_LIST_IF_TLV           (WFA_DEVICE_GET_INFO_TLV + 0x01)              /* 29 */

#define WFA_STA_DEBUG_SET_TLV            (WFA_DEVICE_LIST_IF_TLV + 0x01)               /* 30 */
#define WFA_STA_SET_MODE_TLV             (WFA_STA_DEBUG_SET_TLV + 0x01)                /* 31 */
#define WFA_STA_UPLOAD_TLV               (WFA_STA_SET_MODE_TLV + 0x01)                 /* 32 */


#define WFA_STA_SET_WMM_TLV              (WFA_STA_UPLOAD_TLV + 0x01)                   /* 33 */


#define WFA_STA_REASSOCIATE_TLV          (WFA_STA_SET_WMM_TLV + 0x01)                  /* 34 */
#define WFA_STA_SET_PWRSAVE_TLV          (WFA_STA_REASSOCIATE_TLV + 0x01)              /* 35 */
#define WFA_STA_SEND_NEIGREQ_TLV         (WFA_STA_SET_PWRSAVE_TLV + 0x01)              /* 36 */

#define WFA_STA_COMMANDS_END             (WFA_STA_SEND_NEIGREQ_TLV + 0x01)             /* 37 */


/* Version response */
#define WFA_GET_VERSION_RESP_TLV         (WFA_STA_COMMANDS_END +       0x01)           /* 38 */

/* Generic Traffic Generator Responses */
#define WFA_TRAFFIC_SEND_PING_RESP_TLV   (WFA_GET_VERSION_RESP_TLV +  0x01)            /* 39 */ 
#define WFA_TRAFFIC_STOP_PING_RESP_TLV   (WFA_TRAFFIC_SEND_PING_RESP_TLV + 0x01)       /* 40 */
#define WFA_TRAFFIC_AGENT_CONFIG_RESP_TLV (WFA_TRAFFIC_STOP_PING_RESP_TLV + 0x01)      /* 41 */
#define WFA_TRAFFIC_AGENT_SEND_RESP_TLV  (WFA_TRAFFIC_AGENT_CONFIG_RESP_TLV + 0x01)    /* 42 */
#define WFA_TRAFFIC_AGENT_RECV_START_RESP_TLV (WFA_TRAFFIC_AGENT_SEND_RESP_TLV + 0x01) /* 43 */
#define WFA_TRAFFIC_AGENT_RECV_STOP_RESP_TLV (WFA_TRAFFIC_AGENT_RECV_START_RESP_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_RESET_RESP_TLV (WFA_TRAFFIC_AGENT_RECV_STOP_RESP_TLV + 0x01) /* 45 */
#define WFA_TRAFFIC_AGENT_STATUS_RESP_TLV (WFA_TRAFFIC_AGENT_RESET_RESP_TLV + 0x01)    /* 46 */

/* STATION/DUT Responses */
#define WFA_STA_GET_IP_CONFIG_RESP_TLV (WFA_TRAFFIC_AGENT_STATUS_RESP_TLV + 0x01)      /* 47 */ 
#define WFA_STA_SET_IP_CONFIG_RESP_TLV (WFA_STA_GET_IP_CONFIG_RESP_TLV + 0x01)         /* 48 */
#define WFA_STA_GET_MAC_ADDRESS_RESP_TLV (WFA_STA_SET_IP_CONFIG_RESP_TLV + 0x01)       /* 49 */
#define WFA_STA_SET_MAC_ADDRESS_RESP_TLV (WFA_STA_GET_MAC_ADDRESS_RESP_TLV + 0x01)     /* 50 */ 
#define WFA_STA_IS_CONNECTED_RESP_TLV (WFA_STA_SET_MAC_ADDRESS_RESP_TLV + 0x01)        /* 51 */
#define WFA_STA_VERIFY_IP_CONNECTION_RESP_TLV  (WFA_STA_IS_CONNECTED_RESP_TLV + 0x01)  /* 52 */
#define WFA_STA_GET_BSSID_RESP_TLV (WFA_STA_VERIFY_IP_CONNECTION_RESP_TLV + 0x01)      /* 53 */
#define WFA_STA_GET_STATS_RESP_TLV (WFA_STA_GET_BSSID_RESP_TLV + 0x01)                 /* 54 */
#define WFA_STA_SET_ENCRYPTION_RESP_TLV (WFA_STA_GET_STATS_RESP_TLV + 0x01)
#define WFA_STA_SET_PSK_RESP_TLV (WFA_STA_SET_ENCRYPTION_RESP_TLV + 0x01)
#define WFA_STA_SET_EAPTLS_RESP_TLV (WFA_STA_SET_PSK_RESP_TLV + 0x01)
#define WFA_STA_SET_UAPSD_RESP_TLV (WFA_STA_SET_EAPTLS_RESP_TLV + 0x01)
#define WFA_STA_ASSOCIATE_RESP_TLV (WFA_STA_SET_UAPSD_RESP_TLV + 0x01)                 /* 59 */
#define WFA_STA_SET_EAPTTLS_RESP_TLV   (WFA_STA_ASSOCIATE_RESP_TLV + 0x01)             /* 60 */
#define WFA_STA_SET_EAPSIM_RESP_TLV   (WFA_STA_SET_EAPTTLS_RESP_TLV + 0x01)
#define WFA_STA_SET_PEAP_RESP_TLV      (WFA_STA_SET_EAPSIM_RESP_TLV + 0x01)
#define WFA_STA_SET_IBSS_RESP_TLV         (WFA_STA_SET_PEAP_RESP_TLV + 0x01)
#define WFA_STA_GET_INFO_RESP_TLV      (WFA_STA_SET_IBSS_RESP_TLV + 0x01)              /* 64 */
#define WFA_DEVICE_GET_INFO_RESP_TLV  (WFA_STA_GET_INFO_RESP_TLV + 0x01)
#define WFA_DEVICE_LIST_IF_RESP_TLV (WFA_DEVICE_GET_INFO_RESP_TLV + 0x01)              /* 66 */ 

#define WFA_STA_DEBUG_SET_RESP_TLV  (WFA_DEVICE_LIST_IF_RESP_TLV + 0x01)               /* 67 */
#define WFA_STA_SET_MODE_RESP_TLV   (WFA_STA_DEBUG_SET_RESP_TLV + 0x01)                /* 68 */
#define WFA_STA_UPLOAD_RESP_TLV     (WFA_STA_SET_MODE_RESP_TLV + 0x01)                 /* 69 */


#define WFA_STA_SET_WMM_RESP_TLV    (WFA_STA_UPLOAD_RESP_TLV + 0x01)                   /* 70 */


#define WFA_STA_REASSOCIATE_RESP_TLV  (WFA_STA_SET_WMM_RESP_TLV + 0x01)                 /* 71 */
#define WFA_STA_SET_PWRSAVE_RESP_TLV      (WFA_STA_REASSOCIATE_RESP_TLV + 0x01)        /* 72 */
#define WFA_STA_SEND_NEIGREQ_RESP_TLV    (WFA_STA_SET_PWRSAVE_RESP_TLV + 0x01)         /* 73 */

#define WFA_STA_RESPONSE_END (WFA_STA_SEND_NEIGREQ_RESP_TLV + 0x01)                    /* 74 */

#define WFA_TLV_END WFA_STA_RESPONSE_END 
// New STA/DUT commands

#define WFA_STA_NEW_COMMANDS_START		0x100                                  /* 256 */
#define WFA_STA_PRESET_PARAMETERS_TLV	    (WFA_STA_NEW_COMMANDS_START + 0x01)        /* 257 */
#define WFA_STA_SET_EAPFAST_TLV		    (WFA_STA_PRESET_PARAMETERS_TLV + 0x01)     /* 258 */
#define WFA_STA_SET_EAPAKA_TLV		    (WFA_STA_SET_EAPFAST_TLV + 0x01)           /* 259 */
#define WFA_STA_SET_SYSTIME_TLV		    (WFA_STA_SET_EAPAKA_TLV + 0x01)            /* 260 */

#define WFA_STA_SET_11N_TLV		    (WFA_STA_SET_SYSTIME_TLV + 0x01)           /* 261 */
#define WFA_STA_SET_WIRELESS_TLV	    (WFA_STA_SET_11N_TLV + 0x01)               /* 262 */
#define WFA_STA_SEND_ADDBA_TLV		    (WFA_STA_SET_WIRELESS_TLV + 0x01)          /* 263 */

#define WFA_STA_SEND_COEXIST_MGMT_TLV       (WFA_STA_SEND_ADDBA_TLV + 0x01)            /* 264 */
#define WFA_STA_SET_RIFS_TEST_TLV           (WFA_STA_SEND_COEXIST_MGMT_TLV +0x01)      /* 265 */
#define WFA_STA_RESET_DEFAULT_TLV           (WFA_STA_SET_RIFS_TEST_TLV + 0x01)         /* 266 */
#define WFA_STA_DISCONNECT_TLV              (WFA_STA_RESET_DEFAULT_TLV +0x01)          /* 267 */
/* P2P */

#define WFA_STA_GET_P2P_DEV_ADDRESS_TLV           (WFA_STA_DISCONNECT_TLV + 0x01)  /* 268 */
#define WFA_STA_SET_P2P_TLV           (WFA_STA_GET_P2P_DEV_ADDRESS_TLV + 0x01)  /* 269 */
#define WFA_STA_P2P_CONNECT_TLV           (WFA_STA_SET_P2P_TLV + 0x01)  /* 270 */
#define WFA_STA_START_AUTO_GO           (WFA_STA_P2P_CONNECT_TLV + 0x01)  /* 271 */
#define WFA_STA_P2P_START_GRP_FORMATION_TLV           (WFA_STA_START_AUTO_GO + 0x01)  /* 272 */
#define WFA_STA_P2P_DISSOLVE_TLV           (WFA_STA_P2P_START_GRP_FORMATION_TLV + 0x01)  /* 273 */
#define WFA_STA_SEND_P2P_INV_REQ_TLV           (WFA_STA_P2P_DISSOLVE_TLV + 0x01)  /* 274 */
#define WFA_STA_ACCEPT_P2P_INV_REQ_TLV           (WFA_STA_SEND_P2P_INV_REQ_TLV + 0x01)  /* 275 */
#define WFA_STA_SEND_P2P_PROV_DIS_REQ_TLV           (WFA_STA_ACCEPT_P2P_INV_REQ_TLV + 0x01)  /* 276 */
#define WFA_STA_SET_WPS_PBC_TLV           (WFA_STA_SEND_P2P_PROV_DIS_REQ_TLV + 0x01)  /* 277 */
#define WFA_STA_WPS_READ_PIN_TLV           (WFA_STA_SET_WPS_PBC_TLV + 0x01)  /* 278 */
#define WFA_STA_WPS_ENTER_PIN_TLV           (WFA_STA_WPS_READ_PIN_TLV + 0x01)  /* 279 */
#define WFA_STA_GET_PSK_TLV           (WFA_STA_WPS_ENTER_PIN_TLV + 0x01)  /* 280 */
#define WFA_STA_P2P_RESET_TLV           (WFA_STA_GET_PSK_TLV + 0x01)  /* 281 */
#define WFA_STA_WPS_READ_LABEL_TLV           (WFA_STA_P2P_RESET_TLV + 0x01)  /* 282 */
#define WFA_STA_GET_P2P_IP_CONFIG_TLV           (WFA_STA_WPS_READ_LABEL_TLV + 0x01)  /* 283 */
#define WFA_STA_SEND_SERVICE_DISCOVERY_REQ_TLV           (WFA_STA_GET_P2P_IP_CONFIG_TLV + 0x01)  /* 284 */
#define WFA_STA_SEND_P2P_PRESENCE_REQ_TLV           (WFA_STA_SEND_SERVICE_DISCOVERY_REQ_TLV + 0x01)  /* 285 */
#define WFA_STA_SET_SLEEP_TLV           (WFA_STA_SEND_P2P_PRESENCE_REQ_TLV + 0x01)  /* 286 */
#define WFA_STA_SET_OPPORTUNISTIC_PS_TLV           (WFA_STA_SET_SLEEP_TLV + 0x01)  /* 287 */

#define WFA_STA_ADD_ARP_TABLE_ENTRY_TLV (WFA_STA_SET_OPPORTUNISTIC_PS_TLV +0x01) /* 288 */
#define WFA_STA_BLOCK_ICMP_RESPONSE_TLV (WFA_STA_ADD_ARP_TABLE_ENTRY_TLV +0x01) /* 289 */ 
/* P2P */

#define WFA_STA_NEW_COMMANDS_END            (WFA_STA_BLOCK_ICMP_RESPONSE_TLV + 0x01)            /* 290 */


//New STA/DUT command responses
#define WFA_STA_NEW_COMMANDS_RESPONSE_START	    0x200 /* 512 */
#define WFA_STA_PRESET_PARAMETERS_RESP_TLV  (WFA_STA_NEW_COMMANDS_RESPONSE_START + 0x01)   /* 513 */
#define WFA_STA_SET_EAPFAST_RESP_TLV	    (WFA_STA_PRESET_PARAMETERS_RESP_TLV + 0x01)    /* 514 */
#define WFA_STA_SET_EAPAKA_RESP_TLV	    (WFA_STA_SET_EAPFAST_RESP_TLV + 0x01)          /* 515 */
#define WFA_STA_SET_SYSTIME_RESP_TLV	    (WFA_STA_SET_EAPAKA_RESP_TLV + 0x01)           /* 516 */

#define WFA_STA_SET_11N_RESP_TLV    	    (WFA_STA_SET_SYSTIME_RESP_TLV + 0x01)          /* 517 */
#define WFA_STA_SET_WIRELESS_RESP_TLV	    (WFA_STA_SET_11N_RESP_TLV + 0x01)              /* 518 */
#define WFA_STA_SET_SEND_ADDBA_RESP_TLV	    (WFA_STA_SET_WIRELESS_RESP_TLV + 0x01)         /* 519 */

#define WFA_STA_SEND_COEXIST_MGMT_RESP_TLV  (WFA_STA_SET_SEND_ADDBA_RESP_TLV + 0x01)
#define WFA_STA_SET_RIFS_TEST_RESP_TLV      (WFA_STA_SEND_COEXIST_MGMT_RESP_TLV +0x01)
#define WFA_STA_RESET_DEFAULT_RESP_TLV      (WFA_STA_SET_RIFS_TEST_RESP_TLV + 0x01)
#define WFA_STA_DISCONNECT_RESP_TLV         (WFA_STA_RESET_DEFAULT_RESP_TLV + 0x01)
/* P2P */

#define WFA_STA_GET_P2P_DEV_ADDRESS_RESP_TLV           (WFA_STA_DISCONNECT_RESP_TLV + 0x01)  /* 524 */
#define WFA_STA_SET_P2P_RESP_TLV           (WFA_STA_GET_P2P_DEV_ADDRESS_RESP_TLV + 0x01)  /* 525 */
#define WFA_STA_P2P_CONNECT_RESP_TLV           (WFA_STA_SET_P2P_RESP_TLV + 0x01)  /* 526 */
#define WFA_STA_P2P_START_AUTO_GO_RESP_TLV           (WFA_STA_P2P_CONNECT_RESP_TLV + 0x01)  /* 527 */
#define WFA_STA_P2P_START_GRP_FORM_RESP_TLV           (WFA_STA_P2P_START_AUTO_GO_RESP_TLV + 0x01)  /* 528 */
#define WFA_STA_P2P_DISSOLVE_RESP_TLV           (WFA_STA_P2P_START_GRP_FORM_RESP_TLV + 0x01)  /* 529 */
#define WFA_STA_SEND_P2P_INV_REQ_RESP_TLV           (WFA_STA_P2P_DISSOLVE_RESP_TLV + 0x01)  /* 530 */
#define WFA_STA_ACCEPT_P2P_REQ_RESP_TLV           (WFA_STA_SEND_P2P_INV_REQ_RESP_TLV + 0x01)  /* 531 */
#define WFA_STA_SEND_P2P_PROV_DIS_REQ_RESP_TLV           (WFA_STA_ACCEPT_P2P_REQ_RESP_TLV + 0x01)  /* 532 */
#define WFA_STA_SET_WPS_PBC_RESP_TLV           (WFA_STA_SEND_P2P_PROV_DIS_REQ_RESP_TLV + 0x01)  /* 533 */
#define WFA_STA_WPS_READ_PIN_RESP_TLV           (WFA_STA_SET_WPS_PBC_RESP_TLV + 0x01)  /* 534 */
#define WFA_STA_WPS_ENTER_PIN_RESP_TLV           (WFA_STA_WPS_READ_PIN_RESP_TLV + 0x01)  /* 535 */
#define WFA_STA_GET_PSK_RESP_TLV           (WFA_STA_WPS_ENTER_PIN_RESP_TLV + 0x01)  /* 536 */
#define WFA_STA_P2P_RESET_RESP_TLV           (WFA_STA_GET_PSK_RESP_TLV + 0x01)  /* 537 */
#define WFA_STA_WPS_READ_LABEL_RESP_TLV           (WFA_STA_P2P_RESET_RESP_TLV + 0x01)  /* 538 */
#define WFA_STA_GET_P2P_IP_CONFIG_RESP_TLV           (WFA_STA_WPS_READ_LABEL_RESP_TLV + 0x01)  /* 539 */
#define WFA_STA_SEND_SERVICE_DISCOVERY_REQ_RESP_TLV           (WFA_STA_GET_P2P_IP_CONFIG_RESP_TLV + 0x01)  /* 540 */
#define WFA_STA_SEND_P2P_PRESENCE_REQ_RESP_TLV           (WFA_STA_SEND_SERVICE_DISCOVERY_REQ_RESP_TLV + 0x01)  /* 541 */
#define WFA_STA_SET_SLEEP_REQ_RESP_TLV           (WFA_STA_SEND_P2P_PRESENCE_REQ_RESP_TLV + 0x01)  /* 542 */
#define WFA_STA_SET_OPPORTUNISTIC_PS_REQ_RESP_TLV           (WFA_STA_SET_SLEEP_REQ_RESP_TLV + 0x01)  /* 543 */

#define WFA_STA_ADD_ARP_TABLE_ENTRY_RESP_TLV (WFA_STA_SET_OPPORTUNISTIC_PS_REQ_RESP_TLV + 0x01) /* 544 */
#define WFA_STA_BLOCK_ICMP_RESPONSE_RESP_TLV (WFA_STA_ADD_ARP_TABLE_ENTRY_RESP_TLV + 0x01) /* 545 */

/* P2P */
#define WFA_STA_NEW_COMMANDS_RESPONSE_END   (WFA_STA_BLOCK_ICMP_RESPONSE_RESP_TLV + 0x01) /* 546 */






#define WFA_TLV_HEAD_LEN 1+2

extern WORD wfaGetTag(BYTE *tlv_data);
extern void wfaSetTag(BYTE *tlv_data, BYTE new_tag);
extern WORD wfaGetTLVLen(BYTE *tlv_data);
extern WORD wfaGetValueLen(BYTE *tlv_data);
extern BOOL wfaGetValue(BYTE *pstr, int value_len, BYTE *tlv_data);
extern BOOL wfaIsValidTag(BYTE the_tag);
extern void wfaAliasByTag(BYTE the_tag, char *aliasStr);
extern BOOL wfaDecodeTLV(BYTE *tlv_data, int tlv_len, WORD *ptlv_tag, int *ptlv_val_len, BYTE *ptlv_value);
extern BOOL wfaEncodeTLV(WORD the_tag, WORD the_len, BYTE *the_value, BYTE *tlv_data);

extern WORD wfaGetValueType(BYTE the_tag, BYTE *tlv_data);

#endif
