/*
 * status_bar.h
 * Copyright 2014 John Lindgren
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions, and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions, and the following disclaimer in the documentation
 *    provided with the distribution.
 *
 * This software is provided "as is" and without any warranty, express or
 * implied. In no event shall the authors be liable for any damages arising from
 * the use of this software.
 */

#ifndef STATUS_BAR_H
#define STATUS_BAR_H

#include <QLabel>
#include <QStatusBar>

#include <libaudcore/hook.h>

class StatusBar : public QStatusBar
{
public:
    StatusBar (QWidget * parent);

private:
    QLabel * codec_label;
    QLabel * length_label;

    void update_codec ();
    void update_length ();

    const HookReceiver<StatusBar>
     hook1 {"playlist activate", this, & StatusBar::update_length},
     hook2 {"playlist update", this, & StatusBar::update_length},
     hook3 {"playback ready", this, & StatusBar::update_codec},
     hook4 {"playback stop", this, & StatusBar::update_codec},
     hook5 {"info change", this, & StatusBar::update_codec},
     hook6 {"tuple change", this, & StatusBar::update_codec};
};

#endif // STATUS_BAR_H
