/*
 * Decompiled with CFR 0.152.
 */
package vlcskineditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import vlcskineditor.Helper;
import vlcskineditor.Language;
import vlcskineditor.Layout;
import vlcskineditor.Main;
import vlcskineditor.NumbersOnlyDocument;
import vlcskineditor.Skin;
import vlcskineditor.XML;
import vlcskineditor.history.WindowAddEvent;
import vlcskineditor.history.WindowEditEvent;

public class Window
implements ActionListener {
    final String ID_DEFAULT = "none";
    final String VISIBLE_DEFAULT = "true";
    final int X_DEFAULT = 0;
    final int Y_DEFAULT = 0;
    final boolean DRAGDROP_DEFAULT = true;
    final boolean PLAYONDROP_DEFAULT = true;
    public String id = "none";
    public String visible = "true";
    public int x = 0;
    public int y = 0;
    public boolean dragdrop = true;
    public boolean playondrop = true;
    public List<Layout> layouts = new LinkedList<Layout>();
    public Skin s;
    JFrame frame = null;
    JTextField id_tf;
    JTextField x_tf;
    JTextField y_tf;
    JTextField visible_tf;
    JTextField dragdrop_tf;
    JTextField playondrop_tf;
    JButton ok_btn;
    JButton cancel_btn;
    JButton help_btn;
    boolean created = false;
    public String type = Language.get("WINDOW");

    public Window(Node node, Skin skin) {
        this.s = skin;
        this.id = XML.getStringAttributeValue(node, "id", Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId())));
        this.visible = XML.getStringAttributeValue(node, "visible", this.visible);
        this.x = XML.getIntAttributeValue(node, "x", this.x);
        this.y = XML.getIntAttributeValue(node, "y", this.y);
        this.dragdrop = XML.getBoolAttributeValue(node, "dragdrop", this.dragdrop);
        this.playondrop = XML.getBoolAttributeValue(node, "playondrop", this.playondrop);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals("Layout")) continue;
            this.layouts.add(new Layout(nodeList.item(i), this, this.s));
        }
        this.created = true;
    }

    public Window(String string, Skin skin) {
        int n;
        this.s = skin;
        String[] stringArray = string.split("\n");
        this.id = stringArray[0].indexOf("id=\"") != -1 ? XML.getValue(stringArray[0], "id") : Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        if (stringArray[0].indexOf("visible=\"") != -1) {
            this.visible = XML.getValue(stringArray[0], "visible");
        }
        if (stringArray[0].indexOf("x=\"") != -1) {
            this.x = XML.getIntValue(stringArray[0], "x");
        }
        if (stringArray[0].indexOf("y=\"") != -1) {
            this.y = XML.getIntValue(stringArray[0], "y");
        }
        if (stringArray[0].indexOf("dragdrop=\"") != -1) {
            this.dragdrop = XML.getBoolValue(stringArray[0], "dragdrop");
        }
        if (stringArray[0].indexOf("playondrop=\"") != -1) {
            this.playondrop = XML.getBoolValue(stringArray[0], "playondrop");
        }
        String string2 = "";
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringArray[n].trim();
        }
        for (n = 1; n < stringArray.length; ++n) {
            if (stringArray[n].startsWith("<!--")) {
                while (stringArray[n].indexOf("-->") == -1) {
                    ++n;
                }
                continue;
            }
            if (stringArray[n].startsWith("<Layout")) {
                string2 = stringArray[n];
                continue;
            }
            if (stringArray[n].startsWith("</Layout>")) {
                string2 = string2 + "\n" + stringArray[n];
                this.layouts.add(new Layout(string2, this, this.s));
                string2 = "";
                continue;
            }
            string2 = string2 + "\n" + stringArray[n];
        }
        this.created = true;
    }

    public Window(Skin skin) {
        this.s = skin;
        this.id = Language.get("UNNAMED").replaceAll("%t", this.type).replaceAll("%i", String.valueOf(this.s.getNewId()));
        this.s.updateWindows();
        this.showOptions();
    }

    public void update() {
        if (!this.created) {
            WindowAddEvent windowAddEvent = new WindowAddEvent(this.s, this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.visible = this.visible_tf.getText();
            this.dragdrop = Boolean.parseBoolean(this.dragdrop_tf.getText());
            this.playondrop = Boolean.parseBoolean(this.playondrop_tf.getText());
            this.s.updateWindows();
            this.created = true;
            this.frame.setDefaultCloseOperation(2);
            this.s.m.hist.addEvent(windowAddEvent);
        } else {
            WindowEditEvent windowEditEvent = new WindowEditEvent(this);
            this.id = this.id_tf.getText();
            this.x = Integer.parseInt(this.x_tf.getText());
            this.y = Integer.parseInt(this.y_tf.getText());
            this.visible = this.visible_tf.getText();
            this.dragdrop = Boolean.parseBoolean(this.dragdrop_tf.getText());
            this.playondrop = Boolean.parseBoolean(this.playondrop_tf.getText());
            this.s.updateWindows();
            windowEditEvent.setNew();
            this.s.m.hist.addEvent(windowEditEvent);
        }
    }

    public void showOptions() {
        if (this.frame == null) {
            this.frame = new JFrame(Language.get("WIN_WINDOW_TITLE"));
            this.frame.setIconImage(Main.edit_icon.getImage());
            this.frame.setResizable(false);
            if (!this.created) {
                this.frame.setDefaultCloseOperation(0);
            }
            JLabel jLabel = new JLabel(Language.get("WIN_ITEM_ID"));
            this.id_tf = new JTextField();
            this.id_tf.setToolTipText(Language.get("WIN_ITEM_ID_TIP").replaceAll("%t", this.type));
            JLabel jLabel2 = new JLabel(Language.get("WIN_ITEM_X"));
            this.x_tf = new JTextField();
            this.x_tf.setToolTipText(Language.get("WIN_WINDOW_X_TIP"));
            this.x_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel3 = new JLabel(Language.get("WIN_ITEM_Y"));
            this.y_tf = new JTextField();
            this.y_tf.setToolTipText(Language.get("WIN_WINDOW_Y_TIP"));
            this.y_tf.setDocument(new NumbersOnlyDocument());
            JLabel jLabel4 = new JLabel(Language.get("WIN_ITEM_VISIBLE"));
            this.visible_tf = new JTextField();
            this.visible_tf.setToolTipText(Language.get("WIN_WINDOW_VISIBLE_TIP"));
            JLabel jLabel5 = new JLabel(Language.get("WIN_WINDOW_DD"));
            this.dragdrop_tf = new JTextField();
            this.dragdrop_tf.setToolTipText(Language.get("WIN_WINDOW_DD_TIP"));
            JLabel jLabel6 = new JLabel(Language.get("WIN_WINDOW_PD"));
            this.playondrop_tf = new JTextField();
            this.playondrop_tf.setToolTipText(Language.get("WIN_WINDOW_PD_TIP"));
            this.ok_btn = new JButton(Language.get("BUTTON_OK"));
            this.ok_btn.addActionListener(this);
            this.cancel_btn = new JButton(Language.get("BUTTON_CANCEL"));
            this.cancel_btn.addActionListener(this);
            this.help_btn = new JButton(Language.get("BUTTON_HELP"));
            this.help_btn.addActionListener(this);
            JLabel jLabel7 = new JLabel(Language.get("NOTE_STARRED"));
            Component[] componentArray = new Component[]{jLabel, jLabel2, jLabel3, jLabel4, jLabel5, jLabel6};
            int n = Helper.maxWidth(componentArray) + 10;
            int n2 = 200;
            JPanel jPanel = new JPanel(null);
            jPanel.add(jLabel);
            jPanel.add(this.id_tf);
            this.id_tf.setPreferredSize(new Dimension(n2, this.id_tf.getPreferredSize().height));
            jPanel.add(jLabel2);
            jPanel.add(this.x_tf);
            this.x_tf.setPreferredSize(new Dimension(n2, this.x_tf.getPreferredSize().height));
            jPanel.add(jLabel3);
            jPanel.add(this.y_tf);
            this.y_tf.setPreferredSize(new Dimension(n2, this.y_tf.getPreferredSize().height));
            jPanel.add(jLabel4);
            jPanel.add(this.visible_tf);
            this.visible_tf.setPreferredSize(new Dimension(n2, this.visible_tf.getPreferredSize().height));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_ITEM_GENERAL")));
            SpringLayout springLayout = new SpringLayout();
            jPanel.setLayout(springLayout);
            springLayout.putConstraint("North", (Component)jLabel, 5, "North", (Component)jPanel);
            springLayout.putConstraint("West", (Component)jLabel, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.id_tf, 0, "VerticalCenter", (Component)jLabel);
            springLayout.putConstraint("West", (Component)this.id_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)jPanel, 5, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel2, 10, "South", (Component)this.id_tf);
            springLayout.putConstraint("West", (Component)jLabel2, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.x_tf, 0, "VerticalCenter", (Component)jLabel2);
            springLayout.putConstraint("West", (Component)this.x_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.x_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel3, 10, "South", (Component)this.x_tf);
            springLayout.putConstraint("West", (Component)jLabel3, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.y_tf, 0, "VerticalCenter", (Component)jLabel3);
            springLayout.putConstraint("West", (Component)this.y_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.y_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("North", (Component)jLabel4, 10, "South", (Component)this.y_tf);
            springLayout.putConstraint("West", (Component)jLabel4, 5, "West", (Component)jPanel);
            springLayout.putConstraint("VerticalCenter", (Component)this.visible_tf, 0, "VerticalCenter", (Component)jLabel4);
            springLayout.putConstraint("West", (Component)this.visible_tf, n, "West", (Component)jPanel);
            springLayout.putConstraint("East", (Component)this.visible_tf, 0, "East", (Component)this.id_tf);
            springLayout.putConstraint("South", (Component)jPanel, 10, "South", (Component)this.visible_tf);
            this.frame.add(jPanel);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.add(jLabel5);
            jPanel2.add(this.dragdrop_tf);
            this.dragdrop_tf.setPreferredSize(new Dimension(n2, this.dragdrop_tf.getPreferredSize().height));
            jPanel2.add(jLabel6);
            jPanel2.add(this.playondrop_tf);
            this.playondrop_tf.setPreferredSize(new Dimension(n2, this.playondrop_tf.getPreferredSize().height));
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Language.get("WIN_WINDOW_DD_PANEL")));
            SpringLayout springLayout2 = new SpringLayout();
            jPanel2.setLayout(springLayout2);
            springLayout2.putConstraint("North", (Component)jLabel5, 5, "North", (Component)jPanel2);
            springLayout2.putConstraint("West", (Component)jLabel5, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.dragdrop_tf, 0, "VerticalCenter", (Component)jLabel5);
            springLayout2.putConstraint("West", (Component)this.dragdrop_tf, n, "West", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)jPanel2, 5, "East", (Component)this.dragdrop_tf);
            springLayout2.putConstraint("North", (Component)jLabel6, 10, "South", (Component)this.dragdrop_tf);
            springLayout2.putConstraint("West", (Component)jLabel6, 5, "West", (Component)jPanel2);
            springLayout2.putConstraint("VerticalCenter", (Component)this.playondrop_tf, 0, "VerticalCenter", (Component)jLabel6);
            springLayout2.putConstraint("West", (Component)this.playondrop_tf, n, "North", (Component)jPanel2);
            springLayout2.putConstraint("East", (Component)this.playondrop_tf, 0, "East", (Component)this.dragdrop_tf);
            springLayout2.putConstraint("South", (Component)jPanel2, 10, "South", (Component)this.playondrop_tf);
            this.frame.add(jPanel2);
            this.frame.add(this.ok_btn);
            this.frame.add(this.cancel_btn);
            this.frame.add(this.help_btn);
            this.frame.add(jLabel7);
            SpringLayout springLayout3 = new SpringLayout();
            this.frame.setLayout(springLayout3);
            springLayout3.putConstraint("North", (Component)jPanel, 5, "North", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)jPanel, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jPanel2, 5, "South", (Component)jPanel);
            springLayout3.putConstraint("West", (Component)jPanel2, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)jLabel7, 5, "South", (Component)jPanel2);
            springLayout3.putConstraint("West", (Component)jLabel7, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("East", (Component)jLabel7, 5, "East", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("North", (Component)this.ok_btn, 5, "South", (Component)jLabel7);
            springLayout3.putConstraint("North", (Component)this.cancel_btn, 5, "South", (Component)jLabel7);
            springLayout3.putConstraint("North", (Component)this.help_btn, 5, "South", (Component)jLabel7);
            springLayout3.putConstraint("West", (Component)this.ok_btn, 5, "West", (Component)this.frame.getContentPane());
            springLayout3.putConstraint("West", (Component)this.cancel_btn, 5, "East", (Component)this.ok_btn);
            springLayout3.putConstraint("West", (Component)this.help_btn, 5, "East", (Component)this.cancel_btn);
            springLayout3.putConstraint("South", (Component)this.frame.getContentPane(), 5, "South", (Component)this.ok_btn);
            springLayout3.putConstraint("East", (Component)this.frame.getContentPane(), 5, "East", (Component)jPanel);
            this.frame.pack();
            this.frame.getRootPane().setDefaultButton(this.ok_btn);
        }
        this.id_tf.setText(this.id);
        this.x_tf.setText(String.valueOf(this.x));
        this.y_tf.setText(String.valueOf(this.y));
        this.visible_tf.setText(this.visible);
        this.dragdrop_tf.setText(String.valueOf(this.dragdrop));
        this.playondrop_tf.setText(String.valueOf(this.playondrop));
        this.frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.ok_btn)) {
            if (this.id_tf.getText().equals("")) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_INVALID_MSG"), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            if (!this.id_tf.getText().equals(this.id) && this.s.idExists(this.id_tf.getText())) {
                JOptionPane.showMessageDialog(this.frame, Language.get("ERROR_ID_EXISTS_MSG").replaceAll("%i", this.id_tf.getText()), Language.get("ERROR_ID_INVALID_TITLE"), 1);
                return;
            }
            this.frame.setVisible(false);
            this.update();
        } else if (actionEvent.getSource().equals(this.help_btn)) {
            Helper.browse("http://www.videolan.org/vlc/skinedhlp/window.html");
        } else if (actionEvent.getSource().equals(this.cancel_btn)) {
            this.frame.setVisible(false);
            if (!this.created) {
                this.s.windows.remove(this);
            }
        }
    }

    public void addLayout() {
        this.layouts.add(new Layout(this, this.s));
    }

    public String returnCode(String string) {
        String string2 = string + "<Window";
        if (!this.id.equals("none")) {
            string2 = string2 + " id=\"" + this.id + "\"";
        }
        if (!this.visible.equals("true")) {
            string2 = string2 + " visible=\"" + String.valueOf(this.visible) + "\"";
        }
        if (this.x != 0) {
            string2 = string2 + " x=\"" + String.valueOf(this.x) + "\"";
        }
        if (this.y != 0) {
            string2 = string2 + " y=\"" + String.valueOf(this.y) + "\"";
        }
        if (!this.dragdrop) {
            string2 = string2 + " dragdrop=\"" + String.valueOf(this.dragdrop) + "\"";
        }
        if (!this.playondrop) {
            string2 = string2 + " playondrop=\"" + String.valueOf(this.playondrop) + "\"";
        }
        string2 = string2 + ">";
        for (int i = 0; i < this.layouts.size(); ++i) {
            string2 = string2 + "\n" + this.layouts.get(i).returnCode(string + Skin.indentation);
        }
        string2 = string2 + "\n" + string + "</Window>\n";
        return string2;
    }

    public Layout getLayout(String string) {
        Layout layout = null;
        for (int i = 0; i < this.layouts.size(); ++i) {
            if (!this.layouts.get((int)i).id.equals(string)) continue;
            layout = this.layouts.get(i);
        }
        return layout;
    }

    public DefaultMutableTreeNode getTreeNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Window: " + this.id);
        for (int i = 0; i < this.layouts.size(); ++i) {
            defaultMutableTreeNode.add(this.layouts.get(i).getTreeNode());
        }
        return defaultMutableTreeNode;
    }

    public void renameForCopy(String string) {
        String string2;
        String string3 = string;
        String string4 = string2 = (string = string.replaceAll("%oldid%", this.id));
        int n = 1;
        while (this.s.idExists(string4)) {
            string4 = string2 + "_" + String.valueOf(++n);
        }
        this.id = string4;
        for (Layout layout : this.layouts) {
            layout.renameForCopy(string3);
        }
    }
}

