/**************************************************************************
**
** Copyright (C) 2020 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the tools applications of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
**************************************************************************/

function Component()
{
    if (installer.containsValue("TelemetryPluginApproved")) {
        if (installer.value("TelemetryPluginApproved") == "true" ) {
            installer.finishAllComponentsReset.connect(this, reselectComponentAfterRefresh);
        }
    } else {
        component.loaded.connect(this, addTelemetryQuery);
    }
}

Component.prototype.createOperations = function()
{
    component.createOperations();
    component.addOperation("GlobalConfig", "QtProject", "UserFeedback.QtCreator",
        "UserFeedback/StatisticsCollectionMode", "DetailedUsageStatistics");
}

// called after refresh
function reselectComponentAfterRefresh()
{
    component.setValue("AutoDependOn", "qt.tools.qtcreator")
}

function enableNextButton()
{
    var widget = gui.pageWidgetByObjectName("DynamicTelemetryPluginForm");
    if (widget) {
        widget.complete = true;
    }
}

addTelemetryQuery = function()
{
    if (installer.isInstaller()) {
        var pageWidget = gui.currentPageWidget()
        if (installer.addWizardPage(component, "TelemetryPluginForm", QInstaller.TargetDirectory)) {
            component.userInterface("TelemetryPluginForm").statisticGroupBox.enableStatisticRadioButton.checked = false;
            component.userInterface("TelemetryPluginForm").statisticGroupBox.enableStatisticRadioButton.toggled.connect(installTelemetryPluginIfChecked);
            component.userInterface("TelemetryPluginForm").statisticGroupBox.disableStatisticRadioButton.checked = false;
            component.userInterface("TelemetryPluginForm").statisticGroupBox.disableStatisticRadioButton.toggled.connect(installTelemetryPluginIfChecked);
            var widget = gui.pageWidgetByObjectName("DynamicTelemetryPluginForm");

            if (widget != null) {
                //complete = false will disable next button
                widget.complete = false;
            }
        } else { //Command line instance
            var result = QMessageBox["question"]("telemetry-question", "Contribute to Qt Development",
                "Help us improve Qt and Qt Creator by allowing tracking of pseudonymous usage data in Qt Creator. " +
                "The tracking can be disabled at any time. Read the Qt Company data collection privacy statement " +
                "https://www.qt.io/terms-conditions/#privacy.", QMessageBox.Yes | QMessageBox.No, QMessageBox.Yes);
            if (result == QMessageBox.Yes)
                selectTelemetry();
            else
                deselectTelemetry();
        }
    }
}

installTelemetryPluginIfChecked = function(checked)
{
    // Select/unselect the telemetry plugin component for installation
    var widget = gui.pageWidgetByObjectName("DynamicTelemetryPluginForm");
    // Component cannot be selected if it is virtual, change value temporarily
    if (widget != null) {
        var componentSelectionPage = gui.pageWidgetByObjectName("ComponentSelectionPage");
        enableNextButton()
        var pluginForm = component.userInterface("TelemetryPluginForm")
        if (pluginForm && pluginForm.statisticGroupBox.enableStatisticRadioButton.checked == true) {
            // ComponentSelectionPage might not be visible. This is the case when using 'Default Install'
            // feature in 4.0.0. If that is the case use installer.selectComponent() instead which
            // is available from ifw version 4.0.0 onwards
            if (componentSelectionPage)
                componentSelectionPage.selectComponent(component.name);
            else
                installer.selectComponent(component.name);
            selectTelemetry();
        }
        if (pluginForm && pluginForm.statisticGroupBox.disableStatisticRadioButton.checked == true) {
            if (componentSelectionPage)
                componentSelectionPage.deselectComponent(component.name);
            else
                installer.deselectComponent(component.name);
            deselectTelemetry();
        }
        installer.clearComponentsToInstallCalculated();
        installer.calculateComponentsToInstall()
    } else {
        console.log("DynamicTelemetryPluginForm not found")
    }
}

function selectTelemetry()
{
    component.setValue("AutoDependOn", "qt.tools.qtcreator")
    installer.setValue("TelemetryPluginApproved", "true");
    // user has fetched preview category, selected QtCreator preview and approved telemetry, decides to start over
    if (installer.componentByName("preview.qt.tools.qtcreator") && installer.componentByName("preview.qt.tools.qtcreator.telemetry")) {
        installer.componentByName("preview.qt.tools.qtcreator.telemetry").setValue("AutoDependOn", "preview.qt.tools.qtcreator");
    }
}

function deselectTelemetry()
{
    component.setValue("AutoDependOn", "")
    // user has fetched preview category, selected QtCreator preview, approved telemetry, decides to start over, declines telemetry
    if (installer.componentByName("preview.qt.tools.qtcreator.telemetry")) {
        installer.componentByName("preview.qt.tools.qtcreator.telemetry").setValue("AutoDependOn", "");
    }
    installer.setValue("TelemetryPluginApproved", "false");
}
