/**** AUTO GENERATED ****/

/*****************************************************************************

Copyright (c) 2004 by Nanoradio AB      

This software is copyrighted by and is the sole property of Nanoradio AB.
All rights, title, ownership, or other interests in the
software remain the property of Nanoradio AB.  This software may
only be used in accordance with the corresponding license agreement.  Any
unauthorized use, duplication, transmission, distribution, or disclosure of
this software is expressly forbidden.

This Copyright notice may not be removed or modified without prior written
consent of Nanoradio AB.

Nanoradio AB reserves the right to modify this software without
notice.

Nanoradio AB
Torshamnsgatan 39                       info@nanoradio.se
164 40 Kista                            http://www.nanoradio.se
SWEDEN

Module Description :
==================
This module is autogenerated and implements fuctions to pack and unpack MAC
messages.

*****************************************************************************/
#include "driverenv.h"
#include "m80211_defs.h"
#include "m80211_stddefs.h"
#include "mac_mgmt_defs.h"
#include "mib_defs.h"
#include "hicWrapper.h"
#include "macWrapper.h"

#undef NIL
#define NIL ((void*)0xffffffff)

/*****************************************************************************
T E M P O R A R Y   T E S T V A R I A B L E S
*****************************************************************************/

/*****************************************************************************
C O N S T A N T S / M A C R O S
*****************************************************************************/
/*****************************************************************************
L O C A L   D A T A T Y P E S
*****************************************************************************/

/*****************************************************************************
L O C A L   F U N C T I O N   P R O T O T Y P E S
*****************************************************************************/

/*****************************************************************************
 M O D U L E   V A R I A B L E S
*****************************************************************************/

/*****************************************************************************
G L O B A L   C O N S T A N T S / V A R I A B L E S
*****************************************************************************/

/*****************************************************************************
G L O B A L   F U N C T I O N S (Hand Coded)
*****************************************************************************/
/*!
 * @brief Initialize a context for packing and unpacking of messages (HIC or MAC) 
 * using wrapper functions
 *
 * Reset all context variables and set the buffer and length members
 * to point at a buffer with a message in packed/binary format.
 * 
 * @param [in] _blob Adress of the context to be initialized.
 * @param [in] _ptr  Adress of the packed message (e.g. MAC in binary format according to 802.11 specifications) 
 * @param [in] _len  Length of the packed message
 *
 * @return void.
 */
void INIT_BLOB(Blob_t * _blob, char * _ptr, uint16_t _len)
{
   DE_MEMSET(_blob,0,sizeof(Blob_t));
   (_blob)->status = TRUE;
   (_blob)->length = (uint16_t)(_len);
   (_blob)->buffer = (char*)(_ptr);
}

/*!
 * @brief Allocate a buffer for C-structure to be used with wrapper functions
 *
 * 
 * @param [in]       blob  Adress of the context which will be used when packing
 *                         the allocated C structure to binary format.
 * @param [in]       size  Number of byte to alloc
 * @param [in,debug] file  File name from where the function was called
 * @param [in,debug] line  Line number from where the function was called
 *
 * @return void.
 */
void* WrapperAllocStructure(Blob_t* blob, int size)
{
   void*                     new_buffer;
   struct wrapper_alloc_buf* buf_hdr;
   buf_hdr = (struct wrapper_alloc_buf*)DriverEnvironment_Nonpaged_Malloc(size + sizeof(struct wrapper_alloc_buf));
   buf_hdr->next_in_chain = NULL;
#ifdef SUPPORT_STRUCTURE_COPY
   buf_hdr->this_buf_size = size;
#endif /*  SUPPORT_STRUCTURE_COPY */

   new_buffer = (void*)((char*)buf_hdr + sizeof(struct wrapper_alloc_buf));
   if (blob != NULL)
   {
      blob->structure = new_buffer;
   }

   /* Return a pointer to the allocated structure. */
   DE_MEMSET(new_buffer, M80211_IE_ID_NOT_USED, size);
   return (new_buffer);
}

void* WrapperAttachStructure(void* context_p, int size)
{
   void*                new_buffer;
   struct wrapper_alloc_buf* main_buf_hdr;
   struct wrapper_alloc_buf* attached_buf_hdr;

   HIC_ASSERT(context_p != NULL);
   main_buf_hdr      = (struct wrapper_alloc_buf*)((char*)context_p - sizeof(struct wrapper_alloc_buf));
   attached_buf_hdr  = (struct wrapper_alloc_buf*)DriverEnvironment_Nonpaged_Malloc(size + sizeof(struct wrapper_alloc_buf));

   /* Insert buffer in chain. */
#ifdef SUPPORT_STRUCTURE_COPY
   attached_buf_hdr->this_buf_size = size;
#endif /*  SUPPORT_STRUCTURE_COPY */

   attached_buf_hdr->next_in_chain = main_buf_hdr->next_in_chain;
   main_buf_hdr->next_in_chain     = attached_buf_hdr; 

   /* Return a pointer to the attached structure. */
   new_buffer = (void*)((char*)attached_buf_hdr + sizeof(struct wrapper_alloc_buf));
   DE_MEMSET(new_buffer, M80211_IE_ID_NOT_USED, size);
   return (new_buffer);
}

#ifdef SUPPORT_STRUCTURE_COPY
void* WrapperCopyStructure(void* source_structure_p)
{
   char*                tmp_buf;
   char*                dst_buf;
   char*                src_buf;
   struct wrapper_alloc_buf* dest_buf_hdr;
   struct wrapper_alloc_buf* source_buf_hdr;

   /* Setup the source and destination buffer headers. */
   source_buf_hdr = (struct wrapper_alloc_buf*)((char*)source_structure_p - sizeof(struct wrapper_alloc_buf));
   dst_buf        = (char*)WrapperAllocStructure(NULL, source_buf_hdr->this_buf_size);

   /* Initialize pointers to working buffer. */
   tmp_buf = NULL;

   /* Copy the complete chain of buffers. */
   while (source_buf_hdr != NULL)
   {  
      if (tmp_buf == NULL)
      {
         tmp_buf = dst_buf;
      }
      else
      {
         tmp_buf = (char*)WrapperAttachStructure((void*)dst_buf, source_buf_hdr->this_buf_size);
      }

      /* Locate the destination buffer header. */
      dest_buf_hdr = (struct wrapper_alloc_buf*)(tmp_buf - sizeof(struct wrapper_alloc_buf));

      /* Copy the buffer size information. */
      dest_buf_hdr->this_buf_size = source_buf_hdr->this_buf_size;

      /* Copy the buffer data. */
      src_buf = ((char*)source_buf_hdr + sizeof(struct wrapper_alloc_buf));
      DE_MEMCPY(tmp_buf, src_buf, dest_buf_hdr->this_buf_size);
      
      source_buf_hdr = (struct wrapper_alloc_buf*)source_buf_hdr->next_in_chain;
   }
   
   return (void*)dst_buf;
}
#endif /*  SUPPORT_STRUCTURE_COPY */

void  WrapperFreeStructure(void*  structure_ref)
{
   struct wrapper_alloc_buf* tmp;
   struct wrapper_alloc_buf* buf_hdr;

   if (structure_ref != NULL && structure_ref != NIL)
   {
      buf_hdr = &((struct wrapper_alloc_buf*)structure_ref)[-1];
   

      /* Release the complete chain of buffers. */
      while (buf_hdr != NULL)
      {
         tmp = buf_hdr;
         buf_hdr = (struct wrapper_alloc_buf*)buf_hdr->next_in_chain;
         tmp->next_in_chain = NULL;
         DriverEnvironment_Nonpaged_Free(tmp);
      }
   }
}

void*  WrapperNextInChain(void*  structure_ref)
{
   struct wrapper_alloc_buf* buf_hdr;
   char*                next_buf;

   HIC_ASSERT(structure_ref != NIL);
   HIC_ASSERT(structure_ref != NULL);
   
   buf_hdr  = (struct wrapper_alloc_buf*)((char*)structure_ref - sizeof(struct wrapper_alloc_buf));
   next_buf = (char*)buf_hdr->next_in_chain;
   if (next_buf != NULL)
   {
      /* Move to the start of the user buffer. */
      next_buf += sizeof(struct wrapper_alloc_buf);
   }
   return (void*)next_buf;
}

void*  WrapperLastInChain(void*  structure_ref)
{
   struct wrapper_alloc_buf* buf_hdr;
   char*                     last_buf;

   HIC_ASSERT(structure_ref != NIL);
   HIC_ASSERT(structure_ref != NULL);
   
   buf_hdr  = (struct wrapper_alloc_buf*)((char*)structure_ref - sizeof(struct wrapper_alloc_buf));
   while (buf_hdr->next_in_chain != NULL)
   {
      buf_hdr = (struct wrapper_alloc_buf*)buf_hdr->next_in_chain;
   }

   /* Move to the start of the user buffer. */
   last_buf = (char*)buf_hdr + sizeof(struct wrapper_alloc_buf);
   return (void*)last_buf;
}

static bool_t MacWrapper_m80211_ie_hdr_t_indexed(m80211_ie_hdr_t* object_p, Blob_t* blob, WrapperAction_t action, uint8_t id, uint16_t min, uint16_t max, int *ie_index)
{
   switch (action)
   {
      case  ACTION_UNPACK:
      {        
         if (BLOB_IS_FIRST_IE(blob))
         {
            /* Store the index of the first information element. */
            BLOB_PUSH_IE(blob);
         }
         else
         {
            /* Restore the index of the first information element. */
            BLOB_POP_IE(blob);
         }

         /* Store an index to the currently processed IE. */
         BLOB_SET_CURRENT_IE(blob);

         *ie_index = 0;
         object_p->id = M80211_IE_ID_NOT_USED;
         object_p->len = 0;

         /* Scan through all information elements to find the current one. */
         while ( (object_p->id == M80211_IE_ID_NOT_USED) && (blob->index < blob->length ) )
         {
            /* Strore an index to the currently processed IE. */
            BLOB_SET_CURRENT_IE(blob);
            
            /* Read the id and length fields and continue. */ 
            MacWrapper_uint8_t(&object_p->id, blob, action);
            MacWrapper_uint8_t(&object_p->len, blob, action); 
            if (object_p->id == id)
            {
               /* The IE is the requested one. */ 
               if (object_p->len <= BLOB_REMAINING_SIZE(blob))
               {
                  blob->ie_map |= (1 << *ie_index);
                  break;
               }
            }
            else if (object_p->id != M80211_IE_ID_NOT_USED)
            {
               /* The element was not the one we looked for. */
               object_p->id = M80211_IE_ID_NOT_USED;
            }
            if ( object_p->len > BLOB_REMAINING_SIZE(blob) )
            {
               /* Corrupt indata, like in probe responses from Open WRT on linksys. 
                  Discard this and all following IE's. 
               */
               object_p->id  = M80211_IE_ID_NOT_USED;
               object_p->len = 0;
               BLOB_BUF_RESIZE(blob, BLOB_CURRENT_SIZE(blob) - 2);
               break;
            }
            else
            {
               BLOB_SKIP(blob, object_p->len);
               (*ie_index)++;
               HIC_ASSERT(*ie_index < 32);
            }
         }
      }
      break;

      case ACTION_PACK:
      case ACTION_GET_SIZE:
      {
         /* Strore an index to the currently processed IE. */
         BLOB_SET_CURRENT_IE(blob);
   
         if (object_p->id != M80211_IE_ID_NOT_USED)
         {
            MacWrapper_uint8_t(&object_p->id,  blob, action);
            MacWrapper_uint8_t(&object_p->len, blob, action); 
         }
      }
   }

   if (object_p->id == M80211_IE_ID_NOT_USED)
   {
      /* Ensure that an undefined information element is correctly filled out. */
      object_p->len = 0;
      return FALSE;
   }

   /* Assert that the length parameter is within range. */
   if ( (object_p->len > max) 
     || (object_p->len < min) )
   {
      /* The element was erronoeus. */
      object_p->id  = M80211_IE_ID_NOT_USED;      
      object_p->len = 0;
      return FALSE;
   }
   return TRUE;
} /* MacWrapper_m80211_ie_hdr_t */ 

/* workaround for broken ie_map in ..._ie_hdr_t(...); can't handle more then one ie of same id */
/* FIXME: refactor this */
bool_t MacWrapper_m80211_ie_hdr_t(m80211_ie_hdr_t* object_p, Blob_t* blob, WrapperAction_t action, uint8_t id, uint16_t min, uint16_t max) {
   int ie_index;
   return MacWrapper_m80211_ie_hdr_t_indexed(object_p, blob, action, id, min, max, &ie_index);
}


void MacWrapper_m80211_ie_ssid_t(m80211_ie_ssid_t* object_p, Blob_t* blob, WrapperAction_t action) 
{ 
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_SSID, 0, M80211_IE_MAX_LENGTH_SSID))
   { 
      switch (action)
      {
         case ACTION_PACK:
            DE_STRNCPY(&blob->buffer[blob->index], object_p->ssid, object_p->hdr.len);
            break;

         case ACTION_UNPACK:
            DE_STRNCPY(object_p->ssid, &blob->buffer[blob->index], object_p->hdr.len);
            break;
         case ACTION_GET_SIZE:
            break;
      }
      blob->index += object_p->hdr.len;
   }
} /* MacWrapper_m80211_ie_ssid_t */ 

void MacWrapper_m80211_ie_supported_rates_t(m80211_ie_supported_rates_t* object_p, Blob_t* blob, WrapperAction_t action) 
{ 
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_SUPPORTED_RATES, 1, M80211_IE_MAX_LENGTH_SUPPORTED_RATES))
   { 
      switch (action)
      {
         case ACTION_PACK:
            DE_MEMCPY(&blob->buffer[blob->index], &object_p->rates, object_p->hdr.len);
            break;

         case ACTION_UNPACK:
            if (object_p->hdr.len <= M80211_IE_MAX_LENGTH_SUPPORTED_RATES)
            {
               DE_MEMCPY(&object_p->rates, &blob->buffer[blob->index], object_p->hdr.len);
            }
            else
            {
               object_p->hdr.id  = M80211_IE_ID_NOT_USED;
               object_p->hdr.len = 0;
            }
            break;
         case ACTION_GET_SIZE:
            break;
      }
   }
   blob->index += object_p->hdr.len;
} /* MacWrapper_m80211_ie_supported_rates_t */ 


void MacWrapper_m80211_ie_ext_supported_rates_t(m80211_ie_ext_supported_rates_t* object_p, Blob_t* blob, WrapperAction_t action) 
{ 
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_EXTENDED_SUPPORTED_RATES, 1, M80211_IE_MAX_LENGTH_EXT_SUPPORTED_RATES))
   { 
      switch (action)
      {
         case ACTION_PACK:
            DE_MEMCPY(&blob->buffer[blob->index], &object_p->rates, object_p->hdr.len);
            break;

         case ACTION_UNPACK:
            if (object_p->hdr.len <= M80211_IE_MAX_LENGTH_EXT_SUPPORTED_RATES)
            {
               DE_MEMCPY(&object_p->rates, &blob->buffer[blob->index], object_p->hdr.len);
            }
            else
            {
               object_p->hdr.id  = M80211_IE_ID_NOT_USED;
               object_p->hdr.len = 0;
            }
            break;
         case ACTION_GET_SIZE:
            break;
      }
   }
   blob->index += object_p->hdr.len;
} /* MacWrapper_m80211_ie_ext_supported_rates_t */ 


bool_t MacWrapper_m80211_ie_vendor_specific_hdr_t(m80211_ie_vendor_specific_hdr_t* object_p, Blob_t* blob, WrapperAction_t action, uint8_t OUI_type, int *ie_index)
{
   int vendor_ie_index = -1; /* first */
   switch (action)
   {
      case ACTION_GET_SIZE:
      {
         if (object_p->hdr.id != M80211_IE_ID_NOT_USED)
         {
            blob->index += 6;
         }
         else
         {
            object_p->hdr.len = 0;
            return FALSE;
         }
      }
      break;
      case  ACTION_UNPACK:
      {
         /* There is a type field in this IE. 
            To be able to find the IE with the rigth type field we must be able to iterate through
            the present IE information elements. 
            Facilitate this by using a temporary blob.
         */
         Blob_t org_blob = *blob;
         int blob_ie_index;

         while (MacWrapper_m80211_ie_hdr_t_indexed(&object_p->hdr, blob, action, 
                                           M80211_IE_ID_VENDOR_SPECIFIC, 1, M80211_IE_MAX_LEN, &blob_ie_index))
         {
            if(vendor_ie_index<0) {
               vendor_ie_index = blob_ie_index;
            } else {
               /* each loop will start from a new index and always start from 0 */
               vendor_ie_index += (1+blob_ie_index);
            }
            HIC_ASSERT(vendor_ie_index < 32);

            MacWrapper_uint8_t(&object_p->OUI_1, blob, action);
            MacWrapper_uint8_t(&object_p->OUI_2, blob, action);
            MacWrapper_uint8_t(&object_p->OUI_3, blob, action);

            if ( (object_p->OUI_1 == 0x00) && (object_p->OUI_2 == 0x50) && (object_p->OUI_3 == 0xf2) )
            {
               MacWrapper_uint8_t(&object_p->OUI_type, blob, action);

               if (object_p->OUI_type == OUI_type)
               {
                  /* Ready searching! Restore the IE stack. */
                  BLOB_RESTORE_IE(blob, &org_blob);
                  blob->ie_map |= (1 << vendor_ie_index);
                  if(ie_index) *ie_index = vendor_ie_index;
                  return TRUE;
               }
            }
#if (DE_CCX == CFG_INCLUDED)
	    else if ( (object_p->OUI_1 == 0x00) && (object_p->OUI_2 == 0x40) && (object_p->OUI_3 == 0x96) )
            {
               MacWrapper_uint8_t(&object_p->OUI_type, blob, action);
               if (object_p->OUI_type == OUI_type)
               {
                  /* Ready searching! Restore the IE stack. */
                  BLOB_RESTORE_IE(blob, &org_blob);
                  blob->ie_map |= (1 << vendor_ie_index);
                  if(ie_index) *ie_index = vendor_ie_index;
                  return TRUE;
               }
            }
#endif
            /* Update the blob to skip this information element in next round. 
               Note that we need to add two octets for the IE header.
             */
            BLOB_SKIP_IE(blob, object_p->hdr.len + 2);
         }
#if (DE_CCX == CFG_INCLUDED)
	/* Restore the blob! */
          *blob = org_blob;
        vendor_ie_index = -1;
//	DE_TRACE_STATIC(TR_SM_HIGH_RES, "cpl - look for cisco proprietary oui\n");
	while (MacWrapper_m80211_ie_hdr_t_indexed(&object_p->hdr, blob, action, 
                                           M80211_IE_ID_CISCO_VENDOR_SPECIFIC, 1, M80211_IE_MAX_LEN, &blob_ie_index))
         {
//	    DE_TRACE_STATIC(TR_SM_HIGH_RES, "cpl - inside while...\n");
//	    DE_TRACE_STATIC4(TR_SM_HIGH_RES, "OUI CHECK %02X:%02X:%02X\n", object_p->OUI_1, object_p->OUI_2, object_p->OUI_3);

            if(vendor_ie_index<0) {
               vendor_ie_index = blob_ie_index;
            } else {
               /* each loop will start from a new index and always start from 0 */
               vendor_ie_index += (1+blob_ie_index);
            }
            HIC_ASSERT(vendor_ie_index < 32);

            MacWrapper_uint8_t(&object_p->OUI_1, blob, action);
            MacWrapper_uint8_t(&object_p->OUI_2, blob, action);
            MacWrapper_uint8_t(&object_p->OUI_3, blob, action);

	    if ( (object_p->OUI_1 == 0x00) && (object_p->OUI_2 == 0x50) && (object_p->OUI_3 == 0xf2) )
            {
               MacWrapper_uint8_t(&object_p->OUI_type, blob, action);
               if (object_p->OUI_type == OUI_type)
               {
                  /* Ready searching! Restore the IE stack. */
                  BLOB_RESTORE_IE(blob, &org_blob);
                  blob->ie_map |= (1 << vendor_ie_index);
                  if(ie_index) *ie_index = vendor_ie_index;
                  return TRUE;
               }
            }

	    else if ( (object_p->OUI_1 == 0x00) && (object_p->OUI_2 == 0x40) && (object_p->OUI_3 == 0x96) )
            {
//               DE_TRACE_STATIC(TR_SM_HIGH_RES, "check for 0x00 0x40 0x96\n");
	       MacWrapper_uint8_t(&object_p->OUI_type, blob, action);
               if (object_p->OUI_type == OUI_type)
               {
                  /* Ready searching! Restore the IE stack. */
//  		  DE_TRACE_STATIC(TR_SM_HIGH_RES, "FOUND IT!!!\n");
                  BLOB_RESTORE_IE(blob, &org_blob);
                  blob->ie_map |= (1 << vendor_ie_index);
                  if(ie_index) *ie_index = vendor_ie_index;
                  return TRUE;
               }
            }

            /* Update the blob to skip this information element in next round. 
               Note that we need to add two octets for the IE header.
             */
            BLOB_SKIP_IE(blob, object_p->hdr.len + 2);
         }
#endif //DE_CCX
          /* Restore the blob! */
         *blob = org_blob;

         /* Assure that the IE id and len is set up correctly. */
         object_p->hdr.id  = M80211_IE_ID_NOT_USED;
         object_p->hdr.len = 0;
         
         return FALSE;
      }
      break;

      case ACTION_PACK:
      {
         if (MacWrapper_m80211_ie_hdr_t(&object_p->hdr, blob, action, 
                                    M80211_IE_ID_VENDOR_SPECIFIC, 1, M80211_IE_MAX_LEN))
         {
            MacWrapper_uint8_t(&object_p->OUI_1, blob, action);
            MacWrapper_uint8_t(&object_p->OUI_2, blob, action);
            MacWrapper_uint8_t(&object_p->OUI_3, blob, action);
            MacWrapper_uint8_t(&object_p->OUI_type, blob, action);
         }
         else 
         {
            return FALSE;
         }
      }
   }
   return TRUE;
} /* MacWrapper_m80211_ie_vendor_specific_hdr_t */

#if (DE_CCX == CFG_INCLUDED)
#if 0
bool_t MacWrapper_m80211_ie_ccx_adj_vendor_specific_hdr_t(m80211_ie_ccx_adj_parameter_set_t* object_p, 
                              						       Blob_t* blob, 
                              						       WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_CISCO_ADJ_VENDOR_SPECIFIC, 4, M80211_IE_MAX_LEN))
   {
//   	DE_TRACE_STATIC(TR_SM_HIGH_RES, "ok\n");
      	return TRUE;
   }
   return FALSE;
} /* MacWrapper_m80211_ie_ccx_adj_vendor_specific_hdr_t */
#endif //0

#endif


bool_t MacWrapper_m80211_ie_wapi_vendor_specific_hdr_t(m80211_ie_wapi_vendor_specific_hdr_t* object_p, 
                              						       Blob_t* blob, 
                              						       WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_WAPI_VENDOR_SPECIFIC, 4, M80211_IE_MAX_LEN))
   {
      MacWrapper_uint16_t(&object_p->version, blob, action);
      return TRUE;
   }
   return FALSE;
} /* MacWrapper_m80211_ie_wapi_vendor_specific_hdr_t */

bool_t MacWrapper_m80211_ie_WMM_header_t(m80211_ie_WMM_header_t* object_p, Blob_t* blob, WrapperAction_t action, uint8_t sub_type)
{
   int wmm_ie_index = -1; /* first */

   switch (action)
   {
      case  ACTION_UNPACK:
      {
         /* There is a subtype field in this IE. 
            To be able to find the IE with the rigth subtype field we must be able to iterate through
            the present IEinformation elements. 
            Facilitate this by using a temporary blob.
         */
         Blob_t org_blob = *blob;
         int blob_ie_index;

         while (MacWrapper_m80211_ie_vendor_specific_hdr_t(&object_p->hdr, blob, action, WMM_IE_OUI_TYPE,&blob_ie_index))
         {
            if(wmm_ie_index<0) {
               wmm_ie_index = blob_ie_index;
            } else {
               /* each loop will start from a new index and always start from 0 */
               wmm_ie_index += (1+blob_ie_index);
            }
            HIC_ASSERT(wmm_ie_index < 32);

            MacWrapper_uint8_t(&object_p->OUI_Subtype, blob, action);
            if (object_p->OUI_Subtype == sub_type)
            {
               /* Ready searching! Restore the IE stack. */
               BLOB_RESTORE_IE(blob, &org_blob);
               blob->ie_map |= (1 << wmm_ie_index);
               return TRUE;
            }
            /* Update the blob to skip this information element in next round. 
               Note that we need to add two octets for the IE header.
             */
            BLOB_SKIP_IE(blob, object_p->hdr.hdr.len + 2);
         }  
          /* Restore the blob! */
         *blob = org_blob;
         return FALSE;
      }

      case ACTION_PACK:
      case ACTION_GET_SIZE:
      {
         if (MacWrapper_m80211_ie_vendor_specific_hdr_t(&object_p->hdr, blob, action, WMM_IE_OUI_TYPE,NULL))
         {
            /* Update the length field with the size of this element. */
            MacWrapper_uint8_t(&object_p->OUI_Subtype, blob, action);
         }
         else
         {
            return FALSE;
         }
      }
   }
   return TRUE;
} /* MacWrapper_m80211_ie_WMM_header_t */

void* WrapperCopy_default(void* context_p, 
                          m80211_ie_hdr_t* dest_hdr, 
                          m80211_ie_hdr_t* source_hdr,
                          void* source_p, int size)
{
   void* dest_p = NULL;
   if (source_hdr->id != M80211_IE_ID_NOT_USED)
   {
      if ( (source_p != NULL) && (size > 0) )
      {
         dest_p = (void*)WrapperAttachStructure(context_p, size);
         
         if (dest_p != NULL)
         {
            DE_MEMCPY(dest_p, source_p, size);  
         }
         else
         {
            dest_hdr->id   = M80211_IE_ID_NOT_USED;
            dest_hdr->len  = 0x00;
         }
      }
   }
   return dest_p;
}

void WrapperCopy_m80211_ie_tim_t(void* context_p, m80211_ie_tim_t* dest, m80211_ie_tim_t* source)
{
   int tim_element_size = source->hdr.len - 3;

   *dest = *source;

   dest->bitmap = (char*)WrapperCopy_default(context_p, &dest->hdr, &source->hdr, (void*)source->bitmap, tim_element_size);
}

void MacWrapper_m80211_ie_tim_t(m80211_ie_tim_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_TIM, 4, 254))
   {
      int tim_element_size = object_p->hdr.len - 3;

      MacWrapper_uint8_t(&object_p->dtim_timing.count, blob, action);
      MacWrapper_uint8_t(&object_p->dtim_timing.period, blob, action);
      MacWrapper_uint8_t(&object_p->bitmap_control, blob, action);

      /* Before unpacking the elements of this IE, allocate a buffer for it. */
      if (action == ACTION_UNPACK)
      {
         /* Allocate a buffer for this IE. */
         object_p->bitmap = (char*)WrapperAttachStructure(blob->structure, tim_element_size);
      }
      /* The length member is implicitly set by MacWrapper_m80211_ie_hdr_t. */
      MacWrapper_array_t(object_p->bitmap, tim_element_size, blob, action);
   }
} /* MacWrapper_m80211_ie_tim_t */

void WrapperCopy_m80211_ie_rsn_parameter_set_t(void* context_p, m80211_ie_rsn_parameter_set_t* dest, m80211_ie_rsn_parameter_set_t* source)
{
   *dest = *source;

   dest->rsn_pool = (char*)WrapperCopy_default(context_p, &dest->hdr, &source->hdr, (void*)source->rsn_pool, source->hdr.len);
}

void MacWrapper_m80211_ie_rsn_parameter_set_t(m80211_ie_rsn_parameter_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   int i;
   m80211_cipher_suite_selector_t*  cipher_selectors;
   m80211_akm_suite_selector_t*     akm_selectors;
   m80211_pmkid_selector_t*         pmkid_selectors;

   if (ACTION_GET_SIZE == action)
   {
      if (object_p->hdr.id != M80211_IE_ID_NOT_USED)
      {
         blob->index += object_p->hdr.len + 2;
      }
      else
      {
         object_p->hdr.len = 0;
      }
      return;
   }
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_RSN, 0, 255))
   {
      Blob_t   tmp_blob;
      uint16_t index_for_next_ie = 0;

      /* Create a temporary context which points at this IE header. */
      tmp_blob = *blob;
      BLOB_POP_CURRENT_IE(&tmp_blob);

      /* According to 802.11i spec all fields after version may be omitted in the coded IE 
         if its count or value is zero. We need to know the limits of this IE to honor that.
       */      
      /* Before unpacking the elements of this IE, clear all items from version and onwards. */
      if (action == ACTION_UNPACK)
      {
         DE_MEMSET(&object_p->version, 0x00, ((char*)&object_p->rsn_pool - (char*)&object_p->version));
         /* To be safe, allocate the whole size of this IE. */
         object_p->rsn_pool = (char*)WrapperAttachStructure(blob->structure, object_p->hdr.len);         
      }

      index_for_next_ie = BLOB_CURRENT_SIZE(&tmp_blob) + object_p->hdr.len + 2;
      
      /* Handle the elements. */
      MacWrapper_uint16_t(&object_p->version, blob, action);
      if (BLOB_CURRENT_SIZE(blob) < index_for_next_ie)
      {      
         MacWrapper_m80211_cipher_suite_selector_t(&object_p->group_cipher_suite, blob, action);

         if (BLOB_CURRENT_SIZE(blob) < index_for_next_ie)
         {
            MacWrapper_uint16_t(&object_p->pairwise_cipher_suite_count, blob, action);
            cipher_selectors = M80211_IE_RSN_PARAMETER_SET_GET_PAIRWISE_CIPHER_SELECTORS(object_p);
            for (i=0; i<object_p->pairwise_cipher_suite_count; i++) {
               MacWrapper_m80211_cipher_suite_selector_t(&cipher_selectors[i], blob, action);
            } 

            if (BLOB_CURRENT_SIZE(blob) < index_for_next_ie)
            {
               MacWrapper_uint16_t(&object_p->akm_suite_count, blob, action);
               akm_selectors = M80211_IE_RSN_PARAMETER_SET_GET_AKM_SELECTORS(object_p);
               for (i=0; i<object_p->akm_suite_count; i++)
               {
                  MacWrapper_m80211_akm_suite_selector_t(&akm_selectors[i], blob, action);
               } 
            
               if (BLOB_CURRENT_SIZE(blob) < index_for_next_ie)
               {
                  MacWrapper_uint16_t(&object_p->rsn_capabilities, blob, action);

                  if (BLOB_CURRENT_SIZE(blob) < index_for_next_ie)
                  {
                     MacWrapper_uint16_t(&object_p->pmkid_count, blob, action);
                     pmkid_selectors = M80211_IE_RSN_PARAMETER_SET_GET_PMKID_SELECTORS(object_p);
                     for (i=0; i<object_p->pmkid_count; i++)
                     {
                        MacWrapper_m80211_pmkid_selector_t(&pmkid_selectors[i], blob, action);
                     } 
                  }

               }
            }
         }
      }
   }
} /* MacWrapper_m80211_ie_rsn_parameter_set_t */

void WrapperCopy_m80211_ie_wpa_parameter_set_t(void * context_p, m80211_ie_wpa_parameter_set_t * dest, m80211_ie_wpa_parameter_set_t * source)
{
   *dest = *source;

   dest->rsn_pool = (char*)WrapperCopy_default(context_p, &dest->hdr.hdr, &source->hdr.hdr, (void*)source->rsn_pool, source->hdr.hdr.len);
}


void MacWrapper_m80211_ie_wpa_parameter_set_t(m80211_ie_wpa_parameter_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   int i;
   m80211_cipher_suite_selector_t*  cipher_selectors;
   m80211_akm_suite_selector_t*     akm_selectors;
   
   if (ACTION_GET_SIZE == action)
   {
      if (object_p->hdr.hdr.id != M80211_IE_ID_NOT_USED)
      {
         blob->index += object_p->hdr.hdr.len + 2;
      }
      else
      {
         object_p->hdr.hdr.len = 0;
      }
      return;
   }
   if (MacWrapper_m80211_ie_vendor_specific_hdr_t(&object_p->hdr, blob, action, WPA_IE_OUI_TYPE,NULL))
   {
      Blob_t   tmp_blob;
      uint16_t index_for_next_ie = 0;

      /* Create a temporary context which points at this IE header. */
      tmp_blob = *blob;
      BLOB_POP_CURRENT_IE(&tmp_blob);

      /* According to 802.11i spec all fields after version may be omitted in the coded IE 
         if its count or value is zero. We need to know the limits of this IE to honor that.
       */      
      /* Before unpacking the elements of this IE, clear all items from version and onwards. */
      if (action == ACTION_UNPACK)
      {
         DE_MEMSET(&object_p->version, 0x00, ((char*)&object_p->rsn_pool - (char*)&object_p->version));
         /* To be safe, allocate the whole size of this IE. */
         object_p->rsn_pool = (char*)WrapperAttachStructure(blob->structure, object_p->hdr.hdr.len);
      }

      index_for_next_ie = BLOB_CURRENT_SIZE(&tmp_blob) + object_p->hdr.hdr.len + 2;

      /* Handle the elements. */
      MacWrapper_uint16_t(&object_p->version, blob, action);
      if (BLOB_CURRENT_SIZE(blob) < index_for_next_ie)
      {      
         MacWrapper_m80211_cipher_suite_selector_t(&object_p->group_cipher_suite, blob, action);

         if (BLOB_CURRENT_SIZE(blob) < index_for_next_ie)
         {
            MacWrapper_uint16_t(&object_p->pairwise_cipher_suite_count, blob, action);
            cipher_selectors = M80211_IE_WPA_PARAMETER_SET_GET_PAIRWISE_CIPHER_SELECTORS(object_p);
            for (i=0; i<object_p->pairwise_cipher_suite_count; i++) {
               MacWrapper_m80211_cipher_suite_selector_t(&cipher_selectors[i], blob, action);
            } 

            if (BLOB_CURRENT_SIZE(blob) < index_for_next_ie)
            {
               MacWrapper_uint16_t(&object_p->akm_suite_count, blob, action);
               akm_selectors = M80211_IE_WPA_PARAMETER_SET_GET_AKM_SELECTORS(object_p);
               for (i=0; i<object_p->akm_suite_count; i++)
               {
                  MacWrapper_m80211_akm_suite_selector_t(&akm_selectors[i], blob, action);
               } 
            
               if (BLOB_CURRENT_SIZE(blob) < index_for_next_ie)
               {
                  MacWrapper_uint16_t(&object_p->rsn_capabilities, blob, action);
               }
            }
         }
      }
   }
} /* MacWrapper_m80211_ie_wpa_parameter_set_t */

void WrapperCopy_m80211_ie_wapi_parameter_set_t(void * context_p, m80211_ie_wapi_parameter_set_t * dest, m80211_ie_wapi_parameter_set_t * source)
{
  int wapi_element_size = source->hdr.hdr.len - WAPI_VERSION_SIZE;

  *dest = *source;

  dest->wapi_pool = (char*)WrapperCopy_default(context_p, &dest->hdr.hdr, &source->hdr.hdr, (void*)source->wapi_pool, wapi_element_size);
}

void MacWrapper_m80211_ie_wapi_parameter_set_t(m80211_ie_wapi_parameter_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (ACTION_GET_SIZE == action)
   {
      if (object_p->hdr.hdr.id != M80211_IE_ID_NOT_USED)
      {
         blob->index += object_p->hdr.hdr.len + 2;
      }
      else
      {
         object_p->hdr.hdr.len = 0;
      }
      return;
   }

   if (MacWrapper_m80211_ie_wapi_vendor_specific_hdr_t(&object_p->hdr, blob, action))
   {
      int wapi_element_size = object_p->hdr.hdr.len - WAPI_VERSION_SIZE;
      
      if (action == ACTION_UNPACK)
      {
         object_p->wapi_pool = (char*)WrapperAttachStructure(blob->structure, wapi_element_size);
      }

      MacWrapper_array_t((char*)&object_p->wapi_pool[0], wapi_element_size, blob, action);
   }
} /* MacWrapper_m80211_ie_wapi_parameter_set_t */


static void 
MacWrapper_supported_mcs_set_t(m80211_supported_mcs_set_t *object_p, 
                               Blob_t *blob, 
                               WrapperAction_t action)
{
   MacWrapper_array_t((char*)object_p->rx_mcs_bitmap, 
                      sizeof(object_p->rx_mcs_bitmap), blob, action);
   MacWrapper_uint8_t(&object_p->rx_highest_supp_data_rate_low_byte,
                      blob, action);
                      
   MacWrapper_uint8_t(&object_p->rx_highest_supp_data_rate_high_byte,
                      blob, action);
   MacWrapper_uint8_t(&object_p->tx_mcs_flags, blob, action);
   MacWrapper_array_t((char*)object_p->reserved, 
                      sizeof(object_p->reserved), blob, action);
}

void
MacWrapper_m80211_ie_ht_capabilities_t(m80211_ie_ht_capabilities_t *object_p, 
                                       Blob_t* blob, 
                                       WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_HT_CAPABILITIES, 26, 26))
   { 
      MacWrapper_array_t((char*)object_p->ht_capabilities_info, 2, 
                         blob, action);
      MacWrapper_uint8_t(&object_p->a_mpdu_parameters, blob, action);
      MacWrapper_supported_mcs_set_t(&object_p->supported_mcs_set, 
                                     blob, action);
      MacWrapper_array_t((char*)object_p->ht_extended_capabilities, 2, 
                         blob, action);
      MacWrapper_array_t((char*)object_p->transmit_beamforming_capabilities, 4, 
                         blob, action);
      MacWrapper_uint8_t(&object_p->asel_capabilities, 
                         blob, action);
   }
} /* MacWrapper_m80211_ie_ht_capabilities_t */

void
MacWrapper_m80211_ie_ht_operation_t(m80211_ie_ht_operation_t* object_p, 
                                    Blob_t* blob, 
                                    WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_HT_OPERATION, 22, 22))
   { 
      MacWrapper_uint8_t(&object_p->primary_channel, blob, action);
      MacWrapper_array_t((char*)object_p->bitfield, 5, 
                         blob, action);
      MacWrapper_array_t((char*)object_p->basic_mcs_set, 16,
                         blob, action);
   }
} /* MacWrapper_m80211_ie_ht_operation_t */


void WrapperCopy_m80211_ie_wps_parameter_set_t(void * context_p, m80211_ie_wps_parameter_set_t * dest, m80211_ie_wps_parameter_set_t * source)
{
   int wps_element_size = source->hdr.hdr.len - M80211_IE_ID_VENDOR_SPECIFIC_HDR_SIZE;

   *dest = *source;

   dest->wps_pool = (char*)WrapperCopy_default(context_p, &dest->hdr.hdr, &source->hdr.hdr, (void*)source->wps_pool, wps_element_size);
}

void MacWrapper_m80211_ie_wps_parameter_set_t(m80211_ie_wps_parameter_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (ACTION_GET_SIZE == action)
   {
      if (object_p->hdr.hdr.id != M80211_IE_ID_NOT_USED)
      {
          blob->index += object_p->hdr.hdr.len + 2;
      }
      else
      {
         object_p->hdr.hdr.len = 0;
      }
      return;
   }

   /* FIXME: work with OUI done by MacWrapper_m80211_ie_vendor_specific_hdr_t(...,ACTION_PACK,...) 
    * will be overwritten by MacWrapper_array_t (wps_pool contain vendor header) */
   if (MacWrapper_m80211_ie_vendor_specific_hdr_t(&object_p->hdr, blob, action, WPS_IE_OUI_TYPE,NULL))
   {
      int wps_element_size = object_p->hdr.hdr.len - M80211_IE_ID_VENDOR_SPECIFIC_HDR_SIZE;
      if (action == ACTION_UNPACK)
      {
          /* To be safe, allocate the whole size of this IE. */
          object_p->wps_pool = (char*)WrapperAttachStructure(blob->structure, wps_element_size);
      }

      MacWrapper_array_t((char*)&object_p->wps_pool[0], wps_element_size, blob, action);
   }
} /* MacWrapper_m80211_ie_wps_parameter_set_t */

#if (DE_CCX == CFG_INCLUDED)
void WrapperCopy_m80211_ie_ccx_parameter_set_t(void * context_p, m80211_ie_ccx_parameter_set_t * dest, m80211_ie_ccx_parameter_set_t * source)
{

   int ccx_element_size = source->hdr.hdr.len - M80211_IE_ID_VENDOR_SPECIFIC_HDR_SIZE;
   if(ccx_element_size!=1)
	return;


   *dest = *source;
	
    dest->ccx_version=4;
}

void MacWrapper_m80211_ie_ccx_parameter_set_t(m80211_ie_ccx_parameter_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_vendor_specific_hdr_t(&object_p->hdr, blob, action, CCX_IE_OUI_TYPE,NULL))
   {
      MacWrapper_uint8_t(&object_p->ccx_version, blob, action);
   }
} /* MacWrapper_m80211_ie_ccx_parameter_set_t */

void WrapperCopy_m80211_ie_ccx_rm_parameter_set_t(void * context_p, m80211_ie_ccx_rm_parameter_set_t * dest, m80211_ie_ccx_rm_parameter_set_t * source)
{
   int ccx_rm_element_size = source->hdr.hdr.len - M80211_IE_ID_VENDOR_SPECIFIC_HDR_SIZE;
   if(ccx_rm_element_size!=2)
	return;

   *dest = *source;
	
    dest->ccx_rm_status=4;
}

void MacWrapper_m80211_ie_ccx_rm_parameter_set_t(m80211_ie_ccx_rm_parameter_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_vendor_specific_hdr_t(&object_p->hdr, blob, action, CCX_RM_IE_OUI_TYPE,NULL))
   {
      MacWrapper_uint16_t(&object_p->ccx_rm_status, blob, action);
   }
} /* MacWrapper_m80211_ie_ccx_rm_parameter_set_t */

void WrapperCopy_m80211_ie_ccx_cpl_parameter_set_t(void * context_p, m80211_ie_ccx_cpl_parameter_set_t * dest, m80211_ie_ccx_cpl_parameter_set_t * source)
{
   int ccx_element_size = source->hdr.hdr.len - M80211_IE_ID_VENDOR_SPECIFIC_HDR_SIZE;
   if(ccx_element_size!=2)
	return;

   *dest = *source;
}

void MacWrapper_m80211_ie_ccx_cpl_parameter_set_t(m80211_ie_ccx_cpl_parameter_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
//   DE_TRACE_STATIC(TR_SM_HIGH_RES, "\n\n\n\n\nLOOK FOR CCX CPL OUI TYPE\n");
   /* FIXME: work with OUI done by MacWrapper_m80211_ie_vendor_specific_hdr_t(...,ACTION_PACK,...) 
    * will be overwritten by MacWrapper_array_t (ccx_version contain vendor header) */
   if (MacWrapper_m80211_ie_vendor_specific_hdr_t(&object_p->hdr, blob, action, 0x00, NULL))
   {
        // Check Id and length until we change MacWrapper_m80211_ie_vendor_specific_hdr_t.
        if (object_p->hdr.hdr.id != M80211_IE_ID_CISCO_VENDOR_SPECIFIC  || object_p->hdr.hdr.len != 6)
        {
            // DE_TRACE_STATIC(TR_SM_HIGH_RES, "\nOOPS NO CPL\n");
            object_p->hdr.hdr.id  = M80211_IE_ID_NOT_USED;
            object_p->hdr.hdr.len = 0;
            return;
        }

        MacWrapper_uint8_t(&object_p->cpl, blob, action);
	DE_TRACE_STATIC2(TR_SM_HIGH_RES, "Found cpl (%d)\n", object_p->cpl);
	if(WiFiEngine_is_in_joining_state())
	{
		DE_TRACE_STATIC2(TR_SM_HIGH_RES, "store cpl value (%d)\n", object_p->cpl);
		
		WiFiEngine_store_cpl_state(1, object_p->cpl);
	}
	else
	{
		WiFiEngine_store_cpl_state(0, 0);
	}
   }
   else
   {
 	DE_TRACE_STATIC(TR_SM_HIGH_RES, "Did not find cpl\n");	
   }

} /* MacWrapper_m80211_ie_ccx_cpl_parameter_set_t */

void WrapperCopy_m80211_ie_ccx_tsm_parameter_set_t(void * context_p, m80211_ie_ccx_tsm_parameter_set_t * dest, m80211_ie_ccx_tsm_parameter_set_t * source)
{
   int ccx_element_size = source->hdr.hdr.len - M80211_IE_ID_VENDOR_SPECIFIC_HDR_SIZE;
   if(ccx_element_size!=4)
	return;

   *dest = *source;
}

void MacWrapper_m80211_ie_ccx_tsm_parameter_set_t(m80211_ie_ccx_tsm_parameter_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{

//   DE_TRACE_STATIC(TR_SM_HIGH_RES, "\n\n\n\n\nLOOK FOR CCX CPL OUI TYPE\n");
   /* FIXME: work with OUI done by MacWrapper_m80211_ie_vendor_specific_hdr_t(...,ACTION_PACK,...) 
    * will be overwritten by MacWrapper_array_t (ccx_version contain vendor header) */
   if (MacWrapper_m80211_ie_vendor_specific_hdr_t(&object_p->hdr, blob, action, 0x00, NULL))
   {
        // Check Id and length until we change MacWrapper_m80211_ie_vendor_specific_hdr_t.
        if (object_p->hdr.hdr.id != M80211_IE_ID_VENDOR_SPECIFIC  || object_p->hdr.hdr.len != 8)
        {
            // DE_TRACE_STATIC(TR_SM_HIGH_RES, "\nOOPS NO TSM\n");
            object_p->hdr.hdr.id  = M80211_IE_ID_NOT_USED;
            object_p->hdr.hdr.len = 0;
            return;
        }
	MacWrapper_uint8_t(&object_p->tsid, blob, action);
	MacWrapper_uint8_t(&object_p->state, blob, action);
	MacWrapper_uint16_t(&object_p->interval, blob, action);
    DE_TRACE_STATIC2(TR_SM_HIGH_RES, "TSID IS %d\n", object_p->tsid);

   }

} /* MacWrapper_m80211_ie_ccx_tsm_parameter_set_t */

void WrapperCopy_m80211_ie_wmm_tspec_parameter_set_t(void * context_p, m80211_wmm_tspec_ie_t * dest, m80211_wmm_tspec_ie_t * source)
{
   *dest = *source;
}


void MacWrapper_m80211_ie_wmm_tspec_parameter_set_t(m80211_wmm_tspec_ie_t* object_p, Blob_t* blob, WrapperAction_t action)
{
    /* Update the IE header. */
    if (MacWrapper_m80211_ie_WMM_header_t(&object_p->WMM_hdr, blob, action, WMM_IE_OUI_SUBTYPE_TSPEC))
    {
        MacWrapper_uint8_t(&object_p->WMM_Protocol_Version, blob, action);
        MacWrapper_array_t((char*)object_p->TSPEC_body, (sizeof(uint8_t)*55), blob, action);
    }
}

void WrapperCopy_m80211_ie_ccx_reassoc_req_parameter_set_t(void* context_p, m80211_ie_ccx_reassoc_req_parameter_set_t* dest, m80211_ie_ccx_reassoc_req_parameter_set_t* source)
{
	int ccx_element_size = source->hdr.hdr.len - M80211_IE_ID_VENDOR_SPECIFIC_HDR_SIZE;
	if (ccx_element_size != 20)
		return;
		
   *dest = *source;
}

void   MacWrapper_m80211_ie_ccx_reassoc_req_parameter_set_t(m80211_ie_ccx_reassoc_req_parameter_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
	if (ACTION_GET_SIZE == action)
	{
      if (object_p->hdr.hdr.id != M80211_IE_ID_NOT_USED)
      {
         blob->index += object_p->hdr.hdr.len + 2;
      }
      else
      {
         object_p->hdr.hdr.len = 0;
      }
      return;
   }
	
	/* Update the IE header. */
	if ( action == ACTION_PACK )
	{
		if(MacWrapper_m80211_ie_hdr_t(&object_p->hdr.hdr, blob, action, 
                                    M80211_IE_ID_CISCO_CCKM_VENDOR_SPECIFIC, 24, 24))
        {
			DE_TRACE_STATIC(TR_SM_HIGH_RES, "found 0x9c header\n");
			MacWrapper_uint8_t(&object_p->hdr.OUI_1, blob, action);
			MacWrapper_uint8_t(&object_p->hdr.OUI_2, blob, action);
			MacWrapper_uint8_t(&object_p->hdr.OUI_3, blob, action);
			MacWrapper_uint8_t(&object_p->hdr.OUI_type, blob, action);
		 
			MacWrapper_array_t((char*)&object_p->timestamp, 8, blob, action);
			MacWrapper_array_t((char*)&object_p->request_number, 4, blob, action);
			//MacWrapper_uint32_t(&object_p->request_number, blob, action);
			MacWrapper_array_t((char*)&object_p->MIC, 8, blob, action);
         }
		else
		{
			DE_TRACE_STATIC(TR_SM_HIGH_RES, "did not find 0x9c header\n");
        }
      }
}

void WrapperCopy_m80211_ie_ccx_reassoc_rsp_parameter_set_t(void* context_p, m80211_ie_ccx_reassoc_rsp_parameter_set_t* dest, m80211_ie_ccx_reassoc_rsp_parameter_set_t* source)
{
	int ccx_element_size = source->hdr.hdr.len - M80211_IE_ID_VENDOR_SPECIFIC_HDR_SIZE;
	
	if (source->hdr.hdr.id != 0x9c) {
		if (source->hdr.hdr.id != M80211_IE_ID_NOT_USED)
		return;
	}
			
  *dest = *source;

   dest->body_p = (char*)WrapperCopy_default(context_p, &dest->hdr.hdr, &source->hdr.hdr, 
							(void*)source->body_p, ccx_element_size);
}

void   MacWrapper_m80211_ie_ccx_reassoc_rsp_parameter_set_t(m80211_ie_ccx_reassoc_rsp_parameter_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
	if (ACTION_GET_SIZE == action)
	{
      if (object_p->hdr.hdr.id != M80211_IE_ID_NOT_USED)
      {
         blob->index += object_p->hdr.hdr.len + 2;
      }
      else
      {
         object_p->hdr.hdr.len = 0;
      }
      return;
   }
	
	/* Update the IE header, length should be greater than 24 which the length of the cckm request IE */
	if(MacWrapper_m80211_ie_hdr_t(&object_p->hdr.hdr, blob, action, 
                                    M80211_IE_ID_CISCO_CCKM_VENDOR_SPECIFIC, 28, 128))
    {
		int ccx_element_size = object_p->hdr.hdr.len - M80211_IE_ID_VENDOR_SPECIFIC_HDR_SIZE;
		
		MacWrapper_uint8_t(&object_p->hdr.OUI_1, blob, action);
		MacWrapper_uint8_t(&object_p->hdr.OUI_2, blob, action);
		MacWrapper_uint8_t(&object_p->hdr.OUI_3, blob, action);
		MacWrapper_uint8_t(&object_p->hdr.OUI_type, blob, action);
			
		if (action == ACTION_PACK ) {
			DE_TRACE_STATIC(TR_SM_HIGH_RES, "found 0x9c header for CCX RSP PACK ???\n");
        }
		
        if (action == ACTION_UNPACK)
        {
			object_p->body_p = (char*)WrapperAttachStructure(blob->structure, ccx_element_size);
		}
		
		MacWrapper_array_t((char*)object_p->body_p, ccx_element_size, blob, action);
	}
}

#endif //DE_CCX

void MacWrapper_m80211_ie_challenge_text_t(m80211_ie_challenge_text_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_CHALLENGE_TEXT, 0, 255))
   {
      /* The length member is implicitly set by MacWrapper_m80211_ie_hdr_t. */
      MacWrapper_array_t((char*)&object_p->challenge_text[0], object_p->hdr.len, blob, action);
   }
} /* MacWrapper_m80211_ie_challenge_text_t */


void MacWrapper_m80211_ie_ibss_par_set_t(m80211_ie_ibss_par_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_IBSS_PAR_SET, 2, 2))
   {
      MacWrapper_uint16_t(&object_p->atim_window, blob, action);
   }
} /* MacWrapper_m80211_ie_ibss_par_set_t */


void MacWrapper_m80211_ie_request_info_t(m80211_ie_request_info_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_REQUEST, 1, 1))
   {
      MacWrapper_uint8_t(&object_p->requested_element_id, blob, action);
   }
} /* MacWrapper_m80211_ie_request_info_t */

void WrapperCopy_m80211_ie_country_t(void* context_p, m80211_ie_country_t* dest, m80211_ie_country_t* source)
{
   int  channel_info_size;

   *dest = *source;

   if ( (source->hdr.id != M80211_IE_ID_NOT_USED) 
     && (source->hdr.len >= M80211_IE_LEN_COUNTRY_STRING + M80211_IE_CHANNEL_INFO_TRIPLET_SIZE) )
   {
      int  channel_info_count;
      channel_info_count = (source->hdr.len - M80211_IE_LEN_COUNTRY_STRING) / M80211_IE_CHANNEL_INFO_TRIPLET_SIZE;
      channel_info_size  = channel_info_count * sizeof(m80211_country_channels_t);
   }
   else
   {
      channel_info_size = 0;
   }

   dest->channel_info = (m80211_country_channels_t*)
      WrapperCopy_default(context_p, &dest->hdr, &source->hdr, (void*)source->channel_info, channel_info_size);
}

void MacWrapper_m80211_ie_country_t(m80211_ie_country_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   int i;

   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_COUNTRY, 6, 46))
   {
      int  channel_info_count;
      int  channel_info_size;
      
      
      MacWrapper_m80211_country_string_t(&object_p->country_string, blob, action);     

      if (object_p->hdr.len >= M80211_IE_LEN_COUNTRY_STRING + M80211_IE_CHANNEL_INFO_TRIPLET_SIZE)
      {
         channel_info_count = (object_p->hdr.len - M80211_IE_LEN_COUNTRY_STRING) / M80211_IE_CHANNEL_INFO_TRIPLET_SIZE;
         channel_info_size  = channel_info_count * M80211_IE_CHANNEL_INFO_TRIPLET_SIZE;
         
         /* The channel info is encoded as a dynamic number of triplets. 
            Clear the channel info field and copy the codes present in the IE. 
          */
         if (action == ACTION_UNPACK)
         {
            /* Before unpacking the elements of this IE, allocate a buffer for it. */
            object_p->channel_info = (m80211_country_channels_t*)WrapperAttachStructure(blob->structure, 
                                                                     channel_info_size);         
            DE_MEMSET((char*)object_p->channel_info, 0, channel_info_size);
         }
         for (i=0; i<channel_info_count; i++)
         {
            MacWrapper_array_t((char*)&object_p->channel_info[i], M80211_IE_CHANNEL_INFO_TRIPLET_SIZE, blob, action);
         }
      } 
      else
      {
         if (action == ACTION_UNPACK)
         {
            object_p->channel_info = NULL;
         }
      }        
   }
} /* MacWrapper_m80211_ie_country_t */

#if (DE_CCX == CFG_INCLUDED)
void WrapperCopy_m80211_ie_qbss_load_t(void* context_p, m80211_ie_qbss_load_t* dest, m80211_ie_qbss_load_t* source)
{
    *dest = *source;    /* fixed size IE */
}

void MacWrapper_m80211_ie_qbss_load_t(m80211_ie_qbss_load_t* object_p, Blob_t* blob, WrapperAction_t action)
{
    if (MacWrapper_m80211_ie_hdr_t(&object_p->hdr, blob, action,
                                   M80211_IE_ID_QBSS_LOAD, 5, 5))
    {
        MacWrapper_uint16_t(&object_p->station_cnt, blob, action);
        MacWrapper_uint8_t (&object_p->channel_util, blob, action);
        MacWrapper_uint16_t(&object_p->avail_adm_capa, blob, action);
    }
} /* MacWrapper_m80211_ie_qbss_load_t */
#endif

void MacWrapper_m80211_ie_cf_par_set_t(m80211_ie_cf_par_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_CF_PAR_SET, 6, 6))
   {
      MacWrapper_uint8_t(&object_p->cf_timing.count, blob, action);
      MacWrapper_uint8_t(&object_p->cf_timing.period, blob, action);
      MacWrapper_uint16_t(&object_p->max_duration, blob, action);
      MacWrapper_uint16_t(&object_p->duration_remaining, blob, action);
   }
} /* MacWrapper_m80211_ie_cf_par_set_t */


void MacWrapper_m80211_ie_ds_par_set_t(m80211_ie_ds_par_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_DS_PAR_SET, 1, 1))
   {
      MacWrapper_uint8_t(&object_p->channel, blob, action);
   }
} /* MacWrapper_m80211_ie_ds_par_set_t */


void MacWrapper_m80211_ie_fh_par_set_t(m80211_ie_fh_par_set_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_FH_PAR_SET, 5, 5))
   {
      MacWrapper_uint16_t(&object_p->dwell_time, blob, action);
      MacWrapper_uint8_t(&object_p->hop_set, blob, action);
      MacWrapper_uint8_t(&object_p->hop_pattern, blob, action);
      MacWrapper_uint8_t(&object_p->hop_index, blob, action);
   }
} /* MacWrapper_m80211_ie_fh_par_set_t */


void MacWrapper_m80211_ie_erp_t(m80211_ie_erp_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_ERP, 1, 1))
   {
      MacWrapper_uint8_t(&object_p->info, blob, action);
   }
} /* MacWrapper_m80211_ie_erp_t */

void MacWrapper_m80211_ie_WMM_information_element_t(m80211_ie_WMM_information_element_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (ACTION_GET_SIZE == action)
   {
      if (object_p->WMM_hdr.hdr.hdr.id != M80211_IE_ID_NOT_USED)
      {
         blob->index += object_p->WMM_hdr.hdr.hdr.len + 2;
      }
      else
      {
         object_p->WMM_hdr.hdr.hdr.len = 0;
      }
      return;
   }
   
   if (MacWrapper_m80211_ie_WMM_header_t(&object_p->WMM_hdr, blob, action, WMM_IE_OUI_SUBTYPE_INFORMATION))
   {
      MacWrapper_uint8_t(&object_p->WMM_Protocol_Version, blob, action);
      MacWrapper_uint8_t(&object_p->WMM_QoS_Info, blob, action);

      /* Update the IE header. */
      if ( (action == ACTION_PACK) || (action == ACTION_GET_SIZE) )
      {
         /* Use a temporary context for inserting an updated header at the rigth position. */
         Blob_t tmp_blob = *blob;
         BLOB_POP_CURRENT_IE(&tmp_blob);
         object_p->WMM_hdr.hdr.hdr.len = BLOB_CURRENT_SIZE(blob) - BLOB_CURRENT_SIZE(&tmp_blob) - 2;
         MacWrapper_m80211_ie_hdr_t(&object_p->WMM_hdr.hdr.hdr, &tmp_blob, action, 
                                    M80211_IE_ID_VENDOR_SPECIFIC, 1, M80211_IE_MAX_LEN);
      }
   }
} /* MacWrapper_m80211_ie_WMM_information_element_t */

void MacWrapper_m80211_ie_WMM_parameter_element_t(m80211_ie_WMM_parameter_element_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_WMM_header_t(&object_p->WMM_hdr, blob, action, WMM_IE_OUI_SUBTYPE_PARAMETERS))
   {    
      MacWrapper_uint8_t(&object_p->WMM_Protocol_Version, blob, action);
      MacWrapper_uint8_t(&object_p->WMM_QoS_Info, blob, action);
      MacWrapper_uint8_t(&object_p->reserved, blob, action);
      MacWrapper_AC_parameters_t(&object_p->AC_BE, blob, action);
      MacWrapper_AC_parameters_t(&object_p->AC_BK, blob, action);
      MacWrapper_AC_parameters_t(&object_p->AC_VI, blob, action);
      MacWrapper_AC_parameters_t(&object_p->AC_VO, blob, action);
      
      /* Update the IE header. */
      if ( (action == ACTION_PACK) || (action == ACTION_GET_SIZE) )
      {
         /* Use a temporary context for inserting an updated header at the rigth position. */
         Blob_t tmp_blob = *blob;
         BLOB_POP_CURRENT_IE(&tmp_blob);
         object_p->WMM_hdr.hdr.hdr.len = BLOB_CURRENT_SIZE(blob) - BLOB_CURRENT_SIZE(&tmp_blob) - 2;
         MacWrapper_m80211_ie_hdr_t(&object_p->WMM_hdr.hdr.hdr, &tmp_blob, action, 
                                    M80211_IE_ID_VENDOR_SPECIFIC, 1, M80211_IE_MAX_LEN);
      }
   }
} /* MacWrapper_m80211_ie_WMM_parameter_element_t */

void MacWrapper_m80211_ie_qos_capability_t(m80211_ie_qos_capability_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_QOS_CAPABILITY, 1, 1))
   {
      MacWrapper_uint8_t(&object_p->qos_info, blob, action);
   }
} /* MacWrapper_m80211_ie_qos_capability_t */


void WrapperCopy_m80211_remaining_IEs_t(void* context_p, m80211_remaining_IEs_t* dest_p, m80211_remaining_IEs_t* source_p)
{
   int         enumeration;
   ie_ref_t    source_ref;

   if ( (source_p == NULL) || (dest_p == NULL) )
   {
      return;
   }

   /* We cant just copy the pointers, new buffers must be allocated. */
   dest_p->buffer_ref  = NULL;

   /* Wrapper structures are always set to M80211_IE_ID_NOT_USED when created. */
   if (source_p->count <= 0) 
   {
      *dest_p = *source_p;

      /* The source is not set. */
      return;
   }

   /* Get first IE. */
   source_ref = (ie_ref_t)source_p->buffer_ref;
   
   /* Copy IE objects one by one... */
   for (enumeration = 0; enumeration < source_p->count; enumeration++)
   {
      MacWrapper_m80211_remaining_IEs_t_Insert(context_p, dest_p, source_ref);

      source_ref = (ie_ref_t)WrapperNextInChain(source_ref);
   }
}

ie_ref_t MacWrapper_m80211_remaining_IEs_t_Insert(void* context_p, 
                                                  m80211_remaining_IEs_t* dest_p, 
                                                  ie_ref_t                ie_p)
{
   ie_ref_t dest_ref;
   int      ie_length;;

   if ( (ie_p == NULL) || (dest_p == NULL) )
   {
      return NULL;
   }

   ie_length = ie_p[1] + 2;

   if ( (dest_p->buffer_ref == NULL) || (dest_p->buffer_ref == NIL) )
   {
      /* Note that the context_p is unknown to this function and may only be passed to the allocator function. */
      dest_ref = (ie_ref_t)WrapperAttachStructure(context_p, ie_length);
      dest_p->count = 0;
      dest_p->acc_size = 0;
      dest_p->buffer_ref = dest_ref;         
   }
   else
   {
      dest_ref = (ie_ref_t)WrapperAttachStructure(dest_p->buffer_ref, ie_length);
   }      
   
   if (dest_ref != NULL)
   {
      dest_p->count++;
      dest_p->acc_size+=ie_length;
      DE_MEMCPY(dest_ref, ie_p, ie_length);
   }

   return dest_ref;
}

ie_ref_t MacWrapper_m80211_remaining_IEs_t_InsertNew(void* context_p, 
                                                     m80211_remaining_IEs_t* dest_p, 
                                                     m80211_ie_id_t id, int ie_length)
{
   ie_ref_t dest_ref;
   char     source_ref[2]; 

   IE_ID(source_ref)       = id;
   IE_LENGTH(source_ref)   = ie_length;
   
   dest_ref = MacWrapper_m80211_remaining_IEs_t_Insert(context_p, dest_p, (ie_ref_t)&source_ref);

   return dest_ref;
}

ie_ref_t MacWrapper_m80211_remaining_IEs_t_LocateNext(ie_ref_t           ie_ref, 
                                                      bool_t             skip_current,  
                                                      m80211_ie_id_t     id,
                                                      int                vendor_specific_oui,
                                                      int                oui_sub_type)
{
   m80211_ie_id_t current_id;

   if (skip_current)
   {
      ie_ref = (ie_ref_t)WrapperNextInChain(ie_ref);
   }
 
   /* Search IE objects one by one... */
   while ( (ie_ref != NULL) && ( ie_ref != NIL) )
   {
      /* Get the id of the current IE. */
      current_id = ie_ref[0];

      if (current_id == id)
      {
         if (vendor_specific_oui == NOT_VENDOR_SPECIFIC)
         {
            return ie_ref;
         }
         if ( (vendor_specific_oui == IE_VENDOR_SPECIFIC_HEADER(ie_ref)->OUI_type)
             && (IE_VENDOR_SPECIFIC_HEADER(ie_ref)->OUI_1 == 0x00) 
             && (IE_VENDOR_SPECIFIC_HEADER(ie_ref)->OUI_2 == 0x50) 
             && (IE_VENDOR_SPECIFIC_HEADER(ie_ref)->OUI_3 == 0xf2) 
            )
         {
            if (vendor_specific_oui == WMM_IE_OUI_TYPE)
            {
               if (oui_sub_type == IE_WMM_HEADER(ie_ref)->OUI_Subtype)
               {
                  return ie_ref;
               }
            }
            else
            {
               return ie_ref;
            }
         }
      }

      ie_ref = (ie_ref_t)WrapperNextInChain(ie_ref);
   }
   return NULL;
}

ie_ref_t MacWrapper_m80211_remaining_IEs_t_Locate(m80211_remaining_IEs_t* remaining_ies, m80211_ie_id_t id, int vendor_specific_oui, int oui_sub_type)
{
   return MacWrapper_m80211_remaining_IEs_t_LocateNext(remaining_ies->buffer_ref, FALSE, id, vendor_specific_oui, oui_sub_type);   
}

void MacWrapper_m80211_remaining_IEs_t_Remove(m80211_remaining_IEs_t* remaining_ies, m80211_ie_id_t id)
{
   int                  enumeration;
   m80211_ie_id_t       current_id;
   ie_ref_t             ie_ref;
   struct wrapper_alloc_buf* previous_buf_hdr;
 
   /* Wrapper structures are always set to M80211_IE_ID_NOT_USED when created. */
   if ( (remaining_ies == NULL) || ( remaining_ies->count <=  0) )
   {
      /* The IE is not set. */
      return;
   }

   /* Get first IE. */
   ie_ref = remaining_ies->buffer_ref;

   previous_buf_hdr = NULL;
   
   /* Search IE objects one by one... */
   for (enumeration = 0; enumeration < remaining_ies->count; enumeration++)
   {
      /* Get the id of the current IE. */
      current_id = ie_ref[0];

      if (current_id == id)
      {
         if (previous_buf_hdr == NULL)
         {
            remaining_ies->buffer_ref = (ie_ref_t)WrapperNextInChain(ie_ref);
         }
         else
         {
            previous_buf_hdr->next_in_chain = (ie_ref_t)WrapperNextInChain(ie_ref);
         }
         return;
      }

      previous_buf_hdr = (struct wrapper_alloc_buf*)((char*)ie_ref - sizeof(struct wrapper_alloc_buf));
      ie_ref = (ie_ref_t)WrapperNextInChain(ie_ref);
   }
}

void MacWrapper_m80211_remaining_IEs_t(m80211_remaining_IEs_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   int      enumeration;
   int      ie_length;
   ie_ref_t buffer_ref;
   
   switch (action)
   {
      case  ACTION_UNPACK:
      {        
         if (blob->ie_first_index == 0)
         {
            /* Store the index of the first information element. */
            BLOB_PUSH_IE(blob);
         }
         else
         {
            /* Restore the index of the first information element. */
            BLOB_POP_IE(blob);
         }

         /* Store an index to the currently processed IE. */
         BLOB_SET_CURRENT_IE(blob);

         enumeration = 0;
         object_p->count      = 0;
         object_p->acc_size   = 0;
         object_p->buffer_ref = NULL;
 
         /* Scan through all information elements to find the current one. */
         while ( blob->index < blob->length )
         {
            /* Get the object length. */
            ie_length = ((uint8_t*)BLOB_CURRENT_POS(blob))[1] + 2;

            if ( (ie_length == 2) || (ie_length > BLOB_REMAINING_SIZE(blob)) )
            {
               /* Corrupt indata, like in probe responses from Open WRT on linksys... */
               BLOB_BUF_RESIZE(blob, BLOB_CURRENT_SIZE(blob));
            }
            else
            {
               /* An IE object was found, lets see if it is already extracted. */
               if (!(blob->ie_map & (1 << enumeration)))
               {
                  /* Noop, mark it as taken and store it */
                  blob->ie_map |= (1 << enumeration);

                  MacWrapper_m80211_remaining_IEs_t_Insert(blob->structure, object_p, (ie_ref_t)BLOB_CURRENT_POS(blob));
               }
               
               BLOB_SKIP(blob, ie_length);
               
               enumeration++;
               HIC_ASSERT(enumeration < 32);
            }
         }
      }
      break;

      case ACTION_GET_SIZE:
         if (object_p->acc_size > 0)
         {
            BLOB_SKIP(blob, object_p->acc_size);
         }
         break;
       
      case ACTION_PACK:
      {  
         char* pos;
         buffer_ref = object_p->buffer_ref;

         /* Wrapper structures are always set to 0xFF (M80211_IE_ID_NOT_USED) when created. */
         if ( ( object_p->count > 0) && (object_p->acc_size > 0) )
         {
            /* Insert objects in reverse order... */
            pos = &blob->buffer[blob->index + object_p->acc_size];
            for (enumeration = 0; enumeration < object_p->count; enumeration++)
            {
               DE_TRACE_INT4(TR_SCAN, "inserting unmaped IE (%d/%d), id: %d len: %d\n", 
                  enumeration , object_p->count, 
                  buffer_ref[0], buffer_ref[1]);

               /* Step back the size of the IE. */
               ie_length = buffer_ref[1] + 2;
               pos -= ie_length;
               DE_MEMCPY(pos, buffer_ref, ie_length);
               buffer_ref = (ie_ref_t)WrapperNextInChain(buffer_ref);
            }
            BLOB_SKIP(blob, object_p->acc_size);
         }
      }
   }
} /* MacWrapper_m80211_ie_country_t */

void MacWrapper_radio_meas_req_hdr_t(radio_meas_req_hdr_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_uint8_t(&object_p->regulatory_class, blob, action);
   MacWrapper_uint8_t(&object_p->channel_number, blob, action);
   MacWrapper_uint16_t(&object_p->random_interval, blob, action);
   MacWrapper_uint16_t(&object_p->measurement_duration, blob, action);
} /* MacWrapper_radio_meas_req_hdr_t */


void MacWrapper_m80211_ie_measurement_report_t(m80211_ie_measurement_report_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_MEASUREMENT_REPORT, 0, 64))
   {   
      MacWrapper_uint8_t(&object_p->token, blob, action);
      MacWrapper_uint8_t(&object_p->mode, blob, action);
      MacWrapper_m80211_measurement_types_t(&object_p->type, blob, action);
      switch (object_p->type) 
      {
      case M80211_MEASUREMENT_CHANNEL_LOAD_REP:
         MacWrapper_channel_load_rep_t(&object_p->rep.channel_load_rep, blob, action);
         break;

      case M80211_MEASUREMENT_NOISE_HISTOGRAM_REP:
         MacWrapper_noise_histogram_rep_t(&object_p->rep.noise_histogram_rep, blob, action);
         break;

      case M80211_MEASUREMENT_BEACON_REP:
         MacWrapper_beacon_rep_t(&object_p->rep.beacon_rep, blob, action);
         break;

      }
       
   }
} /* MacWrapper_m80211_ie_measurement_report_t */ 

void MacWrapper_m80211_ie_measurement_request_t(m80211_ie_measurement_request_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   if (MacWrapper_m80211_ie_hdr_t((m80211_ie_hdr_t*)object_p, blob, action, 
                                  M80211_IE_ID_MEASUREMENT_REQUEST, 0, 64))
   {   
      MacWrapper_uint8_t(&object_p->token, blob, action); 
      MacWrapper_uint8_t(&object_p->mode, blob, action);
      MacWrapper_m80211_measurement_types_t(&object_p->type, blob, action);
      switch (object_p->type)
      {
      case M80211_MEASUREMENT_CHANNEL_LOAD_REQ:
         MacWrapper_channel_load_req_t(&object_p->req.channel_load_req, blob, action);
         break;

      case M80211_MEASUREMENT_NOISE_HISTOGRAM_REQ:
         MacWrapper_noise_histogram_req_t(&object_p->req.noise_histogram_req, blob, action);
         break;

      case M80211_MEASUREMENT_BEACON_REQ:
         MacWrapper_beacon_req_t(&object_p->req.beacon_req, blob, action);
         break;

      case M80211_MEASUREMENT_LCI_REQ:
         MacWrapper_lci_req_t(&object_p->req.lci_req, blob, action);
         break;

      }
      
   }
} /* MacWrapper_m80211_ie_measurement_request_t */ 

/*****************************************************************************
G L O B A L   C A C H E   F U N C T I O N S
*****************************************************************************/
#define MacWrapper_m80211_mgmt_status_t MacWrapper_uint16_t

#define MacWrapper_m80211_ie_id_t MacWrapper_uint8_t

#define MacWrapper_m80211_ie_len_t MacWrapper_uint8_t

void MacWrapper_m80211_oui_id_t(m80211_oui_id_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_array_t((char*)object_p->octet, (sizeof(char)*3), blob, action);
} /* MacWrapper_m80211_oui_id_t */

#define MacWrapper_m80211_cipher_suite_t MacWrapper_uint8_t

#define MacWrapper_m80211_akm_suite_t MacWrapper_uint8_t

#define MacWrapper_m80211_measurement_mode_t MacWrapper_uint8_t

#define MacWrapper_m80211_measurement_report_mode_t MacWrapper_uint8_t

#define MacWrapper_m80211_action_category_t MacWrapper_uint8_t

#define MacWrapper_m80211_radio_measurement_action_detail_t MacWrapper_uint8_t

#define MacWrapper_m80211_beacon_mode_t MacWrapper_uint8_t

#define MacWrapper_m80211_beacon_report_condition_t MacWrapper_uint8_t

#define MacWrapper_m80211_threshold_offset MacWrapper_int8_t

#define MacWrapper_m80211_location_subject_t MacWrapper_uint8_t

#define MacWrapper_m80211_latitude_requested_resolution_t MacWrapper_uint8_t

#define MacWrapper_m80211_longitude_requested_resolution_t MacWrapper_uint8_t

#define MacWrapper_m80211_altitude_requested_resolution_t MacWrapper_uint8_t

#define MacWrapper_m80211_azimuth_request_t MacWrapper_uint8_t

void MacWrapper_m80211_cipher_suite_selector_t(m80211_cipher_suite_selector_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_m80211_oui_id_t(&object_p->id, blob, action);
   MacWrapper_m80211_cipher_suite_t(&object_p->type, blob, action);
} /* MacWrapper_m80211_cipher_suite_selector_t */

void MacWrapper_m80211_akm_suite_selector_t(m80211_akm_suite_selector_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_m80211_oui_id_t(&object_p->id, blob, action);
   MacWrapper_m80211_akm_suite_t(&object_p->type, blob, action);
} /* MacWrapper_m80211_akm_suite_selector_t */

void MacWrapper_m80211_pmkid_selector_t(m80211_pmkid_selector_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_array_t((char*)object_p->octet, (sizeof(uint8_t)*M80211_IE_LEN_PMKID), blob, action);
} /* MacWrapper_m80211_pmkid_selector_t */

void MacWrapper_suite_selector_t(suite_selector_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_m80211_cipher_suite_selector_t(&object_p->cipher, blob, action);
} /* MacWrapper_suite_selector_t */

void MacWrapper_m80211_max_regulatory_power_t(m80211_max_regulatory_power_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_int8_t(&object_p->max_dBm, blob, action);
} /* MacWrapper_m80211_max_regulatory_power_t */

void MacWrapper_m80211_max_tx_power_t(m80211_max_tx_power_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_int8_t(&object_p->tx_dBm, blob, action);
} /* MacWrapper_m80211_max_tx_power_t */

void MacWrapper_m80211_tx_power_used_t(m80211_tx_power_used_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_int8_t(&object_p->tx_dBm, blob, action);
} /* MacWrapper_m80211_tx_power_used_t */

void MacWrapper_m80211_trx_noise_floor_t(m80211_trx_noise_floor_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_int8_t(&object_p->tx_dBm, blob, action);
} /* MacWrapper_m80211_trx_noise_floor_t */

void MacWrapper_meas_req_hdr_t(meas_req_hdr_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_m80211_action_category_t(&object_p->category, blob, action);
   MacWrapper_m80211_radio_measurement_action_detail_t(&object_p->action, blob, action);
   MacWrapper_uint8_t(&object_p->dialog_token, blob, action);
   MacWrapper_uint8_t(&object_p->filler, blob, action);
   MacWrapper_uint16_t(&object_p->number_of_rep, blob, action);
} /* MacWrapper_meas_req_hdr_t */

void MacWrapper_meas_rep_hdr_t(meas_rep_hdr_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_m80211_action_category_t(&object_p->category, blob, action);
   MacWrapper_m80211_radio_measurement_action_detail_t(&object_p->action, blob, action);
   MacWrapper_uint8_t(&object_p->dialog_token, blob, action);
} /* MacWrapper_meas_rep_hdr_t */

void MacWrapper_radio_meas_rep_hdr_t(radio_meas_rep_hdr_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_uint8_t(&object_p->regulatory_class, blob, action);
   MacWrapper_uint8_t(&object_p->channel_number, blob, action);
   MacWrapper_uint16_t(&object_p->random_interval, blob, action);
   MacWrapper_uint16_t(&object_p->measurement_duration, blob, action);
} /* MacWrapper_radio_meas_rep_hdr_t */

void MacWrapper_lci_req_t(lci_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_radio_meas_req_hdr_t(&object_p->hdr, blob, action);
   MacWrapper_m80211_location_subject_t(&object_p->loc_subj, blob, action);
   MacWrapper_m80211_latitude_requested_resolution_t(&object_p->lat_req, blob, action);
   MacWrapper_m80211_longitude_requested_resolution_t(&object_p->long_req, blob, action);
   MacWrapper_m80211_altitude_requested_resolution_t(&object_p->alt_req, blob, action);
   MacWrapper_m80211_azimuth_request_t(&object_p->azi_req, blob, action);
} /* MacWrapper_lci_req_t */

void MacWrapper_channel_load_req_t(channel_load_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_radio_meas_req_hdr_t(&object_p->hdr, blob, action);
} /* MacWrapper_channel_load_req_t */

void MacWrapper_channel_load_rep_t(channel_load_rep_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_radio_meas_rep_hdr_t(&object_p->hdr, blob, action);
} /* MacWrapper_channel_load_rep_t */

void MacWrapper_noise_histogram_req_t(noise_histogram_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_radio_meas_req_hdr_t(&object_p->hdr, blob, action);
} /* MacWrapper_noise_histogram_req_t */

void MacWrapper_noise_histogram_rep_t(noise_histogram_rep_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_radio_meas_rep_hdr_t(&object_p->hdr, blob, action);
} /* MacWrapper_noise_histogram_rep_t */

void MacWrapper_beacon_req_t(beacon_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_radio_meas_req_hdr_t(&object_p->hdr, blob, action);
   MacWrapper_m80211_beacon_mode_t(&object_p->mode, blob, action);
   MacWrapper_m80211_mac_addr_t(&object_p->bssid, blob, action);
   MacWrapper_m80211_beacon_report_condition_t(&object_p->report_condition, blob, action);
   MacWrapper_m80211_threshold_offset(&object_p->thr_off, blob, action);
   MacWrapper_m80211_ie_ssid_t(&object_p->ssid, blob, action);
} /* MacWrapper_beacon_req_t */

void MacWrapper_beacon_rep_t(beacon_rep_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_radio_meas_rep_hdr_t(&object_p->hdr, blob, action);
   MacWrapper_m80211_beacon_mode_t(&object_p->mode, blob, action);
   MacWrapper_m80211_mac_addr_t(&object_p->bssid, blob, action);
   MacWrapper_m80211_beacon_report_condition_t(&object_p->report_condition, blob, action);
   MacWrapper_m80211_threshold_offset(&object_p->thr_off, blob, action);
   MacWrapper_m80211_ie_ssid_t(&object_p->ssid, blob, action);
} /* MacWrapper_beacon_rep_t */

void MacWrapper_m80211k_request(m80211k_request* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_channel_load_req_t(&object_p->channel_load_req, blob, action);
} /* MacWrapper_m80211k_request */

void MacWrapper_m80211k_report(m80211k_report* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_array_t((char*)object_p->buf, (sizeof(uint8_t)*200), blob, action);
} /* MacWrapper_m80211k_report */

void MacWrapper_m80211_radio_measurement_req_t(m80211_radio_measurement_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_meas_req_hdr_t(&object_p->hdr, blob, action);
   MacWrapper_m80211_ie_measurement_request_t(&object_p->measurement, blob, action);
} /* MacWrapper_m80211_radio_measurement_req_t */

void MacWrapper_m80211_radio_measurement_rep_t(m80211_radio_measurement_rep_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_meas_rep_hdr_t(&object_p->hdr, blob, action);
   MacWrapper_m80211_ie_measurement_report_t(&object_p->measurement, blob, action);
} /* MacWrapper_m80211_radio_measurement_rep_t */

void MacWrapper_AC_parameters_t(AC_parameters_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_uint8_t(&object_p->ACI_ACM_AIFSN, blob, action);
   MacWrapper_uint8_t(&object_p->ECWmin_ECWmax, blob, action);
   MacWrapper_uint16_t(&object_p->TXOP_Limit, blob, action);
} /* MacWrapper_AC_parameters_t */

void MacWrapper_mac_mmpdu_mpilot_t(mac_mmpdu_mpilot_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_uint64_t(&object_p->timestamp, blob, action);
   MacWrapper_uint16_t(&object_p->mpilot_interval, blob, action);
   MacWrapper_uint16_t(&object_p->beacon_period, blob, action);
   MacWrapper_uint16_t(&object_p->capability_info, blob, action);
   MacWrapper_m80211_country_string_t(&object_p->country_string, blob, action);
   MacWrapper_m80211_max_regulatory_power_t(&object_p->max_reg_power, blob, action);
   MacWrapper_m80211_max_tx_power_t(&object_p->max_tx_power, blob, action);
   MacWrapper_m80211_tx_power_used_t(&object_p->tx_power_used, blob, action);
   MacWrapper_m80211_trx_noise_floor_t(&object_p->trx_noise_floor, blob, action);
   MacWrapper_m80211_ie_ds_par_set_t(&object_p->ds_parameter_set, blob, action);
} /* MacWrapper_mac_mmpdu_mpilot_t */

void MacWrapper_mac_mmpdu_authenticate_t(mac_mmpdu_authenticate_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_uint16_t(&object_p->algorithm_number, blob, action);
   MacWrapper_uint16_t(&object_p->sequence_number, blob, action);
   MacWrapper_m80211_mgmt_status_t(&object_p->status_code, blob, action);
   MacWrapper_m80211_ie_challenge_text_t(&object_p->challenge_text, blob, action);
} /* MacWrapper_mac_mmpdu_authenticate_t */

void MacWrapper_mac_mmpdu_deauthenticate_t(mac_mmpdu_deauthenticate_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_uint16_t(&object_p->reason, blob, action);
} /* MacWrapper_mac_mmpdu_deauthenticate_t */

void MacWrapper_mac_mmpdu_associate_req_t(mac_mmpdu_associate_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_uint16_t(&object_p->capability_info, blob, action);
   MacWrapper_uint16_t(&object_p->listen_interval, blob, action);
   MacWrapper_common_IEs_t(&object_p->ie, blob, action);
} /* MacWrapper_mac_mmpdu_associate_req_t */

void MacWrapper_mac_mmpdu_associate_rsp_t(mac_mmpdu_associate_rsp_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_uint16_t(&object_p->capability_info, blob, action);
   MacWrapper_m80211_mgmt_status_t(&object_p->status_code, blob, action);
   MacWrapper_uint16_t(&object_p->aid, blob, action);
   MacWrapper_common_IEs_t(&object_p->ie, blob, action);
} /* MacWrapper_mac_mmpdu_associate_rsp_t */

void MacWrapper_mac_mmpdu_reassociate_req_t(mac_mmpdu_reassociate_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_uint16_t(&object_p->capability_info, blob, action);
   MacWrapper_uint16_t(&object_p->listen_interval, blob, action);
   MacWrapper_m80211_mac_addr_t(&object_p->bssId, blob, action);
   MacWrapper_common_IEs_t(&object_p->ie, blob, action);
} /* MacWrapper_mac_mmpdu_reassociate_req_t */

void MacWrapper_mac_mmpdu_disassociate_t(mac_mmpdu_disassociate_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_uint16_t(&object_p->reason_code, blob, action);
} /* MacWrapper_mac_mmpdu_disassociate_t */

void MacWrapper_mac_mmpdu_radio_measurement_req_t(mac_mmpdu_radio_measurement_req_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_m80211_radio_measurement_req_t(&object_p->mreq_body, blob, action);
} /* MacWrapper_mac_mmpdu_radio_measurement_req_t */

void MacWrapper_mac_mmpdu_radio_measurement_rep_t(mac_mmpdu_radio_measurement_rep_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_m80211_radio_measurement_rep_t(&object_p->mrep_body, blob, action);
} /* MacWrapper_mac_mmpdu_radio_measurement_rep_t */

void MacWrapper_mac_mgmt_body_t(mac_mgmt_body_t* object_p, Blob_t* blob, WrapperAction_t action)
{
   MacWrapper_mac_mmpdu_beacon_ind_t(&object_p->mac_mmpdu_beacon_ind, blob, action);
} /* MacWrapper_mac_mgmt_body_t */


/*****************************************************************************
G L O B A L   A C C E S S   F U N C T I O N S
*****************************************************************************/

/******************************* END OF FILE ********************************/


