#include <wx/textdlg.h>
#include <wx/msgdlg.h>
#include <wx/menu.h>
#include <wx/xrc/xmlres.h>
#include "imanager.h"
#include "qmakesettingsdlg.h"
#include "qmakesettingstab.h"
#include "qmakeconf.h"
#include "windowattrmanager.h"
#include <wx/log.h>

QMakeSettingsDlg::QMakeSettingsDlg( wxWindow* parent, IManager *manager, QmakeConf *conf )
		: QMakeSettingsBaseDlg( parent )
		, m_manager(manager)
		, m_conf(conf)
		, m_rightClickTabIdx(wxNOT_FOUND)
{
	Initialize();
	WindowAttrManager::Load(this, wxT("QMakeSettingsDlg"), m_manager->GetConfigTool());
}

void QMakeSettingsDlg::Initialize()
{
	if (!m_conf) {
		return;
	}

	wxString group;
	long     idx;
	bool cont = m_conf->GetFirstGroup(group, idx);
	while (cont) {

		QmakeSettingsTab *p = new QmakeSettingsTab(m_notebook, group);
		p->Load(m_conf);
		m_notebook->AddPage(p, group);

		cont = m_conf->GetNextGroup(group, idx);
	}
}

void QMakeSettingsDlg::OnNewQmakeSettings( wxCommandEvent& event )
{
	wxUnusedVar(event);

	wxString name = wxGetTextFromUser(wxT("New qmake settings name"), wxT("New qmake settings"));
	if (name.IsEmpty() == false) {
		m_notebook->AddPage(new QmakeSettingsTab(m_notebook, name), name, true);
	}
}

void QMakeSettingsDlg::OnOK(wxCommandEvent& event)
{
	// save the data and dismiss the dialog
	m_conf->DeleteAll();
	m_conf->Flush();

	for (size_t i=0; i<m_notebook->GetPageCount(); i++) {
		QmakeSettingsTab *tab = dynamic_cast<QmakeSettingsTab*>(m_notebook->GetPage(i));
		if (tab) {
			tab->Save(m_conf);
		}
	}
	EndModal(wxID_OK);
}


QMakeSettingsDlg::~QMakeSettingsDlg()
{
	WindowAttrManager::Save(this, wxT("QMakeSettingsDlg"), m_manager->GetConfigTool());
}


void QMakeSettingsDlg::OnRightDown(wxMouseEvent& event)
{
	long flags (0);
	m_rightClickTabIdx = m_notebook->HitTest(event.GetPosition(), &flags);
	if ( m_rightClickTabIdx != wxNOT_FOUND && flags & wxNB_HITTEST_ONLABEL ) {
		wxMenu menu;

		menu.Append(XRCID("rename_qmake"), wxT("Rename..."), wxEmptyString);
		menu.Append(XRCID("delete_qmake"), wxT("Delete"), wxEmptyString);

		menu.Connect(XRCID("rename_qmake"), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(QMakeSettingsDlg::OnRename), NULL, this);
		menu.Connect(XRCID("delete_qmake"), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(QMakeSettingsDlg::OnDelete), NULL, this);

		m_notebook->PopupMenu( &menu );
	}
}

void QMakeSettingsDlg::OnDelete(wxCommandEvent& event)
{
	if ( m_rightClickTabIdx != wxNOT_FOUND ) {
		wxString qmakeSettingsName = m_notebook->GetPageText( (size_t) m_rightClickTabIdx );
		int answer = wxMessageBox(wxString::Format(wxT("Are you sure you want to delete qmake settings '%s'?"), qmakeSettingsName.c_str()), wxT("CodeLite"), wxYES_NO|wxCANCEL, this);
		if ( answer == wxYES ) {
			m_notebook->DeletePage( (size_t) m_rightClickTabIdx );
		}
	}
}

void QMakeSettingsDlg::OnRename(wxCommandEvent& event)
{
	if ( m_rightClickTabIdx != wxNOT_FOUND ) {
		wxString qmakeSettingsName = m_notebook->GetPageText( (size_t) m_rightClickTabIdx );
		wxString newName           = wxGetTextFromUser(wxT("New name:"), wxT("Rename..."));
		if ( newName.empty() == false ) {
			QmakeSettingsTab *tab = dynamic_cast<QmakeSettingsTab*>(m_notebook->GetPage(m_rightClickTabIdx));
			if (tab) {
				tab->SetTabName( newName );
				m_notebook->SetPageText( (size_t) m_rightClickTabIdx, newName );
			}
		}
	}
}
