/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.JsUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.HTMLBlock;

public class Button
extends DOMElement {
    public Button(String id, View view, boolean create) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        if (create) {
            Button.createElementWithID("button", id, view);
        }
    }

    public Button(String id, String parentId, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("button", id, parentId);
    }

    public Button(String id, DOMElement parent, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("button", id, parent.getId());
    }

    public Button(String id, String parentId, View view, HTMLBlock content) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("button", id, parentId);
        if (content != null) {
            this.setInnerHTML(content.getHtml());
        }
    }

    public Button(String id, DOMElement parent, View view, HTMLBlock content) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("button", id, parent.getId());
        if (content != null) {
            this.setInnerHTML(content.getHtml());
        }
    }

    @Override
    public void setDisable(boolean disable) {
        if (disable) {
            this.setAttribute("disabled", "disabled");
            this.addClass("disabled");
        } else {
            this.removeAttribute("disabled");
            this.removeClass("disabled");
        }
    }

    public static Button retrieveButton(String id, View currentView) {
        if (Button.exist(id, currentView)) {
            return new Button(id, currentView, false);
        }
        return null;
    }
}

