/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dts.util;

import esecurity.dts.util.Connection;
import esecurity.dts.util.DTMPException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import org.slf4j.Logger;

public class DTMProtocol {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private byte flag;
    private byte[] data;

    public DTMProtocol() {
    }

    public DTMProtocol(byte[] value, byte flag) throws DTMPException {
        this.flag = flag;
        if (value == null) {
            throw new DTMPException("Expected a value");
        }
        this.data = new byte[value.length];
        System.arraycopy(value, 0, this.data, 0, value.length);
    }

    public void read(Connection conn) throws IOException, DTMPException, CapiException {
        this.readPDU(false, conn, 0, 0, 0);
    }

    public void readPDUZero(Connection conn, int minlen, int maxlen, int shutcode) throws IOException, DTMPException, CapiException {
        this.readPDU(true, conn, minlen, maxlen, shutcode);
    }

    public byte[] getData() {
        return this.data;
    }

    public void setFlag(byte value) {
        this.flag = value;
    }

    public byte getFlag() {
        return this.flag;
    }

    public void setData(byte[] value) {
        System.arraycopy(value, 0, this.data, 0, value.length);
    }

    public byte[] toByteArray() {
        if (this.data == null) {
            return null;
        }
        byte[] len = this.intToByteArray(this.data.length + 1);
        byte[] pdu = new byte[5 + this.data.length];
        System.arraycopy(len, 0, pdu, 0, 4);
        pdu[4] = this.flag;
        System.arraycopy(this.data, 0, pdu, 5, this.data.length);
        return pdu;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    private int byteArrayToInt(byte[] buf) {
        if (buf.length != 4) {
            throw new RuntimeException("strange byte array");
        }
        int value = 0;
        for (int i = 0; i < buf.length; ++i) {
            value |= (buf[i] & 0xFF) << (3 - i) * 8;
        }
        return value;
    }

    private byte[] intToByteArray(int value) {
        byte[] byteArr = new byte[4];
        for (int i = byteArr.length - 1; i >= 0; --i) {
            byteArr[i] = (byte)(value & 0xFF);
            value >>>= 8;
        }
        return byteArr;
    }

    private void readPDU(boolean iszero, Connection conn, int minlen, int maxlen, int shutcode) throws IOException, DTMPException, CapiException {
        byte[] len = new byte[4];
        for (int i = 0; i < len.length; ++i) {
            len[i] = conn.read();
        }
        int toRead = this.byteArrayToInt(len);
        logger.debug("toRead= " + toRead);
        if (iszero) {
            if (toRead < minlen) {
                throw new DTMPException("PKI length:" + toRead + " less than " + minlen);
            }
            if (toRead > maxlen) {
                throw new DTMPException("PKI length:" + toRead + " greater than " + maxlen);
            }
        }
        this.flag = conn.read();
        logger.debug("flag=" + this.flag + " toRead= " + --toRead);
        if (iszero && this.flag != 0 && this.flag != (byte)shutcode) {
            throw new DTMPException("PKI flag invalid:" + this.flag);
        }
        this.data = new byte[toRead];
        for (int i = 0; i < toRead; ++i) {
            this.data[i] = conn.read();
        }
        if (logger.isDebugEnabled()) {
            String fn = "./readpdudata.der";
            logger.debug("saving to file " + fn);
            Util.saveToFile(this.data, fn);
            fn = "./alldata.der";
            logger.debug("saving to file " + fn);
            byte[] all = new byte[this.data.length + 4 + 1];
            System.arraycopy(len, 0, all, 0, 4);
            all[4] = this.flag;
            System.arraycopy(this.data, 0, all, 5, this.data.length);
            Util.saveToFile(all, fn);
        }
    }
}

