/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import esecurity.validator.bean.PadesSpecific;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.bean.TstSpecific;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.parser.utils.SignerInfoUtils;
import java.util.LinkedList;

public class SignatureInformation {
    private SignatureFormat format;
    private ContainerFormat containerFormat;
    private String refsCertId;
    private final LinkedList<ReferenceDoc> refDocs;
    private final LinkedList<SignatureInformation> counterSignaturesInformation;
    private final LinkedList<SignatureInformation> timeStampTokens = new LinkedList();
    private boolean corrupted = false;
    private boolean containsGraphometricInfo = false;
    private byte[] signatureInfo;
    private SignerInfoData signerInfoData = null;
    private PadesSpecific padesSpecific = null;
    private String signerName = "";
    private String signatureDate = "";
    private boolean counterSignature = false;
    private TstSpecific tstSpecific = null;

    public SignatureInformation() {
        this.refDocs = new LinkedList();
        this.counterSignaturesInformation = new LinkedList();
    }

    public SignatureFormat getFormat() {
        return this.format;
    }

    public void setFormat(SignatureFormat format) {
        this.format = format;
    }

    public LinkedList<ReferenceDoc> getRefDocs() {
        return this.refDocs;
    }

    public void setRefDocs(LinkedList<ReferenceDoc> refDocs) {
        for (int i = 0; i < refDocs.size(); ++i) {
            this.addRefDoc(refDocs.get(i));
        }
    }

    @JsonIgnore
    public void addRefDoc(ReferenceDoc refDoc) {
        if (!this.refDocs.contains(refDoc)) {
            this.refDocs.add(refDoc);
        }
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public void setCorrupted(boolean corrupted) {
        this.corrupted = corrupted;
    }

    public byte[] getSignatureInfo() {
        return this.signatureInfo;
    }

    public void setSignatureInfo(byte[] signatureInfo) {
        this.signatureInfo = signatureInfo;
    }

    public ContainerFormat getContainerFormat() {
        return this.containerFormat;
    }

    public void setContainerFormat(ContainerFormat containerFormat) {
        this.containerFormat = containerFormat;
    }

    public boolean isContainsGraphometricInfo() {
        return this.containsGraphometricInfo;
    }

    public void setContainsGraphometricInfo(boolean containsGraphometricInfo) {
        this.containsGraphometricInfo = containsGraphometricInfo;
    }

    public PadesSpecific getPadesSpecific() {
        return this.padesSpecific;
    }

    public void setPadesSpecific(PadesSpecific padesSpecific) {
        this.padesSpecific = padesSpecific;
    }

    public String getRefsCertId() {
        return this.refsCertId;
    }

    public void setRefsCertId(String refsCertId) {
        this.refsCertId = refsCertId;
    }

    public LinkedList<SignatureInformation> getCounterSignaturesInformation() {
        return this.counterSignaturesInformation;
    }

    public void setCounterSignaturesInformation(LinkedList<SignatureInformation> counterSignaturesInformation) {
        for (int i = 0; i < counterSignaturesInformation.size(); ++i) {
            this.addCounterSignaturesInformation(counterSignaturesInformation.get(i));
        }
    }

    @JsonIgnore
    public void addCounterSignaturesInformation(SignatureInformation counterSignaturesInformation) {
        if (!this.counterSignaturesInformation.contains(counterSignaturesInformation)) {
            this.counterSignaturesInformation.add(counterSignaturesInformation);
        }
    }

    public LinkedList<SignatureInformation> getTimeStampTokens() {
        return this.timeStampTokens;
    }

    public void setTimeStampTokens(LinkedList<SignatureInformation> timeStampTokens) {
        for (int i = 0; i < timeStampTokens.size(); ++i) {
            this.addTimeStampToken(timeStampTokens.get(i));
        }
    }

    @JsonIgnore
    public void addTimeStampToken(SignatureInformation timeStampToken) {
        if (!this.timeStampTokens.contains(timeStampToken)) {
            this.timeStampTokens.add(timeStampToken);
        }
    }

    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public String getSignatureDate() {
        return this.signatureDate;
    }

    public void setSignatureDate(String signatureDate) {
        this.signatureDate = signatureDate;
    }

    @JsonIgnore
    public SignerInfoData getSignerInfoData() {
        if (this.signerInfoData != null) {
            return this.signerInfoData;
        }
        if (this.signatureInfo == null) {
            return null;
        }
        this.signerInfoData = SignerInfoUtils.parse(this.signatureInfo);
        return this.signerInfoData;
    }

    public boolean isCounterSignature() {
        return this.counterSignature;
    }

    public void setCounterSignature(boolean counterSignature) {
        this.counterSignature = counterSignature;
    }

    public TstSpecific getTstSpecific() {
        return this.tstSpecific;
    }

    public void setTstSpecific(TstSpecific tstSpecific) {
        this.tstSpecific = tstSpecific;
    }
}

