/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.utils;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.filter.Base64InputFilter;
import it.actalis.ellips.capi.datahandlers.inputs.filter.PEMInputFilter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DERSequenceParser;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;

public class DerParserUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputHandler parseDer(InputHandler source, boolean resetFilter) throws CapiException {
        if (source == null) {
            return null;
        }
        InputHandler objReturn = null;
        try {
            boolean bIsPem;
            int firstByte = source.getInputAsNewStream().read();
            boolean bIsDer = firstByte == 48;
            boolean bl = bIsPem = firstByte == 45;
            if (!bIsPem && !bIsDer) {
                source.addFilter(new Base64InputFilter());
            } else if (bIsPem) {
                source.addFilter(new PEMInputFilter());
            }
            objReturn = source;
        }
        catch (IOException e) {
            InputHandler inputHandler = null;
            return inputHandler;
        }
        finally {
            if (resetFilter) {
                source.resetFilter();
            }
        }
        return objReturn;
    }

    public static String retrieveDerID(InputHandler source, boolean resetFilter) throws CapiException {
        try {
            source = DerParserUtils.parseDer(source, resetFilter);
            ASN1StreamParser parser = new ASN1StreamParser(source.getInputAsNewStream());
            ASN1SequenceParser asn1seq = (ASN1SequenceParser)parser.readObject();
            ASN1Encodable obj = asn1seq.readObject();
            if (obj.toASN1Primitive() instanceof ASN1Sequence) {
                obj = asn1seq.readObject();
                asn1seq = ((ASN1Sequence)obj.toASN1Primitive()).parser();
                obj = asn1seq.readObject();
            }
            if (obj == null || !(obj instanceof ASN1ObjectIdentifier)) {
                return null;
            }
            ASN1ObjectIdentifier contentType = (ASN1ObjectIdentifier)obj;
            if (contentType.getId().equals("1.2.840.113549.1.7.2")) {
                obj = asn1seq.readObject();
                if (obj instanceof ASN1TaggedObject) {
                    obj = ((ASN1TaggedObject)obj).getObject();
                    asn1seq = ((ASN1Sequence)obj.toASN1Primitive()).parser();
                    obj = asn1seq.readObject();
                    obj = asn1seq.readObject();
                    obj = asn1seq.readObject();
                    asn1seq = ((ASN1Sequence)obj.toASN1Primitive()).parser();
                    if ((obj = asn1seq.readObject()) == null || !(obj instanceof ASN1ObjectIdentifier)) {
                        return null;
                    }
                    contentType = (ASN1ObjectIdentifier)obj;
                    return contentType.getId();
                }
                if (obj instanceof BERTaggedObjectParser && DerParserUtils.checkSubSeq(asn1seq = (ASN1SequenceParser)((BERTaggedObjectParser)obj).getObjectParser(0, true), "1.2.840.113549.1.9.16.1.4")) {
                    return "1.2.840.113549.1.9.16.1.4";
                }
            } else {
                return contentType.getId();
            }
            return contentType.getId();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static boolean checkSubSeq(ASN1SequenceParser asn1seq, String searchId) {
        try {
            ASN1Encodable obj = asn1seq.readObject();
            while (obj != null) {
                boolean bSubCheck;
                ASN1ObjectIdentifier contentType;
                if (obj instanceof ASN1ObjectIdentifier ? (contentType = (ASN1ObjectIdentifier)obj).getId().equals(searchId) : obj instanceof DERSequenceParser && (bSubCheck = DerParserUtils.checkSubSeq(((ASN1Sequence)obj.toASN1Primitive()).parser(), searchId))) {
                    return true;
                }
                obj = asn1seq.readObject();
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static void validateESSCertID(ESSCertID certID, X509Certificate cert) throws CapiException {
        try {
            if (!MessageDigest.isEqual(certID.getCertHash(), MessageDigest.getInstance("SHA-1", ProvUtils.bcProvider).digest(cert.getEncoded()))) {
                throw new CapiException("ESSCertIDv1 certificate hash does not match certID hash", 30003);
            }
            if (certID.getIssuerSerial() != null) {
                if (!certID.getIssuerSerial().getSerial().getValue().equals(cert.getSerialNumber())) {
                    throw new CapiException("ESSCertIDv1 certificate serial number does not match certID serial number", 30003);
                }
                GeneralName[] names = certID.getIssuerSerial().getIssuer().getNames();
                X500Name x500nameCertificate = X500Name.getInstance((Object)ASN1Primitive.fromByteArray((byte[])cert.getIssuerX500Principal().getEncoded()));
                boolean found = false;
                for (int i = 0; i != names.length; ++i) {
                    if (names[i].getTagNo() != 4 || !X500Name.getInstance((Object)names[i].getName()).equals((Object)x500nameCertificate)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new CapiException("ESSCertIDv1 certificate Issuer Name does not match certID Issuer Name", 30003);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof CapiException) {
                throw new CapiException(ex.getMessage(), ((CapiException)ex).getErrorCode(), ex);
            }
            throw new CapiException(ex.getMessage(), 3010, ex);
        }
    }

    public static void validateESSCertID(ESSCertIDv2 certID, X509Certificate cert) throws CapiException {
        try {
            if (!MessageDigest.isEqual(certID.getCertHash(), MessageDigest.getInstance(certID.getHashAlgorithm().getAlgorithm().getId(), ProvUtils.bcProvider).digest(cert.getEncoded()))) {
                throw new CapiException("ESSCertIDv2 certificate hash does not match certID hash", 30003);
            }
            if (certID.getIssuerSerial() != null) {
                if (!certID.getIssuerSerial().getSerial().getValue().equals(cert.getSerialNumber())) {
                    throw new CapiException("ESSCertIDv2 certificate serial number does not match certID serial number", 30003);
                }
                GeneralName[] names = certID.getIssuerSerial().getIssuer().getNames();
                X500Name x500nameCertificate = X500Name.getInstance((Object)ASN1Primitive.fromByteArray((byte[])cert.getIssuerX500Principal().getEncoded()));
                boolean found = false;
                for (int i = 0; i != names.length; ++i) {
                    if (names[i].getTagNo() != 4 || !X500Name.getInstance((Object)names[i].getName()).equals((Object)x500nameCertificate)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new CapiException("ESSCertIDv2 certificate Issuer Name does not match certID Issuer Name", 30003);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof CapiException) {
                throw new CapiException(ex.getMessage(), ((CapiException)ex).getErrorCode(), ex);
            }
            throw new CapiException(ex.getMessage(), 3010, ex);
        }
    }
}

