/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationStep;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.ValidationStep;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;
import java.util.List;

public abstract class MultipleValidationStepImpl
extends ValidationStep
implements MultipleValidationStep {
    public MultipleValidationStepImpl(ValidationType type) {
        super(type);
    }

    @Override
    public List<ValidatorMessage> checks(ValidationContextParameters param) {
        List<Object> objReturn = new LinkedList<ValidatorMessage>();
        try {
            LinkedList<ValidatorMessage> subMessage = this.checkSubSteps(param);
            objReturn = this.checks(subMessage, param);
            if (objReturn != null && objReturn.size() > 0) {
                objReturn.addAll(subMessage);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("MultipleValidationStepImpl \"{}\" ha generato i seguenti messaggi", (Object)this.getClass().getName());
                    for (ValidatorMessage validatorMessage : objReturn) {
                        this.logger.debug("Messaggio codice {} livello {}:", (Object)validatorMessage.getMessageCode(), (Object)validatorMessage.getLevel());
                    }
                }
            }
        }
        catch (Throwable ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ValidationStep \"{}\" ha generato un errore non gestito: ", (Object)this.getClass().getName(), (Object)ex);
            }
            objReturn.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
        }
        return objReturn;
    }

    protected abstract List<ValidatorMessage> checks(List<ValidatorMessage> var1, ValidationContextParameters var2);
}

