/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepOrder;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

@StepOrder(order=1)
public class StepFormat
extends SingleValidationSubStepImpl {
    public StepFormat() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        String formatName = param.getSignature().getFormat().name();
        if (formatName.startsWith("TST")) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0002_MARK_FORMAT, formatName);
        }
        if (param.getLevelValidation() == null) {
            if (param.getSignature() != null && param.getSignature().getPadesSpecific() != null) {
                String subfilter = param.getSignature().getPadesSpecific().getSubFilter();
                if (subfilter.equalsIgnoreCase("adbe.pkcs7.detached") || subfilter.equalsIgnoreCase("adbe.pkcs7.sha1")) {
                    formatName = formatName + "-basic";
                } else if (subfilter.equalsIgnoreCase("ETSI.CAdES.detached")) {
                    formatName = formatName + "-BES";
                }
            } else {
                formatName = formatName + "-BES";
            }
        } else {
            formatName = formatName + "-" + param.getLevelValidation().getLevel().toString();
        }
        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0001_SIGNATURE_FORMAT, formatName);
    }
}

