/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.tst;

import esecurity.dts.TimeStampToken;
import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class TimeStampStepSignatureDigestAlgoCheck
extends SingleValidationSubStepImpl {
    public TimeStampStepSignatureDigestAlgoCheck() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
        }
        if (param.getSignature() == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
        }
        Date validationDate = param.getCalculatedValidationDate().getDate();
        if (validationDate.after(Constants.DPCM_AGID_121_2019)) {
            SignerInfoData data = param.getSignature().getSignerInfoData();
            if (data == null) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0008_TIMESTAMP_NOSHA256, this.getClass().getName());
            }
            DigestAlgorithm da = DigestAlgorithm.valueFromCadesId(data.getDigestAlgo());
            if (da == null) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, data.getDigestAlgo(), this.getClass().getName());
            }
            if (da.isForbidden()) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, da.name(), this.getClass().getName());
            }
            if (!da.isRecommended()) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, da.name(), this.getClass().getName());
            }
            TimeStampToken tstToken = null;
            try {
                tstToken = new TimeStampToken(param.getSignature().getSignatureInfo());
            }
            catch (CapiException ex) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
            }
            try {
                if (tstToken.hasSigningCertificateV2()) {
                    da = DigestAlgorithm.valueFromCadesId(tstToken.getSigningCertificateV2HashAlg());
                } else if (tstToken.hasSigningCertificate()) {
                    da = DigestAlgorithm.SHA1;
                }
                if (da == null) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, "", this.getClass().getName());
                }
                if (da.isForbidden()) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, da.name(), this.getClass().getName());
                }
                if (!da.isRecommended()) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, da.name(), this.getClass().getName());
                }
                da = DigestAlgorithm.valueFromCadesId(tstToken.getInternalTst().getTimeStampInfo().getMessageImprintAlgOID().getId());
                if (da == null) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, data.getDigestAlgo(), this.getClass().getName());
                }
                if (da.isForbidden()) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, da.name(), this.getClass().getName());
                }
                if (!da.isRecommended()) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, da.name(), this.getClass().getName());
                }
            }
            catch (CapiException ex) {
                this.logger.error("Errore verifica Digest Algo", (Throwable)ex);
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0027_INVALID_TIMESTAMP, this.getClass().getName());
            }
        }
        return null;
    }
}

