/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.steps.CertificateValidationStep;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.annotations.StepOrder;
import esecurity.validator.steps.core.x509.StepX509QcLimit;
import esecurity.validator.steps.core.x509.StepX509QcPDS;
import esecurity.validator.steps.core.x509.StepX509QcQualified;
import esecurity.validator.steps.core.x509.StepX509QcRetention;
import esecurity.validator.steps.core.x509.StepX509QcSSCD;
import esecurity.validator.steps.core.x509.StepX509QcStatementType;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

@StepOrder(order=40)
@StepContext(formats={ValidationSignatureFormats.CADES, ValidationSignatureFormats.PADES, ValidationSignatureFormats.XADES}, profiles={ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE})
public class StepX509CertificateHasLegalValidity
extends CertificateValidationStep {
    public StepX509CertificateHasLegalValidity() {
        this.subSteps.add(new StepX509QcQualified());
        this.subSteps.add(new StepX509QcLimit());
        this.subSteps.add(new StepX509QcRetention());
        this.subSteps.add(new StepX509QcSSCD());
        this.subSteps.add(new StepX509QcPDS());
        this.subSteps.add(new StepX509QcStatementType());
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param != null) {
            if (param.getSignerCertificate() != null) {
                MessageLevel levelRealiableStepsMsg = StepsUtils.retrieveWorstLevel(param.getSignerCertificate().getMessages());
                MessageLevel level = StepsUtils.retrieveWorstLevel(subMessage);
                if (levelRealiableStepsMsg == MessageLevel.ERROR) {
                    return null;
                }
                if (level == MessageLevel.ERROR) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0001_CERT_NOT_VALID, new Object[0]);
                }
                if (param.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.IC0001_CERT_HAS_LEGAL_VALIDITY, new Object[0]);
                }
                return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.IC0019_CERT_IS_VALID_FOR_PROFILE, new Object[0]);
            }
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
        }
        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
    }
}

