/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.core.x509.StepX509DPCM45DigestAlgorithmCompliance;
import esecurity.validator.steps.core.x509.StepX509DPCM45Issuer;
import esecurity.validator.steps.core.x509.StepX509DPCM45SubjectDN;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class StepX509DPCM45Compliance
extends SingleValidationSubStepImpl {
    public StepX509DPCM45Compliance() {
        super(ValidationType.CERTIFICATE);
        this.subSteps.add(new StepX509DPCM45DigestAlgorithmCompliance());
        this.subSteps.add(new StepX509DPCM45SubjectDN());
        this.subSteps.add(new StepX509DPCM45Issuer());
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        MessageLevel level = StepsUtils.retrieveWorstLevel(subMessage);
        if (level != MessageLevel.INFO) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), level, (EsecurityMessage)ValidatorMessageEnum.EC0010_NOCNIPA45, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
        }
        return null;
    }
}

