/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class StepX509ETSIKeyLengthCompliance
extends SingleValidationSubStepImpl {
    private static final int RSA_RECOMMENDED_KEY_LENGTH = 2048;
    private static final int DSA_RECOMMENDED_KEY_LENGTH = 2048;
    private static final int EC_RECOMMENDED_KEY_LENGTH = 256;

    public StepX509ETSIKeyLengthCompliance() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        String encAlg;
        Date notBefore;
        if (param != null && param.getSignerCertificate() != null && (notBefore = param.getSignerCertificate().getCert().getInternalCert().getNotBefore()).after(Constants.DPCM_AGID_121_2019) && (encAlg = param.getSignerCertificate().getCert().getPublicKey().getAlgorithm()) != null) {
            int recommendedKeyLength = 2048;
            if (encAlg.equalsIgnoreCase("EC")) {
                recommendedKeyLength = 256;
            }
            if (param.getSignerCertificate().getCert().getKeyLength() < recommendedKeyLength) {
                return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0023_ETSI_KEY_LENGTH_NOT_RECOMMENDED, new Object[0]);
            }
        }
        return null;
    }
}

