/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class StepX509KeyUsage
extends SingleValidationSubStepImpl {
    public StepX509KeyUsage() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (!(param == null || param.getSignerCertificate() == null || param.getSignature() != null && param.getSignature().getFormat() != null && param.getSignature().getFormat().equals((Object)SignatureFormat.TST))) {
            String keyUsage = "";
            try {
                keyUsage = param.getSignerCertificate().getCert().keyUsageToString(param.getSignerCertificate().getCert().getKeyUsage());
            }
            catch (CapiException e) {
                keyUsage = "";
            }
            if (param.getSignature() != null) {
                if (!param.getSignature().getFormat().equals((Object)SignatureFormat.TST) && !keyUsage.contains("nonRepudiation")) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0011_NODIGITALSIGNATURE, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
                }
            } else {
                try {
                    if (!param.getSignerCertificate().getCert().getBasicConstraints() && !keyUsage.contains("nonRepudiation")) {
                        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0011_NODIGITALSIGNATURE, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
                    }
                }
                catch (CapiException ex) {
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0011_NODIGITALSIGNATURE, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, new Object[0]);
                }
            }
        }
        return null;
    }
}

