/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.crl;

import com.google.gson.Gson;
import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.CrlBean;
import esecurity.validator.x509status.RevocationBean;
import esecurity.validator.x509status.crl.CRLCacheManager;
import esecurity.validator.x509status.crl.CRLUtils;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.I;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URL;
import java.security.cert.X509CRLEntry;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;

public class DefaultCrlCacheManager
implements CRLCacheManager {
    boolean disabledCache = true;
    private static final String INIT_WORD = "1A23C4D567890AB76329CDE";
    private ValidatorConfig config = null;
    private Logger logger = null;
    private static final HashMap<String, MVStore> oldStores = new HashMap();
    private MVStore cachedStore = null;
    private MVMap<String, String> crlInfos = null;
    private static final ConcurrentHashMap<String, CRL> transientCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, MVStore> crlsCache = new ConcurrentHashMap();
    private static final LinkedBlockingQueue<String> crlToElaborate = new LinkedBlockingQueue();
    private Thread job = null;
    private Thread[] workers = null;
    private CrlInternalJob objJob = null;
    private CrlInternalWorker[] objWorkers = null;
    private int workerNum = 3;
    private Gson gson = new Gson();
    private CertDB certDB = null;
    private String fileName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultCrlCacheManager(ValidatorConfig config, Logger callerLogger) throws CapiException {
        this.config = config;
        this.logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        if (callerLogger != null) {
            this.logger = callerLogger;
        }
        String name = config.getElement("certdb.file");
        String pwd = config.getElement("certdb.pwd");
        try {
            this.certDB = CertDB.getInstance(name, pwd, false, true);
        }
        catch (CertDBException e) {
            throw new CapiException("Impossibile trovare il certdb", 1003, e);
        }
        String crldirstr = config.getElement("crl.dir");
        if (crldirstr != null) {
            File fCrlDir = new File(crldirstr);
            if (!fCrlDir.exists()) {
                fCrlDir.mkdirs();
            }
            this.disabledCache = false;
            this.fileName = fCrlDir.getAbsolutePath() + File.separatorChar + "crl.cache";
            HashMap<String, MVStore> hashMap = oldStores;
            synchronized (hashMap) {
                this.cachedStore = oldStores.get(this.fileName);
                if (this.cachedStore == null) {
                    this.cachedStore = this.getCache(this.fileName);
                    this.crlInfos = this.cachedStore.openMap("crlInfos", (MVMap.MapBuilder)new MVMap.Builder());
                    this.objJob = new CrlInternalJob();
                    this.job = new Thread(this.objJob);
                    this.job.setDaemon(true);
                    this.job.start();
                    this.objWorkers = new CrlInternalWorker[this.workerNum];
                    this.workers = new Thread[this.workerNum];
                    for (int i = 0; i < this.workerNum; ++i) {
                        this.objWorkers[i] = new CrlInternalWorker();
                        this.workers[i] = new Thread(this.objWorkers[i]);
                        this.workers[i].setDaemon(true);
                        this.workers[i].start();
                    }
                    oldStores.put(this.fileName, this.cachedStore);
                    Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DefaultCrlCacheManager.this.runHooks();
                        }
                    }));
                } else {
                    this.crlInfos = this.cachedStore.openMap("crlInfos", (MVMap.MapBuilder)new MVMap.Builder());
                }
            }
        }
    }

    private void runHooks() {
        this.waitForJobs();
        for (String crlId : crlsCache.keySet()) {
            crlsCache.get(crlId).close();
        }
        crlsCache.clear();
        this.cachedStore.close();
    }

    @Override
    public RevocationBean checkRevocation(Certificate cert, ValidationDate validationDate) {
        String crlId = CRLUtils.generateCrlId(cert);
        RevocationBean revocationBean = null;
        CRL crl = null;
        crl = transientCache.get(crlId);
        if (crl != null) {
            revocationBean = CRLUtils.validateRevocationReason(crl, cert.getInternalCert().getSerialNumber(), validationDate);
        }
        if (revocationBean != null) {
            return revocationBean;
        }
        if (this.crlInfos.get((Object)crlId) == null) {
            this.logger.debug("Crl not in cache...");
            return revocationBean;
        }
        Date currentDate = new Date();
        CrlBean crlBean = (CrlBean)this.gson.fromJson((String)this.crlInfos.get((Object)crlId), CrlBean.class);
        if (!crlBean.isCrlValid()) {
            this.logger.debug("Crl not valid");
            return revocationBean;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            if (currentDate.before(format.parse(crlBean.getNextUpdate()))) {
                revocationBean = new RevocationBean();
                revocationBean.setCrlBean(crlBean);
                revocationBean.setCrlStatus(crlBean.getCrlStatusExplained());
                MVStore crlCache = crlsCache.get(crlId);
                MVMap mapRevoked = crlCache.openMap(crlId, (MVMap.MapBuilder)new MVMap.Builder());
                String strEntry = (String)mapRevoked.get((Object)cert.getInternalCert().getSerialNumber());
                if (strEntry == null) {
                    revocationBean.setCertRevoked(false);
                } else {
                    InternalCrlEntry crlEntry = (InternalCrlEntry)this.gson.fromJson(strEntry, InternalCrlEntry.class);
                    Date vDate = validationDate.getDate();
                    if (vDate.compareTo(crlEntry.getRevocationDate()) >= 0) {
                        revocationBean.setCertRevoked(true);
                        revocationBean.setRevocationDate(crlEntry.getRevocationDate());
                        revocationBean.setRevocationReason(Integer.toString(crlEntry.getRevocationCode()));
                        String revstr = CRLUtils.reasonCodeToCapiString(crlEntry.getRevocationCode());
                        if (!revocationBean.getInvalidityReason().equalsIgnoreCase("")) {
                            revstr = revocationBean.getInvalidityReason() + " - " + revstr;
                        }
                        revocationBean.setInvalidityReason(revstr);
                    }
                }
            }
        }
        catch (ParseException ex) {
            this.logger.error("unable to parse crl nextUpdate.", (Throwable)ex);
        }
        return revocationBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCrlInCache(String crlId) {
        if (this.disabledCache) {
            return false;
        }
        if (this.crlInfos.get((Object)crlId) == null) {
            this.logger.debug("Crl's info for id:" + crlId + " is null");
            return transientCache.get(crlId) != null;
        }
        CrlBean crlBean = (CrlBean)this.gson.fromJson((String)this.crlInfos.get((Object)crlId), CrlBean.class);
        if (!crlBean.isCrlValid()) {
            this.logger.debug("Crl not valid");
            return transientCache.get(crlId) != null;
        }
        MVStore crlCache = crlsCache.get(crlId);
        if (crlCache == null) {
            ConcurrentHashMap<String, MVStore> concurrentHashMap = crlsCache;
            synchronized (concurrentHashMap) {
                crlCache = crlsCache.get(crlId);
                if (crlCache == null) {
                    crlCache = this.getCache(crlBean.getCacheFile());
                    crlsCache.put(crlId, crlCache);
                }
            }
        }
        if (crlCache != null) {
            Date currentDat = new Date();
            try {
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
                if (currentDat.before(format.parse(crlBean.getNextUpdate()))) {
                    return true;
                }
            }
            catch (ParseException ex) {
                this.logger.error("unable to parse crl nextUpdate.", (Throwable)ex);
            }
        }
        return transientCache.get(crlId) != null;
    }

    @Override
    public void addCrlToCache(String crlId, CRL crl) throws CapiException {
        if (!this.disabledCache && transientCache.size() < 10) {
            transientCache.put(crlId, crl);
            crlToElaborate.add(crlId);
        }
    }

    private void waitForJobs() {
        try {
            if (this.objJob != null) {
                this.objJob.setActive(false);
                this.job.join();
                this.objJob = null;
                this.job = null;
            }
            if (this.objWorkers == null) {
                return;
            }
            for (int i = 0; i < this.workerNum; ++i) {
                this.objWorkers[i].setActive(false);
                this.workers[i].join();
            }
            this.objWorkers = null;
            this.workers = null;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public void finalize() throws Throwable {
        this.waitForJobs();
        super.finalize();
    }

    private MVStore getCache(String File2) {
        return new MVStore.Builder().fileName(File2).encryptionKey(INIT_WORD.toCharArray()).compress().open();
    }

    private class InternalCrlEntry
    implements Serializable {
        private BigInteger serialNumber;
        private int revocationCode;
        private Date revocationDate;

        public InternalCrlEntry(BigInteger serialNumber, int revocationCode, Date revocationDate) {
            this.serialNumber = serialNumber;
            this.revocationCode = revocationCode;
            this.revocationDate = revocationDate;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        public void setSerialNumber(BigInteger serialNumber) {
            this.serialNumber = serialNumber;
        }

        public int getRevocationCode() {
            return this.revocationCode;
        }

        public void setRevocationCode(int revocationCode) {
            this.revocationCode = revocationCode;
        }

        public Date getRevocationDate() {
            return this.revocationDate;
        }

        public void setRevocationDate(Date revocationDate) {
            this.revocationDate = revocationDate;
        }
    }

    private class CrlInternalWorker
    implements Runnable {
        private boolean active = true;

        private CrlInternalWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: while (true) {
                try {
                    while (this.active) {
                        CRL crl;
                        String crlId = (String)crlToElaborate.poll(1L, TimeUnit.SECONDS);
                        if (crlId == null || (crl = (CRL)transientCache.get(crlId)) == null) continue;
                        try {
                            CrlBean crlBean = CRLUtils.retrieveCrlInfo(crl, new Date());
                            String nanoTok = BigInteger.valueOf(System.nanoTime()).toString(16);
                            String fileCache = DefaultCrlCacheManager.this.fileName.replaceAll(".cache", "_" + crlId + "_" + nanoTok + ".cache");
                            MVStore crlCache = DefaultCrlCacheManager.this.getCache(fileCache);
                            MVMap mapRevoked = crlCache.openMap(crlId);
                            if (crl.getInternalCRL() != null && crl.getInternalCRL().getRevokedCertificates() != null) {
                                for (X509CRLEntry x509CRLEntry : crl.getInternalCRL().getRevokedCertificates()) {
                                    int code = 0;
                                    try {
                                        code = crl.getReasonCode(x509CRLEntry.getSerialNumber());
                                    }
                                    catch (CapiException capiException) {
                                        // empty catch block
                                    }
                                    InternalCrlEntry internalEntry = new InternalCrlEntry(x509CRLEntry.getSerialNumber(), code, x509CRLEntry.getRevocationDate());
                                    mapRevoked.putIfAbsent((Object)x509CRLEntry.getSerialNumber(), (Object)DefaultCrlCacheManager.this.gson.toJson((Object)internalEntry));
                                }
                            }
                            crlBean.setCacheFile(fileCache);
                            MVStore oldCache = crlsCache.put(crlId, crlCache);
                            if (oldCache != null) {
                                CrlBean crlBean2 = (CrlBean)DefaultCrlCacheManager.this.gson.fromJson((String)DefaultCrlCacheManager.this.crlInfos.put((Object)crlId, (Object)DefaultCrlCacheManager.this.gson.toJson((Object)crlBean)), CrlBean.class);
                                oldCache.close();
                                File oldCrlFile = new File(crlBean2.getCacheFile());
                                oldCrlFile.delete();
                            } else {
                                DefaultCrlCacheManager.this.crlInfos.put((Object)crlId, (Object)DefaultCrlCacheManager.this.gson.toJson((Object)crlBean));
                            }
                            transientCache.remove(crlId);
                            crlCache.sync();
                            DefaultCrlCacheManager.this.cachedStore.sync();
                            crlCache.commit();
                            DefaultCrlCacheManager.this.cachedStore.commit();
                            continue block8;
                        }
                        catch (Exception ex) {
                            DefaultCrlCacheManager.this.logger.error("unable to parse crl.", (Throwable)ex);
                            ex.printStackTrace();
                        }
                    }
                    break;
                }
                catch (InterruptedException ex) {
                    DefaultCrlCacheManager.this.logger.error("Worker Interrotto", (Throwable)ex);
                    ex.printStackTrace();
                    break;
                }
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }

    private class CrlInternalJob
    implements Runnable {
        private boolean active = true;

        private CrlInternalJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UrlClient client = new UrlClient(DefaultCrlCacheManager.this.config.getNetConfiguration(), DefaultCrlCacheManager.this.logger);
            while (this.active) {
                try {
                    int i = 0;
                    while (this.active && i < 60) {
                        Thread.sleep(1000L);
                    }
                    Date currentDate = new Date();
                    if (transientCache.size() >= 10) continue;
                    for (Map.Entry entry : DefaultCrlCacheManager.this.crlInfos.entrySet()) {
                        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
                        CrlBean crlBean = (CrlBean)DefaultCrlCacheManager.this.gson.fromJson((String)entry.getValue(), CrlBean.class);
                        if (!currentDate.after(new Date(format.parse(crlBean.getNextUpdate()).getTime() - 600000L))) continue;
                        InputStream is = null;
                        CRL crl = null;
                        try {
                            DefaultCrlCacheManager.this.logger.debug(I.d() + "Url " + crlBean.getDownloadedUrl());
                            if (crlBean.getDownloadedUrl().startsWith("ldap")) {
                                UrlReturn ret = client.downloadUrl(crlBean.getDownloadedUrl(), null, null);
                                if (!ret.equals("OK")) {
                                    Util.closeQuietly(is);
                                    continue;
                                }
                                is = new ByteArrayInputStream(ret.getData());
                            } else {
                                is = client.getInputStream(new URL(crlBean.getDownloadedUrl()), null);
                            }
                            DefaultCrlCacheManager.this.logger.debug(I.d() + "Fine download");
                            crl = new CRL(new BufferedInputStream(is));
                            crl.setDownloadedUrl(crlBean.getDownloadedUrl());
                            DefaultCrlCacheManager.this.addCrlToCache((String)entry.getKey(), crl);
                            DefaultCrlCacheManager.this.crlInfos.remove(entry.getKey());
                            Util.closeQuietly(is);
                        }
                        catch (Exception e) {
                            DefaultCrlCacheManager.this.logger.error(I.d() + "Errore: " + e.getMessage());
                        }
                        finally {
                            Util.closeQuietly(is);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

