/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.x509status.ocsp;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.CertificateExpiredException;
import it.actalis.ellips.capi.core.CertificateNotYetValidException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.CrlID;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RespID;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.slf4j.Logger;

public class OCSPResponse {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private OCSPResp ocspResponse;
    private SingleResp singleResponse;
    private BasicOCSPResp basicOCSPResponse;
    private RespID responderID;
    public static int GOOD = 0;
    public static int REVOKED = 1;
    public static int UNKNOWN = 2;
    public static int OCSP_WITHOUT_ARCHIVE_CUTOFF = 3;
    public static int OCSP_WITH_ARCHIVE_CUTOFF_CRT_TOO_OLD = 4;

    public OCSPResponse(OCSPResp ocspResponse, CertificateID reqCertID) throws CapiException, Exception {
        this.ocspResponse = ocspResponse;
        this.basicOCSPResponse = (BasicOCSPResp)this.ocspResponse.getResponseObject();
        if (this.basicOCSPResponse == null) {
            int s = this.ocspResponse.getStatus();
            String err = OCSPResponse.getResponseStatusName(s);
            throw new CapiException("OCSP responder error: status " + err + " (" + s + ")", 31008);
        }
        this.responderID = this.basicOCSPResponse.getResponderId();
        SingleResp[] singleRespArr = this.basicOCSPResponse.getResponses();
        this.singleResponse = null;
        ASN1Primitive reqCertIDSeq = OCSPResponse.certificateIDToASN1Primitive(reqCertID);
        for (SingleResp singleResp : singleRespArr) {
            ASN1Primitive respCertIDSeq = OCSPResponse.certificateIDToASN1Primitive(singleResp.getCertID());
            if (!respCertIDSeq.equals(reqCertIDSeq)) continue;
            this.singleResponse = singleResp;
        }
        if (this.singleResponse == null) {
            throw new CapiException("Not found SingleResp for the specified CertID", 31008);
        }
    }

    public String getResponseStatusName() {
        int status = this.ocspResponse.getStatus();
        return OCSPResponse.getResponseStatusName(status);
    }

    public static String getResponseStatusName(int status) {
        String name = null;
        switch (status) {
            case 0: {
                name = "successful";
                break;
            }
            case 1: {
                name = "malformedRequest";
                break;
            }
            case 2: {
                name = "internalError";
                break;
            }
            case 3: {
                name = "tryLater";
                break;
            }
            case 5: {
                name = "sigRequired";
                break;
            }
            case 6: {
                name = "unauthorized";
                break;
            }
            default: {
                name = "unauthorized";
            }
        }
        return name;
    }

    public int getResponseStatus() {
        return this.ocspResponse.getStatus();
    }

    public BasicOCSPResp getBasicOcspResponse() {
        return this.basicOCSPResponse;
    }

    public OCSPResp getFullOcspResponse() {
        return this.ocspResponse;
    }

    public RespID getResponderID() {
        return this.responderID;
    }

    public String getResponderIDtoString() {
        if (this.responderID == null) {
            return null;
        }
        ASN1TaggedObject dto = (ASN1TaggedObject)this.responderID.toASN1Primitive().toASN1Primitive();
        if (dto.getTagNo() == 1) {
            X500Name name = X500Name.getInstance((Object)dto.getObject());
            return name.toString();
        }
        ASN1OctetString asnioct = ASN1OctetString.getInstance((Object)dto.getObject());
        return asnioct.toString();
    }

    public Date getProducedAt() {
        return this.basicOCSPResponse.getProducedAt();
    }

    public String getName() {
        return this.responderID.toASN1Primitive().toASN1Primitive().toString();
    }

    public byte[] getKeyHash() throws IOException {
        return this.responderID.toASN1Primitive().toASN1Primitive().getEncoded();
    }

    public SingleResp getSingleResponse() {
        return this.singleResponse;
    }

    public Date getArchiveCutoff() {
        try {
            Extension ext = this.singleResponse.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_archive_cutoff);
            if (ext == null) {
                return null;
            }
            byte[] cutOff = ext.getExtnValue().getEncoded();
            if (cutOff == null) {
                return null;
            }
            ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])cutOff));
            ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
            ASN1GeneralizedTime gentime = ASN1GeneralizedTime.getInstance((Object)extIn.readObject());
            if (gentime == null) {
                return null;
            }
            Date date = gentime.getDate();
            return date;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int warningArchiveCutoff(Certificate certificate) throws CapiException {
        CertificateStatus status = this.singleResponse.getCertStatus();
        if (status != CertificateStatus.GOOD) {
            return 0;
        }
        try {
            certificate.isValid();
            return 0;
        }
        catch (CertificateExpiredException certificateExpiredException) {
        }
        catch (CertificateNotYetValidException e) {
            return 0;
        }
        catch (CapiException e) {
            throw e;
        }
        String dateFormat = "yyyyMMddHHmmss";
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date archiveCutoff = this.getArchiveCutoff();
        if (archiveCutoff == null) {
            return OCSP_WITHOUT_ARCHIVE_CUTOFF;
        }
        String exp = certificate.getValidityNotAfter(dateFormat);
        Date crtExpiry = null;
        try {
            crtExpiry = sdf.parse(exp);
        }
        catch (ParseException e) {
            throw new CapiException("Certificate expiry date parsing exception", 30002);
        }
        if (crtExpiry.compareTo(archiveCutoff) >= 0) {
            return 0;
        }
        return OCSP_WITH_ARCHIVE_CUTOFF_CRT_TOO_OLD;
    }

    public int getCertStatus() {
        if (this.singleResponse.getCertStatus() == CertificateStatus.GOOD) {
            return 0;
        }
        logger.debug("OCSP certificate status: " + this.singleResponse.getCertStatus().getClass().getName());
        if (this.singleResponse.getCertStatus() instanceof RevokedStatus) {
            logger.info("OCSP certificate status: OCSP status revoked");
            logger.info("OCSP Revocation time:" + ((RevokedStatus)this.singleResponse.getCertStatus()).getRevocationTime());
            return 1;
        }
        if (this.singleResponse.getCertStatus() instanceof UnknownStatus) {
            logger.info("OCSP status unknown");
            return 2;
        }
        return 2;
    }

    public String getCertStatusName() {
        int status = this.getCertStatus();
        String name = null;
        switch (status) {
            case 0: {
                name = "good";
            }
            case 1: {
                name = "revoked";
            }
            case 2: {
                name = "unknown";
            }
        }
        name = "unknown";
        return name;
    }

    public Date getThisUpdate() {
        return this.singleResponse.getThisUpdate();
    }

    public Date getNextUpdate() {
        return this.singleResponse.getNextUpdate();
    }

    public CrlID getCrlID() throws IOException {
        Extension exte = this.singleResponse.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_crl);
        byte[] ext = exte.getExtnValue().getEncoded();
        if (ext == null) {
            return null;
        }
        ASN1OctetString oct = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])ext));
        ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
        CrlID crlId = CrlID.getInstance((Object)ASN1Sequence.getInstance((Object)extIn.readObject()));
        return crlId;
    }

    public byte[] getNonce() {
        Extension exte = this.basicOCSPResponse.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (exte == null || exte.getExtnValue() == null) {
            return null;
        }
        try {
            return exte.getExtnValue().getEncoded();
        }
        catch (IOException e) {
            logger.warn("Impossibile recuperare il nonce : " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getReasonCodeName() throws IOException {
        String name = null;
        CertificateStatus status = this.singleResponse.getCertStatus();
        if (status == CertificateStatus.GOOD) {
            return null;
        }
        if (status instanceof RevokedStatus) {
            int reason = ((RevokedStatus)status).getRevocationReason();
            switch (reason) {
                case 0: {
                    name = "unspecified";
                }
                case 1: {
                    name = "keyCompromise";
                }
                case 2: {
                    name = "cACompromise";
                }
                case 3: {
                    name = "affiliationChanged";
                }
                case 4: {
                    name = "superseded";
                }
                case 5: {
                    name = "cessationOfOperation";
                }
                case 6: {
                    name = "certificateHold";
                }
                case 8: {
                    name = "removeFromCRL";
                }
                case 9: {
                    name = "privilegeWithdrawn";
                }
                case 10: {
                    name = "aACompromise";
                }
            }
            name = "unknown";
        } else if (status instanceof UnknownStatus) {
            return null;
        }
        return null;
    }

    public int getReasonCode() {
        CertificateStatus status = this.singleResponse.getCertStatus();
        if (status == CertificateStatus.GOOD) {
            return -1;
        }
        if (status instanceof RevokedStatus) {
            int reason = ((RevokedStatus)status).getRevocationReason();
            return reason;
        }
        if (status instanceof UnknownStatus) {
            return -1;
        }
        return -1;
    }

    public Date getRevocationTime() throws ParseException {
        CertificateStatus status = this.singleResponse.getCertStatus();
        if (status == CertificateStatus.GOOD) {
            return null;
        }
        if (status instanceof RevokedStatus) {
            return ((RevokedStatus)status).getRevocationTime();
        }
        if (status instanceof UnknownStatus) {
            return null;
        }
        return null;
    }

    public static ASN1Primitive certificateIDToASN1Primitive(CertificateID certificateID) {
        ASN1Primitive certIDPrimitive;
        if (certificateID.toASN1Primitive().getHashAlgorithm().getParameters() instanceof DERNull) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new AlgorithmIdentifier(certificateID.toASN1Primitive().getHashAlgorithm().getAlgorithm(), null));
            v.add((ASN1Encodable)certificateID.toASN1Primitive().getIssuerNameHash());
            v.add((ASN1Encodable)certificateID.toASN1Primitive().getIssuerKeyHash());
            v.add((ASN1Encodable)certificateID.toASN1Primitive().getSerialNumber());
            certIDPrimitive = new DERSequence(v);
        } else {
            certIDPrimitive = certificateID.toASN1Primitive().toASN1Primitive();
        }
        return certIDPrimitive;
    }
}

