/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.certdb;

import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.ini.IniFileException;
import it.actalis.vol.utils.Constants;
import org.slf4j.Logger;

public class CertDBException
extends CapiException {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private CertDBItem[] chain = null;
    private int[] chain_status = null;
    private int cert_status = 82112;
    static boolean debug = false;

    public CertDBException(String message, int errorCode) {
        super(message, errorCode);
    }

    public CertDBItem[] getChain() {
        return this.chain;
    }

    public int[] getChainStatus() {
        return this.chain_status;
    }

    public int getCertStatus() {
        return this.cert_status;
    }

    CertDBException(String message, int errorCode, CertDBItem[] chain, int[] chainStatus) {
        this(message, errorCode, chain, chainStatus, 82112);
    }

    CertDBException(String message, int errorCode, CertDBItem[] chain, int[] chainStatus, int certStatus) {
        super(message, errorCode);
        this.chain = chain;
        this.chain_status = chainStatus;
        this.cert_status = certStatus;
    }

    static CertDBException convertDB(IniFileException e) {
        logger.debug("[CapiException] converting from IniFile exception " + e.getErrorCode() + ":\n" + e.getMessage());
        String msg = null;
        int code = -1;
        switch (e.getErrorCode()) {
            case 0: {
                code = 80007;
                break;
            }
            case 1: {
                code = 80007;
                break;
            }
            case 2: {
                code = 80007;
                break;
            }
            default: {
                code = 80003;
            }
        }
        return new CertDBException(msg, code);
    }
}

