/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.container;

import it.actalis.ellips.capi.container.ContainerGeneratorOptions;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.signature.BaseGenerator;
import it.actalis.ellips.capi.signature.SignatureOptions;

public abstract class ContainerGenerator<T extends ContainerGeneratorOptions<K>, K extends SignatureOptions>
extends BaseGenerator<T> {
    protected final void validateEntryOptions(K entryOpts) throws CapiException {
        if (entryOpts == null) {
            throw new CapiException("Entry options are null.", 1001);
        }
        this.specificValidateEntryOptions(entryOpts);
    }

    public final void pack(T opts) throws CapiException {
        this.generate(opts);
    }

    protected abstract void specificValidateOptions(T var1) throws CapiException;

    protected abstract void specificValidateEntryOptions(K var1) throws CapiException;

    protected abstract void specificPreProcessEntries(T var1) throws CapiException;

    protected abstract void specificPackEntry(K var1) throws CapiException;

    protected abstract void specificPostProcessEntries(T var1) throws CapiException;

    @Override
    public final void validateOptions(T opts) throws CapiException {
        if (opts == null) {
            throw new CapiException("Options are null.", 1001);
        }
        if (((ContainerGeneratorOptions)opts).getSignEntriesOptions() == null) {
            throw new CapiException("ASiC options: list of signing entries is null.", 1001);
        }
        if (((ContainerGeneratorOptions)opts).getSignEntriesOptions().isEmpty()) {
            throw new CapiException("ASiC options: list of signing entries is empty.", 1002);
        }
        this.specificValidateOptions(opts);
        for (SignatureOptions entryOpts : ((ContainerGeneratorOptions)opts).getSignEntriesOptions()) {
            this.validateEntryOptions(entryOpts);
        }
    }

    @Override
    protected void doGenerate() throws CapiException {
        this.specificPreProcessEntries((ContainerGeneratorOptions)this.options);
        for (SignatureOptions entryOpts : ((ContainerGeneratorOptions)this.options).getSignEntriesOptions()) {
            this.specificPackEntry(entryOpts);
        }
        this.specificPostProcessEntries((ContainerGeneratorOptions)this.options);
    }
}

