/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core.msg;

import com.fasterxml.jackson.annotation.JsonIgnore;
import esecurity.validator.constants.ValidationProfile;
import it.actalis.ellips.capi.core.msg.ETSISubIndication;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.LanguagesCode;
import it.actalis.ellips.capi.core.msg.MessageFactory;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.exception.VolException;
import it.actalis.vol.utils.Constants;
import java.util.LinkedList;
import org.slf4j.Logger;

public class ValidatorMessage {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private EsecurityMessage messageEnum;
    private Object[] args;
    private MessageLevel level;
    private LinkedList<ValidatorMessage> notes = new LinkedList();
    private int priority = 0;
    private ValidationProfile profile;
    private MessageFactory mf;

    public ValidatorMessage(MessageFactory mf, MessageLevel level, EsecurityMessage messageEnum, ValidationProfile profile, Object ... args) {
        this.messageEnum = messageEnum;
        this.args = args;
        this.level = level;
        this.profile = profile;
        this.mf = mf;
        if (mf == null) {
            try {
                mf = new MessageFactory(LanguagesCode.EN);
            }
            catch (VolException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public ValidatorMessage(MessageFactory mf, MessageLevel level, EsecurityMessage messageEnum, Object ... args) {
        this(mf, level, messageEnum, ValidationProfile.ALL_PROFILES, args);
    }

    public String toString() {
        return this.getMessage();
    }

    public String getMessage() {
        return this.mf.getMessage(this.messageEnum, this.args);
    }

    public Object[] getArgs() {
        return this.args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public MessageLevel getLevel() {
        return this.level;
    }

    public void setLevel(MessageLevel level) {
        this.level = level;
    }

    public String getMessageCode() {
        return this.messageEnum.getCode();
    }

    @JsonIgnore
    public ETSISubIndication getMessageEtsiCode() {
        return ((ValidatorMessageEnum)this.messageEnum).getEtsiSubIndication();
    }

    @JsonIgnore
    public void addNotes(ValidatorMessage msg) {
        this.notes.add(msg);
    }

    public LinkedList<ValidatorMessage> getNotes() {
        return this.notes;
    }

    public int getPriority() {
        return this.priority;
    }

    @JsonIgnore
    public ValidationProfile getProfile() {
        return this.profile;
    }
}

