/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.builders;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.builders.BaseDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.CloudChooserDataHandlerBuilderFacade;
import it.actalis.ellips.capi.datahandlers.builders.URLDataHandlerBuilderFacade;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;

public class GenericDataHandlerBuilderFacade
extends BaseDataHandlerBuilderFacade {
    public GenericDataHandlerBuilderFacade setBytes(byte[] data) {
        this.type = DataHandler.DATA_TYPE.BYTE;
        this.byteData = data;
        return this;
    }

    public GenericDataHandlerBuilderFacade setFile(File data) {
        this.type = DataHandler.DATA_TYPE.FILE;
        this.fileData = data;
        return this;
    }

    public GenericDataHandlerBuilderFacade setTemp(File data) {
        this.type = DataHandler.DATA_TYPE.TEMP;
        this.fileData = data;
        return this;
    }

    public GenericDataHandlerBuilderFacade setTemp(String prefix, String suffix) {
        this.type = DataHandler.DATA_TYPE.TEMP;
        this.prefix = prefix;
        this.suffix = suffix;
        return this;
    }

    public GenericDataHandlerBuilderFacade setTemp() {
        this.type = DataHandler.DATA_TYPE.TEMP;
        this.fileData = null;
        return this;
    }

    public URLDataHandlerBuilderFacade setUrl(URL endpoint) {
        this.type = DataHandler.DATA_TYPE.URL;
        this.urlEndpoint = endpoint;
        return GenericDataHandlerBuilderFacade.getNewURLFacadeFrom(this);
    }

    public GenericDataHandlerBuilderFacade setInputStream(InputStream data) {
        return this.setInputStream(data, false);
    }

    public GenericDataHandlerBuilderFacade setInputStream(InputStream data, boolean forceStreamMode) {
        boolean done = false;
        if (!forceStreamMode && !done && data instanceof ByteArrayInputStream) {
            try {
                ByteArrayInputStream bais = (ByteArrayInputStream)data;
                Field bufField = ByteArrayInputStream.class.getDeclaredField("buf");
                bufField.setAccessible(true);
                byte[] buf = (byte[])bufField.get(bais);
                this.setBytes(buf);
                done = true;
            }
            catch (IllegalAccessException e) {
                done = false;
            }
            catch (NoSuchFieldException e) {
                done = false;
            }
        }
        if (!forceStreamMode && !done && data instanceof FileInputStream) {
            try {
                FileInputStream fs = (FileInputStream)data;
                Field pathField = FileInputStream.class.getDeclaredField("path");
                pathField.setAccessible(true);
                String path = (String)pathField.get(fs);
                File f = new File(path);
                this.setFile(f);
                done = true;
            }
            catch (IllegalAccessException e) {
                done = false;
            }
            catch (NoSuchFieldException e) {
                done = false;
            }
        }
        if (!done || forceStreamMode) {
            this.type = DataHandler.DATA_TYPE.STREAM;
            this.streamInputData = data;
        }
        return this;
    }

    public GenericDataHandlerBuilderFacade setOutputStream(OutputStream data) {
        this.type = DataHandler.DATA_TYPE.STREAM;
        this.streamOutputData = data;
        return this;
    }

    public GenericDataHandlerBuilderFacade setByteOutput() {
        return this.setBytes(new byte[0]);
    }

    public CloudChooserDataHandlerBuilderFacade setCloud() {
        this.type = DataHandler.DATA_TYPE.CLOUD;
        return GenericDataHandlerBuilderFacade.getNewCloudFacadeFrom(this);
    }

    @Override
    public GenericDataHandlerBuilderFacade setTotalSize(Long totalSize) {
        return (GenericDataHandlerBuilderFacade)super.setTotalSize(totalSize);
    }

    @Override
    public GenericDataHandlerBuilderFacade setName(String name) {
        return (GenericDataHandlerBuilderFacade)super.setName(name);
    }

    public GenericDataHandlerBuilderFacade setReplace(boolean replace) {
        this.replace = replace;
        return this;
    }
}

