/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.ClonerInputStream;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;

public class StreamInputHandler
extends InputHandler {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    protected InputStream originalStream = null;
    protected CacheOutputStream clonedStream = null;
    protected ClonerInputStream clonerStream = null;

    protected final void initStreamInputHandler(InputStream stream, String name) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Please specify a non-null stream!");
        }
        this.originalStream = stream;
        this.clonedStream = new CacheOutputStream();
        this.clonerStream = new ClonerInputStream(this.originalStream, (OutputStream)this.clonedStream);
        this.initDataHandler(DataHandler.DATA_TYPE.STREAM, name, null);
    }

    protected StreamInputHandler() {
    }

    public StreamInputHandler(InputStream stream, String name) throws IOException {
        this.initStreamInputHandler(stream, name);
    }

    public StreamInputHandler(InputStream stream) throws IOException {
        this(stream, null);
    }

    @Override
    protected InputStream customGetInputAsNewStream() {
        InputStream ret = null;
        try {
            ret = this.clonerStream.getSlaveInputStream(this.clonedStream.getCache());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return ret;
    }
}

