/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.inputs.FileHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.util.TmpFileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class TempFileInputHandler
extends InputHandler
implements FileHandler {
    private File file;
    protected boolean deleteOnClose = true;

    public TempFileInputHandler() throws FileNotFoundException, IOException {
        this.file = TmpFileUtils.createTempFile("handler", ".tmp");
        this.initDataHandler(DataHandler.DATA_TYPE.FILE, this.name != null ? this.name : this.file.getName(), this.file.length());
    }

    public TempFileInputHandler(String prefix, String suffix) throws FileNotFoundException, IOException {
        this.file = TmpFileUtils.createTempFile("handler", ".tmp");
        this.initDataHandler(DataHandler.DATA_TYPE.FILE, this.name != null ? this.name : this.file.getName(), this.file.length());
    }

    public TempFileInputHandler(File file) throws FileNotFoundException {
        this.file = file;
        if (file == null) {
            throw new IllegalArgumentException("Please specify a non-null file!");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("The specified file [" + file.getAbsolutePath() + "] doesn't exist!");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("The specified file [" + file.getAbsolutePath() + "] is a directory!");
        }
        this.file = file;
        this.initDataHandler(DataHandler.DATA_TYPE.FILE, this.name != null ? this.name : file.getName(), file.length());
    }

    @Override
    protected InputStream customGetInputAsNewStream() {
        BufferedInputStream ret = null;
        try {
            ret = new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public void setDeleteOnClose(boolean deleteOnClose) throws IOException {
        this.deleteOnClose = deleteOnClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            try {
                super.close();
            }
            finally {
                if (this.deleteOnClose) {
                    this.file.delete();
                }
            }
        }
    }
}

