/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.RecoverySessionCredential;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class PreparedToken
extends TokenSpi {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private X509Certificate cert = null;
    private byte[] dataToSign = null;
    private int mode = -1;
    private byte[] signedData = null;
    private static final int MAX_PIN_LENGHT = 100;
    private static final int MIN_PIN_LENGHT = 0;
    private static final int MAX_RSA_KEY_LENGTH = 2048;
    private static final int MIN_RSA_KEY_LENGTH = 768;
    private static final String SERIAL_NUMBER = "0";
    private boolean public_session_open = false;
    private boolean session_open = false;

    @Override
    public void initializeLib(String[] args) throws CapiException {
        throw new UnsupportedOperationException("Use Constructor");
    }

    @Override
    public void initializeLib(String[] args, boolean tokenSoftSia) throws CapiException {
        throw new UnsupportedOperationException("Use Constructor");
    }

    @Override
    public void initializeLib(TokenParameters param) throws CapiException {
        throw new UnsupportedOperationException("Use Constructor");
    }

    public PreparedToken(X509Certificate cert) throws CapiException {
        logger.info("Prepared Token Initialized");
        if (cert == null) {
            throw new CapiException("Invalid Cert Parameter", 50040);
        }
        this.cert = cert;
    }

    public PreparedToken(X509Certificate cert, byte[] dataToSign, byte[] signedData) throws CapiException {
        logger.info("Prepared Token Initialized");
        this.cert = cert;
        this.dataToSign = dataToSign;
        this.signedData = signedData;
        try {
            Signature sig = Signature.getInstance("RSA", ProvUtils.bcProvider);
            PublicKey key = cert.getPublicKey();
            sig.initVerify(key);
            sig.update(dataToSign);
            if (!sig.verify(signedData)) {
                throw new CapiException("Firma Specificata non valida", 50040);
            }
        }
        catch (Exception ex) {
            throw new CapiException("Firma Specificata non valida", 50040, ex);
        }
    }

    @Override
    public String[] getLibInfo() {
        String[] libInfo = new String[]{"Prepared Token", "Ellips Prepared Token", "1.0", "ArubaPEC S.p.A."};
        return libInfo;
    }

    @Override
    public String getLibName() {
        return null;
    }

    @Override
    public boolean isTokenInserted() throws CapiException {
        return true;
    }

    @Override
    public String getLabel() throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public String getSerialNumber() throws CapiException {
        return SERIAL_NUMBER;
    }

    @Override
    public void finalizeLib() {
        try {
            this.closeSession();
        }
        catch (CapiException e) {
            logger.debug("Error closing session: " + e.getMessage());
        }
    }

    @Override
    public int getFreeSpace() throws CapiException {
        return -1;
    }

    @Override
    public void changePIN(String oldPin, String newPin) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PIN changing", 1004);
    }

    @Override
    public void changePUK(String oldPuk, String newPuk) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PUK changing", 1004);
    }

    @Override
    public int getMaxRSAKeyLength() throws CapiException {
        return 2048;
    }

    @Override
    public int getMinRSAKeyLength() throws CapiException {
        return 768;
    }

    @Override
    public void unblockPIN(String PUK, String newPin) throws CapiException {
        throw new CapiException("Remote Signature doesn't support unblocking", 1004);
    }

    @Override
    public int getMaxPINLen() throws CapiException {
        return 100;
    }

    @Override
    public int getMinPINLen() throws CapiException {
        return 0;
    }

    @Override
    public void openSession(boolean asSO, String pin) throws CapiException {
        this.session_open = true;
    }

    @Override
    public void openSession(boolean asSO, String pin, int slot) throws CapiException {
        throw new CapiException("openSession not supported with slot information", 1004);
    }

    @Override
    public void openSessionAuthPath(boolean asSO) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    @Override
    public void openPublicSession() throws CapiException {
        this.public_session_open = true;
    }

    @Override
    public void closeSession() throws CapiException {
        this.public_session_open = false;
        this.session_open = false;
    }

    @Override
    public boolean isSessionOpen() throws CapiException {
        return this.session_open;
    }

    @Override
    public byte[] getData(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting certificates", 1004);
    }

    @Override
    public void setData(String alias, byte[] data, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing genric data", 1004);
    }

    @Override
    public String getCert(String alias) throws CapiException {
        try {
            return Base64.toBase64String((byte[])this.cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new CapiException("Unable do encode Cert", 50040, e);
        }
    }

    @Override
    public void setCert(String alias, byte[] cert, int mode, boolean ckapriv) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    @Override
    public String installCertificate(Certificate cert) throws CapiException {
        throw new CapiException("Remote Signature doesn't support install certificates into the token", 1004);
    }

    @Override
    public boolean canImport() {
        return false;
    }

    @Override
    public boolean canExport(String alias) {
        return false;
    }

    @Override
    public int canUnblock() {
        return 0;
    }

    @Override
    public void genKeyPair(String alias, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    @Override
    public void genKeyPair(String alias, KeyAlgo algo, int type, int bits, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    @Override
    public String impCred(String alias, PrivateKey sk, int type, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support importing credentials", 1004);
    }

    @Override
    public PrivateKey expCred(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting a PrivateKey", 1004);
    }

    @Override
    public PublicKey getPublicKey(String alias) throws CapiException {
        return this.cert.getPublicKey();
    }

    @Override
    public PrivateKey getPrivateKey(String alias) throws CapiException {
        if (this.cert == null) {
            return null;
        }
        Certificate certf = new Certificate(this.cert);
        Actalis_PrivateKey ret = new Actalis_PrivateKey(alias);
        ret.setPublicInfo((RSAPublicKey)certf.getInternalCert().getPublicKey());
        ret.setCryptoDev(this);
        return ret;
    }

    @Override
    public void instCert(String alias, Certificate c, boolean enforceKeyUsage, boolean ckapriv) throws CapiException {
        throw new CapiException("Remote Signature doesn't support installing certificates", 1004);
    }

    @Override
    public int getKeyUsage(String alias, boolean testCert) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public int getKeyLength(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    @Override
    public byte[] doSign(byte[] digest, String alias, int mode) throws CapiException {
        if (this.signedData != null) {
            if (!Arrays.areEqual((byte[])digest, (byte[])this.dataToSign)) {
                throw new CapiException("Signature not Match", 50040);
            }
            return this.signedData;
        }
        this.dataToSign = digest;
        this.mode = mode;
        return digest;
    }

    @Override
    public byte[] doDecrypt(byte[] digest, String alias, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support the Decrypt functionality", 1004);
    }

    @Override
    public String[] listObjects(String expr, byte filter) throws CapiException {
        String[] arrReturn = new String[]{"PREPARED1"};
        return arrReturn;
    }

    @Override
    public void deleteObject(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public byte getObjectType(String alias) throws CapiException {
        return 2;
    }

    @Override
    public String getObjectID(String alias) throws CapiException {
        return alias;
    }

    @Override
    public int getObjectSize(String alias) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public void renameObject(String oldAlias, String newAlias, int mode) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    @Override
    public void setCert(String alias, Certificate cert, int mode, byte[] id2, boolean ckapriv) throws CapiException {
    }

    @Override
    public void setCkaId(String label, String newLabel, byte[] newId) throws CapiException {
    }

    @Override
    public boolean exist(String alias) throws CapiException {
        return "PREPARED1".equals(alias);
    }

    @Override
    public String generateID(String[] args) {
        return "PREPARED TOKEN";
    }

    @Override
    public CertificationRequest generatePKCS10CertificationRequest(X500Name subject, PublicKey key, PrivateKey signingKey) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean requiredExtendedAuth() {
        return false;
    }

    @Override
    public RecoverySessionCredential openSessionWithExtendedAuth(boolean asSO, String pin, ExtendedCredentials cred) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, String provname) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(String alias, X500Name subject) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int keySize, String CN, GeneralNames[] subjectAlternativeNames, String challengePasssword) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String certReq(X500Name subject, PublicKey rsapk, PrivateKey rsask, Provider prov) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void resetToken(String puk) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] getDataToSign() {
        return this.dataToSign;
    }

    public int getMode() {
        return this.mode;
    }
}

