/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.rsa;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.vol.utils.Constants;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;

public abstract class DigestRSASignature
extends Signature {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private Cipher a;
    protected String b;
    protected Digest hash;

    protected DigestRSASignature(String signAlgorithmName, String algorithmid, Digest messagedigest) throws NoSuchAlgorithmException {
        super(signAlgorithmName);
        this.b = algorithmid;
        this.hash = messagedigest;
    }

    @Override
    protected boolean engineVerify(byte[] abyte0) throws SignatureException {
        byte[] abyte2;
        logger.debug("engineVerify called...");
        byte[] abyte1 = new byte[this.hash.getDigestSize()];
        this.hash.doFinal(abyte1, 0);
        try {
            abyte2 = this.a.doFinal(abyte0, 0, abyte0.length);
        }
        catch (Exception exception) {
            throw new SignatureException("Signature decryption error: " + exception.toString());
        }
        try {
            ASN1Primitive asn1 = ASN1Primitive.fromByteArray((byte[])abyte2);
            MessageImprint mi = MessageImprint.getInstance((Object)((ASN1Sequence)asn1));
            AlgorithmIdentifier algorithmid = mi.getHashAlgorithm();
            byte[] abyte3 = mi.getHashedMessage();
            logger.debug("engineVerify comparing two digest ..");
            if (this.b.compareTo(algorithmid.getAlgorithm().getId()) != 0) {
                throw new SignatureException("Signature AlgorithmID mismatch!");
            }
            return Arrays.areEqual((byte[])abyte1, (byte[])abyte3);
        }
        catch (SignatureException signatureexception) {
            throw signatureexception;
        }
        catch (Exception exception1) {
            throw new SignatureException("Signature ASN.1 format error: " + exception1.toString());
        }
    }

    @Override
    protected void engineUpdate(byte[] abyte0, int i, int j) {
        this.hash.update(abyte0, i, j);
    }

    @Override
    protected void engineUpdate(byte byte0) {
        this.hash.update(byte0);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        logger.debug("engineSign: Sha256RSASignature");
        byte[] abyte0 = new byte[this.hash.getDigestSize()];
        this.hash.doFinal(abyte0, 0);
        ASN1ObjectIdentifier digestAlgOID = new ASN1ObjectIdentifier(this.b);
        AlgorithmIdentifier alg = new AlgorithmIdentifier(digestAlgOID, (ASN1Encodable)DERNull.INSTANCE);
        ASN1Encodable[] asnArray = new ASN1Encodable[]{alg, new DEROctetString(abyte0)};
        DERSequence sequence = new DERSequence(asnArray);
        byte[] abyte1 = null;
        try {
            logger.debug("engineSign: dofinal ?");
            byte[] abyte2 = sequence.getEncoded();
            abyte1 = this.a.doFinal(abyte2, 0, abyte2.length);
        }
        catch (Exception exception) {
            throw new SignatureException("Signing error: " + exception.toString());
        }
        return abyte1;
    }

    @Override
    protected void engineSetParameter(String s, Object obj) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }

    @Override
    protected void engineInitVerify(PublicKey publickey) throws InvalidKeyException {
        try {
            logger.debug("engineInitVerify called...");
            this.a = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            this.a.init(2, publickey);
            return;
        }
        catch (InvalidKeyException invalidkeyexception) {
            throw invalidkeyexception;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("InitVerify error: " + exception.toString());
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privatekey) throws InvalidKeyException {
        try {
            logger.debug("engineInitSign ?");
            this.a = Cipher.getInstance("RSA/ECB/PKCS1Padding", ActalisSingleton.getActalisProvider());
            logger.debug("engineInitSign: RSA/ECB/PKCS1Padding");
            this.a.init(1, privatekey);
            logger.debug("engineInitSign: ok");
            return;
        }
        catch (InvalidKeyException invalidkeyexception) {
            throw invalidkeyexception;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("InitSign error: " + exception.toString());
        }
    }

    @Override
    protected Object engineGetParameter(String s) throws InvalidParameterException {
        throw new InvalidParameterException("Method not supported!");
    }
}

