/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsa;

import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.tsa.TSAMessageEnum;
import it.actalis.ellips.capi.tsa.TSAUtil;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.ConfigParameter;
import it.arubapec.ca.utils.UserData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampResponse;

public class ArubaDTSClient
extends DTSClient {
    public ArubaDTSClient(ConfigParameter confParams) throws IllegalParamException {
        this(confParams.getTSAData(), confParams.getNetConf());
    }

    public ArubaDTSClient(UserData userData, String requestedUrl, NetworkConfig netConf) {
        TSAData tsaData = new TSAData(userData.getTsaUrl(), userData.getTsaAlternativeUrl(), null, userData.getTsaUsername(), userData.getTsaPassword(), userData.getTsaAlternativeUsername(), userData.getTsaAlternativePassword());
        try {
            this.initializeClient(tsaData, netConf, requestedUrl);
        }
        catch (IllegalParamException illegalParamException) {
            // empty catch block
        }
    }

    public ArubaDTSClient(TSAData tsaData) throws IllegalParamException {
        this(tsaData, new NetworkConfig(), null);
    }

    public ArubaDTSClient(TSAData tsaData, NetworkConfig netConf) throws IllegalParamException {
        this(tsaData, netConf, null);
    }

    public ArubaDTSClient(TSAData tsaData, NetworkConfig networkConfig, String requestedUrl) throws IllegalParamException {
        super(tsaData, networkConfig, requestedUrl);
    }

    @Override
    public void initializeClient(TSAData tsaData, NetworkConfig networkConfig, String requestedUrl) throws IllegalParamException {
        this.tsaData = tsaData;
        this.netConf = networkConfig == null ? new NetworkConfig() : networkConfig;
        this.requestedUrl = requestedUrl;
    }

    @Override
    @Deprecated
    public void setServer(String tsaUrl, HTTP http) {
        this.tsaData.setTSAUrl(tsaUrl);
        this.netConf = http.getConfig();
    }

    @Override
    @Deprecated
    public void setServer(String serverAddr, int serverPort) {
        String url = "https://" + serverAddr + ":" + serverPort + "/tsa/FrontEnd";
        this.tsaData.setTSAUrl(url);
    }

    @Override
    @Deprecated
    public void setTimeout(long timeOut) {
        this.netConf.setConnectionTimeOut("" + timeOut);
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, byte[] message) throws TSAException {
        return this.timeStamp(policy, algorithm, message, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, InputStream message) throws TSAException {
        return this.timeStamp(policy, algorithm, message, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, byte[] message, BigInteger nonce, boolean certReq) throws TSAException {
        ByteArrayInputStream in = null;
        TimeStampToken ret = null;
        try {
            in = new ByteArrayInputStream(message);
            ret = this.timeStamp(policy, algorithm, in, nonce, certReq);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(in);
            throw throwable;
        }
        Util.closeQuietly(in);
        return ret;
    }

    @Override
    public TimeStampToken timeStamp(String policy, String algorithm, InputStream message, BigInteger nonce, boolean certReq) throws TSAException {
        try {
            TimeStampRequest request = TSAUtil.generateMarkRequest(message, policy, certReq);
            TimeStampResponse response = TSAUtil.getMarkFromRequest(request, this.requestedUrl, this.tsaData, this.netConf);
            return new TimeStampToken(response.getEncoded());
        }
        catch (TSAException ex) {
            throw ex;
        }
        catch (CapiException | IOException ex) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR, ex);
        }
    }

    @Override
    public TimeStampToken timeStampHash(String policy, String algorithm, byte[] hash) throws TSAException {
        return this.timeStampHash(policy, algorithm, hash, null, true);
    }

    @Override
    public TimeStampToken timeStampHash(String policy, String algorithm, byte[] hash, BigInteger nonce, boolean certReq) throws TSAException {
        try {
            TimeStampRequest request = TSAUtil.generateMarkRequest(algorithm, nonce, hash, policy, certReq);
            TimeStampResponse response = TSAUtil.getMarkFromRequest(request, this.tsaData, this.netConf);
            return new TimeStampToken(response.getEncoded());
        }
        catch (TSAException ex) {
            throw ex;
        }
        catch (CapiException | IOException ex) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }

    @Override
    public TimeStampResponse getMark(InputStream message, boolean certReq) throws ApiGeneralException, IOException, TSAException {
        try {
            TimeStampResponse response = TSAUtil.getMark(message, certReq, this.tsaData, this.netConf);
            return response;
        }
        catch (TSAException ex) {
            throw ex;
        }
        catch (CapiException | IOException | TSPException ex) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }

    @Override
    public byte[] stamp(InputStream is, TimeStampOptions options) {
        BigInteger nonce = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(options.getTSAPolicy(), options.getTSADigestAlgorithm().toString(), is, nonce, options.isTSACertReq()).toByteArray(false, true);
        }
        catch (CapiException | IOException ex) {
            EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME).debug(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public byte[] stampEx(InputStream is, TimeStampOptions options) throws TSAException {
        BigInteger nonce = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(options.getTSAPolicy(), options.getTSADigestAlgorithm().toString(), is, nonce, options.isTSACertReq()).toByteArray(false, true);
        }
        catch (TSAException ex) {
            throw ex;
        }
        catch (CapiException | IOException ex) {
            EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME).debug(ex.getMessage(), (Throwable)ex);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }
}

