/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl;

import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsl.ParsingResults;
import it.actalis.ellips.capi.tsl.TSL;
import it.actalis.ellips.capi.tsl.TSLPointer;
import it.actalis.ellips.capi.tsl.TSLServiceType;
import it.actalis.ellips.capi.tsl.TSLStatus;
import it.actalis.ellips.capi.tsl.TSPService;
import it.actalis.ellips.capi.tsl.TrustServiceProvider;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class TSLParserFactory {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private LinkedList<String> serviceTypeIDs = new LinkedList();
    private boolean isForceHTTPS = false;
    private boolean completeChain = true;
    private NetworkConfig netConf = new NetworkConfig();

    public void setForceHTTPSConnections(boolean bVal) {
        this.isForceHTTPS = bVal;
    }

    public boolean isForcedToHTTPSConnections() {
        return this.isForceHTTPS;
    }

    public void setServiceTypeIDs(LinkedList<String> serviceTypeIDs) {
        this.serviceTypeIDs = serviceTypeIDs;
    }

    public boolean setNetworkConfig(NetworkConfig config) {
        if (config == null) {
            return false;
        }
        this.netConf = config;
        return true;
    }

    public NetworkConfig getNetworkConfig() {
        return this.netConf;
    }

    public void setConnectionTimeout(int mSec) {
        this.netConf.setConnectionTimeOut(String.format("%d", mSec));
    }

    public void setReadTimeout(int mSec) {
        this.netConf.setReadTimeOut(String.format("%d", mSec));
    }

    private InputStream getRemoteFile(String urlstr) {
        ByteArrayInputStream inputStream = null;
        try {
            UrlClient client = new UrlClient(this.netConf, logger);
            URLCredentials creds = new URLCredentials(this.netConf.getUserProxy(), this.netConf.getPasswordProxy(), null, null);
            RequestData reqData = new RequestData();
            UrlReturn ret = client.downloadUrl(urlstr, reqData, creds);
            if (!ret.getStatus().equals("OK")) {
                return null;
            }
            byte[] data = ret.getData();
            inputStream = new ByteArrayInputStream(data);
        }
        catch (Exception e) {
            logger.error("remote download exception: " + e.getMessage());
            return null;
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTSLHash(String tslUrl) {
        byte[] hash;
        InputStream tslInputStream = this.getRemoteFile(tslUrl);
        if (tslInputStream == null) {
            logger.error("unable to get the remote " + tslUrl);
            return "";
        }
        try {
            hash = Util.digestStreams(Constants.SHA256, tslInputStream);
        }
        catch (Exception e) {
            String string;
            try {
                logger.error("error evaluating hash of " + tslUrl);
                string = "";
            }
            catch (Throwable throwable) {
                try {
                    Util.closeQuietly(tslInputStream);
                    throw throwable;
                }
                catch (Exception ex) {
                    logger.error(String.format("error evaluating TSL hash: %s", ex.getMessage()));
                    return "";
                }
            }
            Util.closeQuietly(tslInputStream);
            return string;
        }
        Util.closeQuietly(tslInputStream);
        return new String(Hex.encode((byte[])hash));
    }

    public List<TSLPointer> parseListOfTSL(String EUTSLUrl) throws CapiException {
        if (EUTSLUrl == null || EUTSLUrl.length() == 0) {
            return null;
        }
        TSLPointer pointer = new TSLPointer(EUTSLUrl);
        try {
            TSL listOfLists = new TSL(pointer, this.netConf, this.serviceTypeIDs, !this.isForceHTTPS);
            Date issue = listOfLists.getIssueDate();
            int seq = listOfLists.getSequenceNumber();
            List<TSLPointer> locations = listOfLists.getTSLLocations();
            logger.info(String.format("TSL issue date: %s\nTSL sequence number:%d\nNational TSL locations found:%d\n", issue.toString(), seq, locations.size()));
            return locations;
        }
        catch (CapiException c) {
            logger.debug("[manageListOfList] Exception " + c.getMessage() + " code:" + c.getErrorCode() + " parsing TSL " + pointer.getUrl());
            throw c;
        }
    }

    public ParsingResults parseEUStateList(TSLPointer tslPointer, CertDB cdb) throws CapiException {
        return this.parseEUStateList(tslPointer, cdb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsingResults parseEUStateList(TSLPointer tslPointer, CertDB cdb, File tempTSLFile) throws CapiException {
        List<TrustServiceProvider> providers;
        ParsingResults parsingResults = new ParsingResults();
        if (tslPointer == null || cdb == null) {
            return parsingResults;
        }
        logger.debug("Parsing TSL " + tslPointer.getUrl());
        TSL tsl = null;
        tsl = tslPointer.getArchivedFile() != null ? new TSL(tslPointer, this.serviceTypeIDs, !this.isForceHTTPS) : new TSL(tslPointer, this.netConf, this.serviceTypeIDs, !this.isForceHTTPS, tempTSLFile);
        if (tsl.getIssueDate() != null) {
            parsingResults.lastUpdate = tsl.getIssueDate();
        }
        if (tsl.getNextIssueDate() != null) {
            parsingResults.nextUpdate = tsl.getNextIssueDate();
        }
        int seq = tsl.getSequenceNumber();
        if (tslPointer.isVerifyXMLSignature()) {
            logger.debug("[parse] TSL sequence number: " + seq);
            X509Certificate cert = tsl.getTslSignerCertificate();
            logger.debug("[parse] TSL signer: " + cert.getSubjectDN().getName());
        }
        if ((providers = tsl.getTrustServiceProvider()) == null || providers.isEmpty()) {
            logger.debug("[parse] No TrustServiceProviders");
            logger.debug("[parse] Found 0 certificates in TSL " + tslPointer.getUrl());
            return parsingResults;
        }
        logger.debug("Found " + providers.size() + " TrustServiceProviders");
        parsingResults.nProviders = providers.size();
        ArrayList<CertDBItem> intermediateRoots = new ArrayList<CertDBItem>();
        for (TrustServiceProvider provider : providers) {
            String provName = provider.getName();
            logger.debug("[parse] TSL provider: " + provName);
            LinkedList<TSPService> services = provider.getTSPService();
            logger.debug("[parse] Found " + services.size() + " TSL service");
            parsingResults.nServices += services.size();
            for (TSPService service : services) {
                CertDBItem intermediateItem;
                CertDBItem dbItem;
                byte[] rootCert;
                int iCert;
                logger.debug("[parse] TSL service: " + service.getName());
                LinkedList<X509Certificate> srvCert = service.getCertificates();
                if (srvCert.isEmpty()) continue;
                parsingResults.nTotalCerts += srvCert.size();
                String status = service.getStatus();
                if (TSLStatus.isStatusIn(TSLStatus.StatusGroup.TRUSTED, status)) {
                    logger.debug("[parse] TSL service accredited certificate: found " + srvCert.size() + " certificates");
                    ++parsingResults.nServiceTrusted;
                    for (iCert = 0; iCert < srvCert.size(); ++iCert) {
                        try {
                            rootCert = ((X509Certificate)srvCert.get(iCert)).getEncoded();
                            dbItem = cdb.contains(rootCert);
                            if (dbItem == null) {
                                if (this.importRoot(cdb, service, rootCert)) {
                                    ++parsingResults.nCertImported;
                                    dbItem = cdb.contains(rootCert);
                                    parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.TRUSTED.ordinal()).add(dbItem);
                                } else {
                                    ++parsingResults.nCertImportSkipped;
                                }
                            } else if (this.updateRoot(cdb, dbItem, 2, service)) {
                                ++parsingResults.nCertUpdated;
                                parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.TRUSTED.ordinal()).add(dbItem);
                            } else {
                                ++parsingResults.nCertUpdateSkipped;
                            }
                            intermediateItem = this.isSuitableIntermediateRoot(dbItem);
                            if (intermediateItem == null) continue;
                            intermediateRoots.add(intermediateItem);
                            continue;
                        }
                        catch (Exception e) {
                            ++parsingResults.nCertErrors;
                        }
                    }
                    if (service.getAdditionalServiceInfo().isEmpty()) {
                        if (!parsingResults.serviceTypeWithoutAdditionalSrvInfo.contains(TSLServiceType.urlToId(service.getType()))) {
                            parsingResults.serviceTypeWithoutAdditionalSrvInfo.add(TSLServiceType.urlToId(service.getType()));
                        }
                        ++parsingResults.nServiceWithoutAdditionalSrvInfo;
                        continue;
                    }
                    if (parsingResults.serviceTypeWithAdditionalSrvInfo.contains(TSLServiceType.urlToId(service.getType()))) continue;
                    parsingResults.serviceTypeWithAdditionalSrvInfo.add(TSLServiceType.urlToId(service.getType()));
                    continue;
                }
                if (TSLStatus.isStatusIn(TSLStatus.StatusGroup.WARNING, status)) {
                    logger.debug("[parse] TSL service unqualified certificate: found " + srvCert.size() + " certificates");
                    ++parsingResults.nServiceWarning;
                    for (iCert = 0; iCert < srvCert.size(); ++iCert) {
                        try {
                            rootCert = ((X509Certificate)srvCert.get(iCert)).getEncoded();
                            dbItem = cdb.contains(rootCert);
                            if (dbItem == null) {
                                if (this.importRoot(cdb, service, rootCert)) {
                                    ++parsingResults.nCertImported;
                                    dbItem = cdb.contains(rootCert);
                                    parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.WARNING.ordinal()).add(dbItem);
                                } else {
                                    ++parsingResults.nCertImportSkipped;
                                }
                            } else if (this.updateRoot(cdb, dbItem, 2, service)) {
                                ++parsingResults.nCertUpdated;
                                parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.WARNING.ordinal()).add(dbItem);
                            } else {
                                ++parsingResults.nCertUpdateSkipped;
                            }
                            intermediateItem = this.isSuitableIntermediateRoot(dbItem);
                            if (intermediateItem == null) continue;
                            intermediateRoots.add(intermediateItem);
                            continue;
                        }
                        catch (Exception e) {
                            ++parsingResults.nCertErrors;
                        }
                    }
                    if (service.getAdditionalServiceInfo().isEmpty()) {
                        if (!parsingResults.serviceTypeWithoutAdditionalSrvInfo.contains(TSLServiceType.urlToId(service.getType()))) {
                            parsingResults.serviceTypeWithoutAdditionalSrvInfo.add(TSLServiceType.urlToId(service.getType()));
                        }
                        ++parsingResults.nServiceWithoutAdditionalSrvInfo;
                        continue;
                    }
                    if (parsingResults.serviceTypeWithAdditionalSrvInfo.contains(TSLServiceType.urlToId(service.getType()))) continue;
                    parsingResults.serviceTypeWithAdditionalSrvInfo.add(TSLServiceType.urlToId(service.getType()));
                    continue;
                }
                if (TSLStatus.isStatusIn(TSLStatus.StatusGroup.UNTRUSTED, status)) {
                    logger.debug("[parse] TSL service accreditationrevoked certificate: found " + srvCert.size() + " certificates");
                    ++parsingResults.nServiceUntrusted;
                    for (iCert = 0; iCert < srvCert.size(); ++iCert) {
                        try {
                            rootCert = ((X509Certificate)srvCert.get(iCert)).getEncoded();
                            dbItem = cdb.contains(rootCert);
                            if (dbItem == null) {
                                if (this.importRoot(cdb, service, rootCert)) {
                                    dbItem = cdb.contains(rootCert);
                                    dbItem.setTrust(0);
                                    dbItem.setStatus(status);
                                    if (cdb.update(dbItem)) {
                                        cdb.store();
                                        ++parsingResults.nCertImported;
                                        parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.UNTRUSTED.ordinal()).add(dbItem);
                                        continue;
                                    }
                                    ++parsingResults.nCertErrors;
                                    continue;
                                }
                                ++parsingResults.nCertImportSkipped;
                                continue;
                            }
                            if (this.updateRoot(cdb, dbItem, 0, service)) {
                                ++parsingResults.nCertUpdated;
                                parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.UNTRUSTED.ordinal()).add(dbItem);
                                continue;
                            }
                            ++parsingResults.nCertUpdateSkipped;
                            continue;
                        }
                        catch (Exception e) {
                            ++parsingResults.nCertErrors;
                        }
                    }
                    continue;
                }
                if (!TSLStatus.isStatusIn(TSLStatus.StatusGroup.REMOVED, status)) continue;
                ++parsingResults.nServiceRemoved;
                logger.debug("[parse] TSL service accreditationceased certificate: found " + srvCert.size() + " certificates");
                for (iCert = 0; iCert < srvCert.size(); ++iCert) {
                    try {
                        rootCert = ((X509Certificate)srvCert.get(iCert)).getEncoded();
                        dbItem = cdb.contains(rootCert);
                        if (dbItem != null) {
                            cdb.delete(dbItem);
                            cdb.store();
                            ++parsingResults.nCertRemoved;
                            parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.REMOVED.ordinal()).add(dbItem);
                            continue;
                        }
                        ++parsingResults.nCertRemoveSkipped;
                        continue;
                    }
                    catch (Exception e) {
                        ++parsingResults.nCertErrors;
                    }
                }
            }
        }
        if (!intermediateRoots.isEmpty() && !tslPointer.getUrl().equals(TSL.URL_DSList)) {
            logger.info(String.format("%d intermediate roots found", intermediateRoots.size()));
            logger.info("-- start parsing caIssuer --");
            String curTimeout = this.netConf.getConnectionTimeOut();
            this.netConf.setConnectionTimeOut("5000");
            this.netConf.setFollowRedirect(true);
            int nParentIssuerAdded = 0;
            try {
                for (int iItem = 0; iItem < intermediateRoots.size(); ++iItem) {
                    LinkedList<CertDBItem> chainDBItems = new LinkedList<CertDBItem>();
                    if (!cdb.resolveChainOnLine(this.netConf, ((CertDBItem)intermediateRoots.get(iItem)).getCert(true), chainDBItems)) continue;
                    for (int iRoot = 0; iRoot < chainDBItems.size(); ++iRoot) {
                        CertDBItem curDBItem = chainDBItems.get(iRoot);
                        curDBItem.setSource(5);
                        curDBItem.resetEllipsUsage();
                        curDBItem.addEllipsUsage(CertDBItem.EllipsUsage.GENERIC_TRUSTED_ROOT);
                        curDBItem.setTslId("");
                        try {
                            cdb.add(curDBItem);
                            ++parsingResults.nCertImportedByCAIssuer;
                            parsingResults.parsedRoots.get(ParsingResults.ParsingStatus.CAISSUER.ordinal()).add(curDBItem);
                            ++nParentIssuerAdded;
                            continue;
                        }
                        catch (Exception ex) {
                            ++parsingResults.nCertErrors;
                        }
                    }
                    cdb.store();
                }
            }
            catch (Throwable throwable) {
                this.netConf.setConnectionTimeOut(curTimeout);
                this.netConf.setFollowRedirect(false);
                logger.info(String.format("%d caIssuer added", nParentIssuerAdded));
                logger.info("-- end parsing caIssuer --");
                throw throwable;
            }
            this.netConf.setConnectionTimeOut(curTimeout);
            this.netConf.setFollowRedirect(false);
            logger.info(String.format("%d caIssuer added", nParentIssuerAdded));
            logger.info("-- end parsing caIssuer --");
        }
        return parsingResults;
    }

    private boolean updateRoot(CertDB cdb, CertDBItem itemToUpdate, int newTrustStatus, TSPService service) throws CertDBException, CapiException {
        int source;
        boolean updated = false;
        if (itemToUpdate.getTrust() != newTrustStatus) {
            itemToUpdate.setTrust(newTrustStatus);
            updated = true;
        }
        if (itemToUpdate.getStatus() == null || itemToUpdate.getStatus().isEmpty() || !itemToUpdate.getStatus().equals(service.getStatus())) {
            itemToUpdate.setStatus(service.getStatus());
            updated = true;
        }
        if ((source = itemToUpdate.getSource()) == 3 || source == 4 || source == 5) {
            itemToUpdate.setSource(1);
            updated = true;
        }
        List<CertDBItem.EllipsUsage> usages = service.getEllipsUsagesForService();
        List<CertDBItem.EllipsUsage> oldUsages = itemToUpdate.getEllipsUsages();
        boolean usagesChanged = false;
        if (usages.size() != oldUsages.size()) {
            usagesChanged = true;
        } else {
            for (CertDBItem.EllipsUsage usage : usages) {
                if (oldUsages.contains((Object)usage)) continue;
                usagesChanged = true;
                break;
            }
        }
        if (usagesChanged) {
            itemToUpdate.addEllipsUsages(usages);
            updated = true;
        }
        if (!itemToUpdate.getTslId().equals(service.getTslId())) {
            itemToUpdate.setTslId(service.getTslId());
            updated = true;
        }
        return updated &= cdb.update(itemToUpdate);
    }

    private boolean importRoot(CertDB cdb, TSPService service, byte[] rootCert) throws CapiException {
        try {
            CertDBItem itemToImport = cdb.canImport(rootCert);
            Certificate itemCert = itemToImport.getCertificate();
            itemToImport.setName(itemCert.getName());
            itemToImport.setSubjectAndIssuer(itemCert);
            itemToImport.setSource(1);
            itemToImport.setTslId(service.getTslId());
            itemToImport.setStatus(service.getStatus());
            itemToImport.resetEllipsUsage();
            itemToImport.addEllipsUsages(service.getEllipsUsagesForService());
            cdb.add(itemToImport);
            logger.debug("[importCert] successfully done.");
            return true;
        }
        catch (CapiException ex) {
            logger.debug("[importCert] Capi Exception " + ex.getErrorCode() + " importing cert: " + ex.getMessage());
            int error = ex.getErrorCode();
            if (error == 80000 || error == 80003 || error == 80004 || error == 80005 || error == 80006 || error == 80007) {
                logger.debug("[importCert] restoring certDB...");
                throw ex;
            }
            return false;
        }
    }

    public boolean isCompleteChain() {
        return this.completeChain;
    }

    public void setCompleteChain(boolean completeChain) {
        this.completeChain = completeChain;
    }

    public CertDBItem isSuitableIntermediateRoot(CertDBItem dbItem) throws CapiException {
        if (!this.completeChain) {
            return null;
        }
        if (dbItem.getCertificate().getSubjectDN().equals(dbItem.getCertificate().getIssuerDN())) {
            logger.debug(dbItem.getName() + " is not suitable to be an intermediate root in the chain because seems self-signed");
            return null;
        }
        if (dbItem.getCertificate().getCaIssuer() == null) {
            logger.debug(dbItem.getName() + " is not suitable to be an intermediate root in the chain because caIssuer link is null");
            return null;
        }
        return dbItem;
    }
}

