/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater.config;

import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.LoggerLevel;
import it.actalis.ellips.capi.tsl.rootupdater.UpdateMode;
import it.actalis.ellips.capi.tsl.rootupdater.config.CertDBFileBuilder;
import it.actalis.ellips.capi.tsl.rootupdater.config.CertDBPasswordBuilder;
import it.actalis.ellips.capi.tsl.rootupdater.config.HomeFolderBuilder;
import it.arubapec.ca.utils.ConfigParameter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import secretstoreutils.SecretStore;

public class RootUpdaterConfigFile
implements HomeFolderBuilder,
CertDBFileBuilder,
CertDBPasswordBuilder {
    private String homeFolder;
    private String certDBFilePath;
    private String certDBPassword;
    private NetworkConfig networkConfig;
    private boolean forceHttpsConnection = false;
    private String reportFileName = "LastUpdateReport.txt";
    private String customTSLItaUrl = "";
    private String customTSLItaCert = "";
    private int maxDaysFromLastUpdateEU = 30;
    private boolean forcedUpdate = false;
    private boolean fileProgressEnabled = false;
    private boolean printTSLEndpoints = false;
    private UpdateMode updateMode = UpdateMode.ATSL_SIGNED;
    private ArrayList<String> ignorelist = new ArrayList();
    private File fileAppender = null;
    private LoggerLevel loggerLevel = LoggerLevel.INFO;
    private boolean consoleAppender = false;

    private RootUpdaterConfigFile() {
    }

    public static HomeFolderBuilder createConfigFile() {
        return new RootUpdaterConfigFile();
    }

    public void save(File configFile) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("homeFolder", this.homeFolder);
        properties.setProperty("certdb.file", this.certDBFilePath);
        properties.setProperty("certdb.pwd", this.certDBPassword);
        properties.setProperty("reportFileName", this.reportFileName);
        properties.setProperty("proxyType", this.networkConfig.getProxyType());
        properties.setProperty("proxyHost", this.networkConfig.getProxy());
        properties.setProperty("proxyPort", this.networkConfig.getProxyPort());
        properties.setProperty("proxyUser", this.networkConfig.getUserProxy());
        properties.setProperty("proxyPassword", SecretStore.CryptByPassword((String)ConfigParameter.USER_NAME, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)this.networkConfig.getPasswordProxy()));
        properties.setProperty("ldapProxyType", this.networkConfig.getLdapProxyType());
        properties.setProperty("ldapProxyHost", this.networkConfig.getLdapProxy());
        properties.setProperty("ldapProxyPort", this.networkConfig.getLdapProxyPort());
        properties.setProperty("ldapProxyUser", this.networkConfig.getLdapUserProxy());
        properties.setProperty("ldapProxyPassword", SecretStore.CryptByPassword((String)ConfigParameter.USER_NAME, (String)"asjkacidofvnianvoraenvoaenvosdafnvsdfvnsdlnf\u00f2sdgorngesogvncmakldmasa'<z,lzxllzc854625567&58", (String)this.networkConfig.getLdapPasswordProxy()));
        properties.setProperty("connectionTimeOut", this.networkConfig.getConnectionTimeOut());
        properties.setProperty("forceHttpsConnection", this.forceHttpsConnection ? "true" : "false");
        properties.setProperty("customTSLItaUrl", this.customTSLItaUrl);
        properties.setProperty("customTSLItaCert", this.customTSLItaCert);
        properties.setProperty("maxDaysFromLastUpdateEU", String.valueOf(this.maxDaysFromLastUpdateEU));
        properties.setProperty("forcedUpdate", this.forcedUpdate ? "true" : "false");
        properties.setProperty("fileProgressEnabled", this.fileProgressEnabled ? "true" : "false");
        properties.setProperty("printTSLEndpoints", this.printTSLEndpoints ? "true" : "false");
        properties.setProperty("updateMode", this.updateMode.name());
        String ignoreTSLList = "";
        for (String url : this.ignorelist) {
            ignoreTSLList = ignoreTSLList + url + ";";
        }
        properties.setProperty("ignorelist", ignoreTSLList);
        properties.setProperty("fileAppender", this.fileAppender.getPath());
        properties.setProperty("level", this.loggerLevel.name());
        properties.setProperty("consoleAppender", this.consoleAppender ? "true" : "false");
        properties.store(new FileOutputStream(configFile), "");
    }

    public RootUpdaterConfigFile setIgnoreTSLList(ArrayList<String> ignoreTSL) {
        this.ignorelist = ignoreTSL;
        return this;
    }

    public RootUpdaterConfigFile setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
        return this;
    }

    public RootUpdaterConfigFile setForceHttpsConnection(boolean force) {
        this.forceHttpsConnection = force;
        return this;
    }

    public RootUpdaterConfigFile setCustomTSLItaUrl(String customTSLItaUrl) {
        this.customTSLItaUrl = customTSLItaUrl;
        return this;
    }

    public RootUpdaterConfigFile setCustomTSLItaCert(String customTSLItaCert) {
        this.customTSLItaCert = customTSLItaCert;
        return this;
    }

    public RootUpdaterConfigFile setMaxDaysFromLastUpdateEU(int maxDaysFromLastUpdateEU) {
        this.maxDaysFromLastUpdateEU = maxDaysFromLastUpdateEU;
        return this;
    }

    public RootUpdaterConfigFile setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
        return this;
    }

    public RootUpdaterConfigFile setForcedUpdate(boolean forcedUpdate) {
        this.forcedUpdate = forcedUpdate;
        return this;
    }

    public RootUpdaterConfigFile setFileProgressEnabled(boolean fileProgressEnabled) {
        this.fileProgressEnabled = fileProgressEnabled;
        return this;
    }

    public RootUpdaterConfigFile setPrintTSLEndpoints(boolean printTSLEndpoints) {
        this.printTSLEndpoints = printTSLEndpoints;
        return this;
    }

    public RootUpdaterConfigFile setUpdateMode(UpdateMode updateMode) {
        this.updateMode = updateMode;
        return this;
    }

    public RootUpdaterConfigFile setLoggerFileAppender(File appender) {
        this.fileAppender = appender;
        return this;
    }

    public RootUpdaterConfigFile setLoggerLevel(LoggerLevel level) {
        this.loggerLevel = level;
        return this;
    }

    public RootUpdaterConfigFile setLoggerConsoleAppender(boolean appender) {
        this.consoleAppender = appender;
        return this;
    }

    @Override
    public CertDBFileBuilder withHomeFolder(String path) {
        this.homeFolder = path;
        return this;
    }

    @Override
    public CertDBPasswordBuilder withCertDBFile(String file) {
        this.certDBFilePath = file;
        return this;
    }

    @Override
    public RootUpdaterConfigFile withCertDBPassword(String password) {
        this.certDBPassword = password;
        return this;
    }
}

