/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ShiftingBuffer<T> {
    private final Queue<T> internalBuffer;
    private final int bufferSize;
    private int actualSize;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getActualSize() {
        return this.actualSize;
    }

    public ShiftingBuffer(int size) {
        this.bufferSize = size;
        this.actualSize = 0;
        this.internalBuffer = new LinkedList<T>();
    }

    public void update(T newElem) {
        if (this.actualSize == this.bufferSize) {
            this.internalBuffer.poll();
            --this.actualSize;
        }
        if (this.internalBuffer.offer(newElem)) {
            ++this.actualSize;
        }
    }

    public void reset() {
        this.actualSize = 0;
        this.internalBuffer.clear();
    }

    public List<T> getValue() {
        Object[] arr = this.internalBuffer.toArray();
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object o : arr) {
            res.add(o);
        }
        return res;
    }
}

