/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml.parser;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.tsl.TSLPointer;
import it.actalis.ellips.capi.xml.parser.SignedXMLEnvelope;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class TSLVerifier {
    private static Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private Date signDate = null;
    private X509Certificate tslSignerCertificate = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifySignedXMLDocument(TSLPointer pointer, File tempTSLFile) throws CapiException {
        InputHandler fis = null;
        SignedXMLEnvelope se = null;
        String[] signers = null;
        try {
            fis = DataHandlerBuilder.get().setFile(tempTSLFile).buildInput();
        }
        catch (IOException e2) {
            throw new CapiException("tslTemporaryFileName not found", 50040);
        }
        catch (Exception ex) {
            throw new CapiException("Unable to read tslTemporaryFileName", 50040, ex);
        }
        try {
            se = new SignedXMLEnvelope(fis);
            signers = se.listSigners();
        }
        finally {
            Util.closeQuietly(fis);
        }
        if (signers == null || signers.length <= 0) {
            logger.debug("No signers found. TSL is not signed");
            throw new CapiException("TSL is not signed", 50001);
        }
        logger.debug("Checking first TSL signature");
        try {
            String signDateStr;
            String cer = se.verify(0);
            Certificate crt = new Certificate(cer.getBytes());
            this.tslSignerCertificate = crt.getInternalCert();
            logger.debug("TSL signature verified successfully.");
            logger.debug("Signed TSL. TSL signer: " + this.tslSignerCertificate.getSubjectX500Principal());
            TimeStampToken tst = null;
            this.signDate = null;
            ByteArrayInputStream tstis = null;
            try {
                if (se.getNumSignatureTimeStamp(0) > 0 && (tst = se.getSignatureTimeStamp(0, 0)) != null) {
                    tstis = new ByteArrayInputStream(tst.toByteArray(true));
                    TimeStampResponse objResp = new TimeStampResponse((InputStream)tstis);
                    this.signDate = Util.getDateFromTStamp(objResp.getTimeStampToken());
                    logger.debug("TSL TimeStamped signTime: " + this.signDate.toString());
                }
            }
            catch (Exception e) {
                tst = null;
                this.signDate = null;
            }
            finally {
                Util.closeQuietly(tstis);
            }
            if (this.signDate == null && (signDateStr = se.getSigningTime(0)) != null) {
                try {
                    logger.debug("[verifyXMLSignature] parse TSL signTime: " + signDateStr);
                    this.signDate = this.parseXMLTime(signDateStr);
                    logger.debug("TSL signTime: " + this.signDate.toString());
                }
                catch (Exception e) {
                    logger.debug("Unable to parse SignTime: " + e.getMessage());
                }
            }
            int numRef = se.getNumReference(0);
            logger.debug("TSL signature has " + numRef + " Reference items...");
            for (int r = 0; r < numRef; ++r) {
                boolean isVerified = se.getReferenceIsVerified(0, r);
                logger.debug(r + " Reference verification is " + isVerified);
                if (isVerified) continue;
                logger.debug("reference item " + r + " verification failed");
                throw new CapiException("reference item " + r + " verification failed ", 3010);
            }
            try {
                if (pointer.getCacerts() != null) {
                    pointer.getCacerts().verify(cer.getBytes());
                }
            }
            catch (CapiException ex) {
                String ski = new String(Base64.encode((byte[])new Certificate(cer.getBytes()).getSubjectKeyIdentifier()));
                if (pointer.getNot_importable_ski() == null || !pointer.getNot_importable_ski().contains(ski)) {
                    throw new CapiException("Invalid certificate ", 3010);
                }
            }
        }
        catch (CapiException ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            logger.debug("TSL has an invalid signature");
            logger.debug(e.getMessage(), (Throwable)e);
            throw new CapiException("Exception verifying TSL signature " + e.getMessage(), 3010);
        }
    }

    public Date getSignDate() {
        return this.signDate;
    }

    public X509Certificate getTslSignerCertificate() {
        return this.tslSignerCertificate;
    }

    private Date parseXMLTime(String signTime) throws Exception {
        SimpleDateFormat df = null;
        Date date = null;
        try {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            df.setTimeZone(TimeZone.getTimeZone("Zulu"));
            date = df.parse(signTime);
            return date;
        }
        catch (Exception e) {
            try {
                df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                df.setTimeZone(TimeZone.getTimeZone("Zulu"));
                date = df.parse(signTime);
                return date;
            }
            catch (Exception e1) {
                try {
                    df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                    df.setTimeZone(TimeZone.getTimeZone("Zulu"));
                    date = df.parse(signTime.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2"));
                    return date;
                }
                catch (Exception eEnd) {
                    logger.debug("Exception parsing TSL issue date: " + eEnd.getMessage());
                    return null;
                }
            }
        }
    }
}

