/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.util.java6;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.ATR;
import it.actalis.vol.utils.Constants;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import org.slf4j.Logger;

public class PCSC6 {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    TerminalFactory tf = null;
    List terms = null;
    String[] pcscReaders = null;
    int slotWithCardPresent = 0;
    Card card = null;
    CardChannel channel = null;
    CardTerminal cardTerminal = null;
    public boolean exclusive = true;
    String osName = null;
    String javaVer = null;

    public PCSC6() throws Exception {
        try {
            this.tf = TerminalFactory.getDefault();
            this.terms = this.tf.terminals().list();
            if (this.terms == null || this.terms.isEmpty() || this.terms.size() == 0) {
                this.pcscReaders = null;
                this.trace("No reader found.");
                throw new CardException("");
            }
            this.pcscReaders = new String[this.terms.size()];
            this.trace("Found " + this.terms.size() + " readers.");
            for (int k = 0; k < this.terms.size(); ++k) {
                CardTerminal ct = (CardTerminal)this.terms.get(k);
                this.pcscReaders[k] = ct.getName().trim();
                this.trace("Found reader: " + this.pcscReaders[k] + " - n. " + k);
            }
            this.osName = System.getProperty("os.name");
            this.javaVer = System.getProperty("java.version");
        }
        catch (Exception e) {
            this.trace(e);
            throw e;
        }
    }

    public List<String> getAllATR() {
        if (this.terms == null || this.terms.isEmpty()) {
            this.trace("No reader found.");
            return null;
        }
        ArrayList<String> atrList = new ArrayList<String>();
        for (int k = 0; k < this.terms.size(); ++k) {
            byte[] atr = this.getATR(k, -1L);
            if (atr == null || atr.length <= 0) continue;
            atrList.add(ATR.toHexString(atr).toLowerCase());
        }
        return atrList;
    }

    public String[] getPcscReaders() {
        return this.pcscReaders;
    }

    public int getLastSlotWithCardPresent() {
        return this.slotWithCardPresent;
    }

    public boolean waitCardRemoveFromReader() {
        if (this.cardTerminal == null) {
            return true;
        }
        try {
            boolean ret = true;
            if (this.osName.toLowerCase().startsWith("mac os") && this.javaVer.compareTo("1.7") >= 0) {
                this.trace("mac os and java version " + this.javaVer);
                Thread.sleep(1000L);
                Card c = this.cardTerminal.connect("*");
                byte[] atr = this.getATR(c);
                return atr == null || atr.length <= 0;
            }
            if (this.cardTerminal.isCardPresent()) {
                ret = this.cardTerminal.waitForCardAbsent(500L);
            }
            return ret;
        }
        catch (Exception e) {
            this.trace(e);
            return true;
        }
    }

    public byte[] getATR() {
        return this.waitCardIntoReader(-1, -1L);
    }

    public byte[] waitCardIntoReader(int readerIdx, long timeout) {
        try {
            if (this.terms == null || this.terms.isEmpty() || this.terms.size() == 0 || readerIdx >= this.terms.size()) {
                this.trace("No reader found.");
                return null;
            }
            if (readerIdx == -1) {
                for (int k = 0; k < this.terms.size(); ++k) {
                    byte[] atr = this.getATR(k, timeout);
                    if (atr == null || atr.length <= 0) continue;
                    return atr;
                }
            } else {
                byte[] atr = this.getATR(readerIdx, timeout);
                return atr;
            }
            return null;
        }
        catch (Exception e) {
            this.trace(e);
            return null;
        }
    }

    private byte[] getATR(int readerIdx, long timeout) {
        try {
            Card crd;
            byte[] atr;
            this.trace("getting ATR of card in reader n. " + readerIdx + " ...");
            CardTerminal ct = (CardTerminal)this.terms.get(readerIdx);
            if (this.osName.toLowerCase().startsWith("mac os") && this.javaVer.compareTo("1.7") >= 0) {
                this.trace("mac os and java version " + this.javaVer);
                if (timeout > 0L) {
                    Thread.sleep(timeout);
                }
            } else {
                boolean present = false;
                present = timeout >= 0L ? ct.waitForCardPresent(timeout) : ct.isCardPresent();
                if (!present) {
                    this.trace("card not present in reader " + ct.getName().trim());
                    return null;
                }
            }
            if ((atr = this.getATR(crd = ct.connect("*"))) != null && atr.length > 0) {
                this.trace("atr: " + PCSC6.byteArrayToHexString(atr));
                this.trace("reader n. " + readerIdx);
                this.trace("reader name: " + ct.getName().trim());
                this.slotWithCardPresent = readerIdx;
                this.card = crd;
                this.cardTerminal = ct;
            } else {
                this.trace("no atr from card in reader " + ct.getName().trim());
            }
            return atr;
        }
        catch (Exception e) {
            this.trace(e);
            return null;
        }
    }

    private byte[] getATR(Card c) throws Exception {
        if (c == null) {
            this.trace("Card is null");
            return null;
        }
        javax.smartcardio.ATR a = c.getATR();
        if (a == null) {
            this.trace("ATR is null");
            return null;
        }
        byte[] atr = a.getBytes();
        if (atr != null && atr.length > 0) {
            this.trace("atr successfully detected");
        } else {
            this.trace("no atr bytes");
        }
        return atr;
    }

    public void connect() throws Exception {
        if (this.card == null) {
            throw new Exception("No card inserted.");
        }
        this.trace("APDU communication - exclusive is " + this.exclusive);
        this.channel = this.card.getBasicChannel();
        if (this.exclusive) {
            this.card.beginExclusive();
            this.trace("APDU communication is exclusive ");
        }
    }

    public byte[] sendAPDU(byte[] c1) throws Exception {
        ResponseAPDU r = this.channel.transmit(new CommandAPDU(c1));
        return r.getBytes();
    }

    public void disconnect() {
        if (this.card == null) {
            return;
        }
        try {
            if (this.exclusive) {
                this.card.endExclusive();
            }
            this.card.disconnect(false);
        }
        catch (CardException e) {
            this.trace(e);
        }
    }

    public static byte[] hexStringToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
        }
        return b;
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            int v = b[i] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }

    private void trace(String s) {
        logger.debug("[PCSC6] {}", (Object)s);
    }

    private void trace(Exception e) {
        logger.debug(e.getMessage(), (Throwable)e);
    }
}

