/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.utils;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class FileUtils {
    public static void copyfile(File r, File d) throws FileNotFoundException, IOException {
        Files.copy(r.toPath(), d.toPath(), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
    }

    private static void copyDirAll(File[] files, File dest) throws IOException {
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory() && !Files.isSymbolicLink(f.toPath())) {
                File dest_dir = new File(dest.getAbsolutePath() + File.separator + f.getName());
                if (!dest_dir.exists()) {
                    dest_dir.mkdirs();
                }
                File[] files2 = f.listFiles();
                FileUtils.copyDirAll(files2, dest_dir);
                continue;
            }
            File dest_file = new File(dest.getAbsolutePath() + File.separator + f.getName());
            FileUtils.copyfile(f, dest_file);
        }
    }

    public static void copyDirAll(File dir1, File dir2) throws FileNotFoundException, IOException {
        if (!dir1.isDirectory() || !dir2.isDirectory() || Files.isSymbolicLink(dir1.toPath()) || Files.isSymbolicLink(dir2.toPath())) {
            throw new IOException("Only Directory support");
        }
        File[] files = dir1.listFiles();
        FileUtils.copyDirAll(files, dir2);
    }

    public static boolean emptyDir(File dir, boolean bRemoveFolder) {
        boolean blnReturn = true;
        if (dir.isDirectory() && !Files.isSymbolicLink(dir.toPath())) {
            File[] children;
            for (File child : children = dir.listFiles()) {
                blnReturn = FileUtils.emptyDir(child, true);
                if (blnReturn) continue;
                return false;
            }
            if (bRemoveFolder) {
                dir.delete();
            }
        } else if (!dir.getAbsoluteFile().getName().endsWith("update.tmp") && !dir.getAbsoluteFile().getName().endsWith("tmp.txt")) {
            blnReturn = dir.delete();
        }
        return blnReturn;
    }

    public static void emptyDirExcept(File dir, List<File> exception, Logger logger) throws IOException {
        if (dir.isDirectory() && !Files.isSymbolicLink(dir.toPath())) {
            File[] childrens;
            for (File children : childrens = dir.listFiles()) {
                if (FileUtils.isFileInList(children, exception)) continue;
                if (children.isDirectory()) {
                    FileUtils.emptyDir(children, true);
                    continue;
                }
                children.delete();
            }
        } else {
            throw new IOException(dir.getAbsolutePath() + " is not directory");
        }
    }

    private static boolean isFileInList(File file, List<File> files) {
        boolean found = false;
        Iterator<File> iter = files.iterator();
        while (!found && iter.hasNext()) {
            if (!iter.next().getAbsolutePath().equals(file.getAbsolutePath())) continue;
            found = true;
        }
        return found;
    }

    public static boolean removeDirSkip(File dir, boolean bRemoveFolder, List<String> skipFileNames) {
        boolean blnReturn = true;
        if (dir.isDirectory() && !Files.isSymbolicLink(dir.toPath())) {
            File[] children = dir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                blnReturn = FileUtils.removeDirSkip(children[i], true, skipFileNames);
                if (blnReturn) continue;
                return false;
            }
            if (bRemoveFolder) {
                dir.delete();
            }
        } else if (!dir.getAbsoluteFile().getName().endsWith("update.tmp") && !dir.getAbsoluteFile().getName().endsWith("tmp.txt")) {
            boolean bSkip = false;
            for (int i = 0; i < skipFileNames.size(); ++i) {
                if (!skipFileNames.get(0).equals(dir.getAbsoluteFile().getName())) continue;
                bSkip = true;
                break;
            }
            if (!bSkip) {
                blnReturn = dir.delete();
            }
        }
        return blnReturn;
    }

    public static boolean isWritablePath(File dir) {
        boolean canwrite = true;
        File apply1 = new File(dir.getAbsolutePath() + File.separator + "dummy.info");
        try {
            if (apply1.exists()) {
                apply1.delete();
            }
            apply1.createNewFile();
            apply1.delete();
        }
        catch (Exception e) {
            canwrite = false;
        }
        return canwrite;
    }

    public static boolean contentEquals(File file1, File file2) throws IOException, CapiException {
        boolean contentIsEqual = false;
        if (!file1.exists() || !file2.exists()) {
            throw new IOException("Uno o entrambi dei seguenti file non esiste: " + file1.getCanonicalPath() + " " + file2.getAbsolutePath());
        }
        byte[] f1 = Util.readFile(file1.getAbsolutePath());
        byte[] f2 = Util.readFile(file2.getAbsolutePath());
        contentIsEqual = Arrays.equals(f1, f2);
        return contentIsEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean areIdenticalFile(File file1, File file2) throws FileNotFoundException, NoSuchAlgorithmException, IOException {
        boolean bl;
        FileInputStream fis1 = null;
        FileInputStream fis2 = null;
        try {
            fis1 = new FileInputStream(file1);
            fis2 = new FileInputStream(file2);
            String sha256_1 = Utils.calculateDigest(fis1, Constants.SHA256);
            String sha256_2 = Utils.calculateDigest(fis2, Constants.SHA256);
            bl = sha256_1.equals(sha256_2);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(fis1);
            Util.closeQuietly(fis2);
            throw throwable;
        }
        Util.closeQuietly(fis1);
        Util.closeQuietly(fis2);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File in) throws IOException {
        MD5Digest objDigest = new MD5Digest();
        try (FileInputStream objInf = null;){
            objInf = new FileInputStream(in);
            objDigest.reset();
            byte[] buf = new byte[4096];
            int letti = objInf.read(buf);
            while (letti != -1) {
                objDigest.update(buf, 0, letti);
                letti = objInf.read(buf);
            }
            byte[] digest = new byte[objDigest.getDigestSize()];
            objDigest.doFinal(digest, 0);
            String string = new String(Hex.encode((byte[])digest));
            return string;
        }
    }

    public static void unZipIt(File zipFile, String outputFolder, Logger logger) throws IOException {
        logger.info("Unzip " + zipFile.getAbsolutePath());
        byte[] buffer = new byte[4096];
        File folder = new File(outputFolder);
        if (!folder.exists()) {
            folder.mkdir();
        }
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            String fileName = ze.getName();
            File newFile = new File(outputFolder + File.separator + fileName);
            logger.info("file unzip : " + newFile.getAbsoluteFile());
            if (fileName.endsWith("/")) {
                newFile.mkdirs();
            } else {
                int len;
                File parentFolder = new File(newFile.getParent());
                if (!parentFolder.exists()) {
                    parentFolder.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        logger.info("Done");
    }
}

