/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class StringWrap {
    public HashMap<String, Integer> breakable = new HashMap();

    public StringWrap() {
        this.breakable.put(" ", 40);
        this.breakable.put(",", 30);
        this.breakable.put(";", 20);
        this.breakable.put(".", 10);
        this.breakable.put("/", 10);
        this.breakable.put("\\", 10);
        this.breakable.put("_", 10);
        this.breakable.put("-", 5);
    }

    public List<String> performWrap(List<String> multiText, float targetWidth, PDFont font, int fontSize) throws IOException {
        ArrayList<String> wrap = new ArrayList<String>();
        for (String text : multiText) {
            if (!text.isEmpty()) {
                int start = 0;
                int index = 0;
                int cols = text.length() / (int)Math.ceil(font.getStringWidth(text) / 1000.0f * (float)fontSize / targetWidth);
                while (font.getStringWidth(text.substring(start)) / 1000.0f * (float)fontSize > targetWidth) {
                    int last = index;
                    index = this.bestBreakIndex(text, start, cols * 2, font, fontSize, targetWidth);
                    if (index == start) break;
                    wrap.add(text.substring(last, index).trim());
                    start = index;
                }
                wrap.add(text.substring(index).trim());
                continue;
            }
            wrap.add(text);
        }
        return wrap;
    }

    private int bestBreakIndex(String text, int start, int radius, PDFont font, int fontSize, float targetWidth) throws IOException {
        int bestIndex = start;
        float bestWeight = 0.0f;
        for (int i = start; i <= start + radius; ++i) {
            Integer charWeight = null;
            if (i > text.length() - 1) break;
            try {
                charWeight = this.breakable.get(text.substring(i, i + 1));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (charWeight == null) continue;
            if (!(font.getStringWidth(text.substring(start, i)) / 1000.0f * (float)fontSize <= targetWidth)) break;
            float examWeight = (float)charWeight.intValue() / (float)Math.abs(start + radius + 1 - i);
            if (!(examWeight > bestWeight)) continue;
            bestIndex = i;
            bestWeight = examWeight;
        }
        return Math.min(bestIndex, text.length() - 1);
    }
}

