/*
 * Decompiled with CFR 0.152.
 */
package esecurity.internal.asb.gw;

import esecurity.internal.asb.gw.GwClientGson;
import esecurity.internal.asb.gw.GwClientI;
import esecurity.internal.asb.gw.GwClientInfo;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import java.security.KeyStore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class GwClient {
    private static String infomiddelware_user = System.getProperty("esecurity.asb.infomiddleware.user");
    private static String infomiddelware_pwd = System.getProperty("esecurity.asb.infomiddleware.pwd");

    public static GwClientI getInstance(UrlClient client, Logger logger, URLCredentials cred, KeyStore store, boolean ignorecert, boolean enforcemode) {
        return GwClient.getInstance(client, logger, cred, store, ignorecert, enforcemode, null);
    }

    public static GwClientI getInstance(UrlClient client, Logger logger, URLCredentials cred, KeyStore store, boolean ignorecert, boolean enforcemode, String username) {
        String regexusername = "^(I|A)[a-zA-Z0-9]{16}$";
        if (System.getProperty("esecurity.asb.infomiddleware.userformat") != null && !"".equals(System.getProperty("esecurity.asb.infomiddleware.userformat"))) {
            regexusername = System.getProperty("esecurity.asb.infomiddleware.userformat");
        }
        Pattern pattern = Pattern.compile(regexusername);
        if (username != null && !"".equals(username)) {
            Matcher m = pattern.matcher(username);
            if (m.matches()) {
                if (System.getProperty("esecurity.asb.infomiddleware.url") != null && !"".equals(System.getProperty("esecurity.asb.infomiddleware.url")) && username.startsWith("I")) {
                    cred = new URLCredentials(infomiddelware_user, infomiddelware_pwd, null, null);
                    return new GwClientInfo(client, logger, cred, store, ignorecert, enforcemode);
                }
                return new GwClientGson(client, logger, cred, store, ignorecert, enforcemode);
            }
            return new GwClientGson(client, logger, cred, store, ignorecert, enforcemode);
        }
        return new GwClientGson(client, logger, cred, store, ignorecert, enforcemode);
    }
}

