/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.xades;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class XadesStepSignatureCanonicalizationMethodCheck
extends SingleValidationSubStepImpl {
    public XadesStepSignatureCanonicalizationMethodCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if (param.getSignature() == null || param.getSignature().getSignatureInfo() == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        XadesSignerInfoData data = (XadesSignerInfoData)param.getSignature().getSignerInfoData();
        String canonicalMethod = data.getCanonicalizationMethod();
        if (canonicalMethod == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0016_NO_CANONICALIZATION_METHOD, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        if (!(canonicalMethod != null && (canonicalMethod.equalsIgnoreCase("http://www.w3.org/2006/12/xml-c14n11#WithComments") || canonicalMethod.equalsIgnoreCase("http://www.w3.org/2006/12/xml-c14n11") || canonicalMethod.equalsIgnoreCase("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || canonicalMethod.equalsIgnoreCase("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || canonicalMethod.equalsIgnoreCase("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || canonicalMethod.equalsIgnoreCase("http://www.w3.org/2001/10/xml-exc-c14n#")))) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0018_INVALID_CANONICALIZATION_ALGORITHM, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        return null;
    }
}

