/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.xades;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.xades.bean.XadesSignatureReference;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import esecurity.validator.xades.bean.XadesSigningCertificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class XadesStepSignatureDigestAlgoirthmCheck
extends SingleValidationSubStepImpl {
    public XadesStepSignatureDigestAlgoirthmCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        if (param == null) {
            return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        Date validationDate = param.getCalculatedValidationDate().getDate();
        if ((param.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE || param.getProfile() == ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE) && validationDate.after(Constants.DPCM_AGID_121_2019)) {
            DigestAlgorithm digAlgUsed;
            XadesSignerInfoData data = (XadesSignerInfoData)param.getSignature().getSignerInfoData();
            if (data != null && data.getReferences() != null && data.getReferences().size() > 0) {
                for (XadesSignatureReference ref : data.getReferences()) {
                    if (ref != null && ref.getDigestMethodAlgorithm() != null && ref.getDigestMethodAlgorithm().equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#sha256")) continue;
                    digAlgUsed = DigestAlgorithm.valueFromXadesId((String)ref.getDigestMethodAlgorithm());
                    if (digAlgUsed == null) {
                        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, new Object[]{ref.getDigestMethodAlgorithm(), ((Object)((Object)this)).getClass().getName()});
                    }
                    if (digAlgUsed.isForbidden()) {
                        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, new Object[]{digAlgUsed.name(), ((Object)((Object)this)).getClass().getName()});
                    }
                    if (digAlgUsed.isRecommended()) continue;
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, new Object[]{digAlgUsed.name(), ((Object)((Object)this)).getClass().getName()});
                }
            }
            if (data != null && data.getSigningCertificates() != null && data.getSigningCertificates().size() > 0) {
                for (XadesSigningCertificate cert : data.getSigningCertificates()) {
                    if (cert != null && cert.getDigestMethod() != null && cert.getDigestMethod().equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#sha256")) continue;
                    digAlgUsed = DigestAlgorithm.valueFromXadesId((String)cert.getDigestMethod());
                    if (digAlgUsed == null) {
                        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, new Object[]{cert.getDigestMethod(), ((Object)((Object)this)).getClass().getName()});
                    }
                    if (digAlgUsed.isForbidden()) {
                        return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, new Object[]{digAlgUsed.name(), ((Object)((Object)this)).getClass().getName()});
                    }
                    if (digAlgUsed.isRecommended()) continue;
                    return new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, new Object[]{digAlgUsed.name(), ((Object)((Object)this)).getClass().getName()});
                }
            }
        }
        return null;
    }

    private static enum HASH_ALGORITHMS {
        SHA_256,
        SHA_512;

    }
}

