/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.xades;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;
import java.util.List;

public class XadesStepSignatureEIDASSignedPropertiesCheck
extends MultipleValidationSubStepImpl {
    public XadesStepSignatureEIDASSignedPropertiesCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> subMessage, ValidationContextParameters param) {
        LinkedList<ValidatorMessage> msgs = new LinkedList<ValidatorMessage>();
        if (param != null && param.getSignature() != null && param.getSignature().getSignerInfoData() != null) {
            XadesSignerInfoData data = (XadesSignerInfoData)param.getSignature().getSignerInfoData();
            if (!data.hasSignedProperties()) {
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0007_NOSIGNTIME, new Object[0]));
                msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0012_XADES_NOSIGNCERT, new Object[0]));
            } else {
                if (!data.hasSigningTime()) {
                    msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0007_NOSIGNTIME, new Object[0]));
                }
                if (data.getSigningCertificates() == null || data.getSigningCertificates().isEmpty()) {
                    msgs.add(new ValidatorMessage(param.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0012_XADES_NOSIGNCERT, new Object[0]));
                }
            }
        }
        return msgs;
    }
}

