/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xades;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.datahandlers.inputs.ByteInputHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.signature.BaseSignatureOptions;
import it.actalis.ellips.capi.signature.SignatureGenerator;
import it.actalis.ellips.capi.xades.XadesDocument;
import it.actalis.ellips.capi.xades.XadesSignatureOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;

public class SoapSignatureGenerator
extends SignatureGenerator<XadesSignatureOptions, BaseSignatureOptions> {
    protected void innerSign(XadesSignatureOptions option) throws CapiException {
        XadesDocument doc = null;
        X509Certificate x509Cert = this.retrieveCert(option);
        PrivateKey privateKey = this.retrieveKey(option);
        Provider prov = this.retrieveProvider(option);
        OutputStream out = null;
        try {
            byte[] bodyToSign = IOUtils.toByteArray((InputStream)option.getInput().getInputAsNewStream());
            String xml = "<?xml version=\"1.0\"?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"><soapenv:Header><wsse:Security xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"><wsu:Timestamp xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\" Id=\"Timestamp\"></wsu:Timestamp></wsse:Security>\t</soapenv:Header>" + new String(bodyToSign) + "</soapenv:Envelope>";
            ByteInputHandler byteInputHandler = new ByteInputHandler(xml.getBytes());
            doc = new XadesDocument((InputHandler)byteInputHandler);
            Document xml_doc = doc.createSoapSignature(option, x509Cert, privateKey, prov);
            out = option.getOutput().getAsOutputStream();
            this.toStream(xml_doc, out);
            option.getOutput().flush();
        }
        catch (IOException ex) {
            throw new CapiException("Unable To sign document.", 1003, (Throwable)ex);
        }
        catch (TransformerException ex) {
            throw new CapiException("Unable To sign document.", 1003, (Throwable)ex);
        }
        catch (CertificateEncodingException ex) {
            throw new CapiException("Unable To sign document.", 1003, (Throwable)ex);
        }
    }

    protected void innerAddSign(XadesSignatureOptions option) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void innerUpdateSign(BaseSignatureOptions option) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void toStream(Document xml, OutputStream os) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(xml), new StreamResult(os));
    }
}

