/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.asic.envelope;

import esecurity.validator.bean.ParsedTransientDocument;
import it.actalis.ellips.capi.asic.ASiCOptions;
import it.actalis.ellips.capi.asic.ASiCSignatureType;
import it.actalis.ellips.capi.asic.envelope.ASiCContainer;
import it.actalis.ellips.capi.asic.envelope.ASiCContainerFactory;
import it.actalis.ellips.capi.asic.parser.util.ASiCContentData;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.naming.OperationNotSupportedException;

public class ASiCSContainer
extends ASiCContainer {
    protected ParsedTransientDocument cadesTransientDocument;
    protected ParsedTransientDocument xadesTransientDocument;
    protected ParsedTransientDocument timestampTransientDocument;
    protected String filename;

    public String getFilename() {
        return this.filename;
    }

    public ParsedTransientDocument getCadesTransientDocument() throws OperationNotSupportedException {
        this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.CADES);
        return this.cadesTransientDocument;
    }

    public ParsedTransientDocument getTimestampTransientDocument() throws OperationNotSupportedException {
        this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.TIMESTAMP);
        return this.timestampTransientDocument;
    }

    public ParsedTransientDocument getXadesTransientDocument() throws OperationNotSupportedException {
        this.throwExceptionIfUnsupportedGetSignature(ASiCSignatureType.XADES);
        return this.xadesTransientDocument;
    }

    ASiCSContainer(ASiCOptions opts, ASiCContainerFactory.ASiCFactoryOptions factoryOpts) throws OperationNotSupportedException {
        super(opts, factoryOpts);
        switch (opts.getSignatureType()) {
            case CADES: {
                Map.Entry<String, ParsedTransientDocument> c = factoryOpts.getCadesTransientDocuments().entrySet().iterator().next();
                this.filename = c.getKey();
                this.cadesTransientDocument = c.getValue();
                break;
            }
            case TIMESTAMP: {
                Map.Entry<String, ParsedTransientDocument> t = factoryOpts.getTimestampTransientDocuments().entrySet().iterator().next();
                this.filename = t.getKey();
                this.timestampTransientDocument = t.getValue();
                break;
            }
            case XADES: {
                Map.Entry<String, ParsedTransientDocument> x = factoryOpts.getXadesTransientDocuments().entrySet().iterator().next();
                this.filename = x.getKey();
                this.xadesTransientDocument = x.getValue();
            }
        }
    }

    public InputStream getContentStream() throws IOException {
        if (this.data.containsKey(this.filename)) {
            InputStream is = ((ASiCContentData)this.data.get(this.filename)).getContentData();
            return is;
        }
        return null;
    }
}

