/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.provider.pkcs11;

import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.TokenManager;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.capi.provider.Token;
import it.actalis.ellips.capi.provider.pkcs11.PKCS11Token;
import it.actalis.vol.utils.Constants;
import java.security.PrivateKey;
import java.security.Provider;
import org.slf4j.Logger;

public class Pkcs11TokenManagerImpl
implements TokenManager {
    private static final Logger logger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public Provider retrieveProviderForKey(PrivateKey key) {
        if (key instanceof Actalis_PrivateKey) {
            return ActalisSingleton.getActalisProvider();
        }
        return null;
    }

    public TokenSpi retrieveTokenByAlias(String alias) {
        try {
            return Token.getTokenSpi((String)alias);
        }
        catch (CapiException ex) {
            logger.info("Nessun Token Trovato per questo alias.");
            return null;
        }
    }

    public TokenSpi initToken(String tokenType) {
        PKCS11Token tk = null;
        if (tokenType.equals("PKCS11Token")) {
            logger.debug("trying to load Token PKCS11...");
            tk = new PKCS11Token();
        }
        return tk;
    }
}

